##############################################################################
#
# Widget to edit items <Peter.Bienstman@ugent.be>
#
##############################################################################

from qt import *
from memaid_core import *
from edit_items_frm import *



##############################################################################
#
# ListItem
#
##############################################################################

class ListItem(QListViewItem):
    def __init__(self, parent, item):
        QListViewItem.__init__(self,parent, item.q, item.a, item.cat.name)

        self.item = item
        
        self.setMultiLinesEnabled(1)
        self.setRenameEnabled(0, 1)
        self.setRenameEnabled(1, 1)
        self.setRenameEnabled(2, 1)
        
        self.changed = False
    
    
    
##############################################################################
#
# EditItemsDlg
#
##############################################################################

class EditItemsDlg(EditItemsFrm):

    ##########################################################################
    #
    # __init__
    #
    ##########################################################################
    
    def __init__(self, parent=None, name=None, modal=0, fl=0):
        
        EditItemsFrm.__init__(self,parent,name,modal,fl)
        
        self.changed = False
        
        self.category_change_queue = []
        self.item_delete_queue = []
        
        self.popup_item = None

        for e in get_items():
            ListItem(self.item_list, e)    
            
        self.connect(self.item_list,
                     SIGNAL("itemRenamed(QListViewItem*,int)"),
                     self.cell_edited)

        self.popup = QPopupMenu(self, "menu")
        #self.popup.insertItem(self.tr("&Edit"), self.edit)
        #self.popup.insertItem(self.tr("&Add vice versa"), self.viceversa)
        self.popup.insertItem(self.tr("&Delete"), self.delete)
        self.connect(self.item_list,
          SIGNAL("contextMenuRequested(QListViewItem*,const QPoint&,int)"),
          self.show_popup)
        self.connect(self.find_button, SIGNAL("clicked()"), self.find)        
        self.connect(self.to_find, SIGNAL("returnPressed()"), self.find)
        self.connect(self.apply_button, SIGNAL("clicked()"), self.apply)
        self.connect(self.discard_button, SIGNAL("clicked()"), self.cancel)
        
    ##########################################################################
    #
    # edit
    #
    ##########################################################################

    def edit(self):
        self.changed = True

    ##########################################################################
    #
    # viceversa
    #
    ##########################################################################
    
    def viceversa(self):
        self.changed = True

    ##########################################################################
    #
    # delete
    #
    ##########################################################################
    
    def delete(self):
        self.item_delete_queue.append(self.popup_item.item)
        self.item_list.takeItem(self.popup_item)
        self.popup_item = None
        self.changed = True

    ##########################################################################
    #
    # show_popup
    #
    ##########################################################################
    
    def show_popup(self,item,point,i):
        self.popup_item = item
        self.popup.popup(point)

    ##########################################################################
    #
    # cell_edited
    #
    ##########################################################################
    
    def cell_edited(self, item, col):
    
        self.changed = True
        item.changed = True
        
        old_cat_name = item.item.cat.name
        new_cat_name = unicode(item.text(2))
        
        if old_cat_name != new_cat_name:
            self.category_change_queue.append((item.item, new_cat_name))
            
    ##########################################################################
    #
    # find
    #
    ##########################################################################
    
    def find(self, string=None):
        f = self.item_list.findItem(self.to_find.text(), 0, Qt.Contains)
        if not f:
            f = self.item_list.findItem(self.to_find.text(), 1, Qt.Contains)
        if not f:
            f = self.item_list.findItem(self.to_find.text(), 2, Qt.Contains)
                                    
        if f:
            self.item_list.setSelected(f, 1)
            self.item_list.ensureItemVisible(f)
            self.item_list.setFocus()
        else:
            QMessageBox.critical(None,
                self.trUtf8("PyQt MemAid"),
                self.trUtf8("""The text you entered was not found."""),
                self.trUtf8("&OK"), None, None, 0, -1)
            
    ##########################################################################
    #
    # apply
    #
    ##########################################################################
    
    def apply(self):
    
        if self.changed == False:
            return self.accept()
    
        # Changed items.
        
        item = self.item_list.firstChild()
        while item:
        
            if item.changed == True:
                item.item.q  = unicode(item.text(0))
                item.item.a  = unicode(item.text(1))
                
            item = item.nextSibling()
            
        # Deleted items.
            
        for item in self.item_delete_queue:
            delete_item(item)
                
        # Category changes.
            
        for i in self.category_change_queue:
            i[0].change_category(i[1])

        rebuild_revision_queue()

        self.changed = False
        self.accept()
  
    ##########################################################################
    #
    # cancel
    #
    ##########################################################################
    
    def cancel(self):
    	if self.changed == True:
            status = QMessageBox.warning(None,
            self.trUtf8("PyQt MemAid"),
            self.trUtf8("""There are changed items in the list. """+\
                        """Do you want to discard the changes?"""),
            self.trUtf8("&Yes"), self.trUtf8("&No"), None, 1, -1)
                
            if status == 0: # Yes
                self.changed = False
                self.close()
            else:
                return
        else:
            self.changed = False
            self.close()

    ##########################################################################
    #
    # closeEvent
    #
    ##########################################################################

    def closeEvent(self, event):
    	if self.changed == True:
            status = QMessageBox.warning(None,
            self.trUtf8("PyQt MemAid"),
            self.trUtf8("""There are changed items in the list. """+\
                        """Do you want to discard the changes?"""),
            self.trUtf8("&Yes"), self.trUtf8("&No"), None, 1, -1)
                
            if status == 0: # Yes
                event.accept()
            else:
                event.ignore()
        else:
            event.accept()

