#! /usr/bin/env python
# -%- strip: true -%-

import sys
import shutil
import os.path
import filecmp

input_file = sys.argv[1]
output_file = sys.argv[2]
output_tmp = output_file + '.tmp'

base = os.path.basename(input_file)
srcdir = os.path.dirname(input_file)
outdir = os.path.dirname(output_file)

if not os.path.exists(outdir):
    os.mkdir(outdir)

output = open(output_tmp, 'w')

print >> output, '/* This file is autogenerated from %s */' % (base,)

if base == 'gtksourcelanguage-parser-2.c':
    print >> output, '#include <mooutils/mooutils-misc.h>'
elif base == 'gtksourcecontextengine.c':
    print >> output, '#include <mooutils/mooutils-misc.h>'
elif base == 'gtksourcelanguage-parser-1.c':
    print >> output, '#include <glib/gmappedfile.h>'
elif base == 'gtksourcestyle.c':
    print >> output, '#include "mooutils/moocompat.h"'
elif base == 'gtksourcestylescheme.c':
    print >> output, '#include "mooutils/moocompat.h"'
elif base == 'gtksourceview-utils.c':
    print >> output, '#ifdef __GNUC__'
    print >> output, '#pragma GCC diagnostic ignored "-Wunused-parameter"'
    print >> output, '#endif'

print >> output, '#line 1 "%s/%s"' % (srcdir, base)

for line in open(input_file):
    if line.endswith('\n'):
        line = line[:-1]
    for name in ['gtksourcecontextengine', 'gtksourceengine', 'gtksourceiter', 'gtksourcelanguage', 'gtksourcelanguage-private',
                 'gtksourcelanguagemanager', 'gtksourcestyle', 'gtksourcestyleschememanager', 'gtksourcestylescheme',
                 'gtksourcestyle-private', 'gtktextregion', 'gtksourceview-utils']:
        line = line.replace('#include "%s.h"' % (name,), '#include "%s-mangled.h"' % (name,))
        line = line.replace('#include <gtksourceview/%s.h>' % (name,), '#include "%s-mangled.h"' % (name,))

    line = line.replace('#include "gtksourcebuffer.h"', '').replace('#include "gtksourceview.h"', '')

    for pair in [('GtkSource', 'MooGtkSource'), ('GtkTextRegion', 'MooGtkTextRegion'), ('_gtk_source', 'gtk_source'),
                 ('gtk_source', '_moo_gtk_source'), ('_gtk_text_region', 'gtk_text_region'),
                 ('gtk_text_region', '_moo_gtk_text_region')]:
        line = line.replace(pair[0], pair[1])

    line = line.replace('g_slice_new', 'moo_new').replace('g_slice_free', 'moo_free')
    line = line.replace('"paragraph-background-set", FALSE,', '') # XXX

    print >> output, line

output.close()

docopy = False
try:
    docopy = not filecmp.cmp(output_file, output_tmp)
except Exception, e:
    docopy = True
if docopy:
    shutil.copyfile(output_tmp, output_file)

try:
    os.remove(output_tmp)
except:
    pass

open(output_file + '.stamp', 'w').write("stamp")
