/*
 *  MediathekView
 *  Copyright (C) 2008 W. Xaver
 *  W.Xaver[at]googlemail.com
 *  http://zdfmediathk.sourceforge.net/
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek;

import java.io.File;
import java.nio.file.Path;
import java.util.ListIterator;
import mediathek.controller.IoXmlLesen;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.daten.DatenDownload;
import mediathek.tool.MVListeFilme;
import msearch.filmeSuchen.MSListenerFilmeLaden;
import msearch.filmeSuchen.MSListenerFilmeLadenEvent;
import msearch.io.MSFilmlisteLesen;

public class MediathekAuto {

    private Daten daten;
    private String pfad = "";

    public MediathekAuto(String[] ar) {
        if (ar != null) {
            if (ar.length > 0) {
                if (!ar[0].startsWith("-")) {
                    if (!ar[0].endsWith(File.separator)) {
                        ar[0] += File.separator;
                    }
                    pfad = ar[0];
                }
            }
        }
    }

    public void starten() {
        daten = new Daten(pfad, null);
        Daten.auto = true;
        Log.startMeldungen(this.getClass().getName());

        if (!IoXmlLesen.einstellungenExistieren()) {
            // Programm erst mit der GuiVersion einrichten
            Log.fehlerMeldung(834986137, "MediathekAuto", "Das Programm muss erst mit der Gui-Version eingerichtet werden!");
            System.exit(0);
        }

        // Einstellungen laden
        Path xmlFilePath = Daten.getMediathekXmlFilePath();
        Log.systemMeldung("Einstellungen laden: " + xmlFilePath.toString());
        if (!IoXmlLesen.datenLesen(xmlFilePath)) {
            // dann hat das Laden nicht geklappt
            Log.fehlerMeldung(834986137, "MediathekAuto", "Einstellungen konnten nicht geladen werden: " + xmlFilePath.toString());
            System.exit(0);
        }

        // Filmliste laden
        new MSFilmlisteLesen().readFilmListe(Daten.getDateiFilmliste(), Daten.listeFilme);

        if (Daten.listeFilme.isTooOld()) {
            // erst neue Filmliste laden
            Log.systemMeldung("Neue Filmliste laden");
            Daten.filmeLaden.addAdListener(new MSListenerFilmeLaden() {
                @Override
                public void fertig(MSListenerFilmeLadenEvent event) {
                    download();
                }
            });
            Daten.filmeLaden.importFilmliste("");
        } else {
            // mit aktueller Filmliste starten
            Log.systemMeldung("aktuelle Filmliste verwenden");
            // Liste erst mal aufbereiten
            Daten.listeAbo.setAboFuerFilm(Daten.listeFilme, false /*aboLoeschen*/);
            MVListeFilme.checkBlacklist();
            download();
        }
    }

    private synchronized void download() {
        try {
            Log.playerMeldungenAus = true;
            Daten.listeDownloads.abosSuchen(null);
            Log.systemMeldung(Daten.listeDownloads.size() + " Filme zum Laden");
            // erst mal die Filme schreiben
            int i = 0;
            ListIterator<DatenDownload> it = Daten.listeDownloads.listIterator();
            while (it.hasNext()) {
                DatenDownload d = it.next();
                Log.systemMeldung("Film " + (i++) + ": ");
                Log.systemMeldung(" Sender: " + d.arr[DatenDownload.DOWNLOAD_SENDER_NR]);
                Log.systemMeldung(" Thema: " + d.arr[DatenDownload.DOWNLOAD_THEMA_NR]);
                Log.systemMeldung(" Titel: " + d.arr[DatenDownload.DOWNLOAD_TITEL_NR]);
            }
            Log.systemMeldung("###########################################################");
            // und jetzt starten
            it = Daten.listeDownloads.listIterator(0);
            while (it.hasNext()) {
                // alle 5 Sekungen einen Download starten
                it.next().startDownload(daten);
                this.wait(5000);
            }
            while (Daten.listeDownloads.getNumberOfStartsNotFinished() > 0) {
                //alle 5 Sekunden nachschauen ob schon fertig
                this.wait(5000);
            }
        } catch (Exception ex) {
            Log.fehlerMeldung(769325469, "MediathekAuto.filmeLaden", ex);
        }
        daten.allesSpeichern();
        Log.printEndeMeldung();
        System.exit(0);
    }
}
