/*  This file is part of MED.
 *
 *  COPYRIGHT (C) 1999 - 2011  EDF R&D, CEA/DEN
 *  MED is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  MED is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with MED.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <med.h>
#include <med_config.h>
#include <med_outils.h>

#include <string.h>
#include <stdlib.h>

void
_MEDfamily23Info30(int dummy,...)
{
  va_list params;
  va_start(params,dummy);

  const med_idt       fid             = va_arg(params, const  med_idt       );
  const char*   const meshname        = va_arg(params, const  char*    const);
  const int           famit           = va_arg(params, const  int           );
  char*         const familyname      = va_arg(params,        char*    const);
  med_int*      const attributenumber = va_arg(params,        med_int* const);
  med_int*      const attributevalue  = va_arg(params,        med_int* const);
  char*         const attributedes    = va_arg(params,        char*    const);
  med_int*      const familynumber    = va_arg(params,        med_int* const);
  char*         const groupname       = va_arg(params,        char*    const);
  med_err*            fret            = va_arg(params,        med_err*      );
/*   ISCRUTE(                   fid); */
/*   SSCRUTE(		     meshname); */
/*   ISCRUTE_int(		     famit); */
/*   SSCRUTE(		     familyname); */

  *fret = MEDfamilyInfo(fid,
			meshname,
			famit,
			familyname,
			familynumber,
			groupname);
/*   ISCRUTE(		     *familynumber); */
/*   ISCRUTE(		     *attributenumber); */
/*   XSCRUTE(		     attributevalue); */
/*   SSCRUTE(		     attributedes); */
/*   SSCRUTE(		     groupname); */

  va_end(params);

  return;
}
