/*  This file is part of MED.
 *
 *  COPYRIGHT (C) 1999 - 2011  EDF R&D, CEA/DEN
 *  MED is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  MED is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with MED.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <med.h>
#include <med_config.h>
#include <med_outils.h>
#include <string.h>
#include <stdlib.h>

#include <2.3.6/med23v30.h>
#include <2.3.6/med23v30_proto.h>
#include "2.3.6/med23v30_misc.h"

void _MEDequivalenceComputingStepInfo236(int dummy, ...) {

  va_list params;
  va_start(params,dummy);

  const med_idt      fid                    = va_arg(params,const med_idt       );
  const char * const meshname               = va_arg(params,const char * const  );
  const char * const equivname              = va_arg(params,const char * const  );
  const int          csit                   = va_arg(params,const int           );
  med_int * const    numdt                  = va_arg(params,med_int * const     );
  med_int * const    numit                  = va_arg(params,med_int * const     );
  med_int * const    nocstpncorrespondence  = va_arg(params,med_int * const     );
  med_err *                  fret          = va_arg(params,        med_err*     );

  med_err  _ret=-1,_err=-1;
  int      _dummy =0;
  med_err  _fret=-1;
  char     _path[MED_TAILLE_MAA+MED_TAILLE_EQS+2*MED_TAILLE_NOM+1]=MED_MAA;
  med_size _nocstpncorrespondence=0;

  if ( csit != 1 ) {
    MED_ERR_(_ret,MED_ERR_INVALID,MED_ERR_PARAMETER,"");
    ISCRUTE_int(csit); goto ERROR;
  }

  /*
   * On inhibe le gestionnaire d'erreur HDF 5
   */
  _MEDmodeErreurVerrouiller();

  strcat(_path,meshname);
  strcat(_path,MED_EQS);
  strcat(_path,equivname);

  if ((_err=_MEDnObjects(fid,_path,&_nocstpncorrespondence)) <0)
    if ( _err == (MED_ERR_COUNT + MED_ERR_DATAGROUP) ) {
      MED_ERR_(_ret,MED_ERR_COUNT,MED_ERR_CORRESPONDENCE,_path);
      goto ERROR;
    }

  *nocstpncorrespondence = (med_int) _nocstpncorrespondence;
  *numdt= MED_NO_DT;
  *numit= MED_NO_IT;

 _ret = 0;


  _ret = 0;
 ERROR:

  va_end(params);
  *fret = _ret;
  return;
}
