dnl  This file is part of MED.
dnl
dnl  COPYRIGHT (C) 1999 - 2011  EDF R&D, CEA/DEN
dnl  MED is free software: you can redistribute it and/or modify
dnl  it under the terms of the GNU Lesser General Public License as published by
dnl  the Free Software Foundation, either version 3 of the License, or
dnl  (at your option) any later version.
dnl
dnl  MED is distributed in the hope that it will be useful,
dnl  but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl  GNU Lesser General Public License for more details.
dnl
dnl  You should have received a copy of the GNU Lesser General Public License
dnl  along with MED.  If not, see <http://www.gnu.org/licenses/>.
dnl

AC_DEFUN([MED_CHECK_TYPEOF_MEDINT], [

## Guess where as med_int type is provided by --with-med_int option
## or auto-detection must be used

AC_ARG_WITH([med_int],
            AC_HELP_STRING([--with-med_int=<C type>],
	                   [Use <C type> for med_int]),
	    [],
	    [withval=no])

if test "x$withval" = "xno"
then

  ## Guess the fortran int size
  AC_CHECK_SIZEOF_FORTRAN(integer)
  if test "x$ac_cv_sizeof_fortran_integer" = "x8" ; then
     AC_DEFINE(HAVE_F77INT64,[],
                       [The size of a Fortran integer, as computed by sizeof.])
     AC_CHECK_SIZEOF(long)
     test "x$ac_cv_sizeof_long" = "x8" || AC_MSG_ERROR([Size of C type long expected to be eight bytes])
     LONG_OR_INT="long"
  elif test "x$ac_cv_sizeof_fortran_integer" = "x4" ; then
     AC_CHECK_SIZEOF(int)
     test "x$ac_cv_sizeof_int" = "x4" || AC_MSG_ERROR([Size of C type int expected to be four bytes])
     LONG_OR_INT="int"
  else
     AC_MSG_ERROR([Size of Fortran type integer is neither four nor eigth bytes])
  fi

else
  LONG_OR_INT="$withval" 
  AC_MSG_NOTICE([Using type $withval for med_int])
fi

AC_SUBST(LONG_OR_INT)

])
