C*************************************************************************
C COPYRIGHT (C) 1999 - 2003  EDF R&D
C THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
C AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
C EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
C
C THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
C WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
C LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
C
C YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
C ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
C INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
C
C**************************************************************************


C ******************************************************************************
C * - Nom du fichier : test18.f
C *
C * - Description : routines de test de la conformite d'une fichier MED.
C *
C ******************************************************************************
      program test18
C     
      implicit none
      include 'med.hf'
C
C
      integer      fid
      integer      cret
      integer      maj,min,rel
      
C **  Creation du fichier test18.med
      call efouvr(fid,'test18.med',MED_CREATION, cret)
      print *,cret
      if (cret .ne. 0 ) then
         print *,'Erreur creation du fichier'
         call efexit(-1)
      endif      
      print *,'- Creation du fichier'

C **  Fermeture du fichier
      call efferm (fid,cret)
      print *,cret
      if (cret .ne. 0 ) then
         print *,'Erreur fermeture du fichier'
         call efexit(-1)
      endif      
      print *,'- Fermeture du fichier'

C ** Quelle version de la bibliotheque est utilisee ? **
      call efvedo(maj,min,rel,cret)
      print *,cret
      if (cret .ne. 0 ) then
         print *,'Erreur lecture version med'
         call efexit(-1)
      endif      
      print *,'- Version MED utilisee : ',maj,'.',min,'.',rel
 
C ** Conformite du format HDF  **
      call effoco('test18.med',cret)
      print *,cret
      if (cret .eq. 0) then
         print *,'- Format HDF conforme'
      else
         print *,'- Format HDF non conforme'
         call efexit(-1)
      endif   

C ** Conformite de la bibliotheque MED
      call efveco('test18.med',cret)
      print *,cret
      if (cret .eq. 0) then
         print *,'- Version MED du fichier conforme'
      else
         print *,'- Version MED du fichier non conforme'
         call efexit(-1)
      endif           

C **  Ouverture du fichier test18.med en lecture seule
      call efouvr(fid,'test18.med',MED_LECTURE, cret)
      if (cret .ne. 0 ) then
         print *,'Erreur ouverture du fichier'
         call efexit(-1)
      endif      
      print *,'- Ouverture du fichier'

C **  Lecture de la version de MED utilisee pour creer le fichier ? **
      call efveli(fid,maj,min,rel,cret)
      if (cret .ne. 0 ) then
         print *,'Erreur lecture version med du fichier'
         call efexit(-1)
      endif      
      print *,cret
      print *,'- Fichier cree avec MED V',maj,'.',min,'.',rel
         
C **  Fermeture du fichier
      call efferm (fid,cret)
      print *,cret
      if (cret .ne. 0 ) then
         print *,'Erreur fermeture du fichier'
         call efexit(-1)
      endif      
      print *,'- Fermeture du fichier'
C 
      end 


