/*************************************************************************
* COPYRIGHT (C) 1999 - 2003  EDF R&D
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

/******************************************************************************
 * - Nom du fichier : test33.c
 *
 * - Description : lecture d'une numerotation globale inexistante dans un maillage MED 
 *
 *****************************************************************************/

#include <med.h>
#include <med_utils.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>


int main (int argc, char **argv)
{
  med_err ret = 0;
  med_idt fid;
  /* la dimension du maillage */
  med_int mdim;
  /* nom du maillage de longueur maxi MED_TAILLE_NOM */
  char maa[MED_TAILLE_NOM+1];
  /* le nombre de maiuds */
  med_int narr = 0;
  /* table des numeros global */
  med_int *numglobalmai;

  /* variable de stockage pour reperer le maillage */
  med_int i;
  char des[MED_TAILLE_DESC+1];
  med_maillage type;

  if (argc != 2) {
    MESSAGE("Il faut passer un fichier MED en paramtre");
    return -1;
  }

  /* Ouverture du fichier passe en argument en lecture seule */
  if ((fid = MEDouvrir(argv[1],MED_LECTURE)) < 0) {
    MESSAGE("Erreur a l'ouverture du fichier : "); SSCRUTE(argv[1]);
    return -1;
  }
  
  /* Lecture des infos sur le premier maillage */
  if (MEDmaaInfo(fid,1,maa,&mdim,&type,des) < 0) {
    MESSAGE("Erreur a lecture des infos sur le 1er maillage"); 
    return -1;
  }
  printf("Maillage de nom %s et de dimension %d \n",maa,mdim);


  /* Lecture du nombre de arretes */
  if ((narr = MEDnEntMaa(fid,maa,MED_COOR,MED_ARETE,MED_SEG2,0)) < 0) {
    MESSAGE("Erreur a la lecture du nombre de arrete ");
    return -1;
  }
  printf("Nombre d'arretes : %d \n",narr);

  /* Allocations memoires */

  /* table de la numerotation globale
     profil : (nombre de arretes +1) pour avoir une table
     meme s'il n'y a pas d'entite concernes*/
  numglobalmai = (med_int*) malloc(sizeof(med_int)*(narr+1));



  /* lecture de la numerotation globale attachee aux arrete Tria3*/
  /* elle n'existe pas le code doit gerer les erreurs */
  if ((ret=MEDglobalNumLire(fid,maa,numglobalmai,narr,MED_ARETE,MED_TRIA3))<0) {
    MESSAGE("Erreur a la lecture de de la numerotation globale pour les arretes");
    MESSAGE("ce qui etait attendu puisqu'il n'y a pas de numerotation globale sur les arretes!");
  }


  free(numglobalmai);

  /* Fermeture du fichier */
  if (MEDfermer(fid) < 0) {
    MESSAGE("Erreur a la fermeture du fichier ");
    return -1;
  }

  if (ret<0) {
    /* le test a reporte une erreur, ce qui est attendu 
       --> PASS */
    return 0;
  }
  else {
    /* le test n'a pas reporte une erreur, ce qui etait attendu 
       --> FAIL */
    return -1;
  }
}

