/*************************************************************************
* COPYRIGHT (C) 1999 - 2003  EDF R&D
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med.h>
#include <med_config.h>
#include <med_outils.h>

#include <string.h>

med_err
MEDscalaireCr(med_idt fid,char *scalaire, med_type_champ type, char *desc)
{
  med_err ret = 0;
  med_idt root,gid;
  char chemin[MED_TAILLE_NUM_DATA+1];
  med_int _type = (med_int) type;

    /*
   * On inhibe le gestionnaire d'erreur HDF 5
   */
  _MEDmodeErreurVerrouiller();

  /* 
   * Si le Groupe  HDF "/NUM_DATA" n'existe pas, on le cree
   */
  strncpy(chemin,MED_NUM_DATA,MED_TAILLE_NUM_DATA-1);
  chemin[MED_TAILLE_NUM_DATA-1] = '\0';
  if ((root = _MEDdatagroupOuvrir(fid,chemin)) < 0)
    if ((root = _MEDdatagroupCreer(fid,chemin)) < 0)
      return -1;  

  /* 
   * Si le groupe HDF "scalaire" n'existe pas, on le cree
   * Sinon => erreur
   */
  if ((gid = _MEDdatagroupOuvrir(root,scalaire)) >= 0)
    return -1;
  if ((gid = _MEDdatagroupCreer(root,scalaire)) < 0)
    return -1;

  /* 
   * On stocke l'unite, et le type de la valeur scalaire
   */
  if ((ret = _MEDattrEntierEcrire(gid,MED_NOM_TYP,&_type)) < 0)
    return -1;
  if ((ret = _MEDattrStringEcrire(gid,MED_NOM_DES,MED_TAILLE_DESC,desc)) < 0)
    return -1;

  /*
   * On ferme tout
   */
  if ((ret = _MEDdatagroupFermer(gid)) < 0)
    return -1;
  if ((ret = _MEDdatagroupFermer(root)) < 0)
    return -1;

  return ret;
}
