/*************************************************************************
* COPYRIGHT (C) 1999 - 2003  EDF R&D
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med.h>
#include <med_outils.h>

#include <string.h>
#include <stdlib.h>

med_err 
MEDprofilInfo(med_idt fid, int indice, char *profilname, med_int *n)
{
  int numero=0;
  med_idt proid=0;
  med_err ret=-1;
  char chemin[MED_TAILLE_PROFILS+MED_TAILLE_NOM+1]="";

  /*
   * On inhibe le gestionnaire d'erreur
   */
  _MEDmodeErreurVerrouiller();

  /*
   * On recupere le nom du groupe de rang "indice"
   */ 
  numero = indice-1;
  if ( _MEDobjetIdentifier(fid,MED_PROFILS,numero,profilname) < 0)
    goto ERROR;

  /*
   * On va chercher l'attribut taille du profil 
   */
  strcpy(chemin,MED_PROFILS);
  strcat(chemin,profilname);
  if ((proid = _MEDdatagroupOuvrir(fid,chemin)) < 0)
    goto ERROR;   
  if (_MEDattrEntierLire(proid,MED_NOM_NBR,n) < 0)
    goto ERROR;
 
  ret = 0;

 ERROR:
  if ( proid > 0 ) if (_MEDdatagroupFermer(proid) < 0)
    goto ERROR;
  
  return 0;
}


