/*************************************************************************
* COPYRIGHT (C) 1999 - 2005  EDF R&D
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med.h>
#include <med_outils.h>

#include <stdlib.h>
#include <string.h>

med_err 
MEDnomLire(med_idt fid,char *maa, char *nom, med_int n, 
	   med_entite_maillage type_ent,med_geometrie_element type_geo)
{
  med_idt root;
  med_idt maaid = 0;
  med_idt entid = 0;
  med_idt geoid = 0;
  med_err ret = -1;
  char chemin[MED_TAILLE_MAA+MED_TAILLE_NOM+1];
  char nom_ent[MED_TAILLE_NOM_ENTITE+1];
  char nom_geo[MED_TAILLE_NOM_ENTITE+1];

  /*
   * On inhibe le gestionnaire d'erreur HDF 5
   */
  _MEDmodeErreurVerrouiller();

  /*
   * Si le maillage n'existe pas => erreur
   */
  strcpy(chemin,MED_MAA);
  strcat(chemin,maa);
  if ((maaid = _MEDdatagroupOuvrir(fid,chemin)) < 0) {
    MESSAGE("Impossible d'acceder au maillage");
    SSCRUTE(chemin);
    goto ERREUR;
  }
  
  /*
   * On met a jour le nom du "Data Group" representant
   * le type des entites
   */
  if (_MEDnomEntite(nom_ent,type_ent) < 0) {
    MESSAGE("L'entit demande n'est pas une entit <med_entite_maillage> : ");
    SSCRUTE(nom_ent); 
    ISCRUTE(type_ent);
    goto ERREUR;
  }
     
  
  /*
   * Si le "Data Group" des entites n'existe pas => erreur
   */
   if ((entid = _MEDdatagroupOuvrir(maaid,nom_ent)) < 0) { 
     MESSAGE("Impossible d'accder au groupe des entits : ");
     SSCRUTE(nom_ent); 
     ISCRUTE(type_ent);
     goto ERREUR;
   }

   /*
    * Pour les mailles, les faces et le aretes,
    * on ouvre le "Data Group" du type geometrique correspondant
    */
   if ((type_ent==MED_MAILLE)||(type_ent==MED_FACE)||(type_ent==MED_ARETE))
     {
       if (_MEDnomGeometrie(nom_geo,type_geo) < 0) {
	 MESSAGE("L'entit demande n'est pas un lment <med_geometrie_element> : ");
	 SSCRUTE(nom_geo); 
	 ISCRUTE(type_geo);
	 goto ERREUR;
       }
       
       if ((geoid = _MEDdatagroupOuvrir(entid,nom_geo)) < 0) {
	 MESSAGE("Impossible d'accder au groupe des lments gomtriques : ");
	 SSCRUTE(nom_geo); 
	 ISCRUTE(type_geo);
	 goto ERREUR;
       }	   
     }
   else /* pour les noeuds */
     geoid = -1;

   /*
    * Lecture du "Data Set" "NOM" :
    * - En cas d'erreur, pas de message car la presence des 
    *   noms est optionnelle dans un maillage MED
    */
   if (geoid == -1)
     root = entid;
   else
     root = geoid;
   if (_MEDdatasetStringLire(root,MED_NOM_NOM,nom) < 0)
     goto ERREUR;

   /*
    * Tout s'est bien pass si on est parvenu jusqu'ici
    */
   ret = 0;

   /*
    * On ferme tout y compris en cas d'erreur
    */
 ERREUR:
   if (geoid > 0)
     if (_MEDdatagroupFermer(geoid) < 0)
       return -1;
   if (entid > 0)
     if (_MEDdatagroupFermer(entid) < 0)
       return -1;
   if (maaid > 0)
     if (_MEDdatagroupFermer(maaid) < 0)
       return -1;

   /* Code retour : 
    *   - ret == 0 en cas de succs
    *   - ret == -1 en cas d'chec 
    */
   return (ret); 
}
