/*************************************************************************
* COPYRIGHT (C) 1999 - 2003  EDF R&D
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med.h>
#include <med_outils.h>

med_err MEDlienInfo(_IN med_idt fid, _IN int indice, _OUT char * maa, _OUT med_int * n)
{

  int numero;
  med_idt lnid;
  char chemin[MED_TAILLE_LIENS+MED_TAILLE_NOM+1];

  /*
   * On inhibe le gestionnaire d'erreur
   */
  _MEDmodeErreurVerrouiller();

  /*
   * On recupere le nom du groupe de rang "indice"
   */ 
  
  strcpy(chemin,MED_LIENS); 
  numero = indice-1;
  
  if ( _MEDobjetIdentifier(fid,chemin,numero,maa) < 0) {
    MESSAGE("Impossible d'itrer sur le groupe : ");
    SSCRUTE(MED_LIENS); return -1;
  }
  
  /*
   * On va chercher l'attribut taille du profil 
   */
  strcat(chemin,maa);

  if ((lnid = _MEDdatagroupOuvrir(fid,chemin)) < 0) {
    MESSAGE("Impossible d'ouvrir le datagroup  : ");
    SSCRUTE(chemin); return -1;
  }
  
  if ( _MEDattrEntierLire(lnid,MED_NOM_NBR,n) < 0) {
    MESSAGE("Impossible de lire l'attribut  : ");
    SSCRUTE(chemin);SSCRUTE(MED_NOM_NBR); return -1;
  }

  if ( _MEDdatagroupFermer(lnid) < 0) {
    MESSAGE("Impossible de fermer le groupe  : ");
    SSCRUTE(chemin);return -1;
  }

  return 0;

}
