C*************************************************************************
C COPYRIGHT (C) 1999 - 2003  EDF R&D
C THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
C AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
C EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
C
C THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
C WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
C LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
C
C YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
C ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
C INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
C
C**************************************************************************

C       ******************************************************************************
C       * - Nom du fichier : test4.f
C       *
C       * - Description : ecriture des noeuds d'un maillage MED.
C       *
C       *****************************************************************************
	program test4
C       
	implicit none
	include 'med.hf'
C       
C       
	integer cret, fid
	
C       ** la dimension du maillage                         **
	integer      mdim
C       ** nom du maillage de longueur maxi MED_TAILLE_NOM  **
	character*32 maa
C       ** le nombre de noeuds                              **
	integer      nnoe 
C       ** table des coordonnees                            **
C       profil : (dimension * nombre de noeuds) ici 8       **
        real*8       coo(8)
C       ** tables des noms et des unites des coordonnees    **
C           profil : (dimension)                            **
	character*16 nomcoo(2)
	character*16 unicoo(2)
C       ** tables des noms, numeros, numeros de familles des noeuds  **
C       autant d'elements que de noeuds - les noms ont pout longueur **
C       MED_TAILLE_PNOM                                              **
        character*16 nomnoe(4)
        integer     numnoe(4)
        integer     nufano(4)

        parameter    ( mdim = 2, maa = "maa1",nnoe = 4 )
        data  coo    /0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0/
        data  nomcoo /"x","y"/, unicoo /"cm","cm"/
        data  nomnoe /"nom1","nom2","nom3","nom4"/
        data  numnoe /1,2,3,4/, nufano /0,1,2,2/

C       ** Creation du fichier test4.med          **
        call efouvr(fid,'test4.med',MED_CREATION, cret)
        print *,cret

C       ** Creation du maillage maa de dimension 2 **
C       **  et de type MED_NON_STRUCTURE           **
        if (cret .eq. 0) then
           call efmaac(fid,maa,mdim,MED_NON_STRUCTURE,
     &                 'un maillage pour test4',cret)
        endif
        print *,cret

C       ** Ecriture des coordonnees en mode MED_FULL_INTERLACE : **
C       ** (X1,Y1, X2,Y2, X3,Y3, ...)  dans un repere cartesien **
        if (cret .eq. 0) then
           call efcooe(fid,maa,mdim,coo,MED_FULL_INTERLACE,
     &     nnoe,MED_CART,nomcoo,unicoo,cret)
        endif
        print *,cret         
        
C       ** Ecriture des noms des noeuds (optionnel dans un maillage MED) **
        if (cret .eq.  0) then
           call efnome(fid,maa,nomnoe,nnoe,MED_NOEUD,0,cret)
         endif
         print *,cret
 
C       ** Ecriture des numeros des noeuds (optionnel dans un maillage MED) **
         if (cret .eq. 0) then
            call efnume(fid,maa,numnoe,nnoe,MED_NOEUD,0,cret)
         endif
         print *,cret
 

C       ** Ecriture des numeros de familles des noeuds **   
        if (cret .eq. 0) then
           call effame(fid,maa,nufano,nnoe,MED_NOEUD,0,cret) 
        endif
        print *,cret

C       ** Fermeture du fichier **
        call efferm (fid,cret)
        print *,cret
        
         end




