#include "pdf/pilot.h"
      SUBROUTINE GS96HO(X,Q,U,D,S,C,B,G)
#include "pdf/impdp.inc"
      PARAMETER(NP=78,NQ=11,NARG=2)
*****************************************************************
* Subroutine returns the parton distributions in the photon in  *
* next-to-leading order. u,d etc. gives the actual distributions*
* not x times the distributions; Q2 means Q^2. The distributions*
* are valid for 5.0e^-4< x < 1.0 and 5.3 GeV^2 < Q^2 < 1.0e^8.  *
* if higher Q^2 or lower x is required, these may be obtained   *
* from the authors on request.                                  * 
* Lionel Gordon April 1996 : Gordon@hep.anl.gov                 *
* John Storrow             :johns@a3.ph.man.ac.uk               *
*****************************************************************
      DIMENSION SIG(NP,NQ),QNS(NP,NQ),GL(NP,NQ),Y(NP)
      DIMENSION XT(NARG),NA(NARG),A(NP+NQ),QT(NQ)
      EXTERNAL GS2XCOR
      SAVE SIG,QNS,GL,Y,ICALL
      DATA QT /3.0D0,20.0D0,50.0D0,100.0D0,500.0D0,1.0D3,1.0D4,1.0D5,
     + 1.0D6,1.0D7,1.0D8/
******************************************************************
        DATA ((SIG(IX,IQ),IQ=1,11),IX=1,6)/
     +   .32952790E+01,  .17617310E+02,  .24664560E+02,  .79734660E+02,
     +   .10394290E+03,  .13205610E+03,  .22801450E+03,  .32663620E+03,
     +   .42694500E+03,  .52839150E+03,  .63063600E+03,
     +   .11355130E+01,  .49007990E+01,  .66096530E+01,  .20736370E+02,
     +   .27152900E+02,  .33481500E+02,  .54249380E+02,  .74646160E+02,
     +   .94712450E+02,  .11448800E+03,  .13400700E+03,
     +   .69725520E+00,  .27181100E+01,  .36078720E+01,  .10865590E+02,
     +   .14099710E+02,  .17157470E+02,  .27046880E+02,  .36598070E+02,
     +   .45881690E+02,  .54947310E+02,  .63831170E+02,
     +   .50751400E+00,  .18400150E+01,  .24154690E+01,  .70494920E+01,
     +   .90649070E+01,  .10935810E+02,  .16934240E+02,  .22669580E+02,
     +   .28204380E+02,  .33580270E+02,  .38826630E+02,
     +   .40121810E+00,  .13731050E+01,  .17868270E+01,  .50892710E+01,
     +   .64925790E+01,  .77819030E+01,  .11890620E+02,  .15791700E+02,
     +   .19537770E+02,  .23163030E+02,  .26691190E+02,
     +   .33308050E+00,  .10861830E+01,  .14031020E+01,  .39184370E+01,
     +   .49651020E+01,  .59201350E+01,  .89495960E+01,  .11810820E+02,
     +   .14548250E+02,  .17190350E+02,  .19756580E+02 /
        DATA ((SIG(IX,IQ),IQ=1,11),IX=7,12)/
     +   .28559850E+00,  .89331280E+00,  .11466080E+01,  .31502900E+01,
     +   .39693270E+01,  .47118240E+01,  .70586360E+01,  .92660250E+01,
     +   .11371930E+02,  .13400400E+02,  .15367710E+02,
     +   .25056860E+00,  .75545290E+00,  .96416780E+00,  .26125790E+01,
     +   .32751870E+01,  .38730210E+01,  .57570350E+01,  .75232170E+01,
     +   .92043930E+01,  .10821190E+02,  .12387470E+02,
     +   .22363090E+00,  .65240040E+00,  .82838500E+00,  .22177870E+01,
     +   .27681710E+01,  .32623690E+01,  .48160030E+01,  .62684990E+01,
     +   .76485700E+01,  .89741320E+01,  .10257160E+02,
     +   .20225260E+00,  .57269080E+00,  .72377460E+00,  .19173610E+01,
     +   .23834610E+01,  .28005980E+01,  .41091970E+01,  .53297510E+01,
     +   .64876830E+01,  .75987540E+01,  .86734410E+01,
     +   .13472800E+00,  .33581240E+00,  .41579080E+00,  .10559280E+01,
     +   .12925430E+01,  .14995290E+01,  .21442820E+01,  .27411460E+01,
     +   .33048170E+01,  .38441940E+01,  .43650690E+01,
     +   .10491760E+00,  .24055790E+00,  .29374620E+00,  .72728380E+00,
     +   .88260870E+00,  .10155930E+01,  .14286250E+01,  .18099560E+01,
     +   .21696630E+01,  .25137560E+01,  .28460940E+01 /
        DATA ((SIG(IX,IQ),IQ=1,11),IX=13,18)/
     +   .86709805E-01,  .18617900E+00,  .22482300E+00,  .54616330E+00,
     +   .65903060E+00,  .75352190E+00,  .10466620E+01,  .13171390E+01,
     +   .15723460E+01,  .18166450E+01,  .20528090E+01,
     +   .74374467E-01,  .15134900E+00,  .18107930E+00,  .43337820E+00,
     +   .52092740E+00,  .59255640E+00,  .81476960E+00,  .10199420E+01,
     +   .12137490E+01,  .13995040E+01,  .15793000E+01,
     +   .65431371E-01,  .12728810E+00,  .15110160E+00,  .35720830E+00,
     +   .42832690E+00,  .48514330E+00,  .66153710E+00,  .82465060E+00,
     +   .97897980E+00,  .11271280E+01,  .12707220E+01,
     +   .58629494E-01,  .10975060E+00,  .12940750E+00,  .30279420E+00,
     +   .36250730E+00,  .40911560E+00,  .55400170E+00,  .68825410E+00,
     +   .81552170E+00,  .93790310E+00,  .10567010E+01,
     +   .53268183E-01,  .96444786E-01,  .11305450E+00,  .26219950E+00,
     +   .31362490E+00,  .35287020E+00,  .47505800E+00,  .58854290E+00,
     +   .69634740E+00,  .80019700E+00,  .90115710E+00,
     +   .48923943E-01,  .86029820E-01,  .10033050E+00,  .23090380E+00,
     +   .27613580E+00,  .30986190E+00,  .41506420E+00,  .51302950E+00,
     +   .60629480E+00,  .69630070E+00,  .78393270E+00 /
        DATA ((SIG(IX,IQ),IQ=1,11),IX=19,24)/
     +   .45325417E-01,  .77671677E-01,  .90175442E-01,  .20612440E+00,
     +   .24648620E+00,  .27597160E+00,  .36812100E+00,  .45415550E+00,
     +   .53623810E+00,  .61558990E+00,  .69295660E+00,
     +   .42290546E-01,  .70825607E-01,  .81900075E-01,  .18607260E+00,
     +   .22264560E+00,  .24877150E+00,  .33059900E+00,  .40721100E+00,
     +   .48046360E+00,  .55140020E+00,  .62065590E+00,
     +   .39692465E-01,  .65121531E-01,  .75038075E-01,  .16955730E+00,
     +   .20299960E+00,  .22643100E+00,  .29997090E+00,  .36900690E+00,
     +   .43515230E+00,  .49930950E+00,  .56202530E+00,
     +   .37440032E-01,  .60299657E-01,  .69263399E-01,  .15574050E+00,
     +   .18662790E+00,  .20784940E+00,  .27459440E+00,  .33741870E+00,
     +   .39773350E+00,  .45632530E+00,  .51366970E+00,
     +   .35466060E-01,  .56172553E-01,  .64341649E-01,  .14402330E+00,
     +   .17278250E+00,  .19216460E+00,  .25325630E+00,  .31091170E+00,
     +   .36637180E+00,  .42032620E+00,  .47319000E+00,
     +   .33719864E-01,  .52601762E-01,  .60100291E-01,  .13397400E+00,
     +   .16093890E+00,  .17877080E+00,  .23509850E+00,  .28839580E+00,
     +   .33975930E+00,  .38979680E+00,  .43887260E+00 /
        DATA ((SIG(IX,IQ),IQ=1,11),IX=25,30)/
     +   .32162480E-01,  .49482886E-01,  .56409642E-01,  .12527020E+00,
     +   .15066100E+00,  .16717900E+00,  .21946070E+00,  .26904790E+00,
     +   .31691800E+00,  .36361120E+00,  .40945090E+00,
     +   .30763483E-01,  .46735819E-01,  .53170551E-01,  .11766680E+00,
     +   .14173100E+00,  .15711330E+00,  .20590070E+00,  .25228480E+00,
     +   .29713750E+00,  .34093990E+00,  .38397940E+00,
     +   .29498696E-01,  .44298116E-01,  .50305955E-01,  .11096760E+00,
     +   .13383810E+00,  .14824130E+00,  .19400660E+00,  .23761120E+00,
     +   .27984020E+00,  .32112550E+00,  .36172580E+00,
     +   .28348716E-01,  .42120434E-01,  .47755107E-01,  .10502540E+00,
     +   .12683710E+00,  .14038510E+00,  .18350680E+00,  .22467540E+00,
     +   .26460150E+00,  .30367480E+00,  .34212800E+00,
     +   .24619857E-01,  .35323314E-01,  .39848242E-01,  .86743489E-01,
     +   .10540140E+00,  .11638150E+00,  .15156290E+00,  .18540100E+00,
     +   .21838070E+00,  .25076720E+00,  .28271890E+00,
     +   .21853192E-01,  .30553076E-01,  .34355298E-01,  .74188948E-01,
     +   .90686098E-01,  .99975824E-01,  .12990140E+00,  .15885240E+00,
     +   .18717560E+00,  .21506010E+00,  .24261850E+00 /
        DATA ((SIG(IX,IQ),IQ=1,11),IX=31,36)/
     +   .19703059E-01,  .27013483E-01,  .30313641E-01,  .65037966E-01,
     +   .79956084E-01,  .88050827E-01,  .11424140E+00,  .13969640E+00,
     +   .16467170E+00,  .18930720E+00,  .21368750E+00,
     +   .17974563E-01,  .24277063E-01,  .27211100E-01,  .58061510E-01,
     +   .71771979E-01,  .78976542E-01,  .10237060E+00,  .12519180E+00,
     +   .14763340E+00,  .16980200E+00,  .19176230E+00,
     +   .16549228E-01,  .22094935E-01,  .24751903E-01,  .52563004E-01,
     +   .65307312E-01,  .71822792E-01,  .93040287E-01,  .11379900E+00,
     +   .13424850E+00,  .15447220E+00,  .17452180E+00,
     +   .15350753E-01,  .20312915E-01,  .22754140E-01,  .48113000E-01,
     +   .60069747E-01,  .66033401E-01,  .85501239E-01,  .10459460E+00,
     +   .12343080E+00,  .14207600E+00,  .16057180E+00,
     +   .14327709E-01,  .18830646E-01,  .21100238E-01,  .44433333E-01,
     +   .55730633E-01,  .61242688E-01,  .79272471E-01,  .96990965E-01,
     +   .11449140E+00,  .13182720E+00,  .14903200E+00,
     +   .13444182E-01,  .17580202E-01,  .19711042E-01,  .41341946E-01,
     +   .52083630E-01,  .57217542E-01,  .74040212E-01,  .90601578E-01,
     +   .10697600E+00,  .12320640E+00,  .13932010E+00 /
        DATA ((SIG(IX,IQ),IQ=1,11),IX=37,42)/
     +   .12674276E-01,  .16513998E-01,  .18531460E-01,  .38707916E-01,
     +   .48974223E-01,  .53786840E-01,  .69582365E-01,  .85157104E-01,
     +   .10057000E+00,  .11585610E+00,  .13103860E+00,
     +   .11998878E-01,  .15597810E-01,  .17522020E-01,  .36437824E-01,
     +   .46296742E-01,  .50833378E-01,  .65744840E-01,  .80468833E-01,
     +   .95051795E-01,  .10952210E+00,  .12389890E+00,
     +   .11403565E-01,  .14806393E-01,  .16653737E-01,  .34466218E-01,
     +   .43969791E-01,  .48267648E-01,  .62412605E-01,  .76397650E-01,
     +   .90258978E-01,  .10401960E+00,  .11769590E+00,
     +   .10877254E-01,  .14120740E-01,  .15904872E-01,  .32743327E-01,
     +   .41942414E-01,  .46030410E-01,  .59503313E-01,  .72841354E-01,
     +   .86071022E-01,  .99210240E-01,  .11227220E+00,
     +   .10411290E-01,  .13526291E-01,  .15258805E-01,  .31226756E-01,
     +   .40159699E-01,  .44064362E-01,  .56948848E-01,  .69719382E-01,
     +   .82394473E-01,  .94988078E-01,  .10751200E+00,
     +   .99988347E-02,  .13011689E-01,  .14702618E-01,  .29890353E-01,
     +   .38591381E-01,  .42334680E-01,  .54701053E-01,  .66971727E-01,
     +   .79158202E-01,  .91270424E-01,  .10331710E+00 /
        DATA ((SIG(IX,IQ),IQ=1,11),IX=43,48)/
     +   .96344016E-02,  .12567966E-01,  .14226112E-01,  .28708473E-01,
     +   .37210722E-01,  .40811460E-01,  .52720375E-01,  .64549908E-01,
     +   .76305106E-01,  .87992281E-01,  .99616937E-01,
     +   .93135582E-02,  .12187938E-01,  .13821121E-01,  .27662413E-01,
     +   .35996199E-01,  .39469995E-01,  .50973836E-01,  .62413912E-01,
     +   .73788591E-01,  .85101403E-01,  .96358329E-01,
     +   .90326807E-02,  .11865777E-01,  .13481013E-01,  .26736151E-01,
     +   .34920789E-01,  .38284242E-01,  .49433734E-01,  .60531553E-01,
     +   .71570978E-01,  .82552649E-01,  .93479961E-01,
     +   .87887971E-02,  .11596706E-01,  .13200351E-01,  .25917782E-01,
     +   .33981018E-01,  .37246559E-01,  .48082780E-01,  .58878690E-01,
     +   .69622464E-01,  .80311924E-01,  .90947837E-01,
     +   .85794227E-02,  .11376764E-01,  .12974606E-01,  .25197493E-01,
     +   .33162601E-01,  .36341149E-01,  .46901077E-01,  .57431698E-01,
     +   .67915753E-01,  .78349166E-01,  .88734441E-01,
     +   .84025022E-02,  .11202639E-01,  .12799975E-01,  .24563916E-01,
     +   .32448944E-01,  .35551958E-01,  .45871548E-01,  .56170788E-01,
     +   .66427633E-01,  .76635823E-01,  .86796649E-01 /
        DATA ((SIG(IX,IQ),IQ=1,11),IX=49,54)/
     +   .82563059E-02,  .11071531E-01,  .12673226E-01,  .24012102E-01,
     +   .31833299E-01,  .34870546E-01,  .44981480E-01,  .55079792E-01,
     +   .65138817E-01,  .75150378E-01,  .85115068E-01,
     +   .81393691E-02,  .10981051E-01,  .12591578E-01,  .23533953E-01,
     +   .31301934E-01,  .34283873E-01,  .44217642E-01,  .54143660E-01,
     +   .64031810E-01,  .73872268E-01,  .83663598E-01,
     +   .80504613E-02,  .10929144E-01,  .12552610E-01,  .23124803E-01,
     +   .30857082E-01,  .33790868E-01,  .43572366E-01,  .53350791E-01,
     +   .63092016E-01,  .72784781E-01,  .82427159E-01,
     +   .79885283E-02,  .10914015E-01,  .12554196E-01,  .22779644E-01,
     +   .30482143E-01,  .33377100E-01,  .43033730E-01,  .52688722E-01,
     +   .62305346E-01,  .71872152E-01,  .81389144E-01,
     +   .79526706E-02,  .10934099E-01,  .12594441E-01,  .22494080E-01,
     +   .30177545E-01,  .33040911E-01,  .42595427E-01,  .52147999E-01,
     +   .61659563E-01,  .71117401E-01,  .80517791E-01,
     +   .79421243E-02,  .10988006E-01,  .12671645E-01,  .22264561E-01,
     +   .29937573E-01,  .32775901E-01,  .42249337E-01,  .51718794E-01,
     +   .61143313E-01,  .70511110E-01,  .79823114E-01 /
        DATA ((SIG(IX,IQ),IQ=1,11),IX=55,60)/
     +   .79562264E-02,  .11074492E-01,  .12784246E-01,  .22087734E-01,
     +   .29755836E-01,  .32575890E-01,  .41988421E-01,  .51392362E-01,
     +   .60745593E-01,  .70036925E-01,  .79268448E-01,
     +   .79944124E-02,  .11192435E-01,  .12930818E-01,  .21960316E-01,
     +   .29623669E-01,  .32432761E-01,  .41804638E-01,  .51159516E-01,
     +   .60455564E-01,  .69681950E-01,  .78837253E-01,
     +   .80561917E-02,  .11340820E-01,  .13110019E-01,  .21879360E-01,
     +   .29542189E-01,  .32345828E-01,  .41693553E-01,  .51013283E-01,
     +   .60264260E-01,  .69437623E-01,  .78533784E-01,
     +   .81411460E-02,  .11518705E-01,  .13320576E-01,  .21843312E-01,
     +   .29502705E-01,  .32307163E-01,  .41647520E-01,  .50944839E-01,
     +   .60161151E-01,  .69290906E-01,  .78339122E-01,
     +   .82489066E-02,  .11725234E-01,  .13561288E-01,  .21849515E-01,
     +   .29501507E-01,  .32312520E-01,  .41660730E-01,  .50946612E-01,
     +   .60136516E-01,  .69228791E-01,  .78231640E-01,
     +   .83791632E-02,  .11959608E-01,  .13830981E-01,  .21894226E-01,
     +   .29535467E-01,  .32358348E-01,  .41727737E-01,  .51010951E-01,
     +   .60180463E-01,  .69239631E-01,  .78200467E-01 /
        DATA ((SIG(IX,IQ),IQ=1,11),IX=61,66)/
     +   .85316403E-02,  .12221093E-01,  .14128524E-01,  .21978032E-01,
     +   .29595131E-01,  .32436047E-01,  .41840464E-01,  .51128577E-01,
     +   .60281888E-01,  .69310732E-01,  .78234360E-01,
     +   .87061003E-02,  .12509022E-01,  .14452809E-01,  .22096861E-01,
     +   .29680053E-01,  .32543853E-01,  .41993879E-01,  .51291585E-01,
     +   .60429726E-01,  .69425702E-01,  .78300618E-01,
     +   .89023467E-02,  .12822819E-01,  .14802766E-01,  .22250477E-01,
     +   .29782128E-01,  .32674585E-01,  .42180751E-01,  .51490601E-01,
     +   .60612094E-01,  .69573112E-01,  .78404374E-01,
     +   .90359822E-02,  .13031869E-01,  .15034065E-01,  .22362122E-01,
     +   .29850839E-01,  .32764409E-01,  .42310800E-01,  .51628429E-01,
     +   .60736999E-01,  .69670126E-01,  .78456439E-01,
     +   .91780219E-02,  .13250767E-01,  .15274761E-01,  .22488188E-01,
     +   .29924517E-01,  .32860663E-01,  .42449314E-01,  .51773544E-01,
     +   .60866475E-01,  .69771327E-01,  .78528494E-01,
     +   .93284314E-02,  .13479475E-01,  .15524645E-01,  .22627080E-01,
     +   .29999176E-01,  .32960486E-01,  .42594228E-01,  .51923074E-01,
     +   .60995921E-01,  .69865242E-01,  .78576982E-01 /
        DATA ((SIG(IX,IQ),IQ=1,11),IX=67,72)/
     +   .94871838E-02,  .13718016E-01,  .15783543E-01,  .22776177E-01,
     +   .30071471E-01,  .33060603E-01,  .42742141E-01,  .52072845E-01,
     +   .61120227E-01,  .69947325E-01,  .78606389E-01,
     +   .96542509E-02,  .13966491E-01,  .16051345E-01,  .22940211E-01,
     +   .30139847E-01,  .33159722E-01,  .42891223E-01,  .52219562E-01,
     +   .61234307E-01,  .70010558E-01,  .78607284E-01,
     +   .98296180E-02,  .14225140E-01,  .16328029E-01,  .23117078E-01,
     +   .30202052E-01,  .33255868E-01,  .43038785E-01,  .52358828E-01,
     +   .61331645E-01,  .70045605E-01,  .78564249E-01,
     +   .10013272E-01,  .14494411E-01,  .16613735E-01,  .23306198E-01,
     +   .30257005E-01,  .33347387E-01,  .43181617E-01,  .52485328E-01,
     +   .61404757E-01,  .70044920E-01,  .78481585E-01,
     +   .10205200E-01,  .14774987E-01,  .16908780E-01,  .23512876E-01,
     +   .30300457E-01,  .33431724E-01,  .43317288E-01,  .52593846E-01,
     +   .61444521E-01,  .69992140E-01,  .78318946E-01,
     +   .10405328E-01,  .15067826E-01,  .17213726E-01,  .23740612E-01,
     +   .30328626E-01,  .33505201E-01,  .43440655E-01,  .52675914E-01,
     +   .61438680E-01,  .69873333E-01,  .78072920E-01 /
        DATA ((SIG(IX,IQ),IQ=1,11),IX=73,78)/
     +   .10613733E-01,  .15375177E-01,  .17530238E-01,  .23991156E-01,
     +   .30339517E-01,  .33566315E-01,  .43547787E-01,  .52722398E-01,
     +   .61372019E-01,  .69667287E-01,  .77717520E-01,
     +   .10830436E-01,  .15700419E-01,  .17860981E-01,  .24269460E-01,
     +   .30324731E-01,  .33610221E-01,  .43633968E-01,  .52721620E-01,
     +   .61223745E-01,  .69341116E-01,  .77194721E-01,
     +   .11055518E-01,  .16048975E-01,  .18210417E-01,  .24589844E-01,
     +   .30280162E-01,  .33635441E-01,  .43694302E-01,  .52657146E-01,
     +   .60963918E-01,  .68853512E-01,  .76464675E-01,
     +   .11233788E-01,  .16404711E-01,  .18568806E-01,  .24966985E-01,
     +   .30198859E-01,  .33643205E-01,  .43727428E-01,  .52507479E-01,
     +   .60546633E-01,  .68133444E-01,  .75430356E-01,
     +   .11195521E-01,  .16786704E-01,  .18971112E-01,  .25527190E-01,
     +   .30142711E-01,  .33703748E-01,  .43775905E-01,  .52260574E-01,
     +   .59902553E-01,  .67055628E-01,  .73906749E-01,
     +   .11157162E-01,  .17455921E-01,  .19645428E-01,  .26781252E-01,
     +   .30308895E-01,  .34030765E-01,  .43964390E-01,  .51890522E-01,
     +   .58854111E-01,  .65300442E-01,  .71444392E-01 /
        DATA ((QNS(IX,IQ),IQ=1,11),IX=1,6)/
     +   .94240336E-02,  .18417537E-01,  .22739289E-01,  .37607048E-01,
     +   .44243883E-01,  .50122499E-01,  .70369989E-01,  .91482073E-01,
     +   .11324320E+00,  .13550980E+00,  .15818140E+00,
     +   .59973067E-02,  .11720352E-01,  .14432831E-01,  .24163216E-01,
     +   .28503288E-01,  .32346703E-01,  .45423366E-01,  .58843695E-01,
     +   .72496824E-01,  .86314097E-01,  .10025040E+00,
     +   .49393503E-02,  .97090816E-02,  .11965460E-01,  .20150421E-01,
     +   .23982644E-01,  .27228395E-01,  .38227096E-01,  .49456306E-01,
     +   .60832184E-01,  .72304659E-01,  .83841935E-01,
     +   .43745874E-02,  .86307731E-02,  .10642637E-01,  .17979529E-01,
     +   .21555452E-01,  .24471853E-01,  .34330886E-01,  .44365548E-01,
     +   .54505978E-01,  .64711556E-01,  .74957199E-01,
     +   .40092943E-02,  .79269614E-02,  .97778682E-02,  .16550563E-01,
     +   .19954743E-01,  .22650827E-01,  .31749010E-01,  .40988449E-01,
     +   .50308473E-01,  .59674632E-01,  .69066122E-01,
     +   .37478260E-02,  .74182409E-02,  .91516310E-02,  .15509205E-01,
     +   .18786343E-01,  .21319561E-01,  .29856237E-01,  .38510069E-01,
     +   .47227092E-01,  .55977229E-01,  .64742774E-01 /
        DATA ((QNS(IX,IQ),IQ=1,11),IX=7,12)/
     +   .35484738E-02,  .70266821E-02,  .86687198E-02,  .14701542E-01,
     +   .17877039E-01,  .20282917E-01,  .28380385E-01,  .36576372E-01,
     +   .44822372E-01,  .53091832E-01,  .61369438E-01,
     +   .33897611E-02,  .67121517E-02,  .82801273E-02,  .14049334E-01,
     +   .17141886E-01,  .19443339E-01,  .27181588E-01,  .35004079E-01,
     +   .42866483E-01,  .50744981E-01,  .58626097E-01,
     +   .32593519E-02,  .64515634E-02,  .79576503E-02,  .13505563E-01,
     +   .16532049E-01,  .18745350E-01,  .26180854E-01,  .33689238E-01,
     +   .41229557E-01,  .48780218E-01,  .56329239E-01,
     +   .31495895E-02,  .62305392E-02,  .76837270E-02,  .13042108E-01,
     +   .16006669E-01,  .18144501E-01,  .25320824E-01,  .32560334E-01,
     +   .39825078E-01,  .47095336E-01,  .54360423E-01,
     +   .27516156E-02,  .54136738E-02,  .66676224E-02,  .11308790E-01,
     +   .14027087E-01,  .15878243E-01,  .22070521E-01,  .28290793E-01,
     +   .34512676E-01,  .40723700E-01,  .46917904E-01,
     +   .25373192E-02,  .49619353E-02,  .61029163E-02,  .10335214E-01,
     +   .12905763E-01,  .14591646E-01,  .20218667E-01,  .25856126E-01,
     +   .31483859E-01,  .37093196E-01,  .42680621E-01 /
        DATA ((QNS(IX,IQ),IQ=1,11),IX=13,18)/
     +   .23864319E-02,  .46382886E-02,  .56970883E-02,  .96306726E-02,
     +   .12086046E-01,  .13650976E-01,  .18864932E-01,  .24077490E-01,
     +   .29272981E-01,  .34445409E-01,  .39592940E-01,
     +   .22713402E-02,  .43883673E-02,  .53830515E-02,  .90831602E-02,
     +   .11444672E-01,  .12914657E-01,  .17805120E-01,  .22685859E-01,
     +   .27544534E-01,  .32377109E-01,  .37182964E-01,
     +   .21788219E-02,  .41857213E-02,  .51280665E-02,  .86372243E-02,
     +   .10918611E-01,  .12310890E-01,  .16936969E-01,  .21547042E-01,
     +   .26131453E-01,  .30687688E-01,  .35216041E-01,
     +   .21016418E-02,  .40156827E-02,  .49139261E-02,  .82624108E-02,
     +   .10473821E-01,  .11800430E-01,  .16203472E-01,  .20585742E-01,
     +   .24939708E-01,  .29264078E-01,  .33559863E-01,
     +   .20354639E-02,  .38693461E-02,  .47295480E-02,  .79390667E-02,
     +   .10088349E-01,  .11358257E-01,  .15568984E-01,  .19755155E-01,
     +   .23911040E-01,  .28036337E-01,  .32132633E-01,
     +   .19775096E-02,  .37409402E-02,  .45677349E-02,  .76557137E-02,
     +   .97481254E-02,  .10968228E-01,  .15010223E-01,  .19024638E-01,
     +   .23007255E-01,  .26958590E-01,  .30880703E-01 /
        DATA ((QNS(IX,IQ),IQ=1,11),IX=19,24)/
     +   .19259059E-02,  .36265303E-02,  .44235704E-02,  .74031064E-02,
     +   .94441744E-02,  .10619841E-01,  .14511577E-01,  .18373329E-01,
     +   .22202175E-01,  .25999289E-01,  .29767124E-01,
     +   .18793355E-02,  .35233255E-02,  .42935591E-02,  .71755024E-02,
     +   .91693141E-02,  .10304910E-01,  .14061378E-01,  .17785965E-01,
     +   .21476803E-01,  .25135649E-01,  .28765282E-01,
     +   .18368444E-02,  .34292820E-02,  .41751377E-02,  .69686845E-02,
     +   .89182211E-02,  .10017415E-01,  .13651083E-01,  .17251292E-01,
     +   .20817133E-01,  .24350848E-01,  .27855478E-01,
     +   .17977183E-02,  .33428592E-02,  .40663714E-02,  .67788879E-02,
     +   .86870156E-02,  .97528668E-02,  .13274182E-01,  .16760744E-01,
     +   .20212485E-01,  .23632064E-01,  .27022738E-01,
     +   .17614159E-02,  .32628726E-02,  .39657708E-02,  .66033578E-02,
     +   .84729679E-02,  .95080482E-02,  .12925822E-01,  .16307818E-01,
     +   .19654684E-01,  .22969447E-01,  .26255554E-01,
     +   .17275111E-02,  .31883945E-02,  .38721631E-02,  .64408416E-02,
     +   .82737096E-02,  .92802355E-02,  .12602052E-01,  .15887277E-01,
     +   .19137194E-01,  .22355136E-01,  .25544692E-01 /
        DATA ((QNS(IX,IQ),IQ=1,11),IX=25,30)/
     +   .16956702E-02,  .31186820E-02,  .37846135E-02,  .62889042E-02,
     +   .80871545E-02,  .90670856E-02,  .12299596E-01,  .15494860E-01,
     +   .18654723E-01,  .21782780E-01,  .24882762E-01,
     +   .16656237E-02,  .30531355E-02,  .37023639E-02,  .61464268E-02,
     +   .79117296E-02,  .88667758E-02,  .12015808E-01,  .15127074E-01,
     +   .18202923E-01,  .21247189E-01,  .24263706E-01,
     +   .16371526E-02,  .29912621E-02,  .36247906E-02,  .60121906E-02,
     +   .77458029E-02,  .86775497E-02,  .11748403E-01,  .14781022E-01,
     +   .17778244E-01,  .20744115E-01,  .23682568E-01,
     +   .16100761E-02,  .29326540E-02,  .35513761E-02,  .58856634E-02,
     +   .75892429E-02,  .84989592E-02,  .11496051E-01,  .14454621E-01,
     +   .17377900E-01,  .20270115E-01,  .23135249E-01,
     +   .15130475E-02,  .27247653E-02,  .32915641E-02,  .54398151E-02,
     +   .70358422E-02,  .78683086E-02,  .10607525E-01,  .13308002E-01,
     +   .15974075E-01,  .18610418E-01,  .21221181E-01,
     +   .14297062E-02,  .25492418E-02,  .30730397E-02,  .50678886E-02,
     +   .65713013E-02,  .73400214E-02,  .98670078E-02,  .12355796E-01,
     +   .14811448E-01,  .17238868E-01,  .19642226E-01 /
        DATA ((QNS(IX,IQ),IQ=1,11),IX=31,36)/
     +   .13563674E-02,  .23973631E-02,  .28846720E-02,  .47500571E-02,
     +   .61722188E-02,  .68868920E-02,  .92345588E-02,  .11545152E-01,
     +   .13824115E-01,  .16076397E-01,  .18306112E-01,
     +   .12908148E-02,  .22637607E-02,  .27195795E-02,  .44729449E-02,
     +   .58233179E-02,  .64914445E-02,  .86850319E-02,  .10842929E-01,
     +   .12970786E-01,  .15073508E-01,  .17155087E-01,
     +   .12316250E-02,  .21449025E-02,  .25732184E-02,  .42289156E-02,
     +   .55154981E-02,  .61428514E-02,  .82019744E-02,  .10227119E-01,
     +   .12223910E-01,  .14197091E-01,  .16150456E-01,
     +   .11778341E-02,  .20383450E-02,  .24424321E-02,  .40115491E-02,
     +   .52416227E-02,  .58329245E-02,  .77735735E-02,  .96821617E-02,
     +   .11564116E-01,  .13423979E-01,  .15265364E-01,
     +   .11287644E-02,  .19423265E-02,  .23249392E-02,  .38168030E-02,
     +   .49954145E-02,  .55547967E-02,  .73906495E-02,  .91963019E-02,
     +   .10976971E-01,  .12736951E-01,  .14479612E-01,
     +   .10839220E-02,  .18555359E-02,  .22190348E-02,  .36413525E-02,
     +   .47741015E-02,  .53048851E-02,  .70471931E-02,  .87612784E-02,
     +   .10452021E-01,  .12123445E-01,  .13778742E-01 /
        DATA ((QNS(IX,IQ),IQ=1,11),IX=37,42)/
     +   .10429369E-02,  .17769686E-02,  .21234076E-02,  .34828938E-02,
     +   .45744213E-02,  .50795381E-02,  .67380839E-02,  .83703874E-02,
     +   .99809458E-02,  .11573471E-01,  .13150859E-01,
     +   .10055272E-02,  .17058378E-02,  .20370285E-02,  .33393521E-02,
     +   .43941182E-02,  .48760460E-02,  .64592627E-02,  .80182981E-02,
     +   .95571596E-02,  .11079242E-01,  .12587328E-01,
     +   .97147172E-03,  .16415142E-02,  .19590692E-02,  .32090063E-02,
     +   .42302958E-02,  .46914709E-02,  .62072063E-02,  .77006207E-02,
     +   .91752894E-02,  .10634297E-01,  .12080133E-01,
     +   .94059587E-03,  .15834844E-02,  .18888538E-02,  .30905926E-02,
     +   .40823021E-02,  .45246948E-02,  .59795799E-02,  .74140122E-02,
     +   .88310866E-02,  .10233535E-01,  .11623533E-01,
     +   .91275759E-03,  .15313239E-02,  .18258197E-02,  .29835096E-02,
     +   .39487118E-02,  .43740915E-02,  .57740975E-02,  .71555194E-02,
     +   .85209096E-02,  .98726815E-02,  .11212891E-01,
     +   .88784238E-03,  .14846778E-02,  .17694950E-02,  .28861878E-02,
     +   .38281640E-02,  .42381478E-02,  .55887257E-02,  .69225645E-02,
     +   .82416162E-02,  .95479656E-02,  .10843531E-01 /
        DATA ((QNS(IX,IQ),IQ=1,11),IX=43,48)/
     +   .86575508E-03,  .14432413E-02,  .17194751E-02,  .27981452E-02,
     +   .37194416E-02,  .41156444E-02,  .54219291E-02,  .67131273E-02,
     +   .79906583E-02,  .92562689E-02,  .10511580E-01,
     +   .84641628E-03,  .14067559E-02,  .16754109E-02,  .27188875E-02,
     +   .36215344E-02,  .40053953E-02,  .52720965E-02,  .65252217E-02,
     +   .77656736E-02,  .89949016E-02,  .10214346E-01,
     +   .82975865E-03,  .13749937E-02,  .16369977E-02,  .26474192E-02,
     +   .35338006E-02,  .39066677E-02,  .51381350E-02,  .63573606E-02,
     +   .75647663E-02,  .87615633E-02,  .99491617E-02,
     +   .81572641E-03,  .13477562E-02,  .16039666E-02,  .25835091E-02,
     +   .34569120E-02,  .38199599E-02,  .50199148E-02,  .62088193E-02,
     +   .73866746E-02,  .85544502E-02,  .97133927E-02,
     +   .80427068E-03,  .13248667E-02,  .15760761E-02,  .25267287E-02,
     +   .33901930E-02,  .37442986E-02,  .49158903E-02,  .60777371E-02,
     +   .72292946E-02,  .83712526E-02,  .95047299E-02,
     +   .79534907E-03,  .13061668E-02,  .15531119E-02,  .24765951E-02,
     +   .33318023E-02,  .36780294E-02,  .48246486E-02,  .59626573E-02,
     +   .70909988E-02,  .82100471E-02,  .93204780E-02 /
        DATA ((QNS(IX,IQ),IQ=1,11),IX=49,54)/
     +   .78892603E-03,  .12915136E-02,  .15348764E-02,  .24326355E-02,
     +   .32813039E-02,  .36206250E-02,  .47453931E-02,  .58625308E-02,
     +   .69705080E-02,  .80695096E-02,  .91602625E-02,
     +   .78496989E-03,  .12807774E-02,  .15211905E-02,  .23947326E-02,
     +   .32383364E-02,  .35716321E-02,  .46774149E-02,  .57764109E-02,
     +   .68666204E-02,  .79480289E-02,  .90212673E-02,
     +   .78345265E-03,  .12738386E-02,  .15118875E-02,  .23623395E-02,
     +   .32021496E-02,  .35303223E-02,  .46199183E-02,  .57033417E-02,
     +   .67781927E-02,  .78442944E-02,  .89022024E-02,
     +   .78435033E-03,  .12705869E-02,  .15068129E-02,  .23352338E-02,
     +   .31724246E-02,  .34963095E-02,  .45723030E-02,  .56425128E-02,
     +   .67042061E-02,  .77571347E-02,  .88020414E-02,
     +   .78764104E-03,  .12709198E-02,  .15058212E-02,  .23131308E-02,
     +   .31488554E-02,  .34692136E-02,  .45339740E-02,  .55931257E-02,
     +   .66436469E-02,  .76852157E-02,  .87185781E-02,
     +   .79330592E-03,  .12747411E-02,  .15087749E-02,  .22959628E-02,
     +   .31306976E-02,  .34483334E-02,  .45042206E-02,  .55543538E-02,
     +   .65955287E-02,  .76273838E-02,  .86505124E-02 /
        DATA ((QNS(IX,IQ),IQ=1,11),IX=55,60)/
     +   .80132775E-03,  .12819601E-02,  .15155423E-02,  .22832237E-02,
     +   .31179774E-02,  .34335442E-02,  .44825966E-02,  .55255168E-02,
     +   .65589719E-02,  .75826435E-02,  .85972035E-02,
     +   .81169140E-03,  .12924910E-02,  .15259976E-02,  .22749053E-02,
     +   .31100719E-02,  .34242724E-02,  .44685043E-02,  .55058813E-02,
     +   .65330602E-02,  .75498386E-02,  .85570021E-02,
     +   .82438299E-03,  .13062516E-02,  .15400186E-02,  .22705384E-02,
     +   .31066088E-02,  .34200996E-02,  .44613751E-02,  .54947105E-02,
     +   .65168762E-02,  .75278734E-02,  .85286936E-02,
     +   .83939038E-03,  .13231644E-02,  .15574869E-02,  .22702448E-02,
     +   .31072609E-02,  .34206652E-02,  .44607022E-02,  .54913131E-02,
     +   .65095178E-02,  .75156037E-02,  .85107759E-02,
     +   .85670268E-03,  .13431550E-02,  .15782870E-02,  .22734660E-02,
     +   .31112402E-02,  .34252387E-02,  .44657774E-02,  .54948679E-02,
     +   .65100011E-02,  .75118644E-02,  .85019497E-02,
     +   .87631017E-03,  .13661537E-02,  .16023031E-02,  .22801904E-02,
     +   .31182719E-02,  .34335172E-02,  .44761305E-02,  .55046869E-02,
     +   .65173940E-02,  .75154915E-02,  .85008712E-02 /
        DATA ((QNS(IX,IQ),IQ=1,11),IX=61,66)/
     +   .89820346E-03,  .13920940E-02,  .16294246E-02,  .22902105E-02,
     +   .31279377E-02,  .34450574E-02,  .44911648E-02,  .55199591E-02,
     +   .65306341E-02,  .75250724E-02,  .85053705E-02,
     +   .92237460E-03,  .14209161E-02,  .16595413E-02,  .23032357E-02,
     +   .31400539E-02,  .34595616E-02,  .45103151E-02,  .55398559E-02,
     +   .65486338E-02,  .75394385E-02,  .85151950E-02,
     +   .94881753E-03,  .14525695E-02,  .16925491E-02,  .23191539E-02,
     +   .31535069E-02,  .34761061E-02,  .45327861E-02,  .55634025E-02,
     +   .65701143E-02,  .75568613E-02,  .85275853E-02,
     +   .96649455E-03,  .14737727E-02,  .17146018E-02,  .23304247E-02,
     +   .31622106E-02,  .34871437E-02,  .45481748E-02,  .55795112E-02,
     +   .65846588E-02,  .75682360E-02,  .85340347E-02,
     +   .98505535E-03,  .14960614E-02,  .17377236E-02,  .23429242E-02,
     +   .31715189E-02,  .34989410E-02,  .45645195E-02,  .55964231E-02,
     +   .65996749E-02,  .75797983E-02,  .85411314E-02,
     +   .10044985E-02,  .15194350E-02,  .17618948E-02,  .23562198E-02,
     +   .31807874E-02,  .35109739E-02,  .45814523E-02,  .56137498E-02,
     +   .66146837E-02,  .75909602E-02,  .85482234E-02 /
        DATA ((QNS(IX,IQ),IQ=1,11),IX=67,72)/
     +   .10248232E-02,  .15438999E-02,  .17871021E-02,  .23705235E-02,
     +   .31895766E-02,  .35229130E-02,  .45987237E-02,  .56311488E-02,
     +   .66291569E-02,  .76006553E-02,  .85519645E-02,
     +   .10460286E-02,  .15694713E-02,  .18133381E-02,  .23857092E-02,
     +   .31980989E-02,  .35348898E-02,  .46162345E-02,  .56483033E-02,
     +   .66425726E-02,  .76081753E-02,  .85515585E-02,
     +   .10681147E-02,  .15961806E-02,  .18406077E-02,  .24019419E-02,
     +   .32063741E-02,  .35468566E-02,  .46337540E-02,  .56647821E-02,
     +   .66543249E-02,  .76132179E-02,  .85494705E-02,
     +   .10910823E-02,  .16240836E-02,  .18689354E-02,  .24190135E-02,
     +   .32130878E-02,  .35578534E-02,  .46507269E-02,  .56799552E-02,
     +   .66635003E-02,  .76139537E-02,  .85399570E-02,
     +   .11149311E-02,  .16532638E-02,  .18983661E-02,  .24373443E-02,
     +   .32194003E-02,  .35687012E-02,  .46672500E-02,  .56934077E-02,
     +   .66692806E-02,  .76096137E-02,  .85245045E-02,
     +   .11396549E-02,  .16838355E-02,  .19289744E-02,  .24572820E-02,
     +   .32237917E-02,  .35782943E-02,  .46826154E-02,  .57042143E-02,
     +   .66702957E-02,  .75979815E-02,  .84982533E-02 /
        DATA ((QNS(IX,IQ),IQ=1,11),IX=73,78)/
     +   .11652628E-02,  .17160538E-02,  .19609558E-02,  .24788762E-02,
     +   .32264341E-02,  .35867651E-02,  .46965568E-02,  .57114917E-02,
     +   .66650049E-02,  .75771199E-02,  .84602814E-02,
     +   .11917589E-02,  .17503077E-02,  .19946259E-02,  .25023462E-02,
     +   .32268544E-02,  .35939009E-02,  .47087069E-02,  .57140728E-02,
     +   .66512520E-02,  .75437622E-02,  .84057571E-02,
     +   .12191528E-02,  .17872198E-02,  .20305095E-02,  .25288546E-02,
     +   .32246693E-02,  .35996984E-02,  .47187502E-02,  .57103517E-02,
     +   .66258898E-02,  .74931574E-02,  .83282115E-02,
     +   .12413139E-02,  .18250246E-02,  .20675659E-02,  .25593296E-02,
     +   .32194380E-02,  .36046421E-02,  .47269203E-02,  .56983405E-02,
     +   .65842373E-02,  .74179485E-02,  .82179485E-02,
     +   .12393846E-02,  .18659254E-02,  .21097811E-02,  .26058301E-02,
     +   .32189018E-02,  .36173693E-02,  .47386773E-02,  .56773759E-02,
     +   .65192748E-02,  .73050433E-02,  .80559906E-02,
     +   .12374151E-02,  .19389354E-02,  .21825545E-02,  .27193346E-02,
     +   .32465039E-02,  .36632048E-02,  .47694566E-02,  .56461799E-02,
     +   .64129378E-02,  .71206577E-02,  .77938964E-02 /
        DATA ((GL(IX,IQ),IQ=1,11),IX=1,6)/ 
     +   .48529990E+02,  .12870040E+03,  .15706260E+03,  .38370580E+03,
     +   .61519150E+03,  .70666880E+03,  .10382790E+04,  .14040060E+04,
     +   .17957580E+04,  .22078860E+04,  .26363170E+04,
     +   .15890960E+02,  .33628660E+02,  .39931390E+02,  .83964760E+02,
     +   .11694850E+03,  .13170540E+03,  .18258190E+03,  .23518540E+03,
     +   .28866640E+03,  .34257400E+03,  .39665660E+03,
     +   .94310980E+01,  .18175180E+02,  .21277330E+02,  .41681420E+02,
     +   .55201450E+02,  .61626310E+02,  .83381870E+02,  .10540340E+03,
     +   .12745100E+03,  .14942310E+03,  .17127760E+03,
     +   .66802850E+01,  .12141380E+02,  .14075520E+02,  .26326920E+02,
     +   .33816230E+02,  .37544280E+02,  .50036320E+02,  .62532720E+02,
     +   .74944210E+02,  .87244550E+02,  .99430920E+02,
     +   .51591140E+01,  .89841540E+01,  .10336430E+02,  .18682250E+02,
     +   .23467670E+02,  .25951700E+02,  .34213800E+02,  .42412950E+02,
     +   .50514890E+02,  .58517450E+02,  .66428190E+02,
     +   .41946060E+01,  .70619560E+01,  .80738110E+01,  .14199900E+02,
     +   .17532030E+02,  .19326750E+02,  .25263170E+02,  .31120420E+02,
     +   .36887950E+02,  .42572410E+02,  .48184150E+02 /
        DATA ((GL(IX,IQ),IQ=1,11),IX=7,12)/ 
     +   .35288730E+01,  .57772250E+01,  .65692210E+01,  .11294930E+02,
     +   .13750450E+02,  .15118280E+02,  .19623350E+02,  .24048990E+02,
     +   .28395830E+02,  .32673770E+02,  .36893470E+02,
     +   .30419200E+01,  .48623110E+01,  .55024400E+01,  .92788580E+01,
     +   .11160360E+02,  .12243700E+02,  .15798790E+02,  .19278800E+02,
     +   .22690250E+02,  .26044140E+02,  .29350600E+02,
     +   .26703820E+01,  .41800760E+01,  .47100670E+01,  .78087810E+01,
     +   .92948980E+01,  .10177610E+02,  .13065580E+02,  .15884490E+02,
     +   .18643830E+02,  .21354680E+02,  .24026370E+02,
     +   .23776530E+01,  .36532620E+01,  .41003660E+01,  .66962170E+01,
     +   .78973980E+01,  .86327130E+01,  .11032260E+02,  .13368940E+02,
     +   .15653690E+02,  .17897230E+02,  .20108140E+02,
     +   .14695900E+01,  .20912560E+01,  .23075640E+01,  .35403820E+01,
     +   .40241170E+01,  .43681370E+01,  .54807730E+01,  .65564470E+01,
     +   .76055440E+01,  .86354300E+01,  .96513940E+01,
     +   .10802530E+01,  .14641260E+01,  .15970510E+01,  .23548000E+01,
     +   .26165310E+01,  .28277200E+01,  .35080070E+01,  .41642440E+01,
     +   .48044590E+01,  .54336700E+01,  .60549590E+01 /
        DATA ((GL(IX,IQ),IQ=1,11),IX=13,18)/ 
     +   .84787960E+00,  .11063140E+01,  .11955030E+01,  .17083810E+01,
     +   .18655730E+01,  .20093670E+01,  .24715870E+01,  .29173410E+01,
     +   .33528030E+01,  .37816090E+01,  .42062570E+01,
     +   .69367090E+00,  .87731270E+00,  .94055530E+00,  .13095010E+01,
     +   .14106630E+01,  .15151670E+01,  .18508740E+01,  .21749670E+01,
     +   .24922060E+01,  .28052850E+01,  .31163180E+01,
     +   .58397920E+00,  .71931010E+00,  .76587130E+00,  .10428030E+01,
     +   .11106750E+01,  .11901670E+01,  .14455980E+01,  .16926470E+01,
     +   .19350150E+01,  .21746200E+01,  .24125360E+01,
     +   .50203150E+00,  .60434630E+00,  .63955520E+00,  .85395630E+00,
     +   .90078840E+00,  .96332250E+00,  .11644380E+01,  .13594100E+01,
     +   .15511590E+01,  .17411420E+01,  .19302900E+01,
     +   .43853270E+00,  .51731970E+00,  .54446970E+00,  .71438090E+00,
     +   .74729330E+00,  .79777910E+00,  .96035330E+00,  .11183840E+01,
     +   .12741880E+01,  .14288210E+01,  .15827430E+01,
     +   .38791870E+00,  .44939010E+00,  .47063000E+00,  .60780210E+00,
     +   .63118570E+00,  .67277980E+00,  .80695640E+00,  .93777170E+00,
     +   .10670820E+01,  .11957530E+01,  .13245020E+01 /
        DATA ((GL(IX,IQ),IQ=1,11),IX=19,24)/ 
     +   .34665570E+00,  .39505460E+00,  .41184650E+00,  .52420930E+00,
     +   .54084130E+00,  .57569740E+00,  .68834800E+00,  .79851220E+00,
     +   .90768090E+00,  .10164890E+01,  .11253730E+01,
     +   .31239220E+00,  .35071640E+00,  .36409070E+00,  .45726440E+00,
     +   .46905640E+00,  .49866390E+00,  .59456930E+00,  .68866500E+00,
     +   .78213980E+00,  .87541510E+00,  .96853840E+00,
     +   .28350310E+00,  .31393070E+00,  .32463340E+00,  .40263530E+00,
     +   .41088930E+00,  .43633690E+00,  .51896510E+00,  .60030390E+00,
     +   .68131460E+00,  .76235900E+00,  .84367270E+00,
     +   .25882940E+00,  .28298000E+00,  .29156430E+00,  .35741600E+00,
     +   .36299110E+00,  .38509200E+00,  .45702380E+00,  .52806320E+00,
     +   .59898170E+00,  .67003450E+00,  .74135010E+00,
     +   .23752240E+00,  .25662460E+00,  .26350900E+00,  .31945240E+00,
     +   .32311680E+00,  .34246850E+00,  .40562650E+00,  .46821550E+00,
     +   .53084740E+00,  .59371670E+00,  .65700290E+00,
     +   .21894650E+00,  .23394800E+00,  .23945450E+00,  .28730270E+00,
     +   .28941910E+00,  .30650290E+00,  .36240090E+00,  .41797570E+00,
     +   .47370080E+00,  .52958380E+00,  .58507090E+00 /
        DATA ((GL(IX,IQ),IQ=1,11),IX=25,30)/ 
     +   .20261640E+00,  .21425900E+00,  .21863880E+00,  .25972380E+00,
     +   .26072540E+00,  .27590580E+00,  .32571060E+00,  .37539280E+00,
     +   .42531580E+00,  .47533090E+00,  .52403220E+00,
     +   .18815480E+00,  .19702690E+00,  .20047890E+00,  .23591050E+00,
     +   .23603700E+00,  .24960760E+00,  .29425620E+00,  .33894140E+00,
     +   .38394360E+00,  .42915350E+00,  .47359070E+00,
     +   .17526470E+00,  .18183780E+00,  .18452110E+00,  .21516090E+00,
     +   .21466740E+00,  .22685990E+00,  .26709920E+00,  .30750590E+00,
     +   .34829710E+00,  .38960260E+00,  .43225460E+00,
     +   .16370820E+00,  .16836440E+00,  .17040750E+00,  .19698360E+00,
     +   .19598750E+00,  .20700130E+00,  .24345240E+00,  .28017040E+00,
     +   .31730650E+00,  .35494590E+00,  .39383850E+00,
     +   .12746030E+00,  .12707300E+00,  .12743460E+00,  .14270610E+00,
     +   .14072550E+00,  .14836340E+00,  .17392820E+00,  .19999170E+00,
     +   .22653530E+00,  .25348820E+00,  .28086890E+00,
     +   .10200540E+00,  .99072851E-01,  .98585270E-01,  .10733410E+00,
     +   .10519130E+00,  .11076640E+00,  .12963620E+00,  .14908340E+00,
     +   .16899390E+00,  .18924010E+00,  .20980620E+00 /
        DATA ((GL(IX,IQ),IQ=1,11),IX=31,36)/ 
     +   .83261266E-01,  .79071991E-01,  .78161083E-01,  .82952023E-01,
     +   .80975369E-01,  .85207291E-01,  .99679098E-01,  .11473360E+00,
     +   .13021420E+00,  .14599940E+00,  .16219400E+00,
     +   .68968028E-01,  .64226680E-01,  .63123502E-01,  .65433361E-01,
     +   .63734278E-01,  .67045681E-01,  .78477465E-01,  .90464495E-01,
     +   .10283340E+00,  .11547220E+00,  .12849930E+00,
     +   .57774346E-01,  .52880250E-01,  .51714636E-01,  .52434806E-01,
     +   .51041912E-01,  .53698793E-01,  .62946260E-01,  .72705969E-01,
     +   .82802862E-01,  .93068495E-01,  .10302780E+00,
     +   .48822779E-01,  .44005964E-01,  .42852037E-01,  .42545836E-01,
     +   .41453704E-01,  .43628745E-01,  .51253814E-01,  .59342265E-01,
     +   .67724489E-01,  .76302469E-01,  .85065432E-01,
     +   .41543383E-01,  .36935728E-01,  .35835505E-01,  .34868360E-01,
     +   .34053877E-01,  .35865203E-01,  .42253211E-01,  .49054630E-01,
     +   .56095999E-01,  .63209556E-01,  .70077658E-01,
     +   .35542656E-01,  .31217217E-01,  .30193670E-01,  .28811287E-01,
     +   .28240420E-01,  .29770782E-01,  .35194006E-01,  .40982444E-01,
     +   .46963304E-01,  .52930225E-01,  .58454961E-01 /
        DATA ((GL(IX,IQ),IQ=1,11),IX=37,42)/ 
     +   .30540215E-01,  .26534021E-01,  .25598461E-01,  .23967603E-01,
     +   .23608219E-01,  .24916900E-01,  .29572174E-01,  .34549791E-01,
     +   .39702527E-01,  .44911645E-01,  .49987104E-01,
     +   .26330978E-01,  .22658577E-01,  .21815188E-01,  .20044504E-01,
     +   .19868838E-01,  .21000214E-01,  .25034785E-01,  .29350990E-01,
     +   .33817947E-01,  .38380049E-01,  .43175381E-01,
     +   .22761498E-01,  .19423366E-01,  .18671896E-01,  .16839994E-01,
     +   .16821781E-01,  .17807977E-01,  .21331685E-01,  .25101034E-01,
     +   .28996825E-01,  .32948896E-01,  .36902972E-01,
     +   .19714693E-01,  .16702496E-01,  .16039969E-01,  .14202482E-01,
     +   .14312029E-01,  .15178242E-01,  .18276546E-01,  .21587918E-01,
     +   .25004115E-01,  .28461335E-01,  .31901490E-01,
     +   .17099718E-01,  .14399716E-01,  .13821516E-01,  .12014621E-01,
     +   .12229261E-01,  .12995567E-01,  .15735839E-01,  .18660692E-01,
     +   .21690875E-01,  .24895152E-01,  .28732846E-01,
     +   .14845011E-01,  .12440257E-01,  .11940845E-01,  .10187574E-01,
     +   .10491603E-01,  .11172105E-01,  .13605919E-01,  .16198263E-01,
     +   .18864267E-01,  .21574745E-01,  .24365081E-01 /
        DATA ((GL(IX,IQ),IQ=1,11),IX=43,48)/ 
     +   .12893437E-01,  .10765237E-01,  .10338598E-01,  .86557819E-02,
     +   .90296203E-02,  .96370047E-02,  .11807495E-01,  .14113699E-01,
     +   .16476428E-01,  .18850012E-01,  .21186231E-01,
     +   .11198856E-01,  .93277292E-02,  .89676771E-02,  .73661194E-02,
     +   .77940393E-02,  .83379159E-02,  .10279461E-01,  .12337290E-01,
     +   .14443425E-01,  .16574530E-01,  .18737625E-01,
     +   .97235842E-02,  .80898963E-02,  .77902800E-02,  .62755812E-02,
     +   .67443443E-02,  .72326530E-02,  .89736022E-02,  .10813558E-01,
     +   .12689628E-01,  .14571436E-01,  .16437961E-01,
     +   .84365765E-02,  .70209587E-02,  .67757773E-02,  .53504459E-02,
     +   .58481670E-02,  .62875370E-02,  .78516202E-02,  .94999624E-02,
     +   .11178712E-01,  .12874294E-01,  .14605011E-01,
     +   .73120063E-02,  .60956310E-02,  .58991169E-02,  .45637870E-02,
     +   .50804755E-02,  .54762443E-02,  .68831155E-02,  .83620390E-02,
     +   .98717529E-02,  .11428135E-01,  .13068485E-01,
     +   .63282275E-02,  .52929819E-02,  .51396578E-02,  .38933353E-02,
     +   .44199834E-02,  .47767651E-02,  .60432088E-02,  .73699811E-02,
     +   .87127574E-02,  .10057214E-01,  .11411997E-01 /
        DATA ((GL(IX,IQ),IQ=1,11),IX=49,54)/ 
     +   .54669739E-02,  .45955651E-02,  .44802641E-02,  .33206195E-02,
     +   .38496056E-02,  .41713011E-02,  .53116912E-02,  .65027177E-02,
     +   .77011143E-02,  .88746678E-02,  .99681346E-02,
     +   .47127111E-02,  .39887261E-02,  .39066095E-02,  .28307301E-02,
     +   .33553415E-02,  .36453218E-02,  .46720691E-02,  .57427599E-02,
     +   .68357103E-02,  .80072861E-02,  .94076097E-02,
     +   .40521673E-02,  .34600997E-02,  .34066585E-02,  .24112663E-02,
     +   .29261985E-02,  .31872878E-02,  .41110185E-02,  .50702901E-02,
     +   .60250992E-02,  .69173952E-02,  .75759287E-02,
     +   .34739231E-02,  .29991798E-02,  .29702333E-02,  .20518992E-02,
     +   .25519510E-02,  .27867043E-02,  .36168986E-02,  .44774325E-02,
     +   .53389524E-02,  .61903261E-02,  .70185601E-02,
     +   .29681101E-02,  .25970007E-02,  .25886917E-02,  .17432495E-02,
     +   .22248747E-02,  .24355252E-02,  .31804622E-02,  .39506904E-02,
     +   .47161230E-02,  .54487702E-02,  .60870470E-02,
     +   .25261631E-02,  .22458818E-02,  .22546651E-02,  .14785756E-02,
     +   .19382576E-02,  .21268046E-02,  .27938937E-02,  .34815152E-02,
     +   .41530817E-02,  .47463877E-02,  .51725246E-02 /
        DATA ((GL(IX,IQ),IQ=1,11),IX=55,60)/ 
     +   .21406065E-02,  .19392093E-02,  .19618410E-02,  .12511247E-02,
     +   .16862222E-02,  .18544963E-02,  .24503896E-02,  .30631558E-02,
     +   .36543363E-02,  .41417694E-02,  .43804199E-02,
     +   .18048959E-02,  .16712700E-02,  .17047965E-02,  .10559455E-02,
     +   .14644208E-02,  .16139932E-02,  .21446492E-02,  .26926622E-02,
     +   .32628893E-02,  .39804033E-02,  .51951655E-02,
     +   .15132793E-02,  .14371148E-02,  .14788593E-02,  .88831043E-03,
     +   .12684151E-02,  .14008406E-02,  .18716479E-02,  .23557961E-02,
     +   .28372828E-02,  .33232141E-02,  .38416204E-02,
     +   .12606832E-02,  .12324414E-02,  .12799926E-02,  .74424793E-03,
     +   .10950567E-02,  .12116791E-02,  .16275726E-02,  .20548766E-02,
     +   .24787872E-02,  .29049153E-02,  .33533813E-02,
     +   .10426207E-02,  .10535023E-02,  .11047025E-02,  .62077324E-03,
     +   .94134692E-03,  .10434433E-02,  .14089389E-02,  .17839950E-02,
     +   .21523484E-02,  .25089125E-02,  .28646204E-02,
     +   .85511315E-03,  .89702843E-03,  .94996102E-03,  .51481061E-03,
     +   .80484606E-03,  .89360634E-03,  .12128714E-02,  .15403864E-02,
     +   .18615247E-02,  .21698938E-02,  .24510692E-02 /
        DATA ((GL(IX,IQ),IQ=1,11),IX=61,66)/ 
     +   .69462199E-03,  .76016103E-03,  .81314059E-03,  .42395398E-03,
     +   .68344019E-03,  .75998489E-03,  .10368736E-02,  .13208538E-02,
     +   .15991258E-02,  .18703775E-02,  .21409541E-02,
     +   .55799709E-03,  .64040016E-03,  .69196307E-03,  .34613954E-03,
     +   .57541387E-03,  .64079266E-03,  .87887404E-03,  .11229855E-02,
     +   .13612587E-02,  .15899333E-02,  .17994390E-02,
     +   .44242750E-03,  .53555850E-03,  .58445230E-03,  .27959974E-03,
     +   .47923587E-03,  .53444429E-03,  .73704944E-03,  .94491709E-03,
     +   .11499835E-02,  .13629402E-02,  .16131144E-02,
     +   .37976223E-03,  .47674883E-03,  .52342948E-03,  .24302480E-03,
     +   .42460355E-03,  .47393574E-03,  .65595709E-03,  .84273744E-03,
     +   .10278203E-02,  .12271540E-02,  .14861936E-02,
     +   .32377799E-03,  .42259792E-03,  .46670469E-03,  .20990966E-03,
     +   .37385608E-03,  .41766485E-03,  .58025646E-03,  .74656424E-03,
     +   .90435368E-03,  .10364352E-02,  .11024800E-02,
     +   .27395386E-03,  .37272234E-03,  .41394209E-03,  .17995390E-03,
     +   .32672964E-03,  .36536818E-03,  .50967175E-03,  .65769651E-03,
     +   .80517057E-03,  .97348861E-03,  .12287423E-02 /
        DATA ((GL(IX,IQ),IQ=1,11),IX=67,72)/ 
     +   .22980465E-03,  .32677129E-03,  .36483782E-03,  .15289533E-03,
     +   .28305233E-03,  .31685113E-03,  .44392538E-03,  .57369040E-03,
     +   .69590734E-03,  .79750392E-03,  .85393875E-03,
     +   .19087768E-03,  .28442426E-03,  .31911809E-03,  .12851208E-03,
     +   .24262680E-03,  .27191307E-03,  .38280417E-03,  .49586652E-03,
     +   .60144276E-03,  .68557670E-03,  .71986660E-03,
     +   .15675026E-03,  .24538868E-03,  .27653706E-03,  .10655740E-03,
     +   .20529632E-03,  .23038426E-03,  .32609791E-03,  .42376091E-03,
     +   .51794731E-03,  .61210821E-03,  .71923883E-03,
     +   .12702562E-03,  .20939946E-03,  .23687704E-03,  .86850647E-04,
     +   .17095124E-03,  .19214209E-03,  .27363410E-03,  .35657937E-03,
     +   .43596257E-03,  .51353715E-03,  .59708609E-03,
     +   .10133997E-03,  .17622036E-03,  .19994892E-03,  .69206086E-04,
     +   .13947536E-03,  .15706119E-03,  .22526080E-03,  .29422212E-03,
     +   .35635440E-03,  .39608881E-03,  .37468970E-03,
     +   .79367856E-04,  .14563842E-03,  .16558901E-03,  .53488286E-04,
     +   .11076736E-03,  .12503305E-03,  .18085355E-03,  .23724210E-03,
     +   .29005515E-03,  .33739625E-03,  .37392578E-03 /
        DATA ((GL(IX,IQ),IQ=1,11),IX=73,78)/ 
     +   .60783786E-04,  .11746485E-03,  .13366299E-03,  .39538561E-04,
     +   .84787382E-04,  .96002914E-04,  .14032156E-03,  .18491085E-03,
     +   .22700217E-03,  .26840641E-03,  .31536425E-03,
     +   .45273802E-04,  .91536160E-04,  .10406847E-03,  .27264969E-04,
     +   .61503961E-04,  .69928057E-04,  .10360509E-03,  .13728385E-03,
     +   .16879971E-03,  .19924328E-03,  .23159156E-03,
     +   .32502478E-04,  .67715468E-04,  .76742552E-04,  .16574819E-04,
     +   .40923231E-04,  .46800356E-04,  .70686932E-04,  .94421048E-04,
     +   .11643116E-03,  .13739125E-03,  .15853342E-03,
     +   .21987848E-04,  .45899367E-04,  .51682022E-04,  .74050604E-05,
     +   .23103194E-04,  .26661361E-04,  .41614618E-04,  .56428016E-04,
     +   .70160619E-04,  .83918188E-04,  .10076668E-03,
     +   .13204433E-04,  .26131152E-04,  .29027275E-04, -.28512312E-06,
     +   .81521121E-05,  .95961141E-05,  .16516115E-04,  .23530647E-04,
     +   .30009225E-04,  .36369518E-04,  .43395718E-04,
     +   .42339570E-05,  .81012440E-05,  .87494236E-05, -.69599464E-05,
     +  -.40101486E-05, -.44945273E-05, -.45099641E-05, -.38566682E-05,
     +  -.30550304E-05, -.17409886E-05,  .20399091E-05 /
******************************************************************
        q2=q*q
*if x is out of range
       IF((X.LT.5.0D-4).OR.(X.GT.1.0D0)) GOTO 90
*******************************************************************
       IF (ICALL.NE.1) THEN
* get the x coordinates
       CALL GS2XCOR(Y,NP)
C       OPEN(UNIT=30,FILE='FOR030.DAT',status='old')
C       DO 20 IQ=1,NQ
C        DO 10 IX=1,NP
C         READ(30,*)SIG(IX,IQ),QNS(IX,IQ),GL(IX,IQ)
C   10   CONTINUE  
C   20  CONTINUE  
        ICALL=1
        END IF
*
      DO 30 IX=1,NP
        A(IX)=Y(IX)
   30 CONTINUE
      DO 40 IQ=1,NQ
        A(NP+IQ)=QT(IQ)
   40 CONTINUE
*
      NA(1)=NP
      NA(2)=NQ  
       XT(1)=X
       XT(2)=Q2
      XSIG=DBFINT(2,XT,NA,A,SIG)
      XQNS=DBFINT(2,XT,NA,A,QNS)
        G =DBFINT(2,XT,NA,A,GL)
*
      IF (Q2.LT.50.0D0) THEN 
C Use three flavour evolution. 
       U=(XSIG+9.0D0*XQNS)/6.0D0
       D=(XSIG-4.5D0*XQNS)/6.0D0
       S=D
       C=0.0D0
       B=0.0D0
*      
      ELSE IF((Q2.GT.50.0).AND.(Q2.LT.250.0)) THEN
C Use four flavour evolution 
      U=(XSIG+6.0D0*XQNS)/8.0D0
      D=(XSIG-6.0D0*XQNS)/8.0D0
      S=D
      C=U
      B=0.0D0
      ELSE
C Use five flavour evolution
      U=(XSIG+7.5D0*XQNS)/10.0D0
      D=(XSIG-5.0D0*XQNS)/10.0D0
      S=D
      C=U
      B=D
      ENDIF
      U=X*U
      US=U
      D=X*D
      DS=D
      S=X*S
      C=X*C
      B=X*B
      G=X*G
 90   RETURN
      END
