/*
 *    Copyright (C) 1999-2002 Stijn van Dongen.
*/

#include "segment.h"
#include "util.h"

#include "util/txt.h"
#include "util/alloc.h"


void  yamSegFree
(  yamSeg   **segpp
)
   {
      yamSeg*   seg        =  *segpp

   ;  if (seg->idx && !seg->txt)
         fprintf(stderr, "PBD at seg idx <%d>\n", seg->idx)
      ,  exit(1)

   ;  if (seg->idx)                   /* the first segment txt is not freed */
      mcxTingFree(&(seg->txt))

   ;  free(seg)
   ;  *segpp               =  NULL
;  }


yamSeg*  yamSegPush
(
   yamSeg*  prev_seg
,  mcxTing*  txt
)
   {
      yamSeg*  next_seg =  (yamSeg*)  mcxAlloc(sizeof(yamSeg), EXIT_ON_FAIL)

   ;  if (prev_seg && (prev_seg->idx > 30))
      yamExit("yamSegPush", "exceeding stacking depth 30")

   ;  next_seg->txt        =  txt
   ;  next_seg->offset     =  0
   ;  next_seg->idx        =  prev_seg ?  prev_seg->idx+1   :  0
   ;  next_seg->prev       =  prev_seg
   ;  return next_seg
;  }


