""" Scripting plugin definition. """


# Enthought library imports.
from enthought.envisage import ExtensionItem, ExtensionPoint, PluginDefinition
from enthought.traits.api import List, Str


# The plugin's globally unique identifier (also used as the prefix for all
# identifiers defined in this module).
ID = "enthought.envisage.scripting"


###############################################################################
# Extension points.
###############################################################################

class ScriptingObject(ExtensionItem):
    """ An object to add to the scripting namespace. """

    # The class name of the scripting object.
    class_name = Str

    # The class name of the factory that creates the scripting object (if you
    # specify a class name then you don't need this).
    factory_class_name = Str

    
class Scripting(ExtensionPoint):
    """ Scripting commands etc. """

    # Commands to add to the scripting environment.
    objects = List(ScriptingObject)
    
###############################################################################
# The plugin definition!
###############################################################################

class ScriptingPluginDefinition(PluginDefinition):
    """ The scripting plugin. """
    
    # The plugin's globally unique identifier.
    id = ID
    
    # The name of the class that implements the plugin.
    class_name = ID + ".scripting_plugin.ScriptingPlugin"

    # General information about the plugin.
    name          = "Scripting Plugin"
    version       = "1.0.0"
    provider_name = "Enthought Inc"
    provider_url  = "www.enthought.com"

    # The Id's of the plugins that this plugin requires.
    requires = ["enthought.envisage.core"]

    # The extension points offered by this plugin,
    extension_points = [Scripting]
    
    # The contributions that this plugin makes to extension points offered by
    # either itself or other plugins.
    extensions = []

#### EOF ######################################################################
