#-------------------------------------------------------------------------------
#  
#  The repository plugin definition.  
#  
#  Written by: David C. Morrill
#  
#  Date: 03/28/2006
#  
#  (c) Copyright 2006 by Enthought, Inc.
#  
#-------------------------------------------------------------------------------

""" The repository plugin definition. """

#-------------------------------------------------------------------------------
#  Imports:  
#-------------------------------------------------------------------------------
    
from enthought.envisage \
    import PluginDefinition
    
from enthought.envisage.repository.repository_extensions \
    import RepositoryRootFactory, ExportableObject
    
#-------------------------------------------------------------------------------
#  Constants:  
#-------------------------------------------------------------------------------

# The plugin's globally unique identifier (also used as the prefix for all
# identifiers defined in this module):
ID = "enthought.envisage.repository"

#-------------------------------------------------------------------------------
# The plugin definition.
#-------------------------------------------------------------------------------

PluginDefinition(
    # The plugin's globally unique identifier:
    id = ID,

    # The name of the class that implements the plugin.
    class_name = ID + ".repository_plugin.RepositoryPlugin",

    # General information about the plugin.
    name          = 'Repository Plugin',
    version       = '1.0.0',
    provider_name = 'Enthought Inc',
    provider_url  = 'www.enthought.com',
    enabled       = True,
    autostart     = True,

    # The Id's of the plugins that this plugin requires.
    requires = [
        'enthought.envisage.core'
    ],

    # The extension points offered by this plugin.
    extension_points = [
        RepositoryRootFactory,
        ExportableObject
    ]
)

