/*!================================================================
 module:    vpc11Version.c

 responsible: BurkhardD
 
 special area:   C-PreComp | Version 
 description: Version und Release Ausgabe
 
 see:  
 



    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




 ===================================================================*/

/*==================================================================*
 *  INCLUDES                                                        *
 *==================================================================*/

#include "vpr100.h"
#include "vsp004.h"
#include "vpc00.h"
#include "vpr07c.h"
/*==================================================================*
 *  DECLARATIONS                                                    *
 *==================================================================*/

/*==================================================================*
 *  EXTERNAL PROTOTYPES                                             *
 *==================================================================*/

externC void pc11VersionOutput(tpc_globals *pc);
externC void pc11GetFullVersionString(tsp00_Line *szFullVersion);

/*==================================================================*
 *  FUNCTION PROTOTYPES                                             *
 *==================================================================*/

/*==================================================================*
 *  CODE                                                            *
 *==================================================================*/

externC void sqlwrite (tsp00_Line acLine);

externC void pc11GetFullVersionString(tsp00_Line *szFullVersion)
{
  tsp00_Versionc  VersionString;
  strcpy((char *) *szFullVersion, P07_COMPANY" ");
  strcat((char *) *szFullVersion, P07_PRODNAME" ");
  strcat((char *) *szFullVersion, COMP_NAME_C_PREC_SP100" ");
  sp100_GetVersionString( "Version", s100buildnumber, VersionString);
  strcat((char *) *szFullVersion, VersionString);
}

externC void pc11VersionOutput(tpc_globals *pc)
{
  tpc_prelinetype outline = "";
  if (!pc->pcopts.variant.C_sp4co_sql_precompiler.opt_silent_F) {
    tsp00_Line szFullVersion;
    int len;
    pc11GetFullVersionString(&szFullVersion);
    strcat((char *) outline, (char *) szFullVersion);
    len = (int)strlen((char *) outline);
    memset(&outline[len], ' ', sizeof(outline)-len);
    sqlwrite (outline);    
  }
}

externC void pc11CopyRightOutput(tpc_globals *pc)
{
  tpc_prelinetype outline = "";
  if (!pc->pcopts.variant.C_sp4co_sql_precompiler.opt_silent_F) {
    int len;
    strcat((char *) outline, P07_PC_COPYR_RESERV);
    len = (int)strlen((char *) outline);
    memset(&outline[len], ' ', sizeof(outline)-len);
    sqlwrite (outline);
  }
}

