/*!
  @file           vos78.cpp
  @author         FerdinandF
  @brief          DCOM Registry auf NT
  @see            

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2003-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



\endif
*/




/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gos00.h"
#include "hsp100.h"
#include "heo78.h"
#include "heo01.h"

#define REG_SK_COMPONENTS                      _T("Components")
#define REG_SK_INSTALLATIONS                   _T("Installations")

externC __declspec(dllexport) int o78_nosilent_mode = 0;

/*===========================================================================*
 *  LOCAL FUNCTIONS                                                          *
 *===========================================================================*/

static VOID  os78_deliver_msg ( LONG     lMsgID,
                                ULONG    ulEventType,
                                const char *      pszFormatStr,
                                va_list  VarArgs ) {
  CHAR                  szMsg [256];

  _vsnprintf(szMsg, sizeof(szMsg) - 1, pszFormatStr, VarArgs );
  if ( o78_nosilent_mode ) 
    printf("-E- MSG:%d - %s\r\n", lMsgID, szMsg );
};

/*==========================================================================*/

static teo78_Result os78getInstallationKey(PATHNAME &szSubKey) {
  tsp00_Pathc             szInstallKey;
  tsp01_RteError          RteError;

  if ( !sqlGetDbrootPath( szInstallKey, TERM_WITH_DELIMITER_EO01, &RteError )) {
    if ( o78_nosilent_mode ) 
      printf("-E- can't locate actual installation. RteError: %s\r\n",RteError.RteErrText);
    return entry_not_found_eo78;
  }
  
  if ( szInstallKey[strlen(szInstallKey)-1] == '\\' )
    szInstallKey[strlen(szInstallKey)-1] = '\0';
  char *psz = &szInstallKey[0];
  while ( psz = strchr(psz,'\\')) 
    *psz = '/';
  
  strcpy( szSubKey, REG_SK_INSTALLATIONS );
  strcat( szSubKey, "\\" );
  strcat( szSubKey, szInstallKey );
  if ( sql50_reg_applic_key_exists ( NULL, HKEY_LOCAL_MACHINE, szSubKey )) {
    if ( o78_nosilent_mode ) 
      printf("-E- application subkey not found in registry\r\nsubkey: '%s'\r\n", szSubKey);
    return entry_not_found_eo78;
  };
  return success_eo78;
};

/*===========================================================================*
 *  GLOBAL FUNCTIONS (CODE)                                                  *
 *===========================================================================*/


externC void  sql60_msg_con_diag           ( LONG               lMsgID,
                                             ULONG              ulEventType,
                                             const char         *pszLabel,
                                             const char         *pszFormatStr,
                                             ... )
{
  va_list     args;
  va_start ( args, pszFormatStr);
  os78_deliver_msg ( lMsgID, ulEventType, pszFormatStr, args );
  va_end ( args );
};

/*==========================================================================*/

externC void  sql60_msg_diag               ( LONG               lMsgID,
                                             ULONG              ulEventType,
                                             const char         *pszLabel,
                                             const char         *pszFormatStr,
                                             ... )
{
  va_list     args;
  va_start ( args, pszFormatStr);
  os78_deliver_msg ( lMsgID, ulEventType, pszFormatStr, args );
  va_end ( args );
};

/*==========================================================================*/

externC void  eo60k_Message               ( SAPDB_UInt1         msg_prio ,
                                            tsp00_Int4          ulEventType,
                                            tsp00_Int4          lMsgID ,
                                            const char         *pszLabel ,
                                            const char         *pszText )
{
    if ( msg_prio == 7 )
    {
        sql60_msg_con_diag(lMsgID, ulEventType, pszLabel, pszText);
    }
    else
    {
        sql60_msg_diag(lMsgID, ulEventType, pszLabel, pszText);
    }
}

/*==========================================================================*/

externC teo78_Result sqlComObjectRegister(teo78_ProgIDPfx   pszProgIDPfx,
                                          teo78_Project     pszProject,
                                          teo78_Version     pszVersion,
                                          teo78_ClsID       ClsID,
                                          teo78_ModuleName  pszModuleName )
{
  PATHNAME                szSubKey;
  PATHNAME                szSubKey2;
  PATHNAME                szTmpKey;       /* PTS 1108081  17-OCT-2000 FF */
  PATHNAME                szValue;
  ULONG                   ulNumOfEntries;
  REG_ENTRY_REC           EntyArray[3];
  tsp100_VersionID1       VersionID;
  teo78_Result            rc;
  LONG                    res;            /* PTS 1108081  17-OCT-2000 FF */

  rc = os78getInstallationKey( szSubKey );
  if ( rc != success_eo78 ) {
    return rc;
  }

  strcat( szSubKey, "\\" );
  strcat( szSubKey, REG_SK_COMPONENTS);
  if ( sql50_reg_applic_key_exists ( NULL, HKEY_LOCAL_MACHINE, szSubKey )) {
    res = sql50_reg_put_applic_values ( NULL, NULL, HKEY_LOCAL_MACHINE, szSubKey, NULL,
      0, &EntyArray[0] );
    if ( res ) {
      if ( o78_nosilent_mode ) {
        printf("-E- couldn't create subkey: '%s' in registry RC: %d\r\n", szSubKey, res);
      }
      return system_error_eo78;
    }
  };

  sp100_GetVersionID      ( VersionIDType1_esp100, &s100buildnumberEx, &VersionID );

  /* create subkey: 'LiveCache.project.Vxx'  (version-dependent ProgID)          */
  strcpy(szSubKey2, pszProgIDPfx);
  strcat(szSubKey2, ".");
  strcat(szSubKey2, pszProject);
  strcat(szSubKey2, ".");
  strcat(szSubKey2, pszVersion);

  /* CLSID:   {xxxxxxxx-xxxx-xxxx-xx-xx-xx-xx-xx-xx-xx-xx}                       */
  for ( int i=0; ( '\0' != ClsID[i] ) && ((i) < sizeof(PATHNAME)); i++)
    szValue[i] = ClsID[i];
  szValue[i] = '\0';
  EntyArray[0].ulValueType  = REG_SZ;
  EntyArray[0].pszValueName = "CLSID";        
  EntyArray[0].pValue       = &szValue[0];     
  EntyArray[0].ulValueSize  = (ULONG)strlen(szValue);     
  ulNumOfEntries            = 1;

  strcpy(szTmpKey, szSubKey);         /* PTS 1108081  17-OCT-2000 FF */
  strcat(szTmpKey, "\\");             /* PTS 1108081  17-OCT-2000 FF */
  strcat(szTmpKey, szSubKey2);        /* PTS 1108081  17-OCT-2000 FF */
  sql50_reg_del_applic_key ( NULL, HKEY_LOCAL_MACHINE, szTmpKey );                /* PTS 1108081  17-OCT-2000 FF */
  /* create subkey: 'COMPONENTS\LiveCache.project.Vxx'  (version-dependent ProgID) */
  /* res = sql50_reg_put_applic_values ( NULL, HKEY_LOCAL_MACHINE, szSubKey, szSubKey2, PTS 1108081  17-OCT-2000 FF */
  res = sql50_reg_put_applic_values ( NULL, NULL, HKEY_LOCAL_MACHINE, szTmpKey, NULL,     /*PTS 1108081  17-OCT-2000 FF */
      ulNumOfEntries, &EntyArray[0] );
  if ( res ) {
    if ( o78_nosilent_mode ) {
      printf("-E- couldn't create subkey: '%s' in registry RC: %d\r\n", szTmpKey, res);
    }
    return system_error_eo78;
  }

  /*PTS 1108081  17-OCT-2000 FF */
  if ( EntyArray[0].rc != NO_ERROR ) {
    if ( o78_nosilent_mode ) {
      printf("-E- couldn't create value: '%s:%s' for subkey: '%s' in registry RC: %d\r\n", 
        EntyArray[0].pszValueName, szValue, szTmpKey, EntyArray[0].rc);
    }
    return system_error_eo78;
  }

  /* create subkey: 'COMPONENTS\CLSID\{xxxxxxxx-xxxx-xxxx-xx-xx-xx-xx-xx-xx-xx-xx}'*/

  strcat(szSubKey,"\\CLSID");
  EntyArray[0].ulValueType  = REG_SZ;
  EntyArray[0].pszValueName = "Path";        
  EntyArray[0].pValue       = pszModuleName;
  EntyArray[0].ulValueSize  = (ULONG)strlen(pszModuleName);
  EntyArray[1].ulValueType  = REG_SZ;
  EntyArray[1].pszValueName = "ProgId";        
  EntyArray[1].pValue       = &szSubKey2[0];     
  EntyArray[1].ulValueSize  = (ULONG)strlen(szSubKey2);     
  EntyArray[2].ulValueType  = REG_BINARY;
  EntyArray[2].pszValueName = "VersionID";        
  EntyArray[2].pValue       = &VersionID;
  EntyArray[2].ulValueSize  = sizeof(VersionID);
  ulNumOfEntries            = 3;

  strcpy(szTmpKey, szSubKey);         /* PTS 1108081  17-OCT-2000 FF */
  strcat(szTmpKey, "\\");             /* PTS 1108081  17-OCT-2000 FF */
  strcat(szTmpKey, szValue);          /* PTS 1108081  17-OCT-2000 FF */

  sql50_reg_del_applic_key ( NULL, HKEY_LOCAL_MACHINE, szTmpKey );                /* PTS 1108081  17-OCT-2000 FF */
  /*res = sql50_reg_put_applic_values ( NULL, HKEY_LOCAL_MACHINE, szSubKey, szValue, PTS 1108081  17-OCT-2000 FF */
  res = sql50_reg_put_applic_values ( NULL, NULL, HKEY_LOCAL_MACHINE, szTmpKey, NULL,    /*PTS 1108081  17-OCT-2000 FF */
    ulNumOfEntries, &EntyArray[0] );
  if ( res ) {
    if ( o78_nosilent_mode ) {
      printf("-E- couldn't create application subkey: '%s' in registry\r\nsubkey: '%s'\r\n RC:%d\r\n", szValue, szSubKey, res);
    }
    return system_error_eo78;
  }

  /*PTS 1108081  17-OCT-2000 FF */
  if ( EntyArray[0].rc != NO_ERROR ) {
    if ( o78_nosilent_mode ) {
      printf("-E- couldn't create value: '%s:%s' for subkey: '%s' in registry RC: %d\r\n", 
        EntyArray[0].pszValueName, pszModuleName, szTmpKey, EntyArray[0].rc);
    }
    return system_error_eo78;
  }

  /*PTS 1108081  17-OCT-2000 FF */
  if ( EntyArray[1].rc != NO_ERROR ) {
    if ( o78_nosilent_mode ) {
      printf("-E- couldn't create value: '%s:%s' for subkey: '%s' in registry RC: %d\r\n", 
        EntyArray[1].pszValueName, szSubKey2, szTmpKey, EntyArray[1].rc);
    }
    return system_error_eo78;
  }

  /*PTS 1108081  17-OCT-2000 FF */
  if ( EntyArray[2].rc != NO_ERROR ) {
    if ( o78_nosilent_mode ) {
      printf("-E- couldn't create value: '%s' for subkey: '%s' in registry RC: %d\r\n", 
        EntyArray[2].pszValueName, szTmpKey, EntyArray[2].rc);
    }
    return system_error_eo78;
  }

  return success_eo78;
};

/*==========================================================================*/

externC teo78_Result sqlComObjectUnregister(teo78_ProgIDPfx pszProgIDPfx,
                                            teo78_Project   pszProject,
                                            teo78_Version   pszVersion,
                                            teo78_ClsID     ClsID )
{
  PATHNAME                szSubKey;
  PATHNAME                szSubKey2;
  PATHNAME                szValue;
  REG_ENTRY_REC           EntyArray[1];
  ULONG                   ulNumOfEntries;
  LONG                    res;

  if ( os78getInstallationKey( szSubKey )) {
    return system_error_eo78;
  }

  strcat( szSubKey, "\\" );
  strcat( szSubKey, REG_SK_COMPONENTS);
  res = sql50_reg_applic_key_exists ( NULL, HKEY_LOCAL_MACHINE, szSubKey );
  if ( res ) {
    if ( o78_nosilent_mode ) 
      printf("-W- application subkey not found in registry\r\nsubkey: '%s' RC: %d\r\n", szSubKey, res);
    return success_eo78;
  };

  strcpy(szSubKey2,szSubKey);

  /* delete subkey: 'LiveCache.project.Vxx'  (version-dependent ProgID)          */
  strcat(szSubKey, "\\" );
  strcat(szSubKey, pszProgIDPfx);
  strcat(szSubKey, ".");
  strcat(szSubKey, pszProject);
  strcat(szSubKey, ".");
  strcat(szSubKey, pszVersion);

  EntyArray[0].ulValueType  = REG_SZ;
  EntyArray[0].pszValueName = "CLSID";        
  EntyArray[0].pValue       = &szValue;
  EntyArray[0].ulValueSize  = sizeof(szValue);
  ulNumOfEntries            = 1;

  res = sql50_reg_get_applic_values ( NULL, HKEY_LOCAL_MACHINE, szSubKey, ulNumOfEntries, &EntyArray[0]);
  if (res ) {
    if ( o78_nosilent_mode ) 
      printf("-W- value CLSID or application subkey not found in registry\r\nsubkey: '%s' RC: %d\r\n", szSubKey, res );
  };

  res = sql50_reg_del_applic_key ( NULL, HKEY_LOCAL_MACHINE, szSubKey );
  if ( res ) {
    if ( o78_nosilent_mode ) 
      printf("-W- application subkey not found in registry\r\nsubkey: '%s' RC: %d\r\n", szSubKey, res );
  }

  strcat(szSubKey2, "\\CLSID\\" );
  strcat(szSubKey2, szValue );
  res = sql50_reg_del_applic_key ( NULL, HKEY_LOCAL_MACHINE, szSubKey2 );
  if ( res ) {
    if ( o78_nosilent_mode ) 
      printf("-W- application subkey not found in registry\r\nsubkey: '%s' RC: %d\r\n", szSubKey2, res );
  }

  return success_eo78;
};


/*===========================================================================*
 *  END OF CODE                                                              *
 *===========================================================================*/

