/*!******************************************************************************

  @file         hkb611.h

  ------------------------------------------------------------------------------

  @author       UweH

  @brief        KB_InsDelUpd_interface

\if EMIT_LICENCE  

    ========== licence begin  GPL
    Copyright (c) 2001-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

\endif

********************************************************************************/

#ifndef HKB611_H
#define HKB611_H


/*===========================================================================*
 *     RefType: Both                                                         *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\xbd\x28\xc7\x38\xdf\x17\xab\x93\x63\xce\x75\xe1\x70\xc4\xf9\x73'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "ggg00.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal void kb611del_AllocateClass (
    Log_DeleteCmd*&                      pDeleteCmd,
    tgg00_TransContext    VAR_VALUE_REF  TransContext,
    const tgg00_StackDesc  VAR_VALUE_REF  StackDesc);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb611del_Init (
    Log_DeleteCmd*                       pDeleteCmd,
    const tgg00_FileId    VAR_VALUE_REF  PrimFileId,
    const tgg00_Rec       VAR_VALUE_REF  OldRecord);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb611del_PostponedExecution (
    const Log_DeleteCmd*                 pDeleteCmd,
    tgg00_TransContext    VAR_VALUE_REF  TransContext,
    tgg00_FileId          VAR_VALUE_REF  PrimFileId);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb611del_ReleaseClass (
    Log_DeleteCmd*&                      pDeleteCmd,
    SAPDBMem_IRawAllocator*                 pAllocator);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb611del_WriteAfterImage (
    const Log_DeleteCmd*                 pDeleteCmd,
    tgg00_TransContext    VAR_VALUE_REF  TransContext);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb611del_WriteBeforeImage (
    const Log_DeleteCmd*                 pDeleteCmd,
    tgg00_TransContext    VAR_VALUE_REF  TransContext);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb611IndexGetKey (
    tgg00_TransContext    VAR_VALUE_REF  TransContext,
    tgg00_StEntryAddr                    pStackList,
    tsp00_Int2                           Entries,
    const tgg00_Rec       VAR_VALUE_REF  Rec,
    tsp00_Uint1           VAR_VALUE_REF  InvDescId,
    tgg00_Lkey            VAR_VALUE_REF  SecondaryKey,
    pasbool               VAR_VALUE_REF  allColumnsAreNull);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb611ins_AllocateClass (
    Log_InsertCmd*&                      pInsertCmd,
    tgg00_TransContext    VAR_VALUE_REF  TransContext,
    const tgg00_StackDesc  VAR_VALUE_REF  StackDesc);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb611ins_Init (
    Log_InsertCmd*                       pInsertCmd,
    const tgg00_FileId    VAR_VALUE_REF  PrimFileId,
    const tgg00_Rec       VAR_VALUE_REF  NewRecord);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb611ins_ReleaseClass (
    Log_InsertCmd*&                      pInsertCmd,
    SAPDBMem_IRawAllocator*                 pAllocator);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb611ins_WriteAfterImage (
    const Log_InsertCmd*                 pInsertCmd,
    tgg00_TransContext    VAR_VALUE_REF  TransContext);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb611ins_WriteBeforeImage (
    const Log_InsertCmd*                 pInsertCmd,
    tgg00_TransContext    VAR_VALUE_REF  TransContext);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb611inv_AddInv (
    const Log_InvHandling*                 pInvHandling,
    tgg00_TransContext    VAR_VALUE_REF  TransContext);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb611inv_CheckUniqueIndex (
    const Log_InvHandling*                 pInvHandling,
    tgg00_TransContext    VAR_VALUE_REF  TransContext);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool kb611inv_ContainsLateUniqueCheck (
    const Log_InvHandling*                 pInvHandling);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool kb611inv_ContainsUniqueIndex (
    const Log_InvHandling*                 pInvHandling);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb611inv_DelInv (
    const Log_InvHandling*                 pInvHandling,
    tgg00_TransContext    VAR_VALUE_REF  TransContext);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool kb611inv_ExecuteOutsideBd (
    Log_InvHandling*                     pInvHandling);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool kb611inv_ExistsAnyIndex (
    const Log_InvHandling*                 pInvHandling);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool kb611inv_IsExecutionPostponed (
    const Log_InvHandling*                 pInvHandling);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb611inv_LockAndCheckUniqueIndex (
    const Log_InvHandling*                 pInvHandling,
    tgg00_TransContext    VAR_VALUE_REF  TransContext,
    tgg00_LockReqMode     VAR_VALUE_REF  GrantedMode);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb611inv_LockUniqueBeforeImageIndex (
    const Log_InvHandling*                 pInvHandling,
    tgg00_TransContext    VAR_VALUE_REF  TransContext,
    tgg00_LockReqMode     VAR_VALUE_REF  GrantedMode);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb611inv_LockUniqueIndex (
    const Log_InvHandling*                 pInvHandling,
    tgg00_TransContext    VAR_VALUE_REF  TransContext,
    tgg00_LockReqMode     VAR_VALUE_REF  GrantedMode);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb611upd_AllocateClass (
    Log_UpdateCmd*&                      pUpdateCmd,
    tgg00_TransContext    VAR_VALUE_REF  TransContext,
    const tgg00_StackDesc  VAR_VALUE_REF  StackDesc);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb611upd_AllocateColumnMap (
    Log_UpdateCmd*                       pUpdateCmd,
    tgg00_TransContext    VAR_VALUE_REF  TransContext,
    tsp00_Int4                           MaxEntries);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb611upd_CreateNewRec (
    Log_UpdateCmd*                       pUpdateCmd,
    tgg00_TransContext    VAR_VALUE_REF  TransContext,
    const tgg00_FileId    VAR_VALUE_REF  PrimFileId,
    const tgg00_Rec       VAR_VALUE_REF  OldRecord,
    tgg00_Rec             VAR_VALUE_REF  NewRecord);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool kb611upd_ExistsEntry (
    Log_UpdateCmd*                       pUpdateCmd,
    const tgg00_StackEntry  VAR_VALUE_REF  StackEntry);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb611upd_InitAfterImageWithExistingNewRec (
    Log_UpdateCmd*                       pUpdateCmd,
    const tgg00_FileId    VAR_VALUE_REF  PrimFileId,
    const tgg00_Rec       VAR_VALUE_REF  NewRecord);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb611upd_InitBeforeImageForExistingNewRec (
    Log_UpdateCmd*                       pUpdateCmd,
    tgg00_TransContext    VAR_VALUE_REF  TransContext,
    const tgg00_Rec       VAR_VALUE_REF  OldRecord);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb611upd_InsertColumn (
    Log_UpdateCmd*                       pUpdateCmd,
    const tgg00_StackEntry  VAR_VALUE_REF  StackEntry,
    const tsp00_BytePtr                  pValue,
    tsp00_Int4                           ValueLength,
    tgg00_BasisError      VAR_VALUE_REF  Error);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb611upd_PostponedExecution (
    const Log_UpdateCmd*                 pUpdateCmd,
    tgg00_TransContext    VAR_VALUE_REF  TransContext,
    tgg00_FileId          VAR_VALUE_REF  PrimFileId);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb611upd_ReleaseClass (
    Log_UpdateCmd*&                      pUpdateCmd,
    SAPDBMem_IRawAllocator*                 pAllocator);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb611upd_WriteAfterImage (
    const Log_UpdateCmd*                 pUpdateCmd,
    tgg00_TransContext    VAR_VALUE_REF  TransContext);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb611upd_WriteBeforeImage (
    const Log_UpdateCmd*                 pUpdateCmd,
    tgg00_TransContext    VAR_VALUE_REF  TransContext);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

