/*!
  @file           geo007_1.h
  @author         JoergM,RaymondR,StefanP,RobinW
  @special area   Kernel Messages for UNIX and NT
  @brief          Kernel Messages for UNIX and NT. Used by MSG Macros (geo60.h)
      and EventList (geo200.h)
  @see            


    Every Message consists of:
      Message Number, Message Type, Message Label, Message Text
      Number are seperated in ranges by the four Message Types and the
      catagories NT Kernel only/ UNIX Kernel only/ Common as follows:
      UNIX Kernel RTE Messges                                       11000-12999
      NT/W95 Kernel RTE Message                                     18000-19999
      Since most of these messages are shared between the operating systems
      the Message Number is represented by a Macro N() adding the offset.

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



\endif
*/



#ifndef GEO007_1_H
#define GEO007_1_H

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "geo47.h"

/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/

/* - this types might be defined by geo200.h */
#if !defined(ERR_TYPE) 
# define  ERR_TYPE	  1
#endif

#if !defined(WRN_TYPE) 
# define  WRN_TYPE	  2
#endif

#if !defined(INFO_TYPE) 
# define  INFO_TYPE	  3
#endif

/*==============================================================*/
/*        Kernel RTE Specific Messages                          */
/*==============================================================*/

/*
  - ID_EO007 is used to extract the ID from a message definition

    Example:  
        teo200_EventList::teo200_EventID      Id;

        Id = ID_EO007( ERR_UNKNOWN_ATTRIBUTE );  
*/
#define ID_EO007(_id, _type, _label, _msg)     _id


#if defined(_WIN32)
/* NT
  - Kernel only errors, infos and error messages ( -18000), - -18999), )
*/
#define N(_n)  (_n+18000)
#else
/* UNIX
  - Kernel only errors, infos and error messages ( -11000), - -11999), )
*/
#define N(_n)  (_n+11000)
#endif


/* =========================== ERRORS ==================================================================================== */

/* NEW_NUMBER_RANGE N(0) */
#define  ERR_UNKNOWN_ATTRIBUTE                        N(0),   ERR_TYPE,_T("IO      "),_T("Unknown Attribute: %d   ")
#define  ERR_ILLEGAL_XP_TYPE                          N(1),   ERR_TYPE,_T("XPARAM  "),_T("Illegal xp_type %d   ")
#define  ERR_UNKNOWN_XP_PARAMETER                     N(2),   ERR_TYPE,_T("XPARAM  "),_T("Unknown parameter in xparam : '%s'  ")
#define  ERR_XP_INVALID_LOG_MODE                      N(3),   ERR_TYPE,_T("XPARAM  "),_T("Invalid logmode '%s'")
#define  ERR_XP_TOO_MANY_DEVSPACES                    N(4),   ERR_TYPE,_T("XPARAM  "),_T("Too many volumes, type='%s', allowed=%d")
#define  ERR_XP_TOO_MANY_TASKCLUSTER                  N(5),   ERR_TYPE,_T("XPARAM  "),_T("Too many Taskcluster, wanted=%d, allowed=%d")
#define  ERR_EXCEPTION                                N(6),   ERR_TYPE,_T("EXCEPT  "),_T("EXCEPTION:%#x IP:%#x ( %#x:%#x:%#x:%#x )")
#define  ERR_THRDID_GR_MAXTHREADS                     N(7),   ERR_TYPE,_T("TASKING "),_T("Thread id exceeds internal thread count  ")
#define  ERR_CREATING_THREAD                          N(8),   ERR_TYPE,_T("TASKING "),_T("Could not create thread: '%s', rc = %d")
#define  ERR_RESUMING_THREAD                          N(9),   ERR_TYPE,_T("TASKING "),_T("Could not resume thread: '%s', rc = %d")
#define  ERR_SETTING_THRD_PRIO                        N(10),  ERR_TYPE,_T("TASKING "),_T("Could not set the thread priority, TID:0x%X")
#define  ERR_SETTING_ASYNC_TIMER                      N(11),  ERR_TYPE,_T("TASKING "),_T("setting async timer, rc = %d")
#define  ERR_ILLEGAL_REQUEST                          N(12),  ERR_TYPE,_T("TASKING "),_T("Illegal '%s' request type: %d")
#define  ERR_UNKNOWN_REQUEST                          N(13),  ERR_TYPE,_T("TASKING "),_T("Unknown request received")
#define  ERR_POSTING_UKT_SEM                          N(14),  ERR_TYPE,_T("IPC     "),_T("posting semaphore of UKT:%u, rc = %d")
#define  ERR_POSTING_KT_SEM                           N(15),  ERR_TYPE,_T("IPC     "),_T("posting semaphore of KT:%u, rc = %d")
#define  ERR_WRONG_VMNEWBUF_COUNT                     N(16),  ERR_TYPE,_T("MEMORY  "),_T("'vmnewbuf' requested count '%d' too large")
#define  ERR_CANT_CLOSE_EVENT_SEM                     N(17),  ERR_TYPE,_T("IPC     "),_T("Could not close event semaphore, rc = %d")
#define  ERR_WRONG_DEVSPACE_NO                        N(18),  ERR_TYPE,_T("VOLUMEIO"),_T("Wrong volume number: %d")
#define  ERR_FREE_TASK_STACK                          N(19),  ERR_TYPE,_T("MEMORY  "),_T("Could not free the tasks stack, rc = %d")
#define  ERR_INVALID_DEVNO                            N(20),  ERR_TYPE,_T("VOLUMEIO"),_T("Invalid  space no.")
#define  ERR_DEVSPACE_NOT_ATT                         N(21),  ERR_TYPE,_T("VOLUMEIO"),_T("Volume not attached")
#define  ERR_WRNG_DEVSPACE_POS                        N(22),  ERR_TYPE,_T("VOLUMEIO"),_T("Wrong volume position: %u - Pages: %u")
#define  ERR_WRNG_DEVSPACE_SEEK_POS                   N(23),  ERR_TYPE,_T("VOLUMEIO"),_T("Wrong volume position. Current: %u - Expected: %u")
#define  ERR_VINITOK_NOT_TIMEOUT                      N(24),  ERR_TYPE,_T("TASKING "),_T("'vinitok' called by other than timeout")
#define  ERR_VXXXX_WRONG_TASK                         N(25),  ERR_TYPE,_T("TASKING "),_T("'%s' from wrong task T%d")
#define  ERR_VPTYPE_WRONG_TASK_TYPE                   N(26),  ERR_TYPE,_T("TASKING "),_T("'vptype' unknown task type: %d")
#define  ERR_WRONG_COMM_REC_SIZE                      N(27),  ERR_TYPE,_T("CONNECT "),_T("Inconsistent size of 'RTE_COMM_REC' %d")
#define  ERR_VFINISH_TW_DUR_NORM_OP                   N(28),  ERR_TYPE,_T("TASKING "),_T("Finishing tracewriter during normal operation (dbstate: %d)")
#define  ERR_SHUTDOWN_NOT_UTILITY                     N(29),  ERR_TYPE,_T("TASKING "),_T("'vshutdown' called by other than utility task")
#define  ERR_ILL_SHUTDOWN_MODE                        N(30),  ERR_TYPE,_T("TASKING "),_T("Illegal shutdown mode")
#define  ERR_AWOKE_FROM_WRONG_EVENT                   N(31),  ERR_TYPE,_T("TASKING "),_T("'%s' awoke from wrong event: [T:%03u] CurrReq: 0x%x expected Req: 0x%x")
#define  ERR_VSUSPEND_WRONG_REQ                       N(32),  ERR_TYPE,_T("TASKING "),_T("'vsuspend' awoke by wrong request")
#define  ERR_VSUSPEND_WRONG_REQ_ARGS                  N(33),  ERR_TYPE,_T("VSUSPEND"),_T( "T%d awoked from T%d by %d (wanted %d)")
#define  ERR_VSLEEP_WRONG_REQ_ARGS                    N(34),  ERR_TYPE,_T("VSLEEP  "),_T( "T%d awoked from T%d by %d (wanted %d)")
#define  ERR_VWAIT_WRONG_REQ                          N(35),  ERR_TYPE,_T("TASKING "),_T("'vwait' awoke by wrong request")
#define  ERR_VWAIT_WRONG_REQ_ARGS                     N(36),  ERR_TYPE,_T("VWAIT   "),_T( "T%d awoked from T%d by %d (wanted %d)")
#define  ERR_VWAIT_ILL_BOOL                           N(37),  ERR_TYPE,_T("TASKING "),_T("'vwait' illegal bool: %d, T%d")

#define  ERR_VSLEEP_WRONG_REQ                         N(39),  ERR_TYPE,_T("TASKING "),_T("'vsleep' awoke by wrong request")
#define  ERR_RAV_ENQU_TO_WRONG_UKT                    N(40),  ERR_TYPE,_T("TASKING "),_T("Tried to enqueue resource availability to other UKT")
#define  ERR_REX_ENQU_TO_WRONG_UKT                    N(41),  ERR_TYPE,_T("TASKING "),_T("Tried to enqueue resource exclusive to other UKT")
#define  ERR_KERNELMAINPRG_RETURNED                   N(42),  ERR_TYPE,_T("TASKING "),_T("Kernel main program returned")
#define  ERR_TASK_RETURNED                            N(43),  ERR_TYPE,_T("TASKING "),_T("Task returned unexpectedly")
#define  ERR_TOO_MANY_REGIONS_REQ                     N(44),  ERR_TYPE,_T("TASKING "),_T("Too many regions requested")
#define  ERR_WRONG_SEMAPHORE_IDX                      N(45),  ERR_TYPE,_T("TASKING "),_T("Semaphore index out of range")
#define  ERR_SEC_REGION_REQUEST                       N(46),  ERR_TYPE,_T("TASKING "),_T("Second request on region: %u")
#define  ERR_WRONG_COM_ENQUE                          N(47),  ERR_TYPE,_T("TASKING "),_T("Tried to enqueue remote task to COM-queue")
#define  ERR_ENDEXCL_WITHOUT_BEG                      N(48),  ERR_TYPE,_T("TASKING "),_T("'vbegexcl' must be called first, T%d")
#define  ERR_WRONG_COMM_REC                           N(49),  ERR_TYPE,_T("CONNECT "),_T("Wrong communication segment")
#define  ERR_TEST_APP_NO_US_UT                        N(50),  ERR_TYPE,_T("CONNECT "),_T("'test application' no user/util task")
#define  ERR_ACT_TASK_IN_INACT_UKT                    N(51),  ERR_TYPE,_T("TASKING "),_T("Active tasks in inactive thread")
#define  ERR_INVALID_CONNECT_STRAT                    N(52),  ERR_TYPE,_T("CONNECT "),_T("Invalid connect strategy %d ")
#define  ERR_CONN_NULL_TASK                           N(53),  ERR_TYPE,_T("CONNECT "),_T("Tried to connect NULL task")
#define  ERR_WRONG_CONN_TASK_STATE                    N(54),  ERR_TYPE,_T("CONNECT "),_T("Wrong connect task state")
#define  ERR_VREC_ILL_LENGTH                          N(55),  ERR_TYPE,_T("CONNECT "),_T("'vreceive' illegal length, act:%d, max:%d")
#define  ERR_CANCEL_REQ_UNKNOWN_TSK                   N(56),  ERR_TYPE,_T("CONNECT "),_T("Cancel request for nonexistent task, T%d")
#define  ERR_XCANCEL_REQ_UNKNOWN_TSK                  N(57),  ERR_TYPE,_T("CONNECT "),_T("Cancel request for nonexistent task, T%d")
#define  ERR_APPL_PID_CHANGED                         N(58),  ERR_TYPE,_T("CONNECT "),_T("'vreply' application pid changed")
#define  ERR_WRONG_PACK_ADDR                          N(59),  ERR_TYPE,_T("CONNECT "),_T("'vreply' with wrong packet address: 0x%lx")
#define  ERR_CREATING_EVENT_SEM                       N(60),  ERR_TYPE,_T("IPC     "),_T("Error on creating semaphore: '%s', rc = %d")
#define  ERR_SETTING_TLS                              N(61),  ERR_TYPE,_T("IPC     "),_T("Error on setting thread local storage, rc = %u")
#define  ERR_CLOSING                                  N(62),  ERR_TYPE,_T("IPC     "),_T("Error on closing '%s', rc = %d")
#define  ERR_CANT_MAP_VIEW_OF_FILE                    N(63),  ERR_TYPE,_T("MEMORY  "),_T("Could not map view of file, rc = %d")
#define  ERR_GET_SYS_PAGE_SIZE                        N(64),  ERR_TYPE,_T("MEMORY  "),_T("Could not get the system page size, rc = %u")
#define  ERR_LOAD_BAL_TASK_WRONG_UKT                  N(65),  ERR_TYPE,_T("TASKING "),_T("Task awoken with wrong UKT: %d, Expected %d")
#define  ERR_WRONG_ASYNCI_NO                          N(66),  ERR_TYPE,_T("TASKING "),_T("Wrong ASYNCi requested: %d")
#define  ERR_WRONG_TASK_TYPE                          N(67),  ERR_TYPE,_T("TASKING "),_T("Wrong task type: %d")
#define  ERR_RESCHEDULE_INACT_TASK                    N(68),  ERR_TYPE,_T("TASKING "),_T("Tried to reschedule inactive task: %d")
#define  ERR_WRONG_DISP_STRAT                         N(69),  ERR_TYPE,_T("TASKING "),_T("Wrong dispather strat, ulStrat = %d")
#define  ERR_CASE_DEFAULT_HIT                         N(70),  ERR_TYPE,_T("TASKING "),_T("CASE '%s' default hit")
#define  ERR_NETW_ALREADY_RESTARTED                   N(71),  ERR_TYPE,_T("CONNECT "),_T("Network already restarted")
#define  ERR_VACK_INVALID_PATHID                      N(72),  ERR_TYPE,_T("CONNECT "),_T("'vnacknowledge' invalid pathid: %ld")
#define  ERR_VACK_PATH_NOT_CONNECTED                  N(73),  ERR_TYPE,_T("CONNECT "),_T("'vnacknowledge' path not connected, pathid: %ld")
#define  ERR_VNREC_ILL_PACKET_LENGTH                  N(74),  ERR_TYPE,_T("CONNECT "),_T("'vnreceive' illegal packet length: %d")
#define  ERR_VNREQ_ILL_PACKET_LENGTH                  N(75),  ERR_TYPE,_T("CONNECT "),_T("'vnrequest' illegal packet length: %d")
#define  ERR_VNREC_WRONG_PACKET_REQ                   N(76),  ERR_TYPE,_T("CONNECT "),_T("'vnreceive' wrong packet requested, T%d")
#define  ERR_VNREQ_WRONG_PACKET_ADDR                  N(77),  ERR_TYPE,_T("CONNECT "),_T("'vnrequest' wrong packet address")
#define  ERR_VCLR_INVALID_PATHID                      N(78),  ERR_TYPE,_T("CONNECT "),_T("'vnclear' invalid pathid: %ld")
#define  ERR_VCLR_PATH_NOT_CONNECTED                  N(79),  ERR_TYPE,_T("CONNECT "),_T("'vnclear' path not connected, pathid: %ld")
#define  ERR_VNCL_INVALID_PATHID                      N(80),  ERR_TYPE,_T("CONNECT "),_T("'vnclose' invalid pathid: %ld")
#define  ERR_VNCL_PATH_NOT_CONNECTED                  N(81),  ERR_TYPE,_T("CONNECT "),_T("'vnclose' path not connected, pathid: %ld")
#define  ERR_VNREQ_INVALID_PATHID                     N(82),  ERR_TYPE,_T("CONNECT "),_T("'vnrequest' invalid pathid: %ld")
#define  ERR_VNREQ_PATH_NOT_CONNECTED                 N(83),  ERR_TYPE,_T("CONNECT "),_T("'vnrequest' path not connected, pathid: %ld")
#define  ERR_WRONG_MIN_REPLY_SIZE                     N(84),  ERR_TYPE,_T("CONNECT "),_T("Wrong minimum reply size: %d, expected: %d")
#define  ERR_VNXX_CALL_WRONG_TASK                     N(85),  ERR_TYPE,_T("CONNECT "),_T("'%s' called from wrong task, T%d")
#define  ERR_WRONG_IDENT_SIZE                         N(86),  ERR_TYPE,_T("XPARAM  "),_T("Wrong size of identfier '%s', (size:%d, needed:%s)")
#define  ERR_TASK_TYPE_UNEXPECTED                     N(87),  ERR_TYPE,_T("TASKING "),_T("'%s': unexpected task type: %d")
#define  ERR_WRONG_PACKET_COUNT                       N(88),  ERR_TYPE,_T("CONNECT "),_T("Wrong packet count: ( count:%d, expected: %d)")
#define  ERR_WRONG_OFFSET_REC_POS                     N(89),  ERR_TYPE,_T("CONNECT "),_T("Wrong offset record position: %x-%x")
#define  ERR_WRONG_PACKET_SIZE                        N(90),  ERR_TYPE,_T("CONNECT "),_T("Wrong packet size: %d")
#define  ERR_PACKET_COUNT_MISMATCH                    N(91),  ERR_TYPE,_T("CONNECT "),_T("Packet count mismatch: (%d <> %d)")
#define  ERR_WRONG_COMM_PACKET_POS                    N(92),  ERR_TYPE,_T("CONNECT "),_T("Wrong communication packet position: %d-%d")
#define  ERR_VREC_WITHOUT_REPLY                       N(93),  ERR_TYPE,_T("CONNECT "),_T("'vreceive' without 'vreply', T%d")
#define  ERR_VREC_WRONG_PACKET_REQ                    N(94),  ERR_TYPE,_T("CONNECT "),_T("'vreceive' wrong packet requested, T%d")
#define  ERR_TASK_ALREADY_CONNECTED                   N(95),  ERR_TYPE,_T("CONNECT "),_T("Task already connected, T%d")
#define  ERR_COMM_WITHOUT_CONNECTION                  N(96),  ERR_TYPE,_T("CONNECT "),_T("'vreceive' or 'vreply' without connection, T%d")
#define  ERR_VREP_WITHOUT_RECEIVE                     N(97),  ERR_TYPE,_T("CONNECT "),_T("'vreply' without 'vreceive', T%d")
#define  ERR_EXCEPTION_DESC                           N(98),  ERR_TYPE,_T("EXCEPT  "),_T("EXCEPTION:'%s' (%#x) IP:%#x ( %#x:%#x:%#x:%#x )")
#define  ERR_TEST_IO_ERROR                            N(99),  ERR_TYPE,_T("VOLUMEIO"),_T("User requested I/O error %s devno %ld page %ld")
#define  ERR_WRONG_DEBUG_BREAK_POS                    N(100), ERR_TYPE,_T("DEBUG   "),_T("Wrong 'DEBUG BREAK' Position %ld, must be > %ld")
#define  ERR_ENV_VAR_TO_LONG                          N(101), ERR_TYPE,_T("ENVVAR  "),_T("Environment variable '%s' to long (max:%d)")
#define  ERR_DUMP_REQUEST                             N(102), ERR_TYPE,_T("EXCEPT  "),_T("!!!! EXTERNAL DUMP REQUEST !!!!")
#define  ERR_GATEWAY_PARM_FOUND                       N(103), ERR_TYPE,_T("XPARAM  "),_T("GATEWAY configuration found - KERNEL can't be started")
#define  ERR_DCOM_NYI                                 N(104), ERR_TYPE,_T("DCOM    "),_T("Not yet implemented")
#define  ERR_DEV0_RECEIVE_ERR_SEMOP                   N(105), ERR_TYPE,_T("DCOM    "),_T("ABEND: dev0_receive: semop error: %s ")
#define  ERR_DEV0_RECEIVE_ERR_SEMOP2                  N(106), ERR_TYPE,_T("DCOM    "),_T("semop error: %s")
#define  ERR_MICROSOFT_CPP_EXCEPTION                  N(107), ERR_TYPE,_T("EXCEPT  "),_T("Unhandled C++ Exception: Addr:%#x ( %#x:%#x:%#x:%#x )")
#define  ERR_MALLOC_FAILED_FOR                        N(108), ERR_TYPE,_T("XPARAM  "),_T("memory allocation failed for '%s'")
#define  ERR_XPARAM_PATH_TO_LONG                      N(109), ERR_TYPE,_T("XPARAM  "),_T("Path of new version of paramfile to long: wanted %d, max %d")
#define  ERR_XPARAM_VERSIONING                        N(110), ERR_TYPE,_T("XPARAM  "),_T("versioning of paramfile failed: %s")
#define  ERR_GET_FILE_INFO                            N(111), ERR_TYPE,_T("IO      "),_T("Could not get file info of '%s'; rc = %d")
#define  ERR_IO_ON_DIR                                N(112), ERR_TYPE,_T("IO      "),_T("File I/O on directory '%s' not allowed")
#define  ERR_IO_ON_SYS                                N(113), ERR_TYPE,_T("IO      "),_T("File I/O on system file '%s' not allowed")
#define  ERR_DEVSPACE_ON_RD_ONLY                      N(114), ERR_TYPE,_T("VOLUMEIO"),_T("No volume on read-only file '%s'")
#define  ERR_DURING_Q_FILE_SIZE                       N(115), ERR_TYPE,_T("IO      "),_T("Error while determinig file size, rc = %d")
#define  ERR_CANT_OPEN_TR_DEVSPACE                    N(116), ERR_TYPE,_T("VOLUMEIO"),_T("Could not open kernel trace file %s, rc = %d")
#define  ERR_CANT_WRITE_TR_DEVSPACE                   N(117), ERR_TYPE,_T("VOLUMEIO"),_T("Could not write to kernel trace file %s, rc = %d")
#define  ERR_CANT_CLOSE_TR_DEVSPACE                   N(118), ERR_TYPE,_T("VOLUMEIO"),_T("Could not close to kernel trace file %s, rc = %d")
#define  ERR_INCORRECT_TR_DEVSIZE                     N(119), ERR_TYPE,_T("VOLUMEIO"),_T("Size incorrect of kernel trace file %s")
#define  ERR_VDEVSIZE_UNSUCCSESSFUL                   N(120), ERR_TYPE,_T("VOLUMEIO"),_T("Vdevsize of kernel trace file unsuccsessful")
#define  ERR_CANT_OPEN_PARAM_FILE                     N(121), ERR_TYPE,_T("XPARAM  "),_T("Could not open xparam file")
#define  ERR_XP_ENTRYXX_GR_ENTRYXY                    N(123), ERR_TYPE,_T("XPARAM  "),_T("XParam file entry: %s greater %s")
#define  ERR_XP_ENTRYXX_OUT_OF_RANGE                  N(124), ERR_TYPE,_T("XPARAM  "),_T("XParam file entry: %s (%d) out of range (%d to %d)")
#define  ERR_XP_ENTRYXX_TOO_SMALL                     N(125), ERR_TYPE,_T("XPARAM  "),_T("XParam file entry: %s too small (%d), minimum (%d)")
#define  ERR_XP_ENTRYXX_INCOMPLETE                    N(126), ERR_TYPE,_T("XPARAM  "),_T("XParam file entry: %s incomplete")
#define  ERR_SIGNAL_HANDLING_FAILED                   N(127), ERR_TYPE,_T("EXCEPT  "),_T("Exception handling failed %d")
#define  ERR_ERROR_HANDLING_FAILED                    N(128), ERR_TYPE,_T("EXCEPT  "),_T("Disabling error handling failed %d")
#define  ERR_SET_EXIT_LIST_FAILED                     N(129), ERR_TYPE,_T("EXIT    "),_T("Set exit handler failed %d")
#define  ERR_SERVERDB_TOO_LONG                        N(130), ERR_TYPE,_T("        "),_T("SERVERDB name too long, allowed are %u characters")
#define  ERR_SERVERDB_NO_SET                          N(131), ERR_TYPE,_T("        "),_T("SERVERDB name must be set")
#define  ERR_WRONG_XP_RUNDIR                          N(132), ERR_TYPE,_T("IO      "),_T("Could not change directory, %s: %s")
#define  ERR_XP_RUNDIR_MISSING                        N(133), ERR_TYPE,_T("IO      "),_T("%s missing")
#define  ERR_TOO_MANY_FILEHANDLES                     N(134), ERR_TYPE,_T("IO      "),_T("Won't be able to open %u files")
#define  ERR_DATABASE_ALREADY_RUN                     N(135), ERR_TYPE,_T("        "),_T("Database '%s' already active")
#define  ERR_TSK_CLST_TOK_TOO_LONG                    N(136), ERR_TYPE,_T("TCLUSTER"),_T("TASKCLUSTER - Token too long '%s' - (max. is %d characters)")
#define  ERR_TSK_CLST_TOO_COMPLEX                     N(137), ERR_TYPE,_T("TCLUSTER"),_T("TASKCLUSTER - TaskCluster too complex")
#define  ERR_TSK_CLST_ILL_NUMBER                      N(138), ERR_TYPE,_T("TCLUSTER"),_T("TASKCLUSTER - Illegal number '%s' ")
#define  ERR_TSK_CLST_ILL_THRD_PRIO                   N(139), ERR_TYPE,_T("TCLUSTER"),_T("TASKCLUSTER - Illegal thread priority '%s'")
#define  ERR_TSK_CLST_MULT_DEFINED                    N(140), ERR_TYPE,_T("TCLUSTER"),_T("TASKCLUSTER - Multiply defined '%s'")
#define  ERR_TSK_CLST_MIS_XX_CNT                      N(141), ERR_TYPE,_T("TCLUSTER"),_T("TASKCLUSTER - Missing count on first '%s'")
#define  ERR_TSK_CLST_MORE_T_ONE_UKT                  N(142), ERR_TYPE,_T("TCLUSTER"),_T("TASKCLUSTER - More then one UKT specified - '%s' not valid")
#define  ERR_TSK_CLST_UNKNOWN_TOKEN                   N(143), ERR_TYPE,_T("TCLUSTER"),_T("TASKCLUSTER - Unknown token '%s'")
#define  ERR_TSK_CLST_ILL_CHAR                        N(144), ERR_TYPE,_T("TCLUSTER"),_T("TASKCLUSTER - Illegal character '%c'")
#define  ERR_TSK_CLST_MIS_TASK_TYPE                   N(145), ERR_TYPE,_T("TCLUSTER"),_T("TASKCLUSTER - Missing task type '%s'")
#define  ERR_TSK_CLST_CON_ALRDY_SPEC                  N(146), ERR_TYPE,_T("TCLUSTER"),_T("TASKCLUSTER - Connect strategy already specified")
#define  ERR_TSK_CLST_TOO_MANY_UKTS                   N(147), ERR_TYPE,_T("TCLUSTER"),_T("TASKCLUSTER - Number of UKTs needed: %d, allowed number: %d")
#define  ERR_TSK_CLST_TOO_MANY_TASKS                  N(148), ERR_TYPE,_T("TCLUSTER"),_T("TASKCLUSTER - Too many tasks int UKT: %d, allowed number: %u")
#define  ERR_ALLOC_MEMORY                             N(149), ERR_TYPE,_T("MEMORY  "),_T("Could not allocate memory, rc = %u")
#define  ERR_ALLOC_MEMORY__FILE_LINE__                N(150), ERR_TYPE,_T("MEMORY  "),_T("Could not allocate memory, rc = %u, ( %s:%d )")
#define  ERR_REALLOC_MEMORY__FILE_LINE__              N(151), ERR_TYPE,_T("MEMORY  "),_T("Could not reallocate memory, rc = %u, ( %s:%d )")
#define  ERR_CANT_OPEN_FILE                           N(152), ERR_TYPE,_T("MEMORY  "),_T("Could not open file '%s', rc = %d")
#define  ERR_CMD_FILE_NOT_FOUND                       N(153), ERR_TYPE,_T("        "),_T("CMD.EXE not found")
#define  ERR_CANNOT_EXEC_FILE                         N(154), ERR_TYPE,_T("EXECUTE "),_T("Could not execute file %s, rc = %d")
#define  ERR_CANT_LOCK_UNLOCK_DEVSPACE                N(155), ERR_TYPE,_T("VOLUMEIO"),_T("Could not lock/unlock the volume '%s', rc = %d")
#define  ERR_NOT_A_VALID_DEVSPACE                     N(156), ERR_TYPE,_T("VOLUMEIO"),_T("It's not a valid volume: '%s'")
#define  ERR_DEVSPACE_ALREADY_ATT                     N(157), ERR_TYPE,_T("VOLUMEIO"),_T("Volume '%s' already attached")
#define  ERR_MAX_DEVSPACES_REACHED                    N(158), ERR_TYPE,_T("VOLUMEIO"),_T("Maximum number of volumes reached")
#define  ERR_CANT_OPEN_DEVSPACE                       N(159), ERR_TYPE,_T("VOLUMEIO"),_T("Could not open volume '%s', rc = %d")
#define  ERR_CANT_CREATE_DEVSPACE                     N(160), ERR_TYPE,_T("VOLUMEIO"),_T("Could not create volume '%s', rc = %d")
#define  ERR_CANT_CLOSE_DEVSPACE                      N(161), ERR_TYPE,_T("VOLUMEIO"),_T("Could not close volume, rc = %d")
#define  ERR_CANT_SEEK_ON_DEVSPACE                    N(162), ERR_TYPE,_T("VOLUMEIO"),_T("Could not seek on volume '%s', rc = %d")
#define  ERR_CANT_WRITE_ON_DEVSPACE                   N(163), ERR_TYPE,_T("VOLUMEIO"),_T("Could not write page %d on volume '%s', rc = %d")
#define  ERR_CANT_READ_FROM_DEVSPACE                  N(164), ERR_TYPE,_T("VOLUMEIO"),_T("Could not read page %d from volume: '%s', rc = %d")
#define  ERR_DEVSPACE_IN_USE                          N(165), ERR_TYPE,_T("VOLUMEIO"),_T("Volume '%s' is already used by another process")
#define  ERR_UNKNOWN_FILE_ATTRIBUTE                   N(166), ERR_TYPE,_T("VOLUMEIO"),_T("'%s' has a unknown file attribute")
#define  ERR_ERROR_ON_DEVSPACE                        N(167), ERR_TYPE,_T("VOLUMEIO"),_T("On volume '%s', volume no. %d")
#define  ERR_SINGLEIO_DEVSPACE_UNDEF                  N(168), ERR_TYPE,_T("VOLUMEIO"),_T("Read/write on undefined volume, no. %d")
#define  ERR_SINGLEIO_READ                            N(169), ERR_TYPE,_T("VOLUMEIO"),_T("Could not write on volume, rc = %d")
#define  ERR_SINGLEIO_WRITE                           N(170), ERR_TYPE,_T("VOLUMEIO"),_T("Could not read from volume, rc = %d")
#define  ERR_DIF_SIZE_MIR_DEVSPACES                   N(171), ERR_TYPE,_T("VOLUMEIO"),_T("Different sizes of mirrored volumes, '%s'-'%s'")
#define  ERR_TASK_NOT_ACTIVE                          N(172), ERR_TYPE,_T("TASKING "),_T("Requested task %d not active")
#define  ERR_INDEF_LOOP                               N(173), ERR_TYPE,_T("TASKING "),_T("Loops indefinitely on region %d")
#define  ERR_WRONG_CON_REQUEST                        N(174), ERR_TYPE,_T("CONSOLE "),_T("Wrong console thread request")
#define  ERR_WRONG_CON_REC                            N(175), ERR_TYPE,_T("CONSOLE "),_T("Wrong console record")
#define  ERR_WRONG_REQ_REQUEST                        N(176), ERR_TYPE,_T("CONSOLE "),_T("Wrong REQUESTOR thread request")
#define  ERR_DEVSPACE_COMPRESSED                      N(177), ERR_TYPE,_T("VOLUMEIO"),_T("No volume on compressed file '%s'")
#define  ERR_DEVSPACE_LOCKED                          N(178), ERR_TYPE,_T("VOLUMEIO"),_T("Volume '%s' locked by another process")
#define  ERR_CANT_LOCK_DEVSPACE                       N(179), ERR_TYPE,_T("VOLUMEIO"),_T("Could not lock volume '%s', rc = %d")
#define  ERR_CANT_UNLOCK_DEVSPACE                     N(180), ERR_TYPE,_T("VOLUMEIO"),_T("Could not unlock volume '%s', rc = %d")
#define  ERR_INV_DEVSPACE_SIZE                        N(181), ERR_TYPE,_T("VOLUMEIO"),_T("Volume '%s', invalid size: %u pages")
#define  ERR_XP_ENTRY_INVALID                         N(182), ERR_TYPE,_T("XPARAM  "),_T("XParam file entry '%s' is invalid ( %s ).")
#define  ERR_PARAM_AND_KERNEL_INCOMP                  N(183), ERR_TYPE,_T("VERSION "),_T("Incompatible versions!\r\n   Running kernel:\t%s\r\n   Param file:   \t%s")
#define  ERR_CANT_ALLOC_TLS                           N(184), ERR_TYPE,_T("MEMORY  "),_T("Could not allocate thread local storage, rc = %u")
#define  ERR_CANT_START_DISPATCHER                    N(185), ERR_TYPE,_T("SERVICE "),_T("Could not start service control dispatcher")
#define  ERR_CANT_ALLOC_SECDESC                       N(186), ERR_TYPE,_T("SECURITY"),_T("Could not allocate security descriptor")
#define  ERR_CANT_INIT_SECDESC                        N(187), ERR_TYPE,_T("SECURITY"),_T("Could not initialize security descriptor")
#define  ERR_CANT_SET_DACL                            N(188), ERR_TYPE,_T("SECURITY"),_T("Could not set discretionary access-control list")
#define  ERR_CANT_ALLOW_ACCESS                        N(189), ERR_TYPE,_T("SECURITY"),_T("Could not allow client access (pos = %d, rc = %d)")
#define  ERR_SYNC_ACCESS_DENIED                       N(190), ERR_TYPE,_T("SECURITY"),_T("Synchronize access denied, refusing connect request")
#define  ERR_OPEN_PROCCESS                            N(191), ERR_TYPE,_T("SECURITY"),_T("Could not open proccess, rc = %d")
#define  ERR_CREATE_UKT_SEM                           N(192), ERR_TYPE,_T("IPC     "),_T("Could not create UKT semaphore: '%s', rc = %d")
#define  ERR_ALLOC_TASK_STACK                         N(193), ERR_TYPE,_T("MEMORY  "),_T("Could not allocate the tasks stack, rc = %d")
#define  ERR_DEVSPACE_ACCESS_DENIED                   N(194), ERR_TYPE,_T("SECURITY"),_T("Access on volume '%s' denied")
#define  ERR_KERNEL_VABORT_EXEPT                      N(195), ERR_TYPE,_T("DBCRASH "),_T("vabort:Emergency Shutdown")
#define  ERR_KERNEL_VABORT_EXEPT_CHK                  N(196), ERR_TYPE,_T("DBCRASH "),_T("vabort:Emergency Shutdown, %s: %d")
#define  ERR_RTE_ABORT_EXEPT                          N(197), ERR_TYPE,_T("DBCRASH "),_T("RTE Abort exception")
#define  ERR_RTE_ABORT_EXEPT_CHK                      N(198), ERR_TYPE,_T("DBCRASH "),_T("RTE Abort exception, %s: %d")
#define  ERR_DEVICE_ALREADY_ATT                       N(199), ERR_TYPE,_T("IO      "),_T("Device '%s' already attached")
#define  ERR_MAX_DEVICES_REACHED                      N(200), ERR_TYPE,_T("IO      "),_T("Maximum number of attached devices reached")
#define  ERR_WRONG_DEVICE_TYPE                        N(201), ERR_TYPE,_T("IO      "),_T("Unsupported device type '%s'")
#define  ERR_FILE_DEV_PIPE_NOT_OPEN                   N(202), ERR_TYPE,_T("IO      "),_T("file/device/pipe is not open")
#define  ERR_THREAD_XXX_NOT_ACTIVE                    N(203), ERR_TYPE,_T("IO      "),_T("'%s' not active")
#define  ERR_CANT_SEEK_FILE_DEV_PIPE                  N(204), ERR_TYPE,_T("IO      "),_T("Could not seek on '%s', rc = %d")
#define  ERR_CANT_READ_FILE_DEV_PIPE                  N(205), ERR_TYPE,_T("IO      "),_T("Could not read from '%s', rc = %d")
#define  ERR_CANT_WRITE_FILE_DEV_PIPE                 N(206), ERR_TYPE,_T("IO      "),_T("Could not write to '%s', rc = %d")
#define  ERR_UNKNOWN_ERROR                            N(207), ERR_TYPE,_T("ARGS    "),_T("Unknown error")
#define  ERR_WRONG_BLOCK_SIZE                         N(208), ERR_TYPE,_T("IO      "),_T("Wrong block size (%d) specified for '%s'")
#define  ERR_CANT_CLOSE_FILE_DEV_PIPE                 N(209), ERR_TYPE,_T("IO      "),_T("Could not close file/device/pipe, rc = %d")
#define  ERR_END_OF_MEDIA                             N(210), ERR_TYPE,_T("IO      "),_T("End of media reached during an operation on '%s'")
#define  ERR_FILE_SET_MARK                            N(211), ERR_TYPE,_T("IO      "),_T("A filemark or setmark was reached during an operation on '%s'")
#define  ERR_MEDIA_NOT_PATITIONED                     N(212), ERR_TYPE,_T("IO      "),_T("No partition information found during an operation on '%s'")
#define  ERR_NO_MEDIA_IN_DEVICE                       N(213), ERR_TYPE,_T("IO      "),_T("Could not access '%s', no media in device")
#define  ERR_MEDIA_CHANGED                            N(214), ERR_TYPE,_T("IO      "),_T("Could not access '%s', media changed")
#define  ERR_BAD_DATA_LEN_WRIT_READ                   N(215), ERR_TYPE,_T("IO      "),_T("Bad length of data written/read during an operation on '%s'")
#define  ERR_CANT_OPEN_TAPE                           N(216), ERR_TYPE,_T("IO      "),_T("Could not open tape '%s', rc = %d")
#define  ERR_CANT_GET_TAPE_DRIVE_INFO                 N(217), ERR_TYPE,_T("IO      "),_T("Could not get drive info, '%s', rc = %d")
#define  ERR_CANT_GET_TAPE_MEDIA_INFO                 N(218), ERR_TYPE,_T("IO      "),_T("Could not get media info, '%s', rc = %d")
#define  ERR_CANT_SET_TAPE_DRIVE_INFO                 N(219), ERR_TYPE,_T("IO      "),_T("Could not set drive info, '%s', rc = %d")
#define  ERR_CANT_SET_TAPE_MEDIA_INFO                 N(220), ERR_TYPE,_T("IO      "),_T("Could not set media info, '%s', rc = %d")
#define  ERR_CANT_REWIND_TAPE                         N(221), ERR_TYPE,_T("IO      "),_T("Could not rewind tape '%s', rc = %d")
#define  ERR_CANT_LOCK_UNLOCK_TAPE                    N(222), ERR_TYPE,_T("IO      "),_T("Could not lock/unlock tape '%s', rc = %d")
#define  ERR_CANT_LOAD_UNLOAD_TAPE                    N(223), ERR_TYPE,_T("IO      "),_T("Could not load/unload tape '%s', rc = %d")
#define  ERR_CANT_WRITE_TAPE_MARK                     N(224), ERR_TYPE,_T("IO      "),_T("Could not write tape mark on '%s', rc = %d")
#define  ERR_CRC_ERROR                                N(225), ERR_TYPE,_T("IO      "),_T("CRC error, data/media might be damaged")
#define  ERR_NO_FREE_SERVER_TASK                      N(226), ERR_TYPE,_T("TASKING "),_T("Not enough server tasks")
#define  ERR_CREATE_CONSOLE_WINDOW                    N(227), ERR_TYPE,_T("GUI     "),_T("Creating console window, rc = %d")
#define  ERR_REGISTER_CLASS                           N(228), ERR_TYPE,_T("GUI     "),_T("Could not register class, rc = %d")
#define  ERR_CREATE_EDIT                              N(229), ERR_TYPE,_T("GUI     "),_T("Could not create edit window, rc = %d")
#define  ERR_CANT_READ_FROM_DIAG_FILE                 N(230), ERR_TYPE,_T("IO      "),_T("Could not read from diagnostic file, rc = %d")
#define  ERR_CANT_GET_FILE_INFO                       N(231), ERR_TYPE,_T("IO      "),_T("Could not get diagnostic file size, rc = %d")
#define  ERR_SERVERDB_MISSING                         N(232), ERR_TYPE,_T("        "),_T("Missing SERVERDB name")
#define  ERR_UPDATE_DIAG_WINDOW                       N(233), ERR_TYPE,_T("GUI     "),_T("Could not update diagnostic file window, rc = 0x%x")
#define  ERR_CREATE_TIMER                             N(234), ERR_TYPE,_T("        "),_T("Could not create timer, rc = 0x%x")
#define  ERR_DEVICE_BUSY                              N(235), ERR_TYPE,_T("IO      "),_T("Could not access '%s', device busy")
#define  ERR_UNRECOGNIZED_MEDIA                       N(236), ERR_TYPE,_T("IO      "),_T("Could not access '%s', unrecognized media")
#define  ERR_CANT_TENSION_TAPE                        N(237), ERR_TYPE,_T("IO      "),_T("Could not tension tape '%s', rc = %d")
#define  ERR_PROTOCOL                                 N(238), ERR_TYPE,_T("CONNECT "),_T("Protocol error, (%s, %d)")
#define  ERR_MAXSERVERDB_EXCEEDED                     N(239), ERR_TYPE,_T("CONNECT "),_T("Could not connect, MAXSERVERDB exceeded")
#define  ERR_IO_ON_READ_ONLY                          N(240), ERR_TYPE,_T("CONNECT "),_T("Could not write on read-only file '%s'")
#define  ERR_VNOPEN_TOO_MANY_SESSIONS                 N(241), ERR_TYPE,_T("CONNECT "),_T("'vnopen' refused, MAXSERVERDB exceeded")
#define  ERR_CONN_BROKEN_STATE                        N(242), ERR_TYPE,_T("CONNECT "),_T("Connection broken, pathid: %d, state %d")
#define  ERR_INVALID_DEVSP_DESCR                      N(243), ERR_TYPE,_T("IO      "),_T("Invalid volume description dev_type=%d, spec_devno=%d")
#define  ERR_WRONG_COMMSEG_VERSION                    N(244), ERR_TYPE,_T("CONNECT "),_T("Wrong communication segment version : %d")
#define  ERR_KERNEL_ABORTS_DIAG_INFO                  N(245), ERR_TYPE,_T("EXCEPT  "),_T("Kernel aborts,\r\n   (view diagnostic file: '%s')")
#define  ERR_ASYNCIO_BLOCK_SIZE                       N(246), ERR_TYPE,_T("IO      "),_T("Block_0 IO: LengthGiven = %d, LenghtWanted = %d")
#define  ERR_WRONG_FTYPE                              N(247), ERR_TYPE,_T("IO      "),_T("%s is %s (%s requested)")
#define  ERR_MARKING_DEVSP_AS_BAD                     N(248), ERR_TYPE,_T("IO      "),_T( "Volume '%s', position %d was marked as bad")
#define  ERR_DEVSP_MARKED_AS_BAD                      N(249), ERR_TYPE,_T("IO      "),_T( "Volume '%s' marked as bad at position %d")
#define  ERR_SETTING_THREAD_AFFINITY                  N(250), ERR_TYPE,_T("THREAD  "),_T("Could not set thread affinity, rc = %d")
#define  ERR_DELETE                                   N(251), ERR_TYPE,_T("        "),_T("Could not delete %s")
#define  ERR_CREATE_IO_COMPL_PORT                     N(252), ERR_TYPE,_T("IO      "),_T("Could not create IO completion port, rc = %d")
#define  ERR_GET_QUEUED_COMPL_STATUS                  N(253), ERR_TYPE,_T("OVERL IO"),_T("GetQueuedCompletionStatus failed, rc = %d")
#define  ERR_USER_MISSING_SERV_PRIV                   N(254), ERR_TYPE,_T("SECURITY"),_T("User '%s' - missing privilege to run service")
#define  ERR_MAX_DCOMIS_REACHED                       N(255), ERR_TYPE,_T("IO      "),_T("Maximum number of DCOMis reached")
#define  ERR_ERROR_TEXT                               N(256), ERR_TYPE,_T("        "),_T("Error: %s")
#define  ERR_DCOM_PROXY_MSG                           N(257), ERR_TYPE,_T("DCOM-PXY"),_T("%s")
#define  ERR_DCOM_DUMP_INFO                           N(258), ERR_TYPE,_T("DCOM-DMP"),_T("%s")
#define  ERR_COINITIALIZE                             N(259), ERR_TYPE,_T("DCOM    "),_T("CoInitialize failed, HRESULT = %d ")
#define  ERR_DCOM_COMETHOD_CRASHED                    N(260), ERR_TYPE,_T("DCOM    "),_T("COM-OBJECT : unhandled exception IID:{%8.8X-%4.4X-%4.4X-%2.2X%2.2X-%2.2X%2.2X%2.2X%2.2X%2.2X%2.2X} FKTNO:%d")
#define  ERR_DCOM_DBPROC_CRASHED                      N(261), ERR_TYPE,_T("DCOM    "),_T("COM-DBPROC : unhandled exception IID:{%8.8X-%4.4X-%4.4X-%2.2X%2.2X-%2.2X%2.2X%2.2X%2.2X%2.2X%2.2X} FKTNO:%d")
#define  ERR_DCOM_COCREATE                            N(262), ERR_TYPE,_T("DCOM    "),_T("%s - HRESULT: %d, Context: %s ")
#define  ERR_DCOM_GUID                                N(263), ERR_TYPE,_T("DCOM    "),_T("%s: {%8.8X-%4.4X-%4.4X-%2.2X%2.2X-%2.2X%2.2X%2.2X%2.2X%2.2X%2.2X}")
#define  ERR_DCOM_HRESULT                             N(264), ERR_TYPE,_T("DCOM    "),_T("%s - HRESULT: %d")
#define  ERR_DCOM_NOMEM                               N(265), ERR_TYPE,_T("DCOM    "),_T("%s - no more memory")
#define  ERR_ALLOC_GUARD_PAGE                         N(266), ERR_TYPE,_T("MEMORY  "),_T("Could not allocate the guard page, rc = %d")
# define ERR_GOTODISP_SETCONTEXT                      N(272), ERR_TYPE,_T("GOTODISP"),_T("setcontext: errno = %d")
# define ERR_GOTODISP_SWAPCONTEXT                     N(273), ERR_TYPE,_T("GOTODISP"),_T("swapcontext: errno = %d")
#define  ERR_KERN_PARAM_PID_OUT_OF_RANGE              N(274), ERR_TYPE,_T("KERNPARA"),_T("task id out-of-range %d")
#define  ERR_INIT_MULTITHREADING                      N(275), ERR_TYPE,_T("DBSTART "),_T("Cannot initialize multithreading: %s")
#define  ERR_INIT_CREATE_TLS_KEY                      N(276), ERR_TYPE,_T("DBSTART "),_T("Cannot create main TLS key: %s")
#define  ERR_IPC_SEMC_SEMGET                          N(277), ERR_TYPE,_T("IPC     "),_T("create_sem: semget error, %s")
#define  ERR_IPC_SEMC_SEMCTL_STAT                     N(278), ERR_TYPE,_T("IPC     "),_T("create_sem: semctl (stat) error, %s")
#define  ERR_IPC_SEMC_SEMCTL_SET                      N(279), ERR_TYPE,_T("IPC     "),_T("create_sem: semctl (set) error, %s")
#define  ERR_IPC_SEMC_IDFILE                          N(280), ERR_TYPE,_T("IPC     "),_T("create_sem: creating id file failed")
#define  ERR_IPC_SEMR_SEMCTL                          N(281), ERR_TYPE,_T("IPC     "),_T("remove_sem: id %d semctl (remove) error, %s")
#define  ERR_IPC_SHMC_SHMGET                          N(282), ERR_TYPE,_T("IPC     "),_T("create_shm: shmget error, %s")
#define  ERR_IPC_SHMC_SHMCTL_STAT                     N(283), ERR_TYPE,_T("IPC     "),_T("create_shm: shmctl (stat) error, %s")
#define  ERR_IPC_SHMC_SHMCTL_SET                      N(284), ERR_TYPE,_T("IPC     "),_T("create_shm: shmctl (set) error, %s")
#define  ERR_IPC_SHMC_IDFILE                          N(285), ERR_TYPE,_T("IPC     "),_T("create_shm: creating id file failed")
#define  ERR_IPC_SHMR_SHMCTL                          N(286), ERR_TYPE,_T("IPC     "),_T("remove_shm: id %d shmctl (remove) error, %s")
#define  ERR_IPC_SHMA_SHMAT                           N(287), ERR_TYPE,_T("IPC     "),_T("attach_shm: shmat error, %s id %d flag 0%o addr 0x%lx")
#define  ERR_IPC_SHMA_WRONG_ADDR                      N(288), ERR_TYPE,_T("IPC     "),_T("attach_shm: got wrong address 0x%lx")
#define  ERR_IPC_SHMD_SHMDT                           N(289), ERR_TYPE,_T("IPC     "),_T("detach_shm: shmdt address 0x%lx, %s")
#define  ERR_IPC_SEMS_WHICH                           N(290), ERR_TYPE,_T("IPC     "),_T("stat_sem: id                   %d")
#define  ERR_IPC_SEMS_SHMCTL                          N(291), ERR_TYPE,_T("IPC     "),_T("stat_sem: id %d semctl (stat) error, %s")
#define  ERR_IPC_SEMS_VALUE                           N(292), ERR_TYPE,_T("IPC     "),_T("stat_sem: semaphore value      %d")
#define  ERR_IPC_SEMS_NUM_SEMS                        N(293), ERR_TYPE,_T("IPC     "),_T("stat_sem: number of sems       %d")
#define  ERR_IPC_SEMS_LASTOP_TIME                     N(294), ERR_TYPE,_T("IPC     "),_T("stat_sem: last operation time  %s")
#define  ERR_IPC_SEMS_LASTCHG_TIME                    N(295), ERR_TYPE,_T("IPC     "),_T("stat_sem: last change time     %s")
#define  ERR_IPC_SEMS_LASTOP_PID                      N(296), ERR_TYPE,_T("IPC     "),_T("stat_sem: pid of last operation %d")
#define  ERR_IPC_SEMS_SEMNCNT                         N(297), ERR_TYPE,_T("IPC     "),_T("stat_sem: semncnt %d")
#define  ERR_IPC_SEMS_SEMZCNT                         N(298), ERR_TYPE,_T("IPC     "),_T("stat_sem: semzcnt %d")
#define  ERR_IPC_SHMS_WHICH                           N(299), ERR_TYPE,_T("IPC     "),_T("stat_shm: id           %d")
#define  ERR_IPC_SHMS_SHMCTL                          N(300), ERR_TYPE,_T("IPC     "),_T("stat_shm: shmctl (stat) error, %s")
#define  ERR_IPC_SHMS_SIZE                            N(301), ERR_TYPE,_T("IPC     "),_T("stat_shm: shm size     %ld")
#define  ERR_IPC_SHMS_ATTACHES                        N(302), ERR_TYPE,_T("IPC     "),_T("stat_shm: attaches     %ld")
#define  ERR_IPC_SHMS_CREATOR_UID                     N(303), ERR_TYPE,_T("IPC     "),_T("stat_shm: creator uid  %ld")
#define  ERR_IPC_SHMS_OWNER_UID                       N(304), ERR_TYPE,_T("IPC     "),_T("stat_shm: owner uid    %ld")
#define  ERR_IPC_SHMS_PERMISSIONS                     N(305), ERR_TYPE,_T("IPC     "),_T("stat_shm: permissions  0%4lo")
#define  ERR_IPC_SHMS_CREATOR_PID                     N(306), ERR_TYPE,_T("IPC     "),_T("stat_shm: creator pid  %ld")
#define  ERR_IPC_SHMS_LAST_OP_PID                     N(307), ERR_TYPE,_T("IPC     "),_T("stat_shm: last op pid  %ld")
#define  ERR_IPC_FIFOC_MKNOD                          N(308), ERR_TYPE,_T("IPC     "),_T("create_fifo: '%s' 0%4o mknod error, %s")
#define  ERR_IPC_FIFOC_CHOWN                          N(309), ERR_TYPE,_T("IPC     "),_T("create_fifo: '%s' chown error, %s")
#define  ERR_IPC_FIFOR_UNLINK                         N(310), ERR_TYPE,_T("IPC     "),_T("remove_fifo: '%s' unlink error, %s")
#define  ERR_IPC_IDFILE_OPEN                          N(311), ERR_TYPE,_T("IPC     "),_T("idfile: '%s' open error, %s")
#define  ERR_IPC_IDFILE_FOPEN                         N(312), ERR_TYPE,_T("IPC     "),_T("idfile: '%s' fopen error, %s")
#define  ERR_IPC_KEY_STAT                             N(313), ERR_TYPE,_T("IPC     "),_T("key: cannot stat '%s': %s")
#define  ERR_IPC_CHECK_DIR_STAT                       N(314), ERR_TYPE,_T("IPC     "),_T("cannot stat directory '%s', %s")
#define  ERR_IPC_CHECK_DIR_MKNOD                      N(315), ERR_TYPE,_T("IPC     "),_T("cannot create directory '%s', %s")
#define  ERR_IPC_CHECK_DIR_NOT_DIR                    N(316), ERR_TYPE,_T("IPC     "),_T("'%s' is not a directory !")
#define  ERR_IPC_REMOVE_DIROPEN                       N(317), ERR_TYPE,_T("IPC     "),_T("remove_all:diropen for '%s' failed, %s")
#define  ERR_IPC_REMOVE_ENTRY                         N(318), ERR_TYPE,_T("IPC     "),_T("error removing ipc for '%s', %s")
#define  ERR_IPC_REMOVE_FILE                          N(319), ERR_TYPE,_T("IPC     "),_T("error removing file '%s', %s")
#define  ERR_IPC_REMOVE_COMMAND                       N(320), ERR_TYPE,_T("IPC     "),_T("'%s' failed with %d")
#define  ERR_IPC_REMOVE_DIRECTORY                     N(321), ERR_TYPE,_T("IPC     "),_T("Remove directory '%s' failed, %s")
#define  ERR_CREATE_THREAD                            N(322), ERR_TYPE,_T("TASKING "),_T("Could not create thread: '%s', %s")
#define  ERR_RESUME_THREAD                            N(323), ERR_TYPE,_T("TASKING "),_T("Could not resume thread: '%s', %s")
#define  ERR_FORK_ERR                                 N(324), ERR_TYPE,_T("COREHAND"),_T("Failed to fork son process: %s")
#define  ERR_MISSING_OFFICIAL_NAME                    N(325), ERR_TYPE,_T("IPC     "),_T("Could not get the official TCP/IP hostname")
#define  ERR_SPOOL_DIR_MISSING                        N(326), ERR_TYPE,_T("IO      "),_T("Spool directory is missing")
#define  ERR_CANT_OPEN_DIAGFILES                      N(327), ERR_TYPE,_T("IO      "),_T("Cannot open diagnose files")
#define  ERR_CANT_OPTAIN_KEY                          N(328), ERR_TYPE,_T("IPC     "),_T("Cannot optain common IPC RTE key")
#define  ERR_ILL_RET_FROM_STACK                       N(329), ERR_TYPE,_T("COREHAND"),_T("Illegal return from stack switch")
#define  ERR_COREHANDER_ABORT                         N(330), ERR_TYPE,_T("COREHAND"),_T("ABORTING due to signal %d")
#define  ERR_SWAPCONTEXT_FAILS                        N(331), ERR_TYPE,_T("COREHAND"),_T("ABORTING swapcontext fails %s")
#define  ERR_MALLOC_SYS_ERR                           N(332), ERR_TYPE,_T("MEMORY  "),_T("%4ld:'%s' malloc for %ld bytes failed, %s")
#define  ERR_REALLOC_SYS_ERR                          N(333), ERR_TYPE,_T("MEMORY  "),_T("%4ld:'%s' realloc for %ld bytes failed, %s")
#define  ERR_NOT_ALL_BYTES_READ                       N(334), ERR_TYPE,_T("IO      "),_T("Could not read from '%s', bytes read: %d, bytes wanted: %d")
#define  ERR_NOT_ALL_BYTES_WRITTEN                    N(335), ERR_TYPE,_T("IO      "),_T("Could not write to '%s', bytes written: %d, bytes wanted: %d")
#define  ERR_READING_PARAMFILE                        N(336), ERR_TYPE,_T("VGETXPAR"),_T("Error reading param file: %s")
#define  ERR_MGH_UNAME_FAILED                         N(337), ERR_TYPE,_T("CONNECT "),_T("Getting uname failed: %s")
#define  ERR_MGH_UNAME_TOO_LONG                       N(338), ERR_TYPE,_T("CONNECT "),_T("Nodename returned by uname too long: %s")
#define  ERR_UKT_ASYNCIO_SIGNAL                       N(339), ERR_TYPE,_T("IO      "),_T("Cannot install AIO signal handler: %s")
#define  ERR_GET_SHRD_MEM                             N(340), ERR_TYPE,_T("CONNECT "),_T("Could not get named-shared-memory: '%s', rc = %d")
#define  ERR_ILL_SWAP_TYPE                            N(341), ERR_TYPE,_T("CONNECT "),_T("Illegal swap type: %d")
#define  ERR_ILL_MAXSEGMENTSIZE                       N(342), ERR_TYPE,_T("CONNECT "),_T("Illegal 'MaxSegmentSize': %d")
#define  ERR_ILL_PACK_SIZE                            N(343), ERR_TYPE,_T("CONNECT "),_T("Illegal packet size: %d")
#define  ERR_STACK_OVERFLOW                           N(344), ERR_TYPE,_T("CONNECT "),_T("Stack overflow T%d")
#define  ERR_NETW_NOT_RESTARTED                       N(345), ERR_TYPE,_T("CONNECT "),_T("'%s' network not restarted")
#define  ERR_FUNCTION_NOT_LOADED                      N(346), ERR_TYPE,_T("CONNECT "),_T("Function '%s' not loaded.")
#define  ERR_VT_WRONG_MAP_SIZE                        N(347), ERR_TYPE,_T("TERMINAL"),_T("Wrong map size")
#define  ERR_UNKNOWN_RET_CODE                         N(348), ERR_TYPE,_T("        "),_T("Unknown return code")
#define  ERR_INIT_CALLED_TWICE                        N(349), ERR_TYPE,_T("INIT    "),_T("RTE-Initialize called twice")
#define  ERR_CANT_FREE_MEMORY                         N(350), ERR_TYPE,_T("MEMORY  "),_T("Could not free memory, rc = %d")
#define  ERR_CANT_FREE_HEAP_MEMORY                    N(351), ERR_TYPE,_T("MEMORY  "),_T("Could not free memory of the heap, rc = %u")
#define  ERR_CANT_SUBSET_MEMORY                       N(352), ERR_TYPE,_T("MEMORY  "),_T("Could not subset memory, rc = %u")
#define  ERR_XSER_EXCEPTION                           N(353), ERR_TYPE,_T("XSERVER "),_T("EXCEPTION:%#x Addr:%#x")
#define  ERR_XSER_SURPRISING_HEADER                   N(354), ERR_TYPE,_T("XSERVER "),_T("Surprising header size")
#define  ERR_XSER_WRONG_COMM_REC                      N(355), ERR_TYPE,_T("XSERVER "),_T("Wrong communication segment")
#define  ERR_XSER_WRONG_PACKET_COUNT                  N(356), ERR_TYPE,_T("XSERVER "),_T("Wrong packet count: ( count:%d, expected: %d)")
#define  ERR_ASSERT                                   N(357), ERR_TYPE,_T("ASSERT  "),_T("Assertion failed: '%s' Line: %d")
#define  ERR_INT_ERR_MSG_PRIO7                        N(358), ERR_TYPE,_T("        "),_T("%s")
#define  ERR_TO_MANY_SESSIONS                         N(359), ERR_TYPE,_T("CONNECT "),_T("Too many open sessions")
#define  ERR_UNSUPPORTED_PROT                         N(360), ERR_TYPE,_T("CONNECT "),_T("'sqlconnect' Unsupported protocol %d")
#define  ERR_REQ_SOCKET_CONNECT                       N(361), ERR_TYPE,_T("CONNECT "),_T("Request socket connect error, rc = %d")
#define  ERR_CANT_ALLOC_COM_SEG                       N(362), ERR_TYPE,_T("CONNECT "),_T("Could not create comm. shared memory, rc = %d")
#define  ERR_CANT_CREATE_COM_SEM                      N(363), ERR_TYPE,_T("CONNECT "),_T("Could not create comm. semaphore, rc = %d")
#define  ERR_CANT_WRITE_COM_QUE                       N(364), ERR_TYPE,_T("CONNECT "),_T("Could not write to comm. queue, rc = %d")
#define  ERR_COM_TIMEOUT                              N(365), ERR_TYPE,_T("CONNECT "),_T("Command timeout")
#define  ERR_WAIT_COM_SEM                             N(366), ERR_TYPE,_T("CONNECT "),_T("On waiting for comm. semaphore, rc = %d")
#define  ERR_CONN_INFO_INIT_TWICE                     N(367), ERR_TYPE,_T("CONNECT "),_T("Connection info was initialized twice")
#define  ERR_WRONG_PROTOCOL                           N(368), ERR_TYPE,_T("CONNECT "),_T("Wrong protocol: %d")
#define  ERR_NO_TCPIP_INSTALLED                       N(369), ERR_TYPE,_T("CONNECT "),_T("No TCP/IP inst. to connect remote server")
#define  ERR_INCORRECT_MAXSEGMENTSIZE                 N(370), ERR_TYPE,_T("CONNECT "),_T("Got incorrect max. segment size: %d")
#define  ERR_CANT_CREATE_SOCKET                       N(371), ERR_TYPE,_T("CONNECT "),_T("Request socket create error, rc = %d")
#define  ERR_CANT_SET_BUF_SIZE                        N(372), ERR_TYPE,_T("CONNECT "),_T("Could not set socket buffer (%s), rc = %d")
#define  ERR_KEEP_ALIVE                               N(373), ERR_TYPE,_T("CONNECT "),_T("Setting 'KEEPALIVE' socket option, rc = %d")
#define  ERR_MISSING_HOSTNAME                         N(374), ERR_TYPE,_T("CONNECT "),_T("Could not get the TCP/IP hostname")
#define  ERR_HOSTNAME_TOO_LONG                        N(375), ERR_TYPE,_T("CONNECT "),_T("'HOSTNAME' too long, allowed are %d characters")
#define  ERR_GET_SERV_BY_NAME                         N(376), ERR_TYPE,_T("CONNECT "),_T("TCP/IP service '%s' not found")
#define  ERR_GET_HOST_BY_NAME                         N(377), ERR_TYPE,_T("CONNECT "),_T("TCP/IP host name '%s' not found")
#define  ERR_TCPIP_ADDR_TOO_LONG                      N(378), ERR_TYPE,_T("CONNECT "),_T("TCP/IP address too long, max: %d")
#define  ERR_GET_HOST_BY_ADDR                         N(379), ERR_TYPE,_T("CONNECT "),_T("Error getting TCP/IP host by address: '%s'")
#define  ERR_TCPIP_HOSTNAME_TOO_LONG                  N(380), ERR_TYPE,_T("CONNECT "),_T("TCP/IP host name too long, max: %d")
#define  ERR_NO_MORE_MEMORY                           N(381), ERR_TYPE,_T("CONNECT "),_T("Out of memory")
#define  ERR_FREE_SHRD_MEMORY                         N(382), ERR_TYPE,_T("CONNECT "),_T("Could not free shared memory")
#define  ERR_CREATE_SHRD_MEM                          N(383), ERR_TYPE,_T("CONNECT "),_T("Could not create named-shared-memory: '%s', rc = %d")
#define  ERR_CANT_SND_TO_SOCKET                       N(384), ERR_TYPE,_T("CONNECT "),_T("Connect packet send error, rc = %d")
#define  ERR_PACK_SEND_SIZE_ERROR                     N(385), ERR_TYPE,_T("CONNECT "),_T("Connect packet send size error, length: %d")
#define  ERR_CONN_PACKET_REC_ERR                      N(386), ERR_TYPE,_T("CONNECT "),_T("Connect packet receive error, rc = %d")
#define  ERR_CONN_SERV_REJECT                         N(387), ERR_TYPE,_T("CONNECT "),_T("Server rejected connection")
#define  ERR_CONN_PACKET_GARBLED                      N(388), ERR_TYPE,_T("CONNECT "),_T("Connect packet garbled: %d bytes")
#define  ERR_PACKET_GARBLED                           N(389), ERR_TYPE,_T("CONNECT "),_T("Received a garbled packet: %d bytes")
#define  ERR_REC_MISSING_BYTES                        N(390), ERR_TYPE,_T("CONNECT "),_T("Received a garbled packet, missing %d bytes, %d packets")
#define  ERR_REC_NEW_MAXSENDLEN                       N(391), ERR_TYPE,_T("CONNECT "),_T("New max. send length")
#define  ERR_SOCKET_SND_ERR                           N(392), ERR_TYPE,_T("CONNECT "),_T("Socket send error, rc = %d")
#define  ERR_SOCKET_REC_ERR                           N(393), ERR_TYPE,_T("CONNECT "),_T("Socket receive error, rc = %d")
#define  ERR_CONN_BROKEN                              N(394), ERR_TYPE,_T("CONNECT "),_T("Connection broken")
#define  ERR_ILL_PACKET_SIZE                          N(395), ERR_TYPE,_T("CONNECT "),_T("Illegal packet size: %d")
#define  ERR_DATABASE_NOT_STARTED                     N(396), ERR_TYPE,_T("CONNECT "),_T("Database '%s' not running")
#define  ERR_CANT_OPEN_UKT_SEM                        N(397), ERR_TYPE,_T("CONNECT "),_T("Could not open kernel semaphore, rc = %d")
#define  ERR_UNBAL_REQUEST_REPLY                      N(398), ERR_TYPE,_T("CONNECT "),_T("Unbalanced request/reply")
#define  ERR_POST_UKT_SEM                             N(399), ERR_TYPE,_T("CONNECT "),_T("Posting kernel semaphore, rc = %d")
#define  ERR_FILE_MAPPING_OPEN                        N(400), ERR_TYPE,_T("CONNECT "),_T("Could not open file mapping object, rc = %d")
#define  ERR_FILE_MAPPING_ACCESS                      N(401), ERR_TYPE,_T("CONNECT "),_T("Could not access file mapping object, rc = %d")
#define  ERR_OUT_OF_SOCK_BUF_MEM                      N(402), ERR_TYPE,_T("CONNECT "),_T("Out of socket buffer (%s) memory")
#define  ERR_XSERVER_NOT_ACTIVE                       N(403), ERR_TYPE,_T("CONNECT "),_T("XSERVER might be inactive")
#define  ERR_PROTOCOL_ERROR                           N(404), ERR_TYPE,_T("CONNECT "),_T("Protocol error: '%s'")
#define  ERR_CONN_TIMEOUT                             N(405), ERR_TYPE,_T("CONNECT "),_T("Connect timeout")
#define  ERR_CONN_REFUSED                             N(406), ERR_TYPE,_T("CONNECT "),_T("Connection refused")
#define  ERR_CREATING_REC_THREAD                      N(407), ERR_TYPE,_T("CONNECT "),_T("Could not create 'ASYNC RECEIVE' thread, rc = %d")
#define  ERR_KILL_REC_THREAD                          N(408), ERR_TYPE,_T("CONNECT "),_T("Could not kill 'ASYNC RECEIVE' thread, rc = %d")
#define  ERR_RESERVE_HANDLE_VALUES                    N(409), ERR_TYPE,_T("CONNECT "),_T("Reserving handle values")
#define  ERR_INVALID_PACKET_SIZE                      N(410), ERR_TYPE,_T("CONNECT "),_T("Invalid packet size: %d")
#define  ERR_COM_SERVER_OR_DB_NOT_ACC                 N(411), ERR_TYPE,_T("CONNECT "),_T("XSERVER or database not accessible")
#define  ERR_INVALID_REPL_PACKET_SIZE                 N(412), ERR_TYPE,_T("CONNECT "),_T("Replied sizes invalid, Packet:%d-%d, Header:%d-%d, MinReply:%d")
#define  ERR_INVALID_MAX_DATA_LEN                     N(413), ERR_TYPE,_T("CONNECT "),_T("Invalid maximum data length: %d")
#define  ERR_REPLY_TIMEOUT                            N(414), ERR_TYPE,_T("CONNECT "),_T("Reply timeout")
#define  ERR_WRONG_MESSCLASS_REPL                     N(415), ERR_TYPE,_T("CONNECT "),_T("Got wrong message class: %d")
#define  ERR_INVALID_MIN_REPL_SIZE                    N(416), ERR_TYPE,_T("CONNECT "),_T("Invalid minimum reply size: %d")
#define  ERR_INVALID_REPL_SIZE                        N(417), ERR_TYPE,_T("CONNECT "),_T("Invalid reply size: %d")
#define  ERR_LINGER                                   N(418), ERR_TYPE,_T("CONNECT "),_T("Setting 'LINGER' socket option, rc = %d")
#define  ERR_UTIL_ALREADY_CONN                        N(419), ERR_TYPE,_T("CONNECT "),_T("Utility session is already in use")
#define  ERR_SERV_BY_NAME_ERROR                       N(420), ERR_TYPE,_T("CONNECT "),_T("Unknown TCP/IP service: %s")
#define  ERR_LOADING_TCPIP_DLL                        N(421), ERR_TYPE,_T("CONNECT "),_T("Could not load the SQLTCP-DLL, rc = %d")
#define  ERR_LOADING_FUNCTION                         N(422), ERR_TYPE,_T("CONNECT "),_T("Missing function '%s' in '%s'")
#define  ERR_SOCKET_SELECT_ERR                        N(423), ERR_TYPE,_T("CONNECT "),_T("Socket select error, rc = %d")
#define  ERR_WRONG_TCPIP_VERSION                      N(424), ERR_TYPE,_T("CONNECT "),_T("Wrong TCPIP-DLL version, (check the SQLTCPx.DLL)")
#define  ERR_WRITING_DIAG_FILE                        N(425), ERR_TYPE,_T("MESSAGES"),_T("Could not write to the diagnostic file: '%s', rc = %d")
#define  ERR_WRITING_CON_MSG                          N(426), ERR_TYPE,_T("MESSAGES"),_T("Could not write to the console, rc = %d")
#define  ERR_CANT_ACC_CONSOLE                         N(427), ERR_TYPE,_T("MESSAGES"),_T("Could not access CONSOLE, rc = %d")
#define  ERR_CANT_OPEN_DIAG_FILE                      N(428), ERR_TYPE,_T("MESSAGES"),_T("Could not open diagnostic file: '%s', rc = %d")
#define  ERR_DIAG_FILE_IN_USE                         N(429), ERR_TYPE,_T("MESSAGES"),_T("Diagnostic file '%s' is already used by another process, rc = %u")
#define  ERR_WRONG_DIAG_FILE_NAME                     N(430), ERR_TYPE,_T("MESSAGES"),_T("Wrong diagnostic file name: '%s'")
#define  ERR_WRITING_EVENT_LOG                        N(431), ERR_TYPE,_T("MESSAGES"),_T("Could not write to event log, rc = %d")
#define  ERR_EVENT_LOG_FULL                           N(432), ERR_TYPE,_T("MESSAGES"),_T("Event log is full, rc = %d")
#define  ERR_CANT_OPEN_EVENT_LOG                      N(433), ERR_TYPE,_T("MESSAGES"),_T("Could not open 'application event log', rc = %d")
#define  ERR_WRONG_DIAG_FILE_SIZE                     N(434), ERR_TYPE,_T("MESSAGES"),_T("Wrong diagnostic file size: '%s', %d Pages")
#define  ERR_WRITING_GUI_CON_MSG                      N(435), ERR_TYPE,_T("MESSAGES"),_T("Could not write to the GUI console, rc = %d")
#define  ERR_WRITING_ERROR_DIAG_FILE                  N(436), ERR_TYPE,_T("MESSAGES"),_T("Could not write to the error diagnostic file, rc = %d")
#define  ERR_READING_DIAG_FILE                        N(437), ERR_TYPE,_T("MESSAGES"),_T("Could not read from the diagnostic file: '%s', rc = %d")
#define  ERR_PRINTER_ON                               N(438), ERR_TYPE,_T("PRINTER "),_T("Printer handling")
#define  ERR_OPEN_SPOOLFILE                           N(439), ERR_TYPE,_T("PRINTER "),_T("Open spool file")
#define  ERR_OPEN_PRINTER                             N(440), ERR_TYPE,_T("PRINTER "),_T("Open printer")
#define  ERR_WRITE_SPOOLFILE                          N(441), ERR_TYPE,_T("PRINTER "),_T("Write spool file")
#define  ERR_READ_SPOOLFILE                           N(442), ERR_TYPE,_T("PRINTER "),_T("Read spool file")
#define  ERR_WRITE_PRINTER                            N(443), ERR_TYPE,_T("PRINTER "),_T("Write printer")
#define  ERR_SYNC_SAME                                N(444), ERR_TYPE,_T("EXECUTE "),_T("Synchronous start of the same session")
#define  ERR_SYNC_END                                 N(445), ERR_TYPE,_T("EXECUTE "),_T("Undefined end of a synchronous session, rc = %lu")
#define  ERR_SYNC_START                               N(446), ERR_TYPE,_T("EXECUTE "),_T("Synchronous start of a session, rc = %lu")
#define  ERR_START_SESSION                            N(447), ERR_TYPE,_T("EXECUTE "),_T("Could not start a new session, rc = %lu")
#define  ERR_END_SESSION                              N(448), ERR_TYPE,_T("EXECUTE "),_T("Could not end session, rc = %lu")
#define  ERR_CMD_LENGTH                               N(449), ERR_TYPE,_T("EXECUTE "),_T("Command length: %u")
#define  ERR_CANNOT_EXECUTE_CMD                       N(450), ERR_TYPE,_T("EXECUTE "),_T("Could not execute command, rc = %lu")
#define  ERR_NO_CMD                                   N(451), ERR_TYPE,_T("EXECUTE "),_T("No command to execute")
#define  ERR_SET_STD_HANDLE                           N(452), ERR_TYPE,_T("EXECUTE "),_T("Could not set standard handle, rc = %d")
#define  ERR_CREATE_PIPE                              N(453), ERR_TYPE,_T("PIPE    "),_T("Could not create '%s' pipe, rc = %d")
#define  ERR_OPEN_PIPE                                N(454), ERR_TYPE,_T("PIPE    "),_T("Could not open '%s' pipe , rc = %d")
#define  ERR_WRITE_PIPE                               N(455), ERR_TYPE,_T("PIPE    "),_T("Could not write to '%s' pipe, rc = %d")
#define  ERR_READ_PIPE                                N(456), ERR_TYPE,_T("PIPE    "),_T("Could not read from '%s' pipe, rc = %d")
#define  ERR_CLOSE_PIPE                               N(457), ERR_TYPE,_T("PIPE    "),_T("Could not close '%s' pipe, rc = %d")
#define  ERR_CREATING_BAT_DIAG_FILE                   N(458), ERR_TYPE,_T("EXECUTE "),_T("Could not create 'BATCH' diagnostic file, rc = %d")
#define  ERR_WRONG_TIME_VALUE                         N(459), ERR_TYPE,_T("EXECUTE "),_T("Wrong time value: %u:%u")
#define  ERR_NO_VALID_OPTION                          N(460), ERR_TYPE,_T("ARGS    "),_T("No valid option! Use -h to get help.")
#define  ERR_NO_COMP_SPECIFIED                        N(461), ERR_TYPE,_T("ARGS    "),_T("No component specified")
#define  ERR_WRONG_OPTION_SEQUENCE                    N(462), ERR_TYPE,_T("ARGS    "),_T("Wrong option sequence! Use -h to get help.")
#define  ERR_MISSING_QUOTE                            N(463), ERR_TYPE,_T("ARGS    "),_T("Missing quote in userid or password")
#define  ERR_VF_BAD_FILENO                            N(464), ERR_TYPE,_T("IO      "),_T("Invalid file number")
#define  ERR_VF_ILL_FILE_DESC                         N(465), ERR_TYPE,_T("IO      "),_T("Illegal file description")
#define  ERR_VF_DELETE                                N(466), ERR_TYPE,_T("IO      "),_T("Could not delete file")
#define  ERR_VF_NO_REG_FILE                           N(467), ERR_TYPE,_T("IO      "),_T("Could not delete non-regular files")
#define  ERR_UNLINK_NO_REG_FILE                       N(467), ERR_TYPE,_T("IO      "),_T("Could not delete non-regular file '%s'")
#define  ERR_FILE_EXIST                               N(468), ERR_TYPE,_T("IO      "),_T("File already exists")
#define  ERR_FILE_SHARING_VIOLATION                   N(469), ERR_TYPE,_T("IO      "),_T("The file '%s' is already in use")
#define  ERR_FREE_BUFPOOL_COUNT_DIFF                  N(470), ERR_TYPE,_T("IO      "),_T("Free Buffer pool: block count error")
#define  ERR_ILL_APPEND_DEVICE                        N(471), ERR_TYPE,_T("IO      "),_T("Illegal device for direction append")
#define  ERR_ILL_DIREC                                N(472), ERR_TYPE,_T("IO      "),_T("Illegal direction")
#define  ERR_ILL_FILE_DESC                            N(473), ERR_TYPE,_T("IO      "),_T("Illegal file description")
#define  ERR_ILL_FILE_SPEC                            N(474), ERR_TYPE,_T("IO      "),_T("Illegal specification")
#define  ERR_ILL_DATA_SIZE                            N(475), ERR_TYPE,_T("IO      "),_T("Illegal data size")
#define  ERR_ILL_NEXT_REC_LEN                         N(476), ERR_TYPE,_T("IO      "),_T("Length of next record is out of range")
#define  ERR_ILL_REC_LEN                              N(477), ERR_TYPE,_T("IO      "),_T("Illegal record length")
#define  ERR_ILL_RESOURCE                             N(478), ERR_TYPE,_T("IO      "),_T("Illegal resource")
#define  ERR_MAX_REC                                  N(479), ERR_TYPE,_T("IO      "),_T("Record too big   (> max record length)")
#define  ERR_MIN_REC                                  N(480), ERR_TYPE,_T("IO      "),_T("Record too small (< min record length)")
#define  ERR_NO_FREE_FILE_DESCRIPTOR                  N(481), ERR_TYPE,_T("IO      "),_T("No free file descriptor found")
#define  ERR_TAPE_END_OF_MEDIA                        N(482), ERR_TYPE,_T("IO      "),_T("The end-of-tape marker was reached during an operation on '%s'")
#define  ERR_TAPE_FILE_SET_MARK                       N(483), ERR_TYPE,_T("IO      "),_T("A filemark or setmark was reached during an operation on '%s'")
#define  ERR_TAPE_NOT_PATITIONED                      N(484), ERR_TYPE,_T("IO      "),_T("The tape partition information could not be found on '%s'")
#define  ERR_TAPE_NO_MEDIA_IN_DRIVE                   N(485), ERR_TYPE,_T("IO      "),_T("There is no media in drive '%s'")
#define  ERR_TAPE_MEDIA_CHANGED                       N(486), ERR_TYPE,_T("IO      "),_T("Media changed in drive '%s'")
#define  ERR_MEDIA_WRITE_PROTECTED                    N(487), ERR_TYPE,_T("IO      "),_T("Could not access '%s', the media is write protected")
#define  ERR_TAPE_WRITE_MARK                          N(488), ERR_TYPE,_T("IO      "),_T("Could not write filemark or setmark on '%s'")
#define  ERR_OPEN                                     N(489), ERR_TYPE,_T("IO      "),_T("Could not open file/tape/pipe '%s', rc = %d")
#define  ERR_READ                                     N(490), ERR_TYPE,_T("IO      "),_T("file/tape/pipe read error, rc = %d")
#define  ERR_WRITE                                    N(491), ERR_TYPE,_T("IO      "),_T("file/tape/pipe write error, rc = %d")
#define  ERR_WRITE_FILE                               N(491), ERR_TYPE,_T("IO      "),_T("file/tape/pipe '%s' write error, rc = %d")
#define  ERR_SEEK                                     N(492), ERR_TYPE,_T("IO      "),_T("file seek error, rc = %d")
#define  ERR_SEEK_FILE                                N(492), ERR_TYPE,_T("IO      "),_T("file '%s' seek error, rc = %d")
#define  ERR_REWIND_TAPE                              N(493), ERR_TYPE,_T("IO      "),_T("rewind tape error, rc = %d")
#define  ERR_DEVICE_NOT_READY                         N(494), ERR_TYPE,_T("IO      "),_T("Could not access '%s', device not ready")
#define  ERR_TAPE_PARAM                               N(495), ERR_TYPE,_T("IO      "),_T("Could not get/set tape parameters, rc = %d")
#define  ERR_TAPE_LOCK_UNLOCK                         N(496), ERR_TYPE,_T("IO      "),_T("Could not lock/unlock tape, rc = %d")
#define  ERR_TAPE_LOAD_UNLOAD                         N(497), ERR_TYPE,_T("IO      "),_T("Could not load/unload tape, rc = %d")
#define  ERR_DISK_FULL                                N(498), ERR_TYPE,_T("IO      "),_T("Error on '%s', not enough space on disk")
#define  ERR_WRONG_PATH                               N(499), ERR_TYPE,_T("IO      "),_T("Wrong path '%s'")
#define  ERR_WRONG_FILE_DEVICE_NAME                   N(500), ERR_TYPE,_T("IO      "),_T("Wrong file or device name '%s'")
#define  ERR_BLOCK_SIZE_MISMATCH                      N(501), ERR_TYPE,_T("IO      "),_T("LengthGiven: %d, LenghtWanted: %d")
#define  ERR_GET_FILE_STATUS                          N(502), ERR_TYPE,_T("IO      "),_T("Could not get file status, rc = %d")
#define  ERR_STAT_FILE                                N(502), ERR_TYPE,_T("IO      "),_T("Could not get file '%s' status, rc = %d")
#define  ERR_GET_FILE_TYPE                            N(503), ERR_TYPE,_T("IO      "),_T("Could not get file type, rc = %d")
#define  ERR_QUERY_FILE_TYPE                          N(504), ERR_TYPE,_T("IO      "),_T("Query file-type error for '%s', rc = %d")
#define  ERR_FILE_NOT_FOUND                           N(505), ERR_TYPE,_T("IO      "),_T("The file '%s' was not found")
#define  ERR_VT_WRONG_WINDOW_SIZE                     N(506), ERR_TYPE,_T("TERMINAL"),_T("The window size is to large")
#define  ERR_VT_GET_VIDEO_MODE                        N(507), ERR_TYPE,_T("TERMINAL"),_T("Could not examine Video mode, rc = %hu")
#define  ERR_VT_OPEN_KEYBOARD                         N(508), ERR_TYPE,_T("TERMINAL"),_T("Could not examine Keyboard, rc = %lu")
#define  ERR_VT_CANT_CHANGE_CURSOR                    N(509), ERR_TYPE,_T("TERMINAL"),_T("Could not change cursor type, rc = %hu")
#define  ERR_VT_GET_KBD_STATUS                        N(510), ERR_TYPE,_T("TERMINAL"),_T("Could not get keyboard status, rc = %hu")
#define  ERR_VT_SET_KBD_STATUS                        N(511), ERR_TYPE,_T("TERMINAL"),_T("Could not set keyboard status, rc = %hu")
#define  ERR_VT_CREATE_THREAD                         N(512), ERR_TYPE,_T("TERMINAL"),_T("Could not create thread, rc = %lu")
#define  ERR_VT_RESUME_THREAD                         N(513), ERR_TYPE,_T("TERMINAL"),_T("Could not resume thread, rc = %lu")
#define  ERR_VT_KILL_THREAD                           N(514), ERR_TYPE,_T("TERMINAL"),_T("Could not kill thread, rc = %lu")
#define  ERR_VT_OPEN_MOUSE                            N(515), ERR_TYPE,_T("TERMINAL"),_T("Could not open mouse port, rc = %lu")
#define  ERR_VT_CLOSE_MOUSE                           N(516), ERR_TYPE,_T("TERMINAL"),_T("Could not close mouse port, rc = %lu")
#define  ERR_CANNOT_OPEN_XUSER_FILE                   N(517), ERR_TYPE,_T("XUSER   "),_T("Could not open USER file, rc = %lu")
#define  ERR_CANNOT_OPEN_XUSER_FILE__SYSMSG           N(517), ERR_TYPE,_T("XUSER   "),_T("Could not open USER file, %s")
#define  ERR_CANNOT_CLOSE_XUSER_FILE                  N(518), ERR_TYPE,_T("XUSER   "),_T("Could not close USER file")
#define  ERR_CANNOT_READ_XUSER_FILE                   N(519), ERR_TYPE,_T("XUSER   "),_T("Could not read USER file, rc = %lu")
#define  ERR_CANNOT_READ_XUSER_FILE__SYSMSG           N(519), ERR_TYPE,_T("XUSER   "),_T("Could not read USER file, %s")
#define  ERR_CANNOT_SEEK_XUSER_FILE                   N(520), ERR_TYPE,_T("XUSER   "),_T("Could not seek in USER file, rc = %lu")
#define  ERR_CREATE_XUSER_FILE                        N(521), ERR_TYPE,_T("XUSER   "),_T("Could not create USER file, rc = %lu")
#define  ERR_DELETE_XUSER_FILE                        N(522), ERR_TYPE,_T("XUSER   "),_T("Could not delete USER file, rc = %lu")
#define  ERR_DELETE_XUSER_FILE__SYSMSG                N(522), ERR_TYPE,_T("XUSER   "),_T("Could not delete USER file, %s")
#define  ERR_ILLEGAL_USER_ENTRY                       N(523), ERR_TYPE,_T("XUSER   "),_T("Illegal USER entry, page no = %lu")
#define  ERR_ILLEGAL_USER_INDEX                       N(524), ERR_TYPE,_T("XUSER   "),_T("Illegal USER index, index = %d")
#define  ERR_BLANK_USERKEY                            N(525), ERR_TYPE,_T("XUSER   "),_T("Blank user key not allowed")
#define  ERR_NO_XUSER_ENTRY_FOUND                     N(526), ERR_TYPE,_T("XUSER   "),_T("No entry found")
#define  ERR_NO_SPACE_LEFT                            N(527), ERR_TYPE,_T("XUSER   "),_T("Space for USER entries exhausted")
#define  ERR_NO_XUSER_FILE                            N(528), ERR_TYPE,_T("XUSER   "),_T("Could not find USER file")
#define  ERR_WRONG_XUSER_FILE_LENGTH                  N(529), ERR_TYPE,_T("XUSER   "),_T("Could not read/write the correct USER file length: %lu")
#define  ERR_READ_ERROR_XUSER_EUSER                   N(530), ERR_TYPE,_T("XUSER   "),_T("Could not read effective USER")
#define  ERR_CANNOT_WRITE_XUSER_FILE                  N(531), ERR_TYPE,_T("XUSER   "),_T("Could not write USER file, rc = %lu")
#define  ERR_CANNOT_WRITE_XUSER_FILE__SYSMSG          N(531), ERR_TYPE,_T("XUSER   "),_T("Could not write USER file, %s")
#define  ERR_DIFFERENT_SIDS                           N(532), ERR_TYPE,_T("XUSER   "),_T("Incorrect USER data owner")
#define  ERR_READ_ERROR_XUSER_PAGE                    N(533), ERR_TYPE,_T("XUSER   "),_T("Unknown USER page")
#define  ERR_READ_XUSER_REG_DATA                      N(534), ERR_TYPE,_T("XUSER   "),_T("Could not read USER data, rc = %d")
#define  ERR_WRITE_XUSER_REG_DATA                     N(535), ERR_TYPE,_T("XUSER   "),_T("Could not write USER data, rc = %d")
#define  ERR_REMOVE_XUSER_REG_DATA                    N(536), ERR_TYPE,_T("XUSER   "),_T("Could not remove USER data")
#define  ERR_WRONG_XUSER_REG_DATA_LEN                 N(537), ERR_TYPE,_T("XUSER   "),_T("Wrong USER data length")
#define  ERR_WRITE_CHAR_SET_OPT_VALS                  N(538), ERR_TYPE,_T("XUSER   "),_T("Could not write CHARACTERSET option values, rc = %d")
#define  ERR_READ_CHAR_SET_OPT_VALS                   N(539), ERR_TYPE,_T("XUSER   "),_T("Could not read CHARACTERSET option values, rc = %d")
#define  ERR_WRITE_USER_DIAG_OPT_VALS                 N(540), ERR_TYPE,_T("XUSER   "),_T("Could not write diagnostic file option values, rc = %d")
#define  ERR_READ_USER_DIAG_OPT_VALS                  N(541), ERR_TYPE,_T("XUSER   "),_T("Could not read diagnostic file  option values, rc = %d")
#define  ERR_WRITE_SQLOPT_OPT_VALS                    N(542), ERR_TYPE,_T("XUSER   "),_T("Could not write SQLOPT option values, rc = %d")
#define  ERR_READ_SQLOPT_OPT_VALS                     N(543), ERR_TYPE,_T("XUSER   "),_T("Could not read SQLOPT option values, rc = %d")
#define  ERR_SQLABORT                                 N(544), ERR_TYPE,_T("XUSER   "),_T("Component aborting, PID: %d")
#define  ERR_CANNOT_OPEN_XPARAM_FILE                  N(545), ERR_TYPE,_T("XPARAM  "),_T("Could not open xparam file: '%s'")
#define  ERR_NO_XPARAM_FILE                           N(546), ERR_TYPE,_T("XPARAM  "),_T("Could not find xparam file")
#define  ERR_BLANK_XP_KEY                             N(547), ERR_TYPE,_T("XPARAM  "),_T("Blank keys not allowed")
#define  ERR_CANNOT_WRITE_XP_KEY                      N(548), ERR_TYPE,_T("XPARAM  "),_T("Could not write key, rc = %d")
#define  ERR_CANNOT_WRITE_XP_VALUE                    N(549), ERR_TYPE,_T("XPARAM  "),_T("Could not write value, rc = %d")
#define  ERR_WRITE_ERROR                              N(550), ERR_TYPE,_T("XPARAM  "),_T("Write error")
#define  ERR_CANNOT_READ_XP_KEY                       N(551), ERR_TYPE,_T("XPARAM  "),_T("Could not read key, rc = %d")
#define  ERR_CANNOT_READ_XP_VALUE                     N(552), ERR_TYPE,_T("XPARAM  "),_T("Could not read value, rc = %d")
#define  ERR_READ_ERROR                               N(553), ERR_TYPE,_T("XPARAM  "),_T("Read error")
#define  ERR_CANNOT_FIND_START_POINT                  N(554), ERR_TYPE,_T("XPARAM  "),_T("Could not find start point, rc = %d")
#define  ERR_CANNOT_FIND_PREV_ENTRY                   N(555), ERR_TYPE,_T("XPARAM  "),_T("Could not find previous entry, rc = %d")
#define  ERR_CANNOT_FIND_ACT_ENTRY                    N(556), ERR_TYPE,_T("XPARAM  "),_T("Could not find actual entry, rc = %d")
#define  ERR_EOF_REACHED                              N(557), ERR_TYPE,_T("XPARAM  "),_T("End of file reached")
#define  ERR_PATH_TOO_LONG_FOR_XPF                    N(558), ERR_TYPE,_T("XPARAM  "),_T("Path too long for XPARAM file")
#define  ERR_ACCESS_XPARAM_FILE                       N(559), ERR_TYPE,_T("XPARAM  "),_T("Could not access xparam file, rc = %d")
#define  ERR_CANNOT_CREATE_XP_FILE                    N(560), ERR_TYPE,_T("XPARAM  "),_T("Could not create xparam file")
#define  ERR_CANNOT_WRITE_XP_FILE                     N(561), ERR_TYPE,_T("XPARAM  "),_T("Could not write to xparam file")
#define  ERR_UNDEFINED_OPEN_MODE                      N(562), ERR_TYPE,_T("XPARAM  "),_T("Undefined open mode of xparam file")
#define  ERR_SET_SYNC_ACCESS                          N(563), ERR_TYPE,_T("SECURITY"),_T("Could not set synchronize access. Location: %d, rc = %d")
#define  ERR_GET_SEC_DESC                             N(564), ERR_TYPE,_T("SECURITY"),_T("Could not get security descriptor, rc = %d")
#define  ERR_GEN_SEC_DESC_COMMON                      N(565), ERR_TYPE,_T("SECURITY"),_T("Creating security descriptor. Location: %d, rc = %d")
#define  ERR_GEN_SEC_DESC_SERVICE                     N(566), ERR_TYPE,_T("SECURITY"),_T("Creating 'Service' security descriptor. Location: %d, rc = %d")
#define  ERR_SET_OBJ_SEC                              N(567), ERR_TYPE,_T("SECURITY"),_T("Could not set kernel object security, rc = %d")
#define  ERR_GET_TOKEN_INFO                           N(568), ERR_TYPE,_T("SECURITY"),_T("Could not get token information. Location: %d, rc = %d")
#define  ERR_GET_USER_NAME                            N(569), ERR_TYPE,_T("SECURITY"),_T("Could not get user name. Location: %d, rc = %d")
#define  ERR_SET_FILE_OWNER                           N(570), ERR_TYPE,_T("SECURITY"),_T("Could not set file owner, Location: %d, rc = %d")
#define  ERR_DEL_SAPDB_ADMIN_GROUP                    N(571), ERR_TYPE,_T("SECURITY"),_T("Could not delete 'SAPDB Admins' group. Location: %d, rc = %d")
#define  ERR_ADD_SAPDB_ADMIN_GROUP                    N(572), ERR_TYPE,_T("SECURITY"),_T("Could not establish 'SAPDB Admins' group. Location: %d, rc = %d")
#define  ERR_GET_DOMAIN_NAME                          N(573), ERR_TYPE,_T("SECURITY"),_T("Could not get domain name. Location: %d, rc = %d")
#define  ERR_OPEN_POLICY                              N(574), ERR_TYPE,_T("SECURITY"),_T("Could not open policy on '%s', rc = %d")
#define  ERR_CHANGING_ACC_RIGHTS                      N(575), ERR_TYPE,_T("SECURITY"),_T("Could not change account rights on '%s' for '%s', rc = %d")
#define  ERR_CHANGING_LOC_ACC_RIGHTS                  N(576), ERR_TYPE,_T("SECURITY"),_T("Could not change account rights for '%s', rc = %d")
#define  ERR_WRONG_USERNAME                           N(577), ERR_TYPE,_T("SECURITY"),_T("Unknown user account '%s'")
#define  ERR_OPEN_SERVICE_NO_PERM                     N(578), ERR_TYPE,_T("SERVICE "),_T("Could not open service manager (missing permission)")
#define  ERR_OPEN_SERVICE_MANAGER                     N(579), ERR_TYPE,_T("SERVICE "),_T("Could not open the service manager, rc = %d")
#define  ERR_CLOSE_SERVICE_MANAGER                    N(580), ERR_TYPE,_T("SERVICE "),_T("Could not close the service manager, rc = %d")
#define  ERR_SERVICE_UNKNOWN                          N(581), ERR_TYPE,_T("SERVICE "),_T("Service '%s' not installed")
#define  ERR_INSTALL_SERVICE                          N(582), ERR_TYPE,_T("SERVICE "),_T("Creating service '%s' failed, rc = %d")
#define  ERR_REMOVE_SERVICE                           N(583), ERR_TYPE,_T("SERVICE "),_T("Removing service '%s' failed, rc = %d")
#define  ERR_START_SERVICE                            N(584), ERR_TYPE,_T("SERVICE "),_T("Starting service '%s' failed, rc = %d")
#define  ERR_SET_SERVICE_STATUS                       N(585), ERR_TYPE,_T("SERVICE "),_T("Could not set the services status, rc = %d")
#define  ERR_SERVICE_ERROR                            N(586), ERR_TYPE,_T("SERVICE "),_T("Could not install/remove service, rc = %d")
#define  ERR_CREAT_SERVICE_NO_ACCESS                  N(587), ERR_TYPE,_T("SERVICE "),_T("Could not create/update/delete service entry, access denied")
#define  ERR_INVALID_PARAMETER                        N(588), ERR_TYPE,_T("SERVICE "),_T("Invalid parameter '%s'")
#define  ERR_INVALID_VALUE                            N(589), ERR_TYPE,_T("SERVICE "),_T("Could not set parameter '%s', invalid value '%s'")
#define  ERR_VALUE_TOO_LONG                           N(590), ERR_TYPE,_T("SERVICE "),_T("Could not set parameter '%s', value too long")
#define  ERR_DB_SERVICE_NOT_INSTALLED                 N(591), ERR_TYPE,_T("SERVICE "),_T("Service '%s' not installed")
#define  ERR_SERVICE_DB_LOCKED                        N(592), ERR_TYPE,_T("SERVICE "),_T("Service database has been locked by another process")
#define  ERR_SERVICE_ACCOUNT_INVALID                  N(593), ERR_TYPE,_T("SERVICE "),_T("The account name is invalid or does not exist")
#define  ERR_DBROOT_NOT_SET                           N(594), ERR_TYPE,_T("        "),_T("DBROOT must be set")
#define  ERR_WRONG_DBROOT_PATH                        N(595), ERR_TYPE,_T("        "),_T("Unknown path: DBROOT=%s")
#define  ERR_CREATING_SEM                             N(596), ERR_TYPE,_T("IPC     "),_T("Error on creating semaphore: '%s', rc = %d")
#define  ERR_OPENING_SEM                              N(597), ERR_TYPE,_T("IPC     "),_T("Error on opening semaphore: '%s', rc = %d   ")
#define  ERR_WAITING_SEM                              N(598), ERR_TYPE,_T("IPC     "),_T("Error while waiting for semaphore: '%s', rc = %d")
#define  ERR_POSTING_SEM                              N(599), ERR_TYPE,_T("IPC     "),_T("Error on posting semaphore: '%s', rc = %d")
#define  ERR_CLOSING_SEM                              N(600), ERR_TYPE,_T("IPC     "),_T("Error on closing semaphore: '%s', rc = %d")
#define  ERR_CREATING_QUEUE_MAILSLOT                  N(601), ERR_TYPE,_T("IPC     "),_T("Error on creating queue/mailslot '%s', rc = %d")
#define  ERR_OPENING_QUEUE_MAILSLOT                   N(602), ERR_TYPE,_T("IPC     "),_T("Error on opening queue/mailslot '%s', rc = %d")
#define  ERR_WRITING_QUEUE_MAILSLOT                   N(603), ERR_TYPE,_T("IPC     "),_T("Error while writing to queue/mailslot, rc = %d")
#define  ERR_READING_QUEUE_MAILSLOT                   N(604), ERR_TYPE,_T("IPC     "),_T("Error while reading from queue/mailslot, rc = %d")
#define  ERR_WRONG_REQ_BUF_SIZE                       N(605), ERR_TYPE,_T("IPC     "),_T("Wrong request buffer size: %u")
#define  ERR_LOOKUP_ACCOUNT_NAME                      N(606), ERR_TYPE,_T("        "),_T("Could not find account name, Location: %d, rc = %d")
#define  ERR_CANT_GIVE_SHRD_MEM                       N(607), ERR_TYPE,_T("MEMORY  "),_T("Could not share memory, rc = %d")
#define  ERR_CANT_ALLOC_HEAP_MEMORY                   N(608), ERR_TYPE,_T("MEMORY  "),_T("Could not allocate memory from the heap, rc = %u")
#define  ERR_SERVER_NODE_UNKNOWN                      N(609), ERR_TYPE,_T("CONNECT "),_T("Server node '%s' not available")
#define  ERR_ACCESS_DENIED_ON_XX                      N(610), ERR_TYPE,_T("SECURITY"),_T("Access on '%s' denied")
#define  ERR_ACCESS_DENIED                            N(611), ERR_TYPE,_T("SECURITY"),_T("Access denied")
#define  ERR_XSER_SYNC_ACCESS_DENIED                  N(612), ERR_TYPE,_T("SECURITY"),_T("Synchronize access denied, refusing connect request")
#define  ERR_XSER_OPEN_PROCCESS                       N(613), ERR_TYPE,_T("SECURITY"),_T("Could not open proccess, rc = %d")
#define  ERR_SET_EXIT_HANDLER_FAILED                  N(614), ERR_TYPE,_T("EXCEPT  "),_T("Set exit handler failed, rc = %d")
#define  ERR_DB_NOT_STARTED                           N(615), ERR_TYPE,_T("DBSTATE "),_T("Database '%s' has not been started")
#define  ERR_WRONG_DB_VERSION                         N(616), ERR_TYPE,_T("VERSION "),_T("Incompatible version of SERVERDB")
#define  ERR_WRONG_GW_VERSION                         N(617), ERR_TYPE,_T("VERSION "),_T("Incompatible version of gateway")
#define  ERR_COMMAND_TIMEOUT                          N(618), ERR_TYPE,_T("CONNECT "),_T("Command timeout")
#define  ERR_TIMEOUT_NO_DB_RESPONSE                   N(619), ERR_TYPE,_T("CONNECT "),_T("Time out, SERVERDB is not responding")
#define  ERR_CMD_LINE_TOO_LONG                        N(620), ERR_TYPE,_T("EXECUTE "),_T("Command line too long")
#define  ERR_STARTING_FUNC_FOM_DLL                    N(621), ERR_TYPE,_T("        "),_T("Could not start '%s' from '%s', rc = %d")
#define  ERR_DB_OR_GW_NOT_STARTED                     N(622), ERR_TYPE,_T("STATE   "),_T("'%s' has not been started")
#define  ERR_XSER_LIS_SOCK_OPEN                       N(623), ERR_TYPE,_T("XSERVER "),_T("Listen socket open error, rc = %d")
#define  ERR_XSER_SET_BUF_SIZE                        N(624), ERR_TYPE,_T("XSERVER "),_T("Could not set socket buffer (%s), rc = %d")
#define  ERR_XSER_SOCK_ADDR_IN_USE                    N(625), ERR_TYPE,_T("XSERVER "),_T("Socket address already in use")
#define  ERR_XSER_BIND_ERROR                          N(626), ERR_TYPE,_T("XSERVER "),_T("Bind error, rc = %d")
#define  ERR_XSER_LISTEN_ERROR                        N(627), ERR_TYPE,_T("XSERVER "),_T("Listen error, rc = %d")
#define  ERR_XSER_ACCEPT_ERROR                        N(628), ERR_TYPE,_T("XSERVER "),_T("Accept error, rc = %d")
#define  ERR_XSER_KEEP_ALIV_ERROR                     N(629), ERR_TYPE,_T("XSERVER "),_T("'setsockopt' (KEEPALIVE), rc = %d")
#define  ERR_XSER_CREATING_THREAD                     N(630), ERR_TYPE,_T("XSERVER "),_T("Error creating %s thread, rc = %d")
#define  ERR_XSER_RESUMING_THREAD                     N(631), ERR_TYPE,_T("XSERVER "),_T("Error resuming %s thread, rc = %d")
#define  ERR_XSER_SET_THRD_PRIO_ERROR                 N(632), ERR_TYPE,_T("XSERVER "),_T("Error setting thread priority (TID:0x%X), rc = %d")
#define  ERR_XSER_REC_REQ_PACKET_ERR                  N(633), ERR_TYPE,_T("XSERVER "),_T("Receive request packet error")
#define  ERR_XSER_ILL_FRST_MESS_CLASS                 N(634), ERR_TYPE,_T("XSERVER "),_T("Illegal first message class: %d")
#define  ERR_XSER_SEND_REQ_PACKET_ERR                 N(635), ERR_TYPE,_T("XSERVER "),_T("Sending request packet error, rc = %d")
#define  ERR_XSER_ILL_PACKET_SIZE                     N(636), ERR_TYPE,_T("XSERVER "),_T("Illegal packet size: %d, Ref:%d")
#define  ERR_XSER_MAX_CONNECTIONS                     N(637), ERR_TYPE,_T("XSERVER "),_T("Max. connections reached")
#define  ERR_XSER_STOPPED_EV_LOG                      N(638), ERR_TYPE,_T("XSERVER "),_T("XSERVER has stopped unexpectedly, (view 'Application Event Log')")
#define  ERR_XSER_STOPPED_DIAG                        N(639), ERR_TYPE,_T("XSERVER "),_T("XSERVER has stopped unexpectedly, (view 'XSERVER Diagnostic File')")
#define  ERR_XSER_NOT_STARTED                         N(640), ERR_TYPE,_T("XSERVER "),_T("XSERVER not active")
#define  ERR_XSER_ALREADY_RUNNING                     N(641), ERR_TYPE,_T("XSERVER "),_T("XSERVER is already running!")
#define  ERR_XSER_CANNOT_START                        N(642), ERR_TYPE,_T("XSERVER "),_T("Starting XSERVER, rc = %d")
#define  ERR_XSER_CANNOT_STOP                         N(643), ERR_TYPE,_T("XSERVER "),_T("Terminating XSERVER, rc = %d")
#define  ERR_XSER_CANNOT_INIT_TCPIP                   N(644), ERR_TYPE,_T("XSERVER "),_T("No TCP/IP connectivity available, (check the SQLTCP-DLL)")
#define  ERR_XSER_GET_SET_HANDLE_DATA                 N(645), ERR_TYPE,_T("XSERVER "),_T("Could not get or set handle data")
#define  ERR_XSER_LOCK_UNLOCK_HANDLE                  N(646), ERR_TYPE,_T("XSERVER "),_T("Could not lock or unlock handle")
#define  ERR_XSER_FREE_HANDLE                         N(647), ERR_TYPE,_T("XSERVER "),_T("Could not free handle")
#define  ERR_XSER_INFO_REQUEST                        N(648), ERR_TYPE,_T("XSERVER "),_T("Info request: %s")
#define  ERR_XSER_CONN_REQ                            N(649), ERR_TYPE,_T("XSERVER "),_T("Connect request: %s")
#define  ERR_XSER_RECV_PACKET                         N(650), ERR_TYPE,_T("XSERVER "),_T("Receive packet, Ref:%d - %s")
#define  ERR_XSER_SEND_PACKET                         N(651), ERR_TYPE,_T("XSERVER "),_T("Send packet, Ref:%d - %s")
#define  ERR_XSER_REQUEST                             N(652), ERR_TYPE,_T("XSERVER "),_T("Request, Ref:%d - %s")
#define  ERR_XSER_RECEIVE                             N(653), ERR_TYPE,_T("XSERVER "),_T("Receive, Ref:%d - %s")
#define  ERR_XSER_WRONG_PACKET_SIZE                   N(654), ERR_TYPE,_T("XSERVER "),_T("SERVERDB: %s, packet size too small, min.: %d")
#define  ERR_XSER_WRONG_VERSION                       N(655), ERR_TYPE,_T("XSERVER "),_T("Wrong XSERVER version installed! Please reinstall the XSERVER.\r\n   Installed:\t'%s'\r\n   Expected:\t'%s'")
#define  ERR_XSER_WRONG_REQ_REQUEST                   N(656), ERR_TYPE,_T("XSERVER "),_T("Wrong requestor thread request")
#define  ERR_XSER_DISTRIB_CONN_REQ                    N(657), ERR_TYPE,_T("XSERVER "),_T("Distrib. connect: %s")
#define  ERR_XSER_SERVERDB_DIED                       N(658), ERR_TYPE,_T("XSERVER "),_T("Connection broken, Ref:%d, SERVERDB '%s' died")
#define  ERR_XSER_RECV_DISTRIB_PACKET                 N(659), ERR_TYPE,_T("XSERVER "),_T("Receive packet (distrib), Ref:%d, PeerRef:%d - %s")
#define  ERR_XSER_SEND_DISTRIB_PACKET                 N(660), ERR_TYPE,_T("XSERVER "),_T("Send packet (distrib), Ref:%d, PeerRef:%d - %s")
#define  ERR_XSER_RECV_PROTOCOL                       N(661), ERR_TYPE,_T("XSERVER "),_T("Protocol error, (%s), Ref:%d")
#define  ERR_XSER_ILL_MESS_CLASS                      N(662), ERR_TYPE,_T("XSERVER "),_T("Illegal message class: %d, Ref:%d")
#define  ERR_XSER_SEND_ACKN                           N(663), ERR_TYPE,_T("XSERVER "),_T("Send acknowledge, Ref:%d - %s")
#define  ERR_XSER_RECV_ACKN                           N(664), ERR_TYPE,_T("XSERVER "),_T("Receive acknowledge, Ref:%d - %s")
#define  ERR_XSER_RELEASING_SOCKET                    N(665), ERR_TYPE,_T("XSERVER "),_T("Releasing socket - %s")
#define  ERR_XSER_USER_MISSING_PRIV                   N(666), ERR_TYPE,_T("XSERVER "),_T("User '%s' - missing privilege to run service")
#define  ERR_XSTRT_CANNOT_STRT_DB                     N(667), ERR_TYPE,_T("XSTART  "),_T("'%s' could not be started, rc = %d")
#define  ERR_XSTRT_ALREADY_RUNNING                    N(668), ERR_TYPE,_T("XSTART  "),_T("'%s' already running!")
#define  ERR_XSTRT_DB_STOPPED_EV_LOG                  N(669), ERR_TYPE,_T("XSTART  "),_T("'%s' has stopped unexpectedly, (view 'Application Event Log')")
#define  ERR_XSTRT_DB_STOPPED_DIAG                    N(670), ERR_TYPE,_T("XSTART  "),_T("'%s' has stopped unexpectedly, (view 'Diagnostic File')")
#define  ERR_XSTRT_LOGON_FAILURE                      N(671), ERR_TYPE,_T("XSTART  "),_T("'%s' did not start due to a service logon failure")
#define  ERR_XSTOP_CANNOT_STP_DB                      N(672), ERR_TYPE,_T("XSTOP   "),_T("'%s' could not be stopped, rc = %d")
#define  ERR_XSTOP_CANNOT_SET_DUMP                    N(673), ERR_TYPE,_T("XSTOP   "),_T("XSTOP could not set dump flag of '%s', rc = %u")
#define  ERR_XSTOP_OPENING_EVENT_SEM                  N(674), ERR_TYPE,_T("XSTOP   "),_T("XSTOP could not open semaphore: '%s', rc = %u")
#define  ERR_PUTPARAM_OPEN_HELPFILE                   N(675), ERR_TYPE,_T("PUTPARAM"),_T("Could not open helpfile: '%s'")
#define  ERR_PUTPARAM_WRONG_KEY                       N(676), ERR_TYPE,_T("PUTPARAM"),_T("Unknown XPARAM key: '%s'")
#define  ERR_PUTPARAM_INV_ENTRY                       N(677), ERR_TYPE,_T("PUTPARAM"),_T("Invalid XPARAM helpfile entry: '%s'")
#define  ERR_PUTPARAM_NUMERIC                         N(678), ERR_TYPE,_T("PUTPARAM"),_T("Value must be numeric: '%s'")
#define  ERR_PUTPARAM_UNSUPP_TYPE                     N(679), ERR_TYPE,_T("PUTPARAM"),_T("Unsupported type: '%s'")
#define  ERR_XCONS_WRONG_TASK                         N(680), ERR_TYPE,_T("XCONS   "),_T("Wrong task index")
#define  ERR_XCONS_WRONG_TASK_TYPE                    N(681), ERR_TYPE,_T("XCONS   "),_T("Could not cancel/kill task")
#define  ERR_XCONS_WRONG_UKT                          N(682), ERR_TYPE,_T("XCONS   "),_T("Wrong ukt index")
#define  ERR_XCONS_SET_UKT_AFFINITY                   N(683), ERR_TYPE,_T("XCONS   "),_T("Could not set affinity, (view kernel diagnostic file)")
#define  ERR_XCONS_AFFIN_NO_PROCESSOR                 N(684), ERR_TYPE,_T("XCONS   "),_T("Not enough processors")
#define  ERR_XCONS_INTERACT_WTH_DECTOP                N(685), ERR_TYPE,_T("XCONS   "),_T("Service needs 'interact with desktop' option for 'DebugBreak'")
#define  ERR_DBPARAMS_ERR_TEXT                        N(686), ERR_TYPE,_T("        "),_T("%s")
#define  ERR_GET_SERVER_DB                            N(687), ERR_TYPE,_T("        "),_T("Could not get SERVERDB name, sqlcode = %d")
#define  ERR_DCOMI_NO_SEMAPHORE                       N(692), ERR_TYPE,_T("DCOM    "),_T("ABEND: Failed to create DCOM[%ld] semaphore")
#define  ERR_WRNG_CONTAINER_PAGE_TYPE                 N(693), ERR_TYPE,_T("PROFCONT"),_T("Wrong profile container page type: %d, expected: %d")
#define  ERR_WRNG_CONTAINER_VERSION                   N(694), ERR_TYPE,_T("PROFCONT"),_T("Wrong profile container version: %d, max: %d")
#define  ERR_SURPRISING_NEXT_PAGE                     N(695), ERR_TYPE,_T("PROFCONT"),_T("Surprising 'next page no': %d")
#define  ERR_PROFILE_NOT_FOUND                        N(696), ERR_TYPE,_T("PROFCONT"),_T("Profile not found")
#define  ERR_INSUFFICIENT_BUFFER                      N(697), ERR_TYPE,_T("PROFCONT"),_T("Insufficient buffer")
#define  ERR_SURPRISING_PROF_DATA_LEN                 N(698), ERR_TYPE,_T("PROFCONT"),_T("Surprising profile data length: %d, expected: %d")
#define  ERR_INVALID_PROFILE_TOKEN                    N(699), ERR_TYPE,_T("PROFCONT"),_T("Invalid profile token: %d")
#define  ERR_SURPRISING_CURR_PAGE                     N(700), ERR_TYPE,_T("PROFCONT"),_T("Surprising 'current page no': %d, expected: %d")
#define  ERR_PROFILE_NO_ENTRIES                       N(701), ERR_TYPE,_T("PROFCONT"),_T("No entries")
#define  ERR_ABEND_ON                                 N(702), ERR_TYPE,_T("EXCEPT  "),_T("ABEND on '%s'")
#define  ERR_CREATE_HEAP                              N(703), ERR_TYPE,_T("MEMORY  "),_T("Could not create heap, rc = %u")
#define  ERR_CANNOT_STAT_XUSER_FILE__SYSMSG           N(704), ERR_TYPE,_T("XUSER   "),_T("Could not stat USER file, %s")
#define  ERR_XUSER_WRONG_FILETYPE                     N(705), ERR_TYPE,_T("XUSER   "),_T("Wrong file type for XUSER file %s")
#define  ERR_XPARAM_MEM_VALUE_TOO_SMALL               N(706), ERR_TYPE,_T("XPARAM  "),_T("XPARAM value '%s' too small")
#define  ERR_INVALID_POOL_HINT                        N(707), ERR_TYPE,_T("MEMORY  "),_T("Invalid pool hint")
#define  ERR_START_PROCCESS                           N(708), ERR_TYPE,_T("EXECUTE "),_T("Could not start a new process '%s', rc = %d")
#define  ERR_DLL_NOT_FOUND                            N(709), ERR_TYPE,_T("DLL     "),_T("Dynamic Link Library '%s' not found")
#define  ERR_LOADING_DLL                              N(710), ERR_TYPE,_T("DLL     "),_T("Load Dynamic Link Library '%s' failed, rc = %d")
#define  ERR_DLL_FUNCTION_NOT_FOUND                   N(711), ERR_TYPE,_T("DLL     "),_T("Function '%s' in '%s' not found")
#define  ERR_GET_FUNCTION_ADDR_FAILED                 N(712), ERR_TYPE,_T("DLL     "),_T("Get function address of '%s' failed, ('%s'), rc = %d")
#define  ERR_OUT_OF_MEMORY                            N(713), ERR_TYPE,_T("CLUSTER "),_T("Out of memory")
#define  ERR_CLUSTER_UNAVAILABLE                      N(714), ERR_TYPE,_T("CLUSTER "),_T("Cluster%sunavailable")
#define  ERR_OPEN_CLUSTER_FAILED                      N(715), ERR_TYPE,_T("CLUSTER "),_T("Open cluster%sfailed")
#define  ERR_SETTING_CLUSTER_LOG_SIZE                 N(716), ERR_TYPE,_T("CLUSTER "),_T("Error setting cluster log size")
#define  ERR_SETTING_LOG_ENV_VAR                      N(717), ERR_TYPE,_T("CLUSTER "),_T("Error setting \"CLUSTERLOG\" environment variable")
#define  ERR_REGISTER_CLU_ADMIN_EXT                   N(718), ERR_TYPE,_T("CLUSTER "),_T("Register 'cluster admin extension' failed, (%s)")
#define  ERR_REGISTER_SERVER                          N(719), ERR_TYPE,_T("CLUSTER "),_T("Register server failed, (%s)")
#define  ERR_UNREGISTER_CLU_ADMIN_EXT                 N(720), ERR_TYPE,_T("CLUSTER "),_T("Unregister 'cluster admin extension' failed, (%s)")
#define  ERR_UNREGISTER_SERVER                        N(721), ERR_TYPE,_T("CLUSTER "),_T("Unregister server failed, (%s)")
#define  ERR_CLUSTER_HANDLE_NOT_VALID                 N(722), ERR_TYPE,_T("CLUSTER "),_T("Cluster handle not valid")
#define  ERR_NETWORK_HANDLE_NOT_VALID                 N(723), ERR_TYPE,_T("CLUSTER "),_T("Network handle not valid")
#define  ERR_GROUP_HANDLE_NOT_VALID                   N(724), ERR_TYPE,_T("CLUSTER "),_T("Group handle not valid")
#define  ERR_RESOURCE_HANDLE_NOT_VALID                N(725), ERR_TYPE,_T("CLUSTER "),_T("Resource handle not valid")
#define  ERR_OPEN_CLUSTER_ENUMERATOR                  N(726), ERR_TYPE,_T("CLUSTER "),_T("Open cluster enumerator failed")
#define  ERR_CLUSTER_ENUM_FAILED                      N(727), ERR_TYPE,_T("CLUSTER "),_T("Cluster enumeratoration failed")
#define  ERR_CLOSE_CLUSTER_ENUMERATOR                 N(728), ERR_TYPE,_T("CLUSTER "),_T("Close cluster enumerator failed")
#define  ERR_NETWORK_NOT_FOUND                        N(729), ERR_TYPE,_T("CLUSTER "),_T("Network '%s' not found")
#define  ERR_OPEN_CLUSTER_NETWORK                     N(730), ERR_TYPE,_T("CLUSTER "),_T("Open cluster network '%s' failed")
#define  ERR_GET_CLUSTER_NETWORK_ID                   N(731), ERR_TYPE,_T("CLUSTER "),_T("Get cluster network id of '%s' failed")
#define  ERR_SETTING_NETWORK_PROP                     N(732), ERR_TYPE,_T("CLUSTER "),_T("Error setting properties of network '%s'")
#define  ERR_GETTING_NETWORK_PROP                     N(733), ERR_TYPE,_T("CLUSTER "),_T("Error getting properties of network '%s'")
#define  ERR_GROUP_NOT_FOUND                          N(734), ERR_TYPE,_T("CLUSTER "),_T("Group '%s' not found")
#define  ERR_OPEN_GROUP_FAILED                        N(735), ERR_TYPE,_T("CLUSTER "),_T("Open group '%s' failed")
#define  ERR_CREATING_GROUP                           N(736), ERR_TYPE,_T("CLUSTER "),_T("Creating group '%s' failed")
#define  ERR_DELETING_GROUP                           N(737), ERR_TYPE,_T("CLUSTER "),_T("Delete group '%s' failed")
#define  ERR_OPEN_GROUP_ENUMERATOR                    N(738), ERR_TYPE,_T("CLUSTER "),_T("Open enumerator of group '%s' failed")
#define  ERR_GROUP_ENUMERATORATION                    N(739), ERR_TYPE,_T("CLUSTER "),_T("Enumeratoration of group '%s' failed")
#define  ERR_CLOSE_GROUP_ENUMERATOR                   N(740), ERR_TYPE,_T("CLUSTER "),_T("Close enumerator of group '%s' failed")
#define  ERR_SETTING_GROUP_PROP                       N(741), ERR_TYPE,_T("CLUSTER "),_T("Error setting properties of group '%s'")
#define  ERR_GETTING_GROUP_PROP                       N(742), ERR_TYPE,_T("CLUSTER "),_T("Error getting properties of group '%s'")
#define  ERR_RESOURCE_NOT_FOUND                       N(743), ERR_TYPE,_T("CLUSTER "),_T("Resource '%s' not found")
#define  ERR_OPEN_RESOURCE_FAILED                     N(744), ERR_TYPE,_T("CLUSTER "),_T("Open resource '%s' failed")
#define  ERR_CREATE_RESOURCE_FAILED                   N(745), ERR_TYPE,_T("CLUSTER "),_T("Create resource '%s' failed")
#define  ERR_DELETING_ONLINE_RESOURCE                 N(746), ERR_TYPE,_T("CLUSTER "),_T("Delete  resource '%s' failed because it is online")
#define  ERR_DELETING_DEPEND_RESOURCE                 N(747), ERR_TYPE,_T("CLUSTER "),_T("Delete  resource '%s' failed, a dependent resource exists")
#define  ERR_DELETING_RESOURCE                        N(748), ERR_TYPE,_T("CLUSTER "),_T("Delete  resource '%s' failed")
#define  ERR_ADD_RESOURCE_DEPENDENCY                  N(749), ERR_TYPE,_T("CLUSTER "),_T("Add resource dependency '%s' failed")
#define  ERR_CHANGE_RESOURCE_TO_GROUP                 N(750), ERR_TYPE,_T("CLUSTER "),_T("Change resource '%s' to group '%s' failed")
#define  ERR_BRINGING_RESOURCE_ONLINE                 N(751), ERR_TYPE,_T("CLUSTER "),_T("Bringing resource '%s' online  failed")
#define  ERR_BRINGING_RESOURCE_OFFLINE                N(752), ERR_TYPE,_T("CLUSTER "),_T("Bringing resource '%s' offline  failed")
#define  ERR_QUERY_VALUE                              N(753), ERR_TYPE,_T("CLUSTER "),_T("Could not query '%s' value")
#define  ERR_INVALID_DATA_TYPE                        N(754), ERR_TYPE,_T("CLUSTER "),_T("Invalid data type (value '%s')")
#define  ERR_GET_RESOURCE_KEY                         N(755), ERR_TYPE,_T("CLUSTER "),_T("Get resource key '%s' failed")
#define  ERR_OPEN_RESOURCE_REG_KEY                    N(756), ERR_TYPE,_T("CLUSTER "),_T("Open resource (%s) registry key '%s' failed")
#define  ERR_CREATE_RESOURCE_REG_KEY                  N(757), ERR_TYPE,_T("CLUSTER "),_T("Create resource (%s) registry key '%s' failed")
#define  ERR_SET_RESOURCE_REG_KEY                     N(758), ERR_TYPE,_T("CLUSTER "),_T("Could not set resoruce (%s) registry value '%s'")
#define  ERR_QUERY_RESOURCE_REG_KEY                   N(759), ERR_TYPE,_T("CLUSTER "),_T("Could not query resoruce (%s) registry value '%s'")
#define  ERR_GET_RESOURCE_STATE                       N(760), ERR_TYPE,_T("CLUSTER "),_T("Could not get state of resource '%s'")
#define  ERR_SETTING_RESOURCE_PROP                    N(761), ERR_TYPE,_T("CLUSTER "),_T("Error setting properties of resource '%s'")
#define  ERR_GETTING_RESOURCE_PROP                    N(762), ERR_TYPE,_T("CLUSTER "),_T("Error getting properties of resource '%s'")
#define  ERR_CREATING_RESOURCE_TYPE                   N(763), ERR_TYPE,_T("CLUSTER "),_T("Creating resource type '%s failed")
#define  ERR_DEL_IN_USE_RESOURCE_TYPE                 N(764), ERR_TYPE,_T("CLUSTER "),_T("Resource type '%s' is in use, delete failed")
#define  ERR_DEL_RESOURCE_TYPE                        N(765), ERR_TYPE,_T("CLUSTER "),_T("Deleting resource type '%s failed")
#define  ERR_SETTING_RESOURCE_TYPE_PROP               N(766), ERR_TYPE,_T("CLUSTER "),_T("Error setting properties of resource type '%s'")
#define  ERR_GETTING_RESOURCE_TYPE_PROP               N(767), ERR_TYPE,_T("CLUSTER "),_T("Error getting properties of resource type '%s'")
#define  ERR_READING_IMAGE_PATH                       N(768), ERR_TYPE,_T("CLUSTER "),_T("Error reading cluster server image path.")
#define  ERR_EXPANDING_IMAGE_PATH                     N(769), ERR_TYPE,_T("CLUSTER "),_T("Error expanding cluster server image path")
#define  ERR_CLUSTER_NOT_INSTALLED                    N(770), ERR_TYPE,_T("CLUSTER "),_T("Microsoft Cluster Server not installed")
#define  ERR_IP_ADDRESS_ALREADY_IN_USE                N(771), ERR_TYPE,_T("CLUSTER "),_T("Error IP-Address '%s' already used by '%s'")
#define  ERR_UNKOWN_RESOURCE_TYPE                     N(772), ERR_TYPE,_T("CLUSTER "),_T("Unknown resource type '%s'")
#define  ERR_BRINGING_GROUP_ONLINE                    N(773), ERR_TYPE,_T("CLUSTER "),_T("Bringing group '%s' online failed")
#define  ERR_BRINGING_GROUP_OFFLINE                   N(774), ERR_TYPE,_T("CLUSTER "),_T("Bringing group '%s' offline failed")
#define  ERR_GROUP_ONLINE_TIMEOUT                     N(775), ERR_TYPE,_T("CLUSTER "),_T("Bringing group '%s' online timed out")
#define  ERR_GROUP_OFFLINE_TIMEOUT                    N(776), ERR_TYPE,_T("CLUSTER "),_T("Bringing group '%s' offline timed out")
#define  ERR_NI_SERV_ACCEPT_ERROR                     N(777), ERR_TYPE,_T("NISERVER"),_T("Accept error, %s")
#define  ERR_NI_SERV_LISTEN_ERROR                     N(778), ERR_TYPE,_T("NISERVER"),_T("Listen error, %s")
#define  ERR_NI_SERV_DURING_STARTUP                   N(779), ERR_TYPE,_T("NISERVER"),_T("Error during startup:'%s'")
#define  ERR_NI_SERV_FORK                             N(780), ERR_TYPE,_T("NISERVER"),_T("Cannot fork: %s")
#define  ERR_NI_SERV_OPTION                           N(781), ERR_TYPE,_T("NISERVER"),_T("Illegal option '%c'.")
#define  ERR_NI_SERV_CHDIR                            N(782), ERR_TYPE,_T("NISERVER"),_T("Cannot chdir to '%s': %s")
#define  ERR_CANT_WRITE_TO_PIPE                       N(783), ERR_TYPE,_T("CONNECT "),_T("Connect packet write pipe error, rc = %d")
#define  ERR_PACK_WRITE_SIZE_ERROR                    N(784), ERR_TYPE,_T("CONNECT "),_T("Connect packet write size error, length: %d")
#define  ERR_CONN_PACKET_READ_ERR                     N(785), ERR_TYPE,_T("CONNECT "),_T("Connect packet read pipe error, rc = %d")
#define  ERR_VAR_PART_EXHAUSTED                       N(789), ERR_TYPE,_T("CONNECT "),_T("Variable packet part exhausted")
#define  ERR_INAVALID_PACKET_TYPE                     N(790), ERR_TYPE,_T("CONNECT "),_T("Invalid packet type")
#define  ERR_INVALID_VAR_PART_LENGTH                  N(791), ERR_TYPE,_T("CONNECT "),_T("Variable packet: invalid value length, len = %d")
#define  ERR_MULTIPLE_VSIGNAL_CALL                    N(792), ERR_TYPE,_T("TASKING "),_T("Multiple calls of 'vsignal', T%d")
#define  ERR_EXCEPTION_DESC_ACCESS_VIOLATION          N(793), ERR_TYPE,_T("EXCEPT  "),_T("EXCEPTION:'%s' (%#x), The program code at IP:%#x attempted to %s to/from address:%#x")
#define  ERR_VSTOP_WRONG_EVENT                        N(795), ERR_TYPE,_T("TASKING "),_T("'vstop' awoke from wrong event")
#define  ERR_VSTOP_WRONG_REQ                          N(796), ERR_TYPE,_T("TASKING "),_T("'vstop' awoke from request (%d)")
#define  ERR_TEST_WILDCARD                            N(797), ERR_TYPE,_T("TEST    "),_T("%s")
#define  ERR_VRESUME_WRONG_STATE                      N(798), ERR_TYPE,_T("TASKING "),_T("T%d 'vresume'd T%d while in wrong state %d")
#define  ERR_VRESUME_WRONG_COUNT                      N(799), ERR_TYPE,_T("TASKING "),_T("T%d 'vresume'd T%d result in wrong count %d")
#define  ERR_EVENTING_INITIALIZE                      N(800), ERR_TYPE,_T("EVENTING"),_T("Initilization of event buffer failed")
#define  ERR_WRONG_RESUME_COUNT                       N(801), ERR_TYPE,_T("TASKING "),_T("T%d Bad resume count detected:%d")
#define  ERR_CANT_OPEN_PIPE                           N(802), ERR_TYPE,_T("IO      "),_T("Could not open pipe '%s', rc = %d")
#define  ERR_UNHANDLED_CPP_EXCEPTION_NO_KT            N(803), ERR_TYPE,_T("EXCEPT  "),_T("Unhandled C++ Exception: DbState %s No KT identified")
#define  ERR_UNHANDLED_CPP_EXCEPTION_KT               N(804), ERR_TYPE,_T("EXCEPT  "),_T("Unhandled C++ Exception: DbState %s Tid %d KT (%s)")
#define  ERR_UNHANDLED_CPP_EXCEPTION_UKT              N(805), ERR_TYPE,_T("EXCEPT  "),_T("Unhandled C++ Exception: DbState %s Tid %d UKT%d (%s) T%d Type %s (%s)")
#define  ERR_XP_UPDATE_ACCESS_DENIED                  N(806), ERR_TYPE,_T("PUTPARAM"),_T("Update of '%s' not allowed")
#define  ERR_XP_UPDATE_UNKNOWN_KEY                    N(807), ERR_TYPE,_T("PUTPARAM"),_T("Unknown parameter '%s'")
#define  ERR_XP_UPDATE_BAD_FORMAT                     N(809), ERR_TYPE,_T("PUTPARAM"),_T("Bad format '%s' for param %s")
#define  ERR_USER_IS_ADMIN                            N(810), ERR_TYPE,_T("SECURITY"),_T("Could not determine admin. privilege. Location: %d, rc = %d")
#define  ERR_INITSHM_CR_KGS_ERR                       N(811), ERR_TYPE,_T("INIT_SHM"),_T("Cannot create kernel shared section")
#define  ERR_ILL_VARPART_VALUE                        N(812), ERR_TYPE,_T("CONNECT "),_T("Illegal VARPART value")
#define  ERR_WRONG_BUFFER_SIZE                        N(813), ERR_TYPE,_T("BUFFER  "),_T("Wrong buffer size: %d expected: %d")
#define  ERR_INCONSISTENT_BUFFER_CONTENT              N(814), ERR_TYPE,_T("BUFFER  "),_T("Inconsistent buffer content")
#define  ERR_REDIRECT_FAILED                          N(815), ERR_TYPE,_T("IO      "),_T("Redirect to '%s' failed, rc = %d")
#define  ERR_LINK_FILE                                N(816), ERR_TYPE,_T("IO      "),_T("Link '%s' to '%s' failed, rc = %d\n")
#define  ERR_COMM_REQ_SERV_REJECT                     N(817), ERR_TYPE,_T("COMMUNIC"),_T("Server rejected connection")
#define  ERR_COMM_REQ_PACKET_GARBLED                  N(818), ERR_TYPE,_T("COMMUNIC"),_T("Request packet garbled: %d bytes, expected: %d")
#define  ERR_COMM_REQ_EVTLST_DROPPED                  N(819), ERR_TYPE,_T("COMMUNIC"),_T("Communication error. Sorry, error information dropped!\n")
#define  ERR_COMM_REQ_WRONG_BUFFER_SIZE               N(820), ERR_TYPE,_T("COMMUNIC"),_T("Request packet buffer too small, min.: %d")
#define  ERR_COMM_REQ_ILL_DATA_LEN                    N(821), ERR_TYPE,_T("COMMUNIC"),_T("Illegal data length: %d, expected: %d")
#define  ERR_COMM_REQ_ILL_VARPART_LEN                 N(822), ERR_TYPE,_T("COMMUNIC"),_T("Illegal varpart length: %d, expected: %d")
#define  ERR_COMM_ILL_SHORT_MSG_LEN                   N(823), ERR_TYPE,_T("COMMUNIC"),_T("Illegal short message length: %d, expected: %d")
#define  ERR_COMM_ILL_VARPART_VALUE_LENGTH            N(824), ERR_TYPE,_T("COMMUNIC"),_T("Illegal VARPART value length: %d")
#define  ERR_COMM_VARPART_VALUE_NOT_FOUND             N(825), ERR_TYPE,_T("COMMUNIC"),_T("VARPART value not found (ID:%d)")
#define  ERR_COMM_NOT_CONNECTED                       N(826), ERR_TYPE,_T("COMMUNIC"),_T("Communication unit not connected")
#define  ERR_COMM_INVALID_RESP_TYPE                   N(827), ERR_TYPE,_T("COMMUNIC"),_T("Protocol error, invalid response type: %d, expected:%d")
#define  ERR_COMM_UNKNOWN_REQ_TYPE                    N(828), ERR_TYPE,_T("COMMUNIC"),_T("Protocol error, unknown request type: %d")
#define  ERR_COMM_SERVER_OR_DB_NOT_FOUND              N(829), ERR_TYPE,_T("COMMUNIC"),_T("Database or server not found")
#define  ERR_DBSTART_UKT_COINITIALIZE_FAILED          N(830), ERR_TYPE,_T("DBSTART "),_T("CoInitialize for UKT%d failed!")
#define  ERR_LSEEK_SYSCALL                            N(831), ERR_TYPE,_T("IO      "),_T("Can't lseek('%s' to %ld, mode '%s'), '%s'")
#define  ERR_MMAP_SYSCALL                             N(832), ERR_TYPE,_T("IO      "),_T("Can't mmap(@0x%lx 0x%lx bytes), '%s'")
#define  ERR_MUNMAP_SYSCALL                           N(833), ERR_TYPE,_T("IO      "),_T("Can't munmap(@0x%lx 0x%lx bytes), '%s'")
#define  ERR_OPEN_SYSCALL                             N(834), ERR_TYPE,_T("IO      "),_T("Can't open('%s' mode 0x%x), '%s'")
#define  ERR_SYSTEM_SYSCALL                           N(835), ERR_TYPE,_T("SYSTEM  "),_T("system('%s') failed, '%s'")
#define  ERR_CREATEFILEMAPPING_SYSCALL                N(836), ERR_TYPE,_T("SYSTEM  "),_T("CreateFileMapping('%s',0x%lx) failed, rc=%d")
#define  ERR_MAPVIEWOFFILE_SYSCALL                    N(837), ERR_TYPE,_T("SYSTEM  "),_T("MapViewOfFile('%s',0x%lx) failed, rc=%d")
#define  ERR_CREATEFILE_SYSCALL                       N(838), ERR_TYPE,_T("SYSTEM  "),_T("CreateFile('%s') failed, rc=%d")
#define  ERR_UNMAPVIEWOFFILE_SYSCALL                  N(839), ERR_TYPE,_T("SYSTEM  "),_T("UnmapViewOfFile(@0x%lx) failed, rc=%d")
#define  ERR_LOCK_TASK_NOT_IN_RUN_QUEUE               N(840), ERR_TYPE,_T("TASKING "),_T("Locking Task T%d not in RunQueue")
#define  ERR_NOT_CURRENT_TASK                         N(841), ERR_TYPE,_T("TASKING "),_T("Current task T%d does not match with T%d")
#define  ERR_ALREADY_LOCKED_UKT                       N(842), ERR_TYPE,_T("TASKING "),_T("UKT already locked by T%d. T%d fails")
#define  ERR_NOT_LOCKED_UKT                           N(843), ERR_TYPE,_T("TASKING "),_T("UKT locked by T%d. NOT locked by T%d")
#define  ERR_DISPATCHER_SEM_RECEIVE                   N(844), ERR_TYPE,_T("TASKING "),_T("UKT semaphore receive:%s")
#define  ERR_XP_PUT_OPENED_READONLY                   N(845), ERR_TYPE,_T("XPARAM  "),_T("Put not allowed, file opened for READONLY")
#define  ERR_DISP_SEMOP_ERR                           N(846), ERR_TYPE,_T("TASKING "),_T("ABEND: dispatcher semop error %s")

#define  ERR_CREATING_FIBER_OUT_OF_MEMORY             N(850), ERR_TYPE,_T("FIBER   "),_T("Out of memory, could not create fiber")
#define  ERR_EXCEPT_GUARD_PAGE_VIOLATION              N(851), ERR_TYPE,_T("EXCEPT  "),_T("Guard page violation (task stack overflow) Addr:%#x  ")
#define  ERR_GUARD_EXCEPTION_INFO                     N(852), ERR_TYPE,_T("EXCEPT  "),_T("T%d, Addr:%08X, stack : %08X - %08X )")
#define  ERR_STACK_ALLOC_HEAP_FAILED                  N(853), ERR_TYPE,_T("MEMORY  "),_T("Could not allocate %d Bytes (heap) for task stacks, rc=%d")
#define  ERR_COMMIT_TASK_STACK                        N(854), ERR_TYPE,_T("MEMORY  "),_T("Could not commit the tasks stack from %X size %X, rc=%d")
#define  ERR_SET_TASK_STACK_GUARD                     N(855), ERR_TYPE,_T("MEMORY  "),_T("Could not set guard page at %X, rc=%d")
#define  ERR_TRACEIO_APPEND_OPEN_FAILED               N(856), ERR_TYPE,_T("TRACE_IO"),_T("AppendOpen '%s' failed: %s")
#define  ERR_TRACEIO_OPEN_FAILED                      N(857), ERR_TYPE,_T("TRACE_IO"),_T("Open '%s' failed: %s")
#define  ERR_TRACEIO_GET_INDEX_FAILED                 N(858), ERR_TYPE,_T("TRACE_IO"),_T("Get index of '%s' failed: %s")
#define  ERR_TRACEIO_OS_ERROR                         N(859), ERR_TYPE,_T("TRACE_IO"),_T("%s '%s' OS error: [%s]")
#define  ERR_TRACEIO_CHECK_FILENAME                   N(860), ERR_TYPE,_T("TRACE_IO"),_T("Check '%s':%s")
#define  ERR_TRACEIO_BAD_FILEINDEX                    N(861), ERR_TYPE,_T("TRACE_IO"),_T("%s: Fileindex %d invalid")
#define  ERR_CLOSING_PROCESS                          N(862), ERR_TYPE,_T("IPC     "),_T("Error on closing process handle, rc = %d")
#define  ERR_SETTING_PROCESSOR_MASK                   N(863), ERR_TYPE,_T("THREAD  "),_T("Could not set thread processor mask to '%X', rc=%d")
#define  ERR_ALLOC_MEMORY_XXX_BYTES_FILE_LINE_        N(864), ERR_TYPE,_T("MEMORY  "),_T("Could not allocate memory %u bytes, rc = %u, ( %s:%d )")
#define  ERR_DLL_ERROR                                N(865), ERR_TYPE,_T("DCOM    "),_T("dlapi(%s) Error:%s")
#define  ERR_CANT_GET_PGM_PATH                        N(866), ERR_TYPE,_T("INSTALL "),_T("Can't determine program path for '%s'")
#define  ERR_CANT_GET_CONFIG_PATH                     N(867), ERR_TYPE,_T("CONFIG  "),_T("Can't determine configuration path.")
#define  ERR_RTE_ERROR                                N(868), ERR_TYPE,_T("        "),_T("RTE_ERROR: %5d / %s")
#define  ERR_OS_ERROR                                 N(869), ERR_TYPE,_T("        "),_T("OS_ERROR:  %5d / %s")
#define  ERR_DCOM_MAX_PARAM                           N(870), ERR_TYPE,_T("DCOM    "),_T("Call of a DBProc with more than %d parameter")
#define  ERR_DCOM_MAX_FPARAM                          N(871), ERR_TYPE,_T("DCOM    "),_T("Call of a DBProc with more than %d float parameter")
#define  ERR_NOT_ENOUGH_MEMORY                        N(872), ERR_TYPE,_T("MEMORY  "),_T("Not enough memory for %s wanted : %ld kB!")
#define  ERR_CANT_WRITE_PAGES_ON_DEVSPACE             N(873), ERR_TYPE,_T("VOLUMEIO"),_T("Could not write page %d-%d on volume '%s', rc = %d")
#define  ERR_CANT_READ_PAGES_FROM_DEVSPACE            N(874), ERR_TYPE,_T("VOLUMEIO"),_T("Could not read page %d-%d from volume: '%s', rc = %d")
#define  ERR_CONVERTING_THREAD_TO_FIBER               N(875), ERR_TYPE,_T("FIBER   "),_T("Could not convert thread to fiber, rc = %d")
#define  ERR_CREATING_FIBER                           N(876), ERR_TYPE,_T("FIBER   "),_T("Could not create fiber, rc = %d")
#define  ERR_ALLOC_MEMORY_XXX_BYTES_FILE_LINE_I64     N(877), ERR_TYPE,_T("MEMORY  "),_T("Could not allocate memory %I64u bytes, rc = %u, ( %s:%d )")
#define  ERR_DIAG_HIST_SEM                            N(878), ERR_TYPE,_T("DIAGHIST"),_T("%s the semaphore failed: %s, rc=%lu")
#define  ERR_DIAG_HIST_GET_FILENAME                   N(879), ERR_TYPE,_T("DIAGHIST"),_T("Filename for %s not found in XParam")
#define  ERR_DIAG_HIST_DIRNAME                        N(880), ERR_TYPE,_T("DIAGHIST"),_T("Can not create directory name for the new history")
#define  ERR_DIAG_HIST_OS_ERROR                       N(881), ERR_TYPE,_T("DIAGHIST"),_T("%s '%s' OS error: [%s]")
#define  ERR_TIME_CONV                                N(882), ERR_TYPE,_T("DIAGHIST"),_T("Could not convert time struct to time: %s")
#define  ERR_INVALID_DEVSPACE_NO                      N(883), ERR_TYPE,_T("VOLUMEIO"),_T("Invalid volume number %d")
#define  ERR_DEVSPACE_ALREADY_EXISTS                  N(884), ERR_TYPE,_T("VOLUMEIO"),_T("Volume '%s' alredy exists")
#define  ERR_XSER_CHDIR                               N(885), ERR_TYPE,_T("XSERVER "),_T("Cannot chdir to '%s':%s")
#define  ERR_XSER_GET_SERVICE                         N(886), ERR_TYPE,_T("XSERVER "),_T("Cannot get service by name '%s'")
#define  ERR_POLL_SYSCALL                             N(887), ERR_TYPE,_T("SERVER  "),_T("Can't poll(%d desc, timeout %d), '%s'")
#define  ERR_XCONS_TASK_INACTIVE                      N(888), ERR_TYPE,_T("XCONS   "),_T("Task is inactive")
#define  ERR_CURR_INST_ADDR                           N(889), ERR_TYPE,_T("COREHAND"),_T("current inst.addr.reg 0x%lx")
#define  ERR_CALLED_FROM_CODE                         N(890), ERR_TYPE,_T("COREHAND"),_T("called from code addr 0x%lx")
#define  ERR_DUMP_CALLSTACK_TASK                      N(891), ERR_TYPE,_T("CALLSTCK"),_T("Dumping callstack of T%d")
#define  ERR_DEBUG_BREAK                              N(892), ERR_TYPE,_T("EXCEPT  "),_T("Debug break occured Addr:%#x")
#define  ERR_PREPARE_SHUTDOWN_NOT_UTILITY             N(893), ERR_TYPE,_T("TASKING "),_T("'vPrepareShutdown' called by other than utility task")
#define  ERR_XSER_PROCESS_GROUP                       N(894), ERR_TYPE,_T("XSERVER "),_T("Failed to set new grocess group:%s")
#define  ERR_XSER_REDIRECT_OUTPUT                     N(895), ERR_TYPE,_T("XSERVER "),_T("Redirect message output to '%s' failed:%s")
#define  ERR_XSERVER_KILL                             N(896), ERR_TYPE,_T("XSERVER "),_T("%s | Killing x_server subprocesses failed: %s")
#define  ERR_UNLINK_SYSCALL                           N(897), ERR_TYPE,_T("IO      "),_T("Can't unlink('%s'), '%s'")
#define  ERR_GETRLIMIT_SYSCALL                        N(898), ERR_TYPE,_T("DBSTATE "),_T("Can't getrlimit(RLIMIT_%s), '%s'")
#define  ERR_SETRLIMIT_SYSCALL                        N(899), ERR_TYPE,_T("DBSTATE "),_T("Can't setrlimit(RLIMIT_%s), '%s'")
#define  ERR_DUMP_CALLSTACK_ENDLESS_LOOP_TASK         N(900), ERR_TYPE,_T("CALLSTCK"),_T("Dumping callstack of T%d which might stuck in an endless loop")
#define  ERR_XP_INVALID_FORMATTING_MODE               N(901), ERR_TYPE,_T("XPARAM  "),_T("Invalid formatting mode '%s'")
#define  ERR_CANT_COPY_FILE_OWNER                     N(902), ERR_TYPE,_T("MEMORY  "),_T("Can't copy owner '%s' of '%s' : %s")
#define  ERR_ALLOCATING_TASK_STACK1                   N(903), ERR_TYPE,_T("MEMORY  "),_T("FATAL: Allocate of task stack chunk failed")
#define  ERR_ALLOCATING_TASK_STACK2                   N(903), ERR_TYPE,_T("MEMORY  "),_T("Reduce number of tasks or task stack size to solve this problem")
#define  ERR_SYSCALL                                  N(904), ERR_TYPE,_T("SYSTEM  "),_T("call to %s failed, errno=%d")
#define  ERR_POPEN_SYSCALL                            N(905), ERR_TYPE,_T("SYSTEM  "),_T("popen('%s') failed, errno=%d")
#define  ERR_OPENDIR_SYSCALL                          N(906), ERR_TYPE,_T("SYSTEM  "),_T("open directory %s failed, errno=%d")
#define  ERR_COULD_NOT_FIND_NUMBER_IN_STRING          N(907), ERR_TYPE,_T("SYSTEM  "),_T("could not find number in string %s")
#define  ERR_STARTING_TASK_THREADS1                   N(908), ERR_TYPE,_T("SYSTEM  "),_T("FATAL: Could not start all user task threads")
#define  ERR_STARTING_TASK_THREADS2                   N(908), ERR_TYPE,_T("SYSTEM  "),_T("Reduce number of tasks or increase OS parameter to solve this problem")
#define  ERR_FREE_BIG_TASK_STACK_CHUNK                N(909), ERR_TYPE,_T("MEMORY  "),_T("FATAL: Freeing big task stack chunk failed")
#define  ERR_REALLOCATING_TASK_STACK                  N(910), ERR_TYPE,_T("MEMORY  "),_T("FATAL: Reallocate of task stack chunk [ 0x%lx - 0x%lx ] failed")
#define  ERR_KERNEL_BASE_KEY                          N(911), ERR_TYPE,_T("IPC     "),_T("FATAL: Got no valid ipc key from 0x%0x up to 0x%0x step 0x%x")
#define  ERR_WRITE_SYSCALL                            N(912), ERR_TYPE,_T("IO      "),_T("Can't write('%s', %ld bytes) got %ld, '%s'")
#define  ERR_OPEN_PARAM_FILE_FAILED                   N(913), ERR_TYPE,_T("XPARAM  "),_T("Error opening parameter file: %s")
#define  ERR_GET_RESOURCE_FAILED                      N(914), ERR_TYPE,_T("ENVIRON "),_T("Get resource '%s' failed:%s")
#define  ERR_INTERNAL_MICRO_TIMER_FAILED_I64          N(915), ERR_TYPE,_T("TASKING "),_T("Dispatcher Timing wrong %s %I64u > %s %I64u")
#define  ERR_XCONS_WRONG_VALUE                        N(916), ERR_TYPE,_T("XCONS   "),_T("Wrong value")
#define  ERR_INVALID_TAPE_BLOCK_COUNT                 N(917), ERR_TYPE,_T("IO      "),_T("Tape '%s', invalid tape block count")
#define  ERR_VBLOCKIO_VDETACH_PENDING                 N(918), ERR_TYPE,_T("IO      "),_T("Detach on device %d already pending")
#define  ERR_XSERVER_OPEN_PROTOCOL_FIFO               N(919), ERR_TYPE,_T("XSERVER "),_T("Open protocol pipe %s failed:%s")
#define  ERR_XSERVER_ALREADY_RUNNING                  N(920), ERR_TYPE,_T("XSERVER "),_T("XSERVER is already running!")
#define  ERR_XSERVER_OPEN_PROCESS                     N(922), ERR_TYPE,_T("XSERVER "),_T("Could not fork background proccess:%s")
#define  ERR_XSERVER_PROCESS_GROUP                    N(923), ERR_TYPE,_T("XSERVER "),_T("Failed to set new grocess group:%s")
#define  ERR_XSERVER_REDIRECT_OUTPUT                  N(924), ERR_TYPE,_T("XSERVER "),_T("Redirect message output to '%s' failed:%s")
#define  ERR_XSERVER_SEND_PACKET                      N(925), ERR_TYPE,_T("XSERVER "),_T("Send packet, Ref:%d - %s")
#define  ERR_XSERVER_RECV_PACKET                      N(926), ERR_TYPE,_T("XSERVER "),_T("Receive packet, Ref:%d - %s")
#define  ERR_XSERVER_CANNOT_STOP                      N(927), ERR_TYPE,_T("XSERVER "),_T("Terminating x_server may have failed, got %d unexpected bytes")
#define  ERR_XSERVER_GET_SERVICE                      N(928), ERR_TYPE,_T("XSERVER "),_T("Cannot get service by name '%s'")
#define  ERR_XSERVER_LISTEN_SOCKET_OPEN               N(929), ERR_TYPE,_T("XSERVER "),_T("Listen socket open error:%s")
#define  ERR_XSERVER_BIND_ERROR                       N(930), ERR_TYPE,_T("XSERVER "),_T("Bind error:%s")
#define  ERR_XSERVER_OPEN_UPDATE_FIFO                 N(931), ERR_TYPE,_T("XSERVER "),_T("Open update pipe '%s' failed:%s")
#define  ERR_XSERVER_LISTEN_ERROR                     N(932), ERR_TYPE,_T("XSERVER "),_T("Listen error:%s")
#define  ERR_XSERVER_ACCEPT_ERROR                     N(933), ERR_TYPE,_T("XSERVER "),_T("Accept error:%s")
#define  ERR_XSERVER_CONN_REQ                         N(934), ERR_TYPE,_T("XSERVER "),_T("Connect request: %s")
#define  ERR_XSERVER_SET_BUF_SIZE                     N(935), ERR_TYPE,_T("XSERVER "),_T("Could not set socket buffer size (%s):%s")
#define  ERR_XSERVER_SURPRISING_HEADER                N(936), ERR_TYPE,_T("XSERVER "),_T("Surprising header size %d minimum %d")
#define  ERR_XSERVER_CREATE_NAMED_PIPE                N(937), ERR_TYPE,_T("XSERVER "),_T("Create named pipe '%s' failed:%s")
#define  ERR_XSERVER_PATH_TOO_LONG                    N(938), ERR_TYPE,_T("XSERVER "),_T("Path to long: '%s'")
#define  ERR_XSERVER_CHDIR                            N(939), ERR_TYPE,_T("XSERVER "),_T("Cannot chdir to '%s':%s")
#define  ERR_XSERVER_PING                             N(940), ERR_TYPE,_T("XSERVER "),_T("Ping request failed:%s")
#define  ERR_XSERVER_VERSION_STRING_CONVERSION        N(941), ERR_TYPE,_T("XSERVER "),_T("Version string conversion failed:%s")
#define  ERR_XSERVER_WRITE_UPDATE_FIFO                N(942), ERR_TYPE,_T("XSERVER "),_T("Write to update pipe '%s' failed:%s")
#define  ERR_XSERVER_READ_UPDATE_FIFO                 N(943), ERR_TYPE,_T("XSERVER "),_T("Read from update pipe '%s' failed:%s")
#define  ERR_XSERVER_WAITING_FOR_PROCESS              N(944), ERR_TYPE,_T("XSERVER "),_T("Waiting for process %d failed:%s")
#define  ERR_XSERVER_CREATE_PIPE                      N(945), ERR_TYPE,_T("XSERVER "),_T("Create background process pipe failed:%s")
#define  ERR_RUNNING_PROCESS_ID                       N(946), ERR_TYPE,_T("XSERVER "),_T("Running process id '%s' retrieved from update pipe is illegal")
#define  ERR_XSERVER_READ_UPDATE_REPLY                N(947), ERR_TYPE,_T("XSERVER "),_T("Read from update reply pipe '%s' got '%s' then failed:%s")
#define  ERR_XSERVER_MISSING_DBROOT                   N(948), ERR_TYPE,_T("XSERVER "),_T("DBROOT not found in environment")
#define  ERR_XSERVER_UPDATE_PROCESS                   N(949), ERR_TYPE,_T("XSERVER "),_T("Cannot access update process %s:%s")
#define  ERR_XSERVER_UPDATE_VERSION                   N(950), ERR_TYPE,_T("XSERVER "),_T("Mismatch version after update '%s' != own '%s'")

#define  ERR_COROUTINES_NOT_AVAILABLE                 N(951), ERR_TYPE,_T("TASKING "),_T("USE_COROUTINES is YES but coroutines are not available on this system due to a broken libc!")
#define  ERR_COREHANDER_PROCESS                       N(952), ERR_TYPE,_T("COREHAND"),_T("Signal send from process %d\n")
#define  ERR_COREHANDER_FAULT_ADDR                    N(953), ERR_TYPE,_T("COREHAND"),_T("Fault address 0x%p\n")
#define  ERR_XSERVER_RENAME_PATH                      N(954), ERR_TYPE,_T("XSERVER "),_T("Renaming '%s' to '%s' failed:%s")
#define  ERR_XSERVER_NOT_ADMINISTRATOR                N(955), ERR_TYPE,_T("XSERVER "),_T("Action allowed for members of sdb administrator group only!")

#define  ERR_COMMSEG_HEADER_CORRUPT                   N(956), ERR_TYPE,_T("CONNECT "),_T("The communication segment header is corrupt")
#define  ERR_FILL_PARAMETER                           N(957), ERR_TYPE,_T("FILLCODE"),_T("Fill limit %d, [0x%p]+%d, %d bytes '%c'")
#define  ERR_FILL_UNICODE_PARAMETER                   N(958), ERR_TYPE,_T("FILUCODE"),_T("Unicode fill limit %d, [0x%p]+%d, %d bytes 0x'%02x|%02x'")
#define  ERR_MOVE_PARAMETER                           N(959), ERR_TYPE,_T("MOVECODE"),_T("Move: limit source %d destination %d, source [0x%p]+%d, destination [0x%p]+%d, %d bytes")
#define  ERR_OVERLAPPING_MOVE_PARAMETER               N(960), ERR_TYPE,_T("OVERLAP "),_T("Overlapping move: limit source %d destination %d, source [0x%p]+%d, destination [0x%p]+%d, %d bytes")

#define  ERR_SEC_NO_USER                              N(970), ERR_TYPE,_T("SECURITY"),_T("No user specified to build security descriptor")
#define  ERR_XUSER_NO_PERMISSION                      N(971), ERR_TYPE,_T("SECURITY"),_T("No permission to change USER data")
#define  ERR_XSER_SEND_CERT_PACKET                    N(974), ERR_TYPE,_T("COMMUNIC"),_T("Send certificate packet failed")
#define  ERR_WAITPID_ERROR                            N(975), ERR_TYPE,_T("PROCESS "),_T("waiting for child failed %d:%s")
#define  ERR_WAITPID_TIMEOUT                          N(976), ERR_TYPE,_T("PROCESS "),_T("waiting for child timeed out after %d seconds")
#define  ERR_WAITPID_WRONG_PID                        N(977), ERR_TYPE,_T("PROCESS "),_T("Waitpid return pid %ld expected %ld")
#define  ERR_KERNEL_EXIT_WITH_CORE                    N(978), ERR_TYPE,_T("DBCRASH "),_T("Kernel exited with core and exit status 0x%x")
#define  ERR_KERNEL_EXIT_WITHOUT_CORE                 N(979), ERR_TYPE,_T("DBCRASH "),_T("Kernel exited without core and exit status 0x%x")
#define  ERR_KERNEL_EXITED_BY_HUP                     N(980), ERR_TYPE,_T("DBCRASH "),_T("Kernel exited due to SIGHUP")
#define  ERR_KERNEL_EXITED_BY_PANIC                   N(981), ERR_TYPE,_T("DBCRASH "),_T("Kernel exited due to reentered signal handler")
#define  ERR_KERNEL_EXITED_BY_SIGNAL                  N(982), ERR_TYPE,_T("DBCRASH "),_T("Kernel exited due to signal %d(%s)")
#define  ERR_KERNEL_EXIT_CODE                         N(983), ERR_TYPE,_T("DBCRASH "),_T("Kernel exited exit code %d")
#define  ERR_KERNEL_INDICATES_STACK_OVERFLOW          N(984), ERR_TYPE,_T("DBCRASH "),_T("No stack backtrace since signal handler was not called. This indicates a stack overflow")
#define  ERR_KERNEL_STACK_BACKTRACE_SUPPRESSED        N(985), ERR_TYPE,_T("DBCRASH "),_T("No stack backtrace since signal handler was suppressed by SUPPRESS_CORE=NO")
#define  ERR_CANT_REGISTER_SYMBOL_RESOLUTION_LOCK     N(1015), ERR_TYPE,_T("TASKING "),_T("Cannot register symbolic resolution lock...")
#define  ERR_REMOTEFUNC_NOT_SET                       N(1016), ERR_TYPE,_T("TASKING "),_T("Remote func for T%d (param %d) not set")
#define  ERR_SUSPEND_THREAD                           N(1017), ERR_TYPE,_T("TASKING "),_T("Could not suspend thread: '%s', %s")

/* =========================== WARNING ====================================================================================================*/

/* NEW_NUMBER_RANGE N(1400) */
#define  WRN_TSK_CLST_MAX_USER                        N(1400),WRN_TYPE,_T("TCLUSTER"),_T("TASKCLUSTER - %d users specified - maxuser %d")
#define  WRN_TSK_CLST_MAX_SERV                        N(1401),WRN_TYPE,_T("TCLUSTER"),_T("TASKCLUSTER - %d server specified - maxserver %d")
#define  WRN_SHRD_DYN_DATA_TOO_SMALL                  N(1402),WRN_TYPE,_T("MEMORY  "),_T("Shareddyndata too small in XPARAM")
#define  WRN_SHRD_DYN_POOL_TOO_SMALL                  N(1403),WRN_TYPE,_T("MEMORY  "),_T("Shareddynpool too small in XPARAM")
#define  WRN_SHUTDOWN_NOT_WARM_STATE                  N(1404),WRN_TYPE,_T("DBSTATE "),_T("Shutdown in not ONLINE state")
#define  WRN_QUERY_TASK_STACK                         N(1405),WRN_TYPE,_T("MEMORY  "),_T("Could not query the tasks stack size, rc = %d")
#define  WRN_DB_STOPPED_IN_WARM_MODE                  N(1406),WRN_TYPE,_T("DBSTATE "),_T("SERVERDB is being stopped in ONLINE state")
#define  WRN_TSK_CLST_MAX_DW                          N(1407),WRN_TYPE,_T("TCLUSTER"),_T("TASKCLUSTER - %d datawriter specified - maxdatawriter %d")
#define  WRN_TSK_CLST_MAX_EV                          N(1408),WRN_TYPE,_T("TCLUSTER"),_T("TASKCLUSTER - %d eventtasks specified - maxeventtasks %d")
#define  WRN_OFF_NODE_NAME_NOT_FOUND                  N(1409),WRN_TYPE,_T("CONNECT "),_T("Could not get official node name. Using: %s")
#define  WRN_NO_INTERACT_WITH_DESCTOP                 N(1410),WRN_TYPE,_T("SERVICE "),_T("Service needs 'interact with desktop' option for 'DebugBreak'")
#define  WRN_EXP_VALUE_TRUNCATED                      N(1411),WRN_TYPE,_T("MATH    "),_T("exp(%8.3f) truncated to exp(%8.3f)")
#define  WRN_TSK_CLST_ILL_THRD_PRIO                   N(1412),WRN_TYPE,_T("TCLUSTER"),_T("- Illegal thread priority '%d'")
#if defined(_WIN32)
#define  WRN_TSK_CLST_ALLOWED_THRD_PRIO               N(1413),WRN_TYPE,_T("TCLUSTER"),_T("- allowed thread priority %d, %d, %d - %d")
#else
#define  WRN_TSK_CLST_ALLOWED_THRD_PRIO               N(1413),WRN_TYPE,_T("TCLUSTER"),_T("- allowed thread priority %d - %d")
#endif
#define  WRN_TSK_CLST_MAX_XX                          N(1414),WRN_TYPE,_T("TCLUSTER"),_T("TaskType '%s': using %d, specified %d")
#define  WRN_RESOURCE_LIMITS                          N(1415),WRN_TYPE,_T("DBSTART "),_T("Cannot obtain resource limits")
#define  WRN_SHRD_DATA_CACHE_TOO_SMALL                N(1416),WRN_TYPE,_T("XPARAM  "),_T("Datacache too small in XPARAM")
#define  WRN_SHRD_CONV_CACHE_TOO_SMALL                N(1417),WRN_TYPE,_T("XPARAM  "),_T("Convertercache too small in XPARAM")
#define  WRN_NODE_PL_DBNAME_TOO_LONG                  N(1418),WRN_TYPE,_T("CONNECT "),_T("SERVERNODE + SERVERDB longer than %d")
#define  WRN_WRONG_SERV_TYPE_LINE                     N(1419),WRN_TYPE,_T("CONNECT "),_T("Illegal line '%s' in server type file ignored")
#define  WRN_ILL_ARG_LENGTH                           N(1420),WRN_TYPE,_T("CONNECT "),_T("Illegal argument length: %d")
#define  WRN_XSER_WRONG_DBROOT                        N(1421),WRN_TYPE,_T("XSERVER "),_T("DBROOT of the running XSERVER is: '%s'")
#define  WRN_XSER_CANNOT_READ_REG                     N(1422),WRN_TYPE,_T("XSERVER "),_T("Could not read registry entry: '%s'")
#define  WRN_PROF_CONTAINER_MODIFIED                  N(1423),WRN_TYPE,_T("PROFCONT"),_T("Profile container modified during repeated scan activities")
#define  WRN_DB_START_SHARED_SIZE_GT_MEM_PHYS         N(1424),WRN_TYPE,_T("DBSTATE "),_T("Shared exceeds physical  memory")
#define  WRN_DB_START_SHARED_SIZE_GT_MEM_AVAIL        N(1425),WRN_TYPE,_T("DBSTATE "),_T("Shared exceeds available memory")
#define  WRN_TEST_WILDCARD                            N(1426),WRN_TYPE,_T("TEST    "),_T("%s")
#define  WRN_RESUMER_HISTORY                          N(1428),WRN_TYPE,_T("TASKING "),_T("ResumerPid T%d")
#define  WRN_XSER_NO_PATH_FOR_PROTFILE_FOUND          N(1429),WRN_TYPE,_T("XSERVER "),_T("No directory for '%s' found! Using current dir")
#define  WRN_XSER_CANT_SET_SYMBOL_PATH                N(1430),WRN_TYPE,_T("XSERVER "),_T("Could not determine symbol directory. No Dr.Watson stack back trace available!")
#define  WRN_NOT_ENOUGH_HEAP_AVAIL_USING_SHM          N(1431),WRN_TYPE,_T("MEMORY  "),_T("Not enough heap available! Try to use shared memory.")
#define  WRN_TRACEIO_BAD_FILEINDEX                    N(1432),WRN_TYPE,_T("TRACE_IO"),_T("%s: Fileindex %d invalid")
#define  WRN_TRACEIO_MAXIMUM_EXCEEDED                 N(1433),WRN_TYPE,_T("TRACE_IO"),_T("Fileindex %d exceeds _MAX_MESSAGE_FILES:%d")

#define  WRN_REMOTEFUNC_ERROR_CALLED                  N(1435),WRN_TYPE,_T("TASKING "),_T("remote func for T%d (param %d) called")
#define  WRN_TIMEZONE_DELTA                           N(1436),WRN_TYPE,_T("vTZdelta"),_T("Problem with day of week delta:%d|%d")
#define  WRN_XSERVER_NO_KILL                          N(1437),WRN_TYPE,_T("XSERVER "),_T("Killing x_server failed")
#define  WRN_DIAG_HIST_DEACTIVATED                    N(1438),WRN_TYPE,_T("DIAGHIST"),_T("Diagnose history was deactivated by user")
#define  WRN_PREPARE_SHUTDOWN_TIMEOUT                 N(1439),WRN_TYPE,_T("TASKING "),_T("'vPrepareShutdown' timeout after %d seconds")
#define  WRN_PREPARE_SHUTDOWN_CANCELED                N(1440),WRN_TYPE,_T("TASKING "),_T("'vPrepareShutdown' canceled after %d seconds")
#define  WRN_XSERVER_NO_DEBUGLEVEL_CHANGE             N(1441),WRN_TYPE,_T("XSERVER "),_T("Failed to change debug level")
#define  WRN_IPC_CLOSEDIR                             N(1442),WRN_TYPE,_T("IPC     "),_T("closedir('%s') failed: %s")
#define  WRN_CANT_SUPPRESS_CORE_DUMP                  N(1443),WRN_TYPE,_T("DBSTATE "),_T("Failed to suppress core dump creation")
#define  WRN_CANT_ALLOW_CORE_DUMP                     N(1444),WRN_TYPE,_T("DBSTATE "),_T("Failed to allow core dump creation")
#define  WRN_USER_LIMITED_CORE_DUMP                   N(1445),WRN_TYPE,_T("DBSTATE "),_T("User has hard limited core dump size")
#define  WRN_PROTECTING_TASK_STACK                    N(1446),WRN_TYPE,_T("TASKING "),_T("Protecting task stack at [ 0x%lx - 0x%lx ] failed (continue unprotected)")
/* PTS 1116686 */
#define  WRN_NOT_ENOUGH_HEAP                          N(1447),WRN_TYPE,_T("MEMORY  "),_T("memory size needed exceeds heap size!")
#define  WRN_NOT_ENOUGH_VIRT_MEMORY                   N(1448),WRN_TYPE,_T("MEMORY  "),_T("memory size needed exceeds virtual address space!")
#define  WRN_VDETACH_IGNORE_SELF_IO                   N(1449),WRN_TYPE,_T("VDETACH "),_T("Ignoring pending self io in UKT%d on device %d")
/* PTS 1124003 */
#define  WRN_ILL_STRING_ARG                           N(1450),WRN_TYPE,_T("CONNECT "),_T("Illegal string argument length: %d tag '%c'")
#define  WRN_LONG_STRING_ARG                          N(1451),WRN_TYPE,_T("CONNECT "),_T("Unterminated string argument length: %d tag '%c'")
#define  WRN_SHORT_STRING_ARG                         N(1452),WRN_TYPE,_T("CONNECT "),_T("Too short string argument length: %d tag '%c'")
#define  WRN_WAITPID_FOR_NO_CHILD                     N(1453),WRN_TYPE,_T("PROCESS "),_T("Your operating system reports no child to wait for...")


/* =========================== INFO MESSAGES ============================================================================================*/
/* NEW_NUMBER_RANGE N(1600) */
#define  INFO_VERSION                                 N(1600),INFO_TYPE,_T("VERSION "),_T("'%s'")
#define  INFO_DATABASE_READY                          N(1601),INFO_TYPE,_T("DBSTATE "),_T("SERVERDB is ready")
#define  INFO_DB_STATE_WARM                           N(1602),INFO_TYPE,_T("DBSTATE "),_T("SERVERDB is in ONLINE state")
#define  INFO_DB_STATE_COLD                           N(1603),INFO_TYPE,_T("DBSTATE "),_T("SERVERDB is in ADMIN state")
#define  INFO_VFOPEN                                  N(1604),INFO_TYPE,_T("IO      "),_T("Opening file '%s")
#define  INFO_EXIT_LIST_SER_ERROR                     N(1605),INFO_TYPE,_T("EXIT    "),_T("Serious error")
#define  INFO_EXIT_LIST_PROC_KILLED                   N(1606),INFO_TYPE,_T("EXIT    "),_T("Process was killed")
#define  INFO_EXIT_LIST_TRAP_OPER                     N(1607),INFO_TYPE,_T("EXIT    "),_T("Trap operation")
#define  INFO_EXIT_LIST_EXITING                       N(1608),INFO_TYPE,_T("EXIT    "),_T("Exiting")
#define  INFO_MORE_THAN_ONE_PARTITION                 N(1610),INFO_TYPE,_T("IO      "),_T("Tape has more than one partition ( '%s', Partitions: %d )")
#define  INFO_DB_STOPPED                              N(1611),INFO_TYPE,_T("DBSTATE "),_T("SERVERDB is being stopped")
#define  INFO_DB_TERM_VERSION                         N(1612),INFO_TYPE,_T("DBSTATE "),_T("SERVERDB '%s' has stopped,\r\n   Version: \t'%s'")
#define  INFO_DEVI_STARTED                            N(1613),INFO_TYPE,_T("DBSTATE "),_T("I/O thread for '%s' started")
#define  INFO_DEVI_STOPPED                            N(1614),INFO_TYPE,_T("DBSTATE "),_T("I/O thread for '%s' stopped")
#define  INFO_ATTACHING_DEVSPACE                      N(1615),INFO_TYPE,_T("VOLUMEIO"),_T("Attaching volume '%s'")
#define  INFO_DETACHING_DEVSPACE                      N(1616),INFO_TYPE,_T("VOLUMEIO"),_T("Detaching volume '%s'")
#define  INFO_SINGLEIO_ATTACH                         N(1617),INFO_TYPE,_T("VOLUMEIO"),_T("Single I/O attach, '%s', UKT:%d")
#define  INFO_SINGLEIO_DETACH                         N(1618),INFO_TYPE,_T("VOLUMEIO"),_T("Single I/O detach, '%s', UKT:%d")
#define  INFO_RELEASING_TRACEWRITER                   N(1619),INFO_TYPE,_T("TASKING "),_T("Releasing tracewriter")
#define  INFO_SHUTDOWN_NORMAL_REQ                     N(1620),INFO_TYPE,_T("DBSTATE "),_T("Shutdown normal requested")
#define  INFO_SHUTDOWN_KILL_REQ                       N(1621),INFO_TYPE,_T("DBSTATE "),_T("Shutdown kill requested")
#define  INFO_SHUTDOWN_REINIT_REQ                     N(1622),INFO_TYPE,_T("DBSTATE "),_T("Shutdown reinit requested")
#define  INFO_TASK_STACK_NOT_FREED                    N(1623),INFO_TYPE,_T("MEMORY  "),_T("Tasks stack not freed")
#define  INFO_KERNEL_ABORTS                           N(1624),INFO_TYPE,_T("EXCEPT  "),_T("Kernel aborts")
#define  INFO_ASYNCI_STARTED                          N(1625),INFO_TYPE,_T("IO      "),_T("Async I/O thread started, '%s")
#define  INFO_ASYNCI_STOPPED                          N(1626),INFO_TYPE,_T("IO      "),_T("Async I/O thread stopped, '%s'")
#define  INFO_UKT_STARTED                             N(1627),INFO_TYPE,_T("TASKING "),_T("UKT started, TID:0x%X")
#define  INFO_UNIX_UKT_STARTED                        N(1627),INFO_TYPE,_T("TASKING "),_T("UKT%d started")
#define  INFO_REQUEST_REJECT                          N(1628),INFO_TYPE,_T("CONNECT "),_T("REQUESTOR is rejecting connect request")
#define  INFO_KILL_TSK_FOR_DIED_APP                   N(1629),INFO_TYPE,_T("CONNECT "),_T("Killing T%d appl. died PID:%d")
#define  INFO_KILL_TSK_FOR_DIED_SND                   N(1630),INFO_TYPE,_T("CONNECT "),_T("Sender died PID:%d")
#define  INFO_CON_REQ_BUT_UT_BUSY                     N(1631),INFO_TYPE,_T("CONNECT "),_T("Connect req., but UTILITY is busy")
#define  INFO_CON_REQ_BUT_US_BUSY                     N(1632),INFO_TYPE,_T("CONNECT "),_T("Connect req., but all user tasks busy")
#define  INFO_CONN_TASK_WITH_APP                      N(1633),INFO_TYPE,_T("CONNECT "),_T("Connect req. (T%d, Node:'%s', PID:%d)")
#define  INFO_CONNECTION_KILLED                       N(1634),INFO_TYPE,_T("CONNECT "),_T("Connection killed for T%d")
#define  INFO_CONN_BROKEN                             N(1635),INFO_TYPE,_T("CONNECT "),_T("Connection broken for T%d")
#define  INFO_CONN_WITH_PATHID                        N(1636),INFO_TYPE,_T("CONNECT "),_T("Connect (pathid: %d, Node:'%s', PID:%d)")
#define  INFO_COMM_TIMEOUT                            N(1637),INFO_TYPE,_T("CONNECT "),_T("'vreceive', COMMAND TIMEOUT, T%d")
#define  INFO_CANCEL_REQ_FOR_TSK                      N(1638),INFO_TYPE,_T("CONNECT "),_T("Cancel request for task, T%d")
#define  INFO_RELEASE_REQ_FOR_TSK                     N(1639),INFO_TYPE,_T("CONNECT "),_T("Release request for task, T%d")
#define  INFO_USER_CONN_LOST                          N(1640),INFO_TYPE,_T("CONNECT "),_T("User lost")
#define  INFO_CON_REFUSED_NET_NOT_REST                N(1641),INFO_TYPE,_T("CONNECT "),_T("Conn. refused, network not restarted")
#define  INFO_CON_REPL_UNEXP_STATE                    N(1642),INFO_TYPE,_T("CONNECT "),_T("'conn_repl' unexpected state %d")
#define  INFO_VNOPEN                                  N(1643),INFO_TYPE,_T("CONNECT "),_T("'vnopen' T%d '%s:%s'")
#define  INFO_EXCEPTION_SIG_KILL                      N(1644),INFO_TYPE,_T("EXCEPT  "),_T("External kill process signal received")
#define  INFO_DEVSPACE_SIZE                           N(1645),INFO_TYPE,_T("VOLUMEIO"),_T("Volume '%s', calculated size: %d pages")
#define  INFO_DEV_SIZE_EXC_MAX                        N(1646),INFO_TYPE,_T("VOLUMEIO"),_T("Volume '%s', requested size exceeds maximum ( %d pages ).")
#define  INFO_DEV_SIZE_LOV_MAX                        N(1647),INFO_TYPE,_T("VOLUMEIO"),_T("Volume '%s', requested size ( %d ) lover than max. ( %d pages ).")
#define  INFO_UNREL_CONN_FOUND                        N(1648),INFO_TYPE,_T("CONNECT "),_T("Unreleased connection found, T%d")
#define  INFO_KT_INIT_TIMEOUT                         N(1649),INFO_TYPE,_T("CONNECT "),_T("Kernel threads initialization timeout")
#define  INFO_ADDR_REQUEST_REJECT                     N(1650),INFO_TYPE,_T("CONNECT "),_T("REQUESTOR is rejecting address request")
#define  INFO_CONN_RELEASED                           N(1651),INFO_TYPE,_T("CONNECT "),_T("Connection released, T%d")
#define  INFO_PACKET_WITHOUT_CONN                     N(1652),INFO_TYPE,_T("CONNECT "),_T("Lost packet found, T%d")
#define  INFO_LOST_CONN_FOUND                         N(1653),INFO_TYPE,_T("CONNECT "),_T("Lost connection found, T%d")
#define  INFO_DB_TERM                                 N(1654),INFO_TYPE,_T("DBSTATE "),_T("SERVERDB '%s' has stopped")
#define  INFO_END_OF_FILE_DEV_PIPE                    N(1655),INFO_TYPE,_T("IO      "),_T("EOF on '%s', rc = %d")
#define  INFO_NO_DATA_DETECTED                        N(1656),INFO_TYPE,_T("IO      "),_T("No more data on '%s'")
#define  INFO_UNREL_CONN_FOUND_IDX                    N(1657),INFO_TYPE,_T("CONNECT "),_T("Unreleased connection found, T%d,%d")
#define  INFO_CONN_TASK_IDX_PATHID                    N(1658),INFO_TYPE,_T("CONNECT "),_T("T%d connected with pathid: %ld")
#define  INFO_VNSHUT_SEND_CLOSE_REQ                   N(1659),INFO_TYPE,_T("CONNECT "),_T("'vnshutdown' sending close request to T%d")
#define  INFO_VNSHUT_SEND_CLEAR_REQ                   N(1660),INFO_TYPE,_T("CONNECT "),_T("'vnshutdown' sending clear request to T%d")
#define  INFO_VNCL_PATHID_T                           N(1661),INFO_TYPE,_T("CONNECT "),_T("'vnclose' request pathid: %ld, T%d")
#define  INFO_CLOSE_FAILED                            N(1662),INFO_TYPE,_T("CONNECT "),_T("'vnclose' failed pathid: %ld ")
#define  INFO_PATHID_CLOSED_BY_C_PART                 N(1663),INFO_TYPE,_T("CONNECT "),_T("Comm. partner closed connection, pathid: %ld")
#define  INFO_VNREC_TIMEOUT_T                         N(1664),INFO_TYPE,_T("CONNECT "),_T("'vnreceive' TIMEOUT, T%d")
#define  INFO_VNREC_SHUTDOWN_T                        N(1665),INFO_TYPE,_T("CONNECT "),_T("'vnreceive' SHUTDOWN, T%d")
#define  INFO_CON_BUT_KERNEL_IS_PAUSED                N(1666),INFO_TYPE,_T("CONNECT "),_T("Connect request but kernel is paused!")
#define  INFO_VCLR_PATHID_T                           N(1667),INFO_TYPE,_T("CONNECT "),_T("'vnclear' request, pathid: %ld, T%d")
#define  INFO_CLOSE_CONNECTIONS_T                     N(1668),INFO_TYPE,_T("CONNECT "),_T("Closing connections")
#define  INFO_END_OF_FILE_OR_MEDIA                    N(1669),INFO_TYPE,_T("IO      "),_T("End of file or media reached, '%s', rc = %d")
#define  INFO_CLEAR_CONNECTIONS_T                     N(1670),INFO_TYPE,_T("CONNECT "),_T("Clearing connections")
#define  INFO_VNREST                                  N(1671),INFO_TYPE,_T("CONNECT "),_T("'vnrestart' request, T%d")
#define  INFO_VNSHUT                                  N(1672),INFO_TYPE,_T("CONNECT "),_T("'vnshutdown' request, T%d")
#define  INFO_VNOPEN_PATHID_T                         N(1673),INFO_TYPE,_T("CONNECT "),_T("'vnopen' request, T%d, pathid: %d")
#define  INFO_BUFFERED_ASYNCIO                        N(1674),INFO_TYPE,_T("IO      "),_T("Using buffered I/O operations: '%s'")
#define  INFO_KERNEL_PAUSED                           N(1675),INFO_TYPE,_T("DBSTATE "),_T("Kernel paused")
#define  INFO_KERNEL_CONTINUED                        N(1676),INFO_TYPE,_T("DBSTATE "),_T("Kernel continued")
#define  INFO_CLIENT_CONN_RELEASE                     N(1677),INFO_TYPE,_T("CONNECT "),_T("Client has released connection, T%d")
#define  INFO_OPEN_CONN_FAILED                        N(1678),INFO_TYPE,_T("CONNECT "),_T("Openning '%s:%s' failed, state %d")
#define  INFO_CLOSE_CONN_FAILED                       N(1679),INFO_TYPE,_T("CONNECT "),_T("Closing pathid: %d failed, state %d")
#define  INFO_VNREQ_FAILED                            N(1680),INFO_TYPE,_T("CONNECT "),_T("'vnrequest' failed, pathid: %d")
#define  INFO_VNREQ_REPLY_FAILED                      N(1681),INFO_TYPE,_T("CONNECT "),_T("'vnrequest' reply failed, pathid: %d")
#define  INFO_PIPE_CONNECT_CANCELLED                  N(1682),INFO_TYPE,_T("IO      "),_T("Pipe operation cancelled")
#define  INFO_TAPE_PARAMS                             N(1683),INFO_TYPE,_T("IO      "),_T("Tape compression: %s, ECC: %s")
#define  INFO_TW_TERM_TIMEOUT                         N(1684),INFO_TYPE,_T("TASKING "),_T("Tracewriter termination timeout: %d sec")
#define  INFO_OVERLAPPED_IO_NOT_SUP                   N(1685),INFO_TYPE,_T("OVERL IO"),_T("Unsupported Overlapped IO request")
#define  INFO_AUTORESTART                             N(1686),INFO_TYPE,_T("TASKING "),_T("Automatic restart, SERVERDB: '%s'")
#define  INFO_AUTOSHUTDOWN                            N(1687),INFO_TYPE,_T("TASKING "),_T("Automatic shutdown, SERVERDB: '%s'")
#define  INFO_KERNEL_THREAD_STARTED                   N(1688),INFO_TYPE,_T("THREAD  "),_T("%s thread started")
#define  INFO_KERNEL_THREAD_STOPPED                   N(1689),INFO_TYPE,_T("THREAD  "),_T("%s thread stopped")
#define  INFO_DCOM_DBPROC_NOTRELEASED                 N(1690),INFO_TYPE,_T("DCOM    "),_T("COM-DBPROC Instance not released ! GUID:{%8.8X-%4.4X-%4.4X-%2.2X%2.2X-%2.2X%2.2X%2.2X%2.2X%2.2X%2.2X}")
#define  INFO_TASK_STACK_USED                         N(1691),INFO_TYPE,_T("MEMORY  "),_T("Task stack used %d")
#define  INFO_TSK_CLST                                N(1692),INFO_TYPE,_T("TCLUSTER"),_T("%s")
#define  INFO_TSK_CLST_NUM_XXX_TSK                    N(1693),INFO_TYPE,_T("TCLUSTER"),_T("number of '%3s': %3d" )
#define  INFO_THRD_PRIO_OK                            N(1694),INFO_TYPE,_T("TCLUSTER"),_T("try to set thread priority to %d")
#define  INFO_XPARAM_TASKCLUSTER                      N(1695),INFO_TYPE,_T("TCLUSTER"),_T("Taskcluster[%d] '%s'")
#define  INFO_CHANGE_STATE                            N(1696),INFO_TYPE,_T("DBSTATE "),_T("Change DbState to '%s'(%d)")
#define  INFO_RESUMED_TW                              N(1697),INFO_TYPE,_T("DBSTATE "),_T("Resuming tracewriter")
#define  INFO_FOR_IPC_RESOURCES                       N(1698),INFO_TYPE,_T("IPC     "),_T("Common RTE specific IPC key: 0x%lx")
#define  INFO_CAUGHT_SIGNAL                           N(1699),INFO_TYPE,_T("IPC     "),_T("Caught signal [%d]")
#define  INFO_END_OF_DATA_SECTION                     N(1702),INFO_TYPE,_T("MEMORY  "),_T("End of data section 0x%lx")
#define  INFO_UKT_ASYNCIO_SIGNAL                      N(1703),INFO_TYPE,_T("IO      "),_T("Installed AIO signal handler")
#define  INFO_NO_TCPIP                                N(1704),INFO_TYPE,_T("CONNECT "),_T("No TCP/IP connectivity available, (check the SQLTCPx.DLL)")
#define  INFO_LOADING_DEFAULT_TCPIP                   N(1705),INFO_TYPE,_T("CONNECT "),_T("Loading default TCPIP-DLL, ( '%s')")
#define  INFO_COM_TIMEOUT                             N(1706),INFO_TYPE,_T("CONNECT "),_T("Communication timeout")
#define  INFO_WINSOCK_AND_DLL_VERSION                 N(1707),INFO_TYPE,_T("CONNECT "),_T("WINSOCK: %d.%d, SQLTCP-DLL: %d.%d.%d")
#define  INFO_TAPE_WRONG_PART_CNT                     N(1708),INFO_TYPE,_T("IO      "),_T("Current tape has more then one partition")
#define  INFO_SERVICE_INSTALLED                       N(1709),INFO_TYPE,_T("SERVICE "),_T("Service '%s' installed successfully")
#define  INFO_SERVICE_REMOVED                         N(1710),INFO_TYPE,_T("SERVICE "),_T("Service '%s' removed successfully")
#define  INFO_SERVICE_STARTED                         N(1711),INFO_TYPE,_T("SERVICE "),_T("Service '%s' started successfully")
#define  INFO_SERVICE_ALREADY_INST                    N(1712),INFO_TYPE,_T("SERVICE "),_T("Service '%s' is already installed")
#define  INFO_SERVICE_NOT_INSTALLED                   N(1713),INFO_TYPE,_T("SERVICE "),_T("Service '%s' is not installed")
#define  INFO_UPDATING_SERVICE                        N(1714),INFO_TYPE,_T("SERVICE "),_T("One or more values are different, updating service: '%s'")
#define  INFO_SERVICE_DELETE_MARKED                   N(1715),INFO_TYPE,_T("SERVICE "),_T("Service has been marked for delete")
#define  INFO_SERVICE_NOT_INST_CORR                   N(1716),INFO_TYPE,_T("SERVICE "),_T("Service has not been installed correctly")
#define  INFO_SERVERDB_SERVICE_AL_INST                N(1717),INFO_TYPE,_T("SERVICE "),_T("This gateway name is already used by a SERVERDB")
#define  INFO_LOGON_AS_SERV_RIGHT_GRNT                N(1718),INFO_TYPE,_T("SERVICE "),_T("'Log On As A Service' right granted to '%s'")
#define  INFO_COMPONENT_MESSAGE                       N(1719),INFO_TYPE,_T("DIALCOMP"),_T("%s")
#define  INFO_XSER_STARTED                            N(1720),INFO_TYPE,_T("XSERVER "),_T("XSERVER started")
#define  INFO_XSER_ON_PORT_STARTED                    N(1720),INFO_TYPE,_T("XSERVER "),_T("on port %s started")
#define  INFO_XSER_STOPPED                            N(1721),INFO_TYPE,_T("XSERVER "),_T("stopped")
#define  INFO_XSER_ON_PORT_STOPPED                    N(1721),INFO_TYPE,_T("XSERVER "),_T("on port %s stopped")
#define  INFO_XSER_SERV_PORT                          N(1722),INFO_TYPE,_T("XSERVER "),_T("Service port is %d")
#define  INFO_XSER_OP_LISEN_SOCKET                    N(1723),INFO_TYPE,_T("XSERVER "),_T("Opened listen socket %d")
#define  INFO_XSER_SEGMENT_SIZES                      N(1724),INFO_TYPE,_T("XSERVER "),_T("Segment sizes, sd: %d, min: %d, max: %d")
#define  INFO_XSER_LISTEN_ON_SOCKET                   N(1725),INFO_TYPE,_T("XSERVER "),_T("Listening on socket %d")
#define  INFO_XSER_ACCEPTING                          N(1726),INFO_TYPE,_T("XSERVER "),_T("Accepting ...")
#define  INFO_XSER_ACCEPT_CONNECTION_FROM_CLIENT      N(1727),INFO_TYPE,_T("XSERVER "),_T("Accepted connection, socket: %d from client node '%s'")
#define  INFO_XSER_SERVER_STARTED                     N(1728),INFO_TYPE,_T("XSERVER "),_T("server thread started, TID:0x%X")
#define  INFO_XSER_SERVER_EXITING                     N(1729),INFO_TYPE,_T("XSERVER "),_T("server thread exiting, TID:0x%X")
#define  INFO_XSER_REC_CONN_PACKET                    N(1730),INFO_TYPE,_T("XSERVER "),_T("Received connect packet")
#define  INFO_XSER_REC_REQ_PACKET                     N(1731),INFO_TYPE,_T("XSERVER "),_T("Rec. request packet - Class. %d, MyRef: %d, PeerRef: %d, Service: %d, SERVERDB '%s', ClientDB: '%s'")
#define  INFO_XSER_ENTER_DATA_TRANS                   N(1732),INFO_TYPE,_T("XSERVER "),_T("Entering data transmission, TID:0x%X")
#define  INFO_XSER_READ_REQ_PACKET                    N(1733),INFO_TYPE,_T("XSERVER "),_T("Request packet read ( %d bytes ), Ref:%d")
#define  INFO_XSER_REQUEST_RETURNED                   N(1734),INFO_TYPE,_T("XSERVER "),_T("Local request returned, Ref:%d, CommState = %d")
#define  INFO_XSER_RECEIVE_RETURNED                   N(1735),INFO_TYPE,_T("XSERVER "),_T("Local receive returned, Ref:%d, CommState = %d")
#define  INFO_XSER_SEND_REPLY_PACKET                  N(1736),INFO_TYPE,_T("XSERVER "),_T("Reply packet send ( %d bytes ), Ref:%d")
#define  INFO_XSER_CANCEL_REQUESTED                   N(1737),INFO_TYPE,_T("XSERVER "),_T("Cancel request, receiver reference: %d")
#define  INFO_XSER_CANCEL_RETURNING                   N(1738),INFO_TYPE,_T("XSERVER "),_T("Cancel returning, CommState = %d")
#define  INFO_XSER_APPL_CONNECTED                     N(1739),INFO_TYPE,_T("XSERVER "),_T("'%s' connected to '%s', T%d")
#define  INFO_XSER_APPL_DISCONNECT                    N(1740),INFO_TYPE,_T("XSERVER "),_T("'%s' disconnect from '%s', T%d")
#define  INFO_XSER_REC_INFO_REQUEST                   N(1741),INFO_TYPE,_T("XSERVER "),_T("Received info request, SERVERDB: %s")
#define  INFO_XSER_REPLY_INFO_REQUEST                 N(1742),INFO_TYPE,_T("XSERVER "),_T("Info req. reply, SERVERDB: %s, PacketSize: %d, MaxDataLen: %d, MinReply:%d")
#define  INFO_XSER_REC_CONN_REQ                       N(1743),INFO_TYPE,_T("XSERVER "),_T("Connect req. received, SERVERDB: %s, SenderRef: %d, PacketSize: %d, MaxDataLen: %d")
#define  INFO_XSER_CONN_REQ                           N(1744),INFO_TYPE,_T("XSERVER "),_T("Connected to SERVERDB: %s, Ref: %d, MaxCmdDataLen: %d, ConnInfoHandle:%d")
#define  INFO_XSER_CONN_KILLED                        N(1745),INFO_TYPE,_T("XSERVER "),_T("Connect killed: SERVERDB: %s, Ref: %d")
#define  INFO_XSER_ABORTS                             N(1746),INFO_TYPE,_T("XSERVER "),_T("XSERVER aborting")
#define  INFO_XSER_ABORTS_DIAG_INFO                   N(1747),INFO_TYPE,_T("XSERVER "),_T("XSERVER aborting,\r\n   (view diagnostic file: '%s')")
#define  INFO_XSER_EXCEP_SIG_KILL                     N(1748),INFO_TYPE,_T("XSERVER "),_T("External kill process signal received")
#define  INFO_XSER_DUMP_REQUESTED                     N(1749),INFO_TYPE,_T("XSERVER "),_T("Dump request, client reference: %d")
#define  INFO_XSER_END_OF_DATA_TRANS                  N(1750),INFO_TYPE,_T("XSERVER "),_T("End of data transmission, TID:0x%X")
#define  INFO_XSER_STARTED_VERSION                    N(1751),INFO_TYPE,_T("XSERVER "),_T("started, '%s'")
#define  INFO_XSER_ON_PORT_STARTED_VERSION            N(1751),INFO_TYPE,_T("XSERVER "),_T("on port %s started, '%s'")
#define  INFO_XSER_STOPPED_VERSION                    N(1752),INFO_TYPE,_T("XSERVER "),_T("stopped, '%s'")
#define  INFO_XSER_ON_PORT_STOPPED_VERSION            N(1752),INFO_TYPE,_T("XSERVER "),_T("on port %s stopped, '%s'")
#define  INFO_XSER_REQUEST_REJECT                     N(1753),INFO_TYPE,_T("XSERVER "),_T("REQUESTOR is rejecting connect request")
#define  INFO_XSER_CONN_LOST                          N(1754),INFO_TYPE,_T("XSERVER "),_T("Connection lost")
#define  INFO_XSER_SERVDB_CONN_REL                    N(1755),INFO_TYPE,_T("XSERVER "),_T("Connection released, Ref:%d")
#define  INFO_XSER_SERVDB_CONN_BROKEN                 N(1756),INFO_TYPE,_T("XSERVER "),_T("Connection broken, Ref:%d")
#define  INFO_XSER_SERVDB_DATA_RECVED                 N(1757),INFO_TYPE,_T("XSERVER "),_T("%d bytes received from, Ref:%d")
#define  INFO_XSER_PEER_ACKN_SEND                     N(1758),INFO_TYPE,_T("XSERVER "),_T("Acknowledge send to peer, Ref:%d")
#define  INFO_XSER_PEER_ACKN_RECVED                   N(1759),INFO_TYPE,_T("XSERVER "),_T("Acknowledge received from peer, Ref:%d, PeerRef:%d")
#define  INFO_XSER_SERVDB_DATA_SEND                   N(1760),INFO_TYPE,_T("XSERVER "),_T("%d bytes send, Ref:%d, PeerRef:%d")
#define  INFO_XSER_SERVDB_ACKN_RECVED                 N(1761),INFO_TYPE,_T("XSERVER "),_T("Acknowledge received from SERVERDB, Ref:%d")
#define  INFO_XSER_SERVDB_ACKN_SEND                   N(1762),INFO_TYPE,_T("XSERVER "),_T("Acknowledge send to SERVERDB, Ref:%d")
#define  INFO_XSTRT_STARTING_CONSOLE                  N(1763),INFO_TYPE,_T("XSTART  "),_T("Starting kernel as console application")
#define  INFO_XSTRT_DB_STARTED                        N(1764),INFO_TYPE,_T("XSTART  "),_T("'%s' started successfully")
#define  INFO_XSTOP_DB_STOPPED                        N(1765),INFO_TYPE,_T("XSTOP   "),_T("'%s' stopped successfully")
#define  INFO_DCOMI_NO_SEMAPHORE                      N(1766),INFO_TYPE,_T("DCOM    "),_T("'%s' stopped successfully")
#define  INFO_PROCESS_STARTED                         N(1767),INFO_TYPE,_T("        "),_T("%s started" )
#define  INFO_PROCESS_STOPPED                         N(1768),INFO_TYPE,_T("        "),_T("%s stopped" )
#define  INFO_DB_START_SERVERDB                       N(1769),INFO_TYPE,_T("INFO    "),_T("Starting SERVERDB:      '%s'")
#define  INFO_DB_START_SERVERNODE                     N(1770),INFO_TYPE,_T("INFO    "),_T("         SERVERNODE:    '%s'")
#define  INFO_DB_START_PID                            N(1771),INFO_TYPE,_T("INFO    "),_T("         Process ID:    %d")
#define  INFO_DB_START_OWNER                          N(1772),INFO_TYPE,_T("INFO    "),_T("         Owner:         '%s'")
#define  INFO_DB_START_GROUP                          N(1772),INFO_TYPE,_T("INFO    "),_T("         Group:         '%s'")
#define  INFO_DB_START_DATE                           N(1773),INFO_TYPE,_T("INFO    "),_T("         Date:          %04d-%02d-%02d")
#define  INFO_DB_START_PRODUCT_SUITE                  N(1774),INFO_TYPE,_T("INFO    "),_T("         Product suite: '%s'")
#define  INFO_DB_START_NUM_POROCESSORS                N(1775),INFO_TYPE,_T("INFO    "),_T("         Processors:    %4d")
#define  INFO_DB_START_MAX_ADDRESS                    N(1776),INFO_TYPE,_T("INFO    "),_T("         Max virtual memory:        %I64d MB")
#define  INFO_DB_START_PHYSICAL_MEMORY_TOTAL          N(1777),INFO_TYPE,_T("INFO    "),_T("         Total physical memory:     %I64d MB")
#define  INFO_DB_START_PHYSICAL_MEMORY_AVAIL          N(1778),INFO_TYPE,_T("INFO    "),_T("         Available physical memory: %I64d MB")
#define  INFO_DB_START_KERNEL_SHARED_SIZE             N(1779),INFO_TYPE,_T("INFO    "),_T("         Kernel shared data size:   %I64d MB")
#define  INFO_DB_START_DBROOT                         N(1780),INFO_TYPE,_T("INFO    "),_T("         DBROOT:        '%s'")
#define  INFO_DB_START_LIBPATH                        N(1780),INFO_TYPE,_T("INFO    "),_T("         %s: '%s'")
#define  INFO_DB_START_VERSION                        N(1781),INFO_TYPE,_T("INFO    "),_T("         Version:       '%s'")
#define  INFO_DB_START_FIBER                          N(1782),INFO_TYPE,_T("INFO    "),_T("         Fiber:         '%s'")
#define  INFO_DB_START_NUM_LOGICAL_PROCESSORS         N(1783),INFO_TYPE,_T("INFO    "),_T("         Processors:    %d ( logical: %d )")
#define  INFO_DB_FILLER3                              N(1784),INFO_TYPE,_T("INFO    "),_T("         ")
#define  INFO_DB_FILLER4                              N(1785),INFO_TYPE,_T("INFO    "),_T("         ")
#define  INFO_DB_FILLER5                              N(1786),INFO_TYPE,_T("INFO    "),_T("         ")
#define  INFO_DB_FILLER6                              N(1787),INFO_TYPE,_T("INFO    "),_T("         ")
#define  INFO_DB_FILLER7                              N(1788),INFO_TYPE,_T("INFO    "),_T("         ")
#define  INFO_DB_FILLER8                              N(1789),INFO_TYPE,_T("INFO    "),_T("         ")
#define  INFO_DB_FILLER9                              N(1790),INFO_TYPE,_T("INFO    "),_T("         ")
#define  INFO_DB_FILLER10                             N(1791),INFO_TYPE,_T("INFO    "),_T("         ")
#define  INFO_DB_FILLER11                             N(1792),INFO_TYPE,_T("INFO    "),_T("         ")
#define  INFO_DB_FILLER12                             N(1793),INFO_TYPE,_T("INFO    "),_T("         ")
#define  INFO_DB_FILLER13                             N(1794),INFO_TYPE,_T("INFO    "),_T("         ")
#define  INFO_DB_FILLER14                             N(1795),INFO_TYPE,_T("INFO    "),_T("         ")
#define  INFO_COREHANDER_WAIT_FOR_TW                  N(1796),INFO_TYPE,_T("COREHAND"),_T("Waiting for tracewriter termination")
#define  INFO_COREHANDER_SON_FORCES_CORE              N(1797),INFO_TYPE,_T("COREHAND"),_T("Try to force core dump file")
#define  INFO_NI_SERV_STARTED                         N(1798),INFO_TYPE,_T("NISERVER"),_T("server started.")
#define  INFO_NI_SERV_STOPPED                         N(1799),INFO_TYPE,_T("NISERVER"),_T("server stopped.")
#define  INFO_NI_SERV_VERSION                         N(1800),INFO_TYPE,_T("NISERVER"),_T("%s")
#define  INFO_NI_WORKER_STARTED                       N(1801),INFO_TYPE,_T("NISERVER"),_T("worker started.")
#define  INFO_NI_WORKER_STOPPED                       N(1802),INFO_TYPE,_T("NISERVER"),_T("worker stopped.")
#define  INFO_NI_SERV_DROPPED                         N(1803),INFO_TYPE,_T("NISERVER"),_T("Connection dropped by kernel")
#define  INFO_TAPE_MEDIA_INFO                         N(1804),INFO_TYPE,_T("IO      "),_T("Tape '%s', media blocksize: %d")
#define  INFO_TAPE_BLOCKSIZE_CORRECTED                N(1805),INFO_TYPE,_T("IO      "),_T("Tape '%s', blocksize wanted: %d, max. tape blocksize: %d ")
#define  INFO_DB_START_MACHINE                        N(1806),INFO_TYPE,_T("INFO    "),_T("         Machine:       '%s'")
#define  INFO_XSER_ACCEPT_CONNECTION                  N(1807),INFO_TYPE,_T("XSERVER "),_T("Accepted connection, determining client node...")
#define  INFO_TRACEWRITER_EMERGENCY                   N(1808),INFO_TYPE,_T("DBSTATE "),_T("Flushing knltrace pages")
#define  INFO_TEST_WILDCARD                           N(1809),INFO_TYPE,_T("TEST    "),_T("%s")
#define  INFO_EVENT_FILE                              N(1810),INFO_TYPE,_T("EVENTING"),_T("Eventfile '%s' %d pages")
#define  INFO_EVENT_NO_FILE                           N(1811),INFO_TYPE,_T("EVENTING"),_T("Suppressing output to '%s' %d pages")
#define  INFO_EVENT_RINGBUFFER                        N(1812),INFO_TYPE,_T("EVENTING"),_T("Eventbuffer %d events %d tasks")
#define  INFO_EVENT_NO_RINGBUFFER                     N(1813),INFO_TYPE,_T("EVENTING"),_T("No Eventbuffer created (%d entries %d tasks)")
#define  INFO_EVENT_ALIVE_CYCLE                       N(1814),INFO_TYPE,_T("EVENTING"),_T("AliveEvent all %d seconds")
#define  INFO_EVENT_NO_ALIVE_CYCLE                    N(1815),INFO_TYPE,_T("EVENTING"),_T("No AliveEvent generation")
#define  INFO_OPEN_FD                                 N(1816),INFO_TYPE,_T("IO      "),_T("Open '%s' successfull, fd: %d")
#define  INFO_DB_STARTED_VERS_DBROOT                  N(1817),INFO_TYPE,_T("DBSTATE "),_T("SERVERDB '%s' started,\r\n   Version: \t'%s'\r\n   DBROOT: \t'%s'")
#define  INFO_GRP_PART_OFFLINE_QUORUM                 N(1818),INFO_TYPE,_T("CLUSTER "),_T("'%s' partial offline, because of a quorum resource")
#define  INFO_DYNAMIC_XP_KEY_CHANGED                  N(1819),INFO_TYPE,_T("PUTPARAM"),_T("'%s' changed from '%s' to '%s'")
#define  INFO_CALLING_AK_DUMP                         N(1820),INFO_TYPE,_T("EXCEPT  "),_T("calling ak dump for T%d")
#define  INFO_THREAD_START                            N(1821),INFO_TYPE,_T("TASKING "),_T("Thread %d starting")
#define  INFO_THREAD_JOIN                             N(1822),INFO_TYPE,_T("TASKING "),_T("Thread %d joining")
#define  INFO_XSER_PING_FROM                          N(1823),INFO_TYPE,_T("XSERVER "),_T("ping request, application version:%s")
#define  INFO_DISP_IGN_SIGNAL                         N(1824),INFO_TYPE,_T("TASKING "),_T("Dispatcher ignored signal")
#define  INFO_DISP_SHUTKILL_STATE1                    N(1825),INFO_TYPE,_T("TASKING "),_T("state %d before shutkill(1)")
#define  INFO_DISP_SHUTKILL_STATE2                    N(1826),INFO_TYPE,_T("TASKING "),_T("state %d before shutkill(2)")
#define  INFO_VCON_WAITING                            N(1827),INFO_TYPE,_T("COMMUNIC"),_T("wait for connection T%d")

#define  INFO_HEAP_MEMORY_ALLOCATED_AT                N(1829),INFO_TYPE,_T("MEM_HEAP"),_T("%d pages allocated at 0x%0"SIZL"x for %s")
#define  INFO_SHM_MEMORY_ALLOCATED_AT                 N(1830),INFO_TYPE,_T("MEM_SHM "),_T("%d pages allocated at 0x%0"SIZL"x for %s")
#define  INFO_TRACEIO_MAX_MESSAGE_FILES               N(1831),INFO_TYPE,_T("TRACE_IO"),_T("Configured _MAX_MESSAGE_FILES:%d")
#define  INFO_TRACEIO_DISABLED                        N(1832),INFO_TYPE,_T("TRACE_IO"),_T("Disabled: No TraceMessagefiles wanted")
#define  INFO_TRACEIO_DISABLED_NOMEM                  N(1833),INFO_TYPE,_T("TRACE_IO"),_T("Disabled: Out of memory")
#define  INFO_TRACEIO_ENABLED                         N(1834),INFO_TYPE,_T("TRACE_IO"),_T("Enabled: TraceMessagefiles usable")
#define  INFO_TRACEIO_LOCK_TERMINATING                N(1835),INFO_TYPE,_T("TRACE_IO"),_T("Lock of '%s' must fail, while in terminating mode")

#define  INFO_MEM_ALLOCATED                           N(1837),INFO_TYPE,_T("MEMORY  "),_T("%d Pages allocated for %s at 0x%p")
#define  INFO_TAPE_OPER_USER_CANCEL_REQ               N(1838),INFO_TYPE,_T("IO      "),_T("Tape operation on '%s' was canceled by the user")
#define  INFO_XSER_CONNECTED                          N(1839),INFO_TYPE,_T("XSERVER "),_T("'%s' connected, Reference: %d")
#define  INFO_XSER_DISCONNECT                         N(1840),INFO_TYPE,_T("XSERVER "),_T("'%s' disconnect, Reference: %d")
#define  INFO_DIAG_HIST_START                         N(1841),INFO_TYPE,_T("DIAGHIST"),_T("Backup of diagnostic files is in progress")
#define  INFO_DIAG_HIST_STOP                          N(1842),INFO_TYPE,_T("DIAGHIST"),_T("Backup of diagnostic files has finished")
#define  INFO_DIAG_HIST_OS_ERROR                      N(1843),INFO_TYPE,_T("DIAGHIST"),_T("%s '%s' OS error: [%s]")
#define  INFO_XSER_NEW_ONLY                           N(1844),INFO_TYPE,_T("XSERVER "),_T("Ignoring 6.10 connections! Selected new connections only mode.")
#define  INFO_KERNEL_EXIT_NORMAL                      N(1845),INFO_TYPE,_T("DBSTATE "),_T("Kernel exited normal")
#define  INFO_CAUGHT_STOP_SIGNAL                      N(1852),INFO_TYPE,_T("DBSTATE "),_T("Caught STOP signal")
#define  INFO_CAUGHT_ANY_SIGNAL                       N(1853),INFO_TYPE,_T("DBSTATE "),_T("Caught signal %d(%s)")
#if defined(OSF1)
#define  INFO_TIMEDEV_NOT_AVAILABLE                   N(1854),INFO_TYPE,_T("vclock  "),_T("/dev/timedev not available: %s")
#define  INFO_TIMESTAMP_MMAP_FAILED                   N(1855),INFO_TYPE,_T("vclock  "),_T("mmap: %s")
#define  INFO_TIMEDEV_AVAILABLE                       N(1856),INFO_TYPE,_T("vclock  "),_T("/dev/timedev available for quick time access")
#endif
#define  INFO_FORKED_CHILD                            N(1857),INFO_TYPE,_T("SERVER  "),_T("Forked child pid %ld")
#define  INFO_EXIT_CODE                               N(1858),INFO_TYPE,_T("SERVER  "),_T("Exiting pid %ld exit code %d")
#define  INFO_MAX_STACK_USE                           N(1859),INFO_TYPE,_T("TASKING "),_T("Task T%d [%s] used %ld bytes on stack")
#define  INFO_RTE_PAGE_ALLOCATOR_MEM_INFO             N(1860),INFO_TYPE,_T("MEMORY  "),_T("I/O buffer cache: %d Pages allocated")
#define  INFO_XSER_LISTEN_ON_NI_HANDLE                N(1861),INFO_TYPE,_T("XSERVER "),_T("Listening on socket. NI-Handle: %d")

/*
 --- tracing outputs!
*/
#define  INFO_CL_COMM_CONNECT_REQ                     N(1862),INFO_TYPE,_T("TRACE001"),_T("[%08x] Connect Request      -> Tid:%d, Node:'%s', ServerDB:'%s', CRef: %d, SType:%d, Prot:%d" )
#define  INFO_CL_COMM_CONNECTED                       N(1862),INFO_TYPE,_T("TRACE001"),_T("[%08x] Connected            -> SRef:%d, MaxCmdDataLen:%d, MinReplySize:%d, PCnt:%d, P[0]:%ph, P[1]:%ph " )
#define  INFO_CL_COMM_CONNECT_ERR                     N(1862),INFO_TYPE,_T("TRACE001"),_T("[%08x] Connect error        -> Commstate:%d, ErrTxt:'%s' " )
#define  INFO_CL_COMM_REQUEST_ERR                     N(1862),INFO_TYPE,_T("TRACE001"),_T("[%08x] Request error        -> Commstate:%d, ErrTxt:'%s' " )
#define  INFO_CL_COMM_REQUEST                         N(1862),INFO_TYPE,_T("TRACE001"),_T("[%08x] Request              -> Tid:%d, CmdData:%p, DataLen:%d" )
#define  INFO_CL_COMM_REQUESTED                       N(1862),INFO_TYPE,_T("TRACE001"),_T("[%08x] Request send" )
#define  INFO_CL_COMM_REPLY_AVAIL_ERR                 N(1862),INFO_TYPE,_T("TRACE001"),_T("[%08x] Reply avail. error   -> Commstate:%d, ErrTxt:'%s' " )
#define  INFO_CL_COMM_REPLY_AVAIL                     N(1862),INFO_TYPE,_T("TRACE001"),_T("[%08x] Replay available?    -> Tid:%d" )
#define  INFO_CL_COMM_REPLY_AVAIL_RESULT              N(1862),INFO_TYPE,_T("TRACE001"),_T("[%08x] Replay %savailable" )
#define  INFO_CL_COMM_RECEIVE_ERR                     N(1862),INFO_TYPE,_T("TRACE001"),_T("[%08x] Receive error        -> Commstate:%d, ErrTxt:'%s' " )
#define  INFO_CL_COMM_RECEIVE                         N(1862),INFO_TYPE,_T("TRACE001"),_T("[%08x] Receiving data       -> Tid:%d" )
#define  INFO_CL_COMM_RECEIVED                        N(1862),INFO_TYPE,_T("TRACE001"),_T("[%08x] Data received        -> Data:%ph, DataLen:%d" )
#define  INFO_CL_COMM_RELEASE_ERR                     N(1862),INFO_TYPE,_T("TRACE001"),_T("[%08x] Release error        -> Commstate:%d, ErrTxt:'%s' " )
#define  INFO_CL_COMM_RELEASING_CONN                  N(1862),INFO_TYPE,_T("TRACE001"),_T("[%08x] Releasing connection -> Tid:%d" )
#define  INFO_CL_COMM_CONN_RELEASED                   N(1862),INFO_TYPE,_T("TRACE001"),_T("[%08x] Connection released" )
#define  INFO_CL_CANCEL_ERR                           N(1862),INFO_TYPE,_T("TRACE001"),_T("[%08x] Cancel error         -> Commstate:%d, ErrTxt:'%s' " )
#define  INFO_CL_CANCEL_REQUEST                       N(1862),INFO_TYPE,_T("TRACE001"),_T("[%08x] Cancel request       -> Tid:%d, CRef: %d, SRef:%d" )
#define  INFO_CL_CANCEL_REQUESTED                     N(1862),INFO_TYPE,_T("TRACE001"),_T("[%08x] Cancel requested" )
#define  INFO_CL_DUMP_REQUEST                         N(1862),INFO_TYPE,_T("TRACE001"),_T("[%08x] Dump request!!!!!!!  -> Tid:%d, CRef: %d, SRef:%d" )

/* PTS 1112617 */
#define  INFO_DCOM_CREATE_INSTANCE                    N(1863),INFO_TYPE,_T("DCOM    "),_T("Create instance IID:{%8.8X-%4.4X-%4.4X-%2.2X%2.2X-%2.2X%2.2X%2.2X%2.2X%2.2X%2.2X}, T%d")
#define  INFO_DCOM_RELEASE_INSTANCE                   N(1864),INFO_TYPE,_T("DCOM    "),_T("Release instance IID:{%8.8X-%4.4X-%4.4X-%2.2X%2.2X-%2.2X%2.2X%2.2X%2.2X%2.2X%2.2X}, T%d")
/* END PTS 1112617 */

#define  INFO_SHUTDOWN_WONT_WAIT                      N(1865),INFO_TYPE,_T("TASKING "),_T("Shutdown wont wait for Task T%d State %s")
#define  INFO_SHUTDOWN_WAITING                        N(1866),INFO_TYPE,_T("TASKING "),_T("Shutdown waiting for Task T%d State %s")
#define  INFO_SHUTDOWN_CANCEL_TASK                    N(1867),INFO_TYPE,_T("TASKING "),_T("Shutdown prepare canceling Task T%d State %s")
#define  INFO_SHUTDOWN_PREPARED                       N(1868),INFO_TYPE,_T("TASKING "),_T("Shutdown prepared after %d seconds")

#define  INFO_XSERVER_REDIRECT_OUTPUT                 N(1869),INFO_TYPE,_T("XSERVER "),_T("Redirect message output to '%s'")
#define  INFO_XSERVER_OPEN_SOCKET                     N(1870),INFO_TYPE,_T("XSERVER "),_T("Opened socket %d")
#define  INFO_XSERVER_INTERRUPTED                     N(1871),INFO_TYPE,_T("XSERVER "),_T("%s interrupted, continuing")
#define  INFO_XSERVER_ACCEPT_CONNECTION               N(1872),INFO_TYPE,_T("XSERVER "),_T("Accepted connection, socket: %d Id %s")
#define  INFO_XSERVER_ACCEPT_CLIENT_NODE              N(1873),INFO_TYPE,_T("XSERVER "),_T("%s | Client node '%s'")
#define  INFO_XSERVER_REQUEST                         N(1874),INFO_TYPE,_T("XSERVER "),_T("%s | %s%s request(%d) Ref %d Peer Ref %d")
#define  INFO_XSERVER_REQUEST_DETAILS                 N(1875),INFO_TYPE,_T("XSERVER "),_T("%s | Service %s(%d) DB %s%s%s Ref %d Peer Ref %d")
#define  INFO_XSERVER_REPLY                           N(1876),INFO_TYPE,_T("XSERVER "),_T("%s | %s reply(%d)")
#define  INFO_XSERVER_ENTER_DATA_TRANS                N(1877),INFO_TYPE,_T("XSERVER "),_T("%s | Entering data transmission")
#define  INFO_XSERVER_END_OF_DATA_TRANS               N(1878),INFO_TYPE,_T("XSERVER "),_T("%s | End of data transmission")
#define  INFO_XSERVER_NEW_DEBUG_LEVEL                 N(1879),INFO_TYPE,_T("XSERVER "),_T("New debug level %d")
/* PTS 1113170 */
#define  INFO_SYS_ENV_VARIABLE_NOT_FOUND              N(1880),INFO_TYPE,_T("SYSTEM  "),_T("The environment variable '%s' was not found in the environment")
#define  INFO_SYS_BUFFER_TO_SMALL                     N(1881),INFO_TYPE,_T("SYSTEM  "),_T("The buffer was to small to hold the value of the environment variable '%s'")
#define  INFO_SYS_ASSUME_32_BIT_PLATFORM              N(1882),INFO_TYPE,_T("SYSTEM  "),_T("It is assumed that we are running on a 32 bit platform")
/* END PTS 1113170 */
#define  INFO_CORE_DUMP_SUPPRESSED                    N(1883),INFO_TYPE,_T("DBSTATE "),_T("Core dump suppressed")
#define  INFO_CORE_DUMP_NOT_SUPPRESSED                N(1884),INFO_TYPE,_T("DBSTATE "),_T("Core dump not suppressed")
/* PTS 1114113 */
#define  INFO_INITSHM_MEM_ALLOCATED                   N(1885),INFO_TYPE,_T("MEMORY  "),_T("%d Pages allocated for %s")
/* PTS 1116387 */
#define  INFO_SYSTEM_CHOOSEN_TASK_STACK               N(1886),INFO_TYPE,_T("TASKING "),_T("Task stack at system choosen address")
#define  INFO_RESERVED_TASK_STACK                     N(1886),INFO_TYPE,_T("TASKING "),_T("Reserved address space for %ldKB beginning at 0x%lx")
#define  INFO_ALLOCATING_TASK_STACK_GAPS              N(1886),INFO_TYPE,_T("TASKING "),_T("Using reserved address area with gaps")
#define  INFO_MAX_TASK_STACK                          N(1886),INFO_TYPE,_T("TASKING "),_T("Maximum task stack size %ldKB")
#define  INFO_MAX_NON_USER_TASK_STACK                 N(1886),INFO_TYPE,_T("TASKING "),_T("Maximum non user task stack size %ldKB")
/* PTS 1115463 */
#define  INFO_ALLOCATING_TASK_STACK1                  N(1886),INFO_TYPE,_T("TASKING "),_T("Allocating task stack chunk for %d tasks")
#define  INFO_ALLOCATING_TASK_STACK2                  N(1886),INFO_TYPE,_T("TASKING "),_T("Maximum single aligned task stack size %5ldKB")
#define  INFO_ALLOCATING_TASK_STACK3                  N(1886),INFO_TYPE,_T("TASKING "),_T("Size of single task guard area %5ldKB")
#define  INFO_ALLOCATING_TASK_STACK4                  N(1886),INFO_TYPE,_T("TASKING "),_T("Task stack chunk area [ 0x%lx - 0x%lx ]")
#define  INFO_ALLOCATING_TASK_STACK5                  N(1886),INFO_TYPE,_T("TASKING "),_T("Physical memory used for task stacks %6ldKB")
#define  INFO_ALLOCATING_TASK_STACK6                  N(1886),INFO_TYPE,_T("TASKING "),_T("Physical memory used for guard areas %6ldKB")
#define  INFO_TASK_MOVE_REQUEST_TO                    N(1887),INFO_TYPE,_T("TASKING "),_T("Sending task move request for T%d (UKT:%d to UKT:%d)")
#define  INFO_TASK_MOVE_REQUEST_REC                   N(1889),INFO_TYPE,_T("TASKING "),_T("Task move request for T%d received")
/* PTS 1116365 */
#define  INFO_DIAG_HIST_FORCED                        N(1890),INFO_TYPE,_T("DIAGHIST"),_T("Backup of diagnostic files will be forced at next restart")
/* PTS 1116686 */
#define  INFO_MAX_CORE_SIZE                           N(1891),INFO_TYPE,_T("INFO    "),_T("maximum core size: %s")
#define  INFO_MAX_OPEN_FILES                          N(1892),INFO_TYPE,_T("INFO    "),_T("maximum number of open files: %s")
#define  INFO_MAX_VIRT_MEM_SIZE                       N(1893),INFO_TYPE,_T("INFO    "),_T("maximum virtual memory size: %s")
#define  INFO_MAX_HEAP_SIZE                           N(1894),INFO_TYPE,_T("INFO    "),_T("maximum heap size: %s")
#define  INFO_MAX_THREADS                             N(1895),INFO_TYPE,_T("INFO    "),_T("maximum number of threads: %s")
#define  INFO_MEM_NEEDED                              N(1896),INFO_TYPE,_T("INFO    "),_T("memory size needed: %s")
/* PTS 1116151 */
#define  INFO_USER_SPECIFIED_OFFICIAL_NODE            N(1897),INFO_TYPE,_T("INFO    "),_T("Using node name from OFFICIAL_NODE parameter: '%s'")
/* PTS */
#define  INFO_ENVIRONMENT_DUMP_START                  N(1898),INFO_TYPE,_T("ENVIRON "),_T("Environment dump start")
#define  INFO_ENVIRONMENT_VARIABLE                    N(1898),INFO_TYPE,_T("ENVIRON "),_T(" %s")
#define  INFO_ENVIRONMENT_DUMP_COMPLETED              N(1898),INFO_TYPE,_T("ENVIRON "),_T("Environment dump completed")
#define  INFO_ULIMITS_DUMP_START                      N(1898),INFO_TYPE,_T("ENVIRON "),_T("Resource limit dump start")
#define  INFO_STARTER_USER_GROUP_ID                   N(1898),INFO_TYPE,_T("ENVIRON "),_T("Started by user id %d group id %d")
#define  INFO_CURRENT_USER_ID                         N(1898),INFO_TYPE,_T("ENVIRON "),_T("Current user id %d effective id %d")
#define  INFO_CURRENT_GROUP_ID                        N(1898),INFO_TYPE,_T("ENVIRON "),_T("Current group id %d effective id %d")
#define  INFO_RESOURCE_LIMIT                          N(1898),INFO_TYPE,_T("ENVIRON "),_T(" %s %ld")
#define  INFO_RESOURCE_LIMIT_KB                       N(1898),INFO_TYPE,_T("ENVIRON "),_T(" %s %ld KBytes")
#define  INFO_RESOURCE_UNLIMITED                      N(1898),INFO_TYPE,_T("ENVIRON "),_T(" %s unlimited")
#define  INFO_ULIMITS_DUMP_COMPLETED                  N(1898),INFO_TYPE,_T("ENVIRON "),_T("Resource limit dump completed")
#define  INFO_XSERVER_WRONG_USER                      N(1899),INFO_TYPE,_T("XSERVER "),_T("Ask user '%s' to operate x_server for you!")
#define  INFO_XSERVER_NOT_RUNNING                     N(1900),INFO_TYPE,_T("XSERVER "),_T("XSERVER not running")
#define  INFO_XSERVER_ON_PORT_NOT_RUNNING             N(1901),INFO_TYPE,_T("XSERVER "),_T("XSERVER on port %s not running")
#define  INFO_XSERVER_STARTED_VERSION                 N(1902),INFO_TYPE,_T("XSERVER "),_T("started, '%s'")
#define  INFO_XSERVER_ON_PORT_STARTED_VERSION         N(1903),INFO_TYPE,_T("XSERVER "),_T("on port %s started, '%s'")
#define  INFO_XSERVER_SERVICE_PORT                    N(1904),INFO_TYPE,_T("XSERVER "),_T("Service port is %d")
#define  INFO_XSERVER_STOPPED                         N(1905),INFO_TYPE,_T("XSERVER "),_T("stopped")
#define  INFO_XSERVER_ON_PORT_STOPPED                 N(1906),INFO_TYPE,_T("XSERVER "),_T("on port %s stopped")
#define  INFO_XSERVER_LISTEN_ON_SOCKET                N(1907),INFO_TYPE,_T("XSERVER "),_T("Opened listen on socket %d")
#define  INFO_XSERVER_ACCEPTING                       N(1908),INFO_TYPE,_T("XSERVER "),_T("Accepting ...")
#define  INFO_XSERVER_ON_PORT_STOPPED_VERSION         N(1909),INFO_TYPE,_T("XSERVER "),_T("on port %s stopped, '%s'")
#define  INFO_XSERVER_STOPPED_VERSION                 N(1910),INFO_TYPE,_T("XSERVER "),_T("stopped, '%s'")
#define  INFO_XSERVER_SEGMENT_SIZES                   N(1911),INFO_TYPE,_T("XSERVER "),_T("Segment sizes, sd: %d, max: %d")
#define  INFO_XSERVER_READ_REQUEST_PACKET             N(1912),INFO_TYPE,_T("XSERVER "),_T("Request packet read ( %d bytes ), Ref:%d")
#define  INFO_XSERVER_REQUEST_RETURNED                N(1913),INFO_TYPE,_T("XSERVER "),_T("Local request returned, Ref:%d, CommState = %d")
#define  INFO_XSERVER_SERVDB_DATA_SEND                N(1914),INFO_TYPE,_T("XSERVER "),_T("%d bytes send, Ref:%d, PeerRef:%d")
#define  INFO_XSERVER_CONN_LOST                       N(1915),INFO_TYPE,_T("XSERVER "),_T("Connection lost")
#define  INFO_XSERVER_RUNNING_VERSION                 N(1916),INFO_TYPE,_T("XSERVER "),_T("Found other running x_server with version '%s'")
#define  INFO_XSERVER_WAIT_FOR_RUNNING_PROCESS        N(1917),INFO_TYPE,_T("XSERVER "),_T("waiting for other running x_server process %d")
#define  INFO_XSERVER_UPDATE_REQUEST                  N(1918),INFO_TYPE,_T("XSERVER "),_T("Got update request with process tag %s")
#define  INFO_XSERVER_ON_PORT_UNLISTEN_VERSION        N(1919),INFO_TYPE,_T("XSERVER "),_T("on port %s got update request. Version '%s' stopped listening")
#define  INFO_XSERVER_UNLISTEN_VERSION                N(1920),INFO_TYPE,_T("XSERVER "),_T("got update request. Version '%s' stopped listening")
#define  INFO_XSERVER_SUPPRESS_DNS_LOOKUP             N(1921),INFO_TYPE,_T("XSERVER "),_T("suppressing DNS lookup for connections")
#define  INFO_ARGUMENT_DUMP_START                     N(1922),INFO_TYPE,_T("ENVIRON "),_T("Command line arguments")
#define  INFO_ARGUMENT_DUMP_COMPLETED                 N(1923),INFO_TYPE,_T("ENVIRON "),_T("Command line argument dump completed")
#define  INFO_ARGUMENT_VALUE_DUMP                     N(1924),INFO_TYPE,_T("ENVIRON "),_T(" [%d] %s")
#define  INFO_XSERVER_NEWER_VERSION1                  N(1925),INFO_TYPE,_T("ENVIRON "),_T("Own version '%s' does not allow update.")
#define  INFO_XSERVER_NEWER_VERSION2                  N(1925),INFO_TYPE,_T("ENVIRON "),_T("If you really have to go back to this old version, stop running x_server first")
#define  INFO_XSERVER_UPDATE_VERSION                  N(1926),INFO_TYPE,_T("XSERVER "),_T("Version after update '%s'")
#define  INFO_USE_COROUTINE_FOR_TASK                  N(1927),INFO_TYPE,_T("TASKING "),_T("Using coroutines for tasks")
#define  INFO_USE_STACK_ON_STACK                      N(1927),INFO_TYPE,_T("TASKING "),_T("Using UKT stack for coroutine stack")
#define  INFO_USE_UCONTEXT                            N(1927),INFO_TYPE,_T("TASKING "),_T("Using ucontext_t for coroutine context")
#define  INFO_USE_OWN_CONTEXT                         N(1927),INFO_TYPE,_T("TASKING "),_T("Using own context for coroutine context")
#define  INFO_USE_THREADS_FOR_TASK                    N(1928),INFO_TYPE,_T("TASKING "),_T("Using threads for tasks")
#define  INFO_UNIX_TASK_STARTED                       N(1929),INFO_TYPE,_T("TASKING "),_T("Task T%d started")
#define  INFO_UNIX_TASKID_CHECK                       N(1929),INFO_TYPE,_T("TASKING "),_T("own task id T%d")
#define  INFO_VINITOK                                 N(1930),INFO_TYPE,_T("TASKING "),_T("Kernel initialization completed")
#define  INFO_XSERVER_ALREADY_STARTED                 N(1931),INFO_TYPE,_T("XSERVER "),_T("XSERVER already started")

#define  INFO_MAX_CPU_TIME                            N(1932),INFO_TYPE,_T("INFO    "),_T("maximum cpu time: %s")
#define  INFO_MAX_NUMBER_OF_PROCESSES                 N(1933),INFO_TYPE,_T("INFO    "),_T("maximum number of processes: %s")
#define  INFO_MAX_FILESIZE                            N(1934),INFO_TYPE,_T("INFO    "),_T("maximum file size: %s")
#define  INFO_STACK_SIZE                              N(1935),INFO_TYPE,_T("INFO    "),_T("maximum stack size: %s")
#define  INFO_LOCKABLE_MEMORY_SIZE                    N(1936),INFO_TYPE,_T("INFO    "),_T("lockable memory size: %s")
#define  INFO_RESIDENT_SET_SIZE                       N(1937),INFO_TYPE,_T("INFO    "),_T("resident set size size: %s")

#define  INFO_EVENTING_BAD_PID                        N(1938),INFO_TYPE,_T("EVENTING"),_T("Illegal Kernel Task Id:%d")
#define  INFO_EVENTING_TASK_MISSING                   N(1939),INFO_TYPE,_T("EVENTING"),_T("Task T%d missing")
#define  INFO_EVENTING_TASK_EXISTS                    N(1940),INFO_TYPE,_T("EVENTING"),_T("Task T%d already added")
#define  INFO_EVENTING_WRONG_TASK_TYPE                N(1941),INFO_TYPE,_T("EVENTING"),_T("Wrong task type: %d")
#define  INFO_REMOTEFUNC_NOT_SET                      N(1942),INFO_TYPE,_T("TASKING "),_T("Remote func for T%d (param %d) not set")

#endif  /* GEO007_1_H */
