/****************************************************************************/
/*!

  @file        SysView_IOThreadStatistics.cpp

  -------------------------------------------------------------------------

  @author      ElkeZ

  @ingroup     SystemViews
  @brief       This module implements the "IOThreadStatistics" view class.

  @see        

*/
/*-------------------------------------------------------------------------

  copyright:    (c) 2002-2004 SAP AG


    ========== licence begin  GPL
    Copyright (c) 2002-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




*****************************************************************************/



/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "ggg00.h"
#include "SystemViews/SysView_Defines.hpp"
#include "SystemViews/SysView_ITableObj.hpp"
#include "SystemViews/SysView_IOThreadStatistics.hpp"


/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/



/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/



/*===========================================================================*
 *  LOCAL CLASSES, STRUCTURES, TYPES, UNIONS ...                             *
 *===========================================================================*/



/*===========================================================================*
 *  STATIC/INLINE FUNCTIONS  (PROTOTYPES)                                     *
 *===========================================================================*/



/*===========================================================================*
 *  METHODS                                                                  *
 *===========================================================================*/

void SysView_IOThreadStatistics::Create()
{
    SAPDBTRACE_METHOD_DEBUG ("SysView_IOThreadStatistics::Create", SysView_Trace, 5);

	m_Table->AppendCol (ITOCT_FIXED ,SV_THREADID, 10);
	m_Table->AppendCol (ITOCT_CHAR ,SV_THREADNAME, 16);
	m_Table->AppendCol (ITOCT_FIXED ,SV_READCOUNT, 20);
	m_Table->AppendCol (ITOCT_FIXED ,SV_READPAGECOUNT, 20);
	m_Table->AppendCol (ITOCT_FIXED ,SV_READTIME, 20);
	m_Table->AppendCol (ITOCT_FIXED ,SV_WRITECOUNT, 20);
	m_Table->AppendCol (ITOCT_FIXED ,SV_WRITEPAGECOUNT, 20);
	m_Table->AppendCol (ITOCT_FIXED ,SV_WRITETIME, 20);
	m_Table->AppendCol (ITOCT_FIXED ,SV_PENDINGIOCOUNT, 5);
	m_Table->AppendCol (ITOCT_FIXED ,SV_MAXPENDINGIOCOUNT, 5);
	m_Table->AppendCol (ITOCT_CHAR ,SV_PATH, 256);
}

/*---------------------------------------------------------------------------*/

SAPDB_Int SysView_IOThreadStatistics::GetColCount()
{
    SAPDBTRACE_METHOD_DEBUG ("SysView_IOThreadStatistics::GetColCount", SysView_Trace, 5);

    return SV_CC_IOTHREADSTATISTICS;
}

/*---------------------------------------------------------------------------*/

SAPDB_Int SysView_IOThreadStatistics::EstimateRows()
{
    SAPDBTRACE_METHOD_DEBUG ("SysView_IOThreadStatistics::EstimateRows", SysView_Trace, 5);

    return SV_ER_IOTHREADSTATISTICS;
}

/*---------------------------------------------------------------------------*/

void SysView_IOThreadStatistics::Execute()
{
    SAPDBTRACE_METHOD_DEBUG ("SysView_IOThreadStatistics::Execute", SysView_Trace, 5);

    m_Context.ThrowError (e_not_implemented, 1);
}

/*===========================================================================*
 *  END OF CODE                                                              *
 *===========================================================================*/
