/*!
  @file           RTEThread_ConsoleCommandWorker.h
  @author         StefanP
  @special area   Kernel Runtime Environment
  @brief          Console Worker Threads (Header File)
  @see            

\if EMIT_LICENCE
    ========== licence begin  GPL
    Copyright (c) 2002-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

\endif
*/



#ifndef RTETHREAD_CONSOLECOMMANDWORKER_H
#define RTETHREAD_CONSOLECOMMANDWORKER_H



/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/
#include    "geo07.h"

/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/
#if defined (_WIN32)
#define CONSOLE_WORKER_PRIO                     THREAD_PRIORITY_NORMAL
#else
//erstmal Idle
#define CONSOLE_WORKER_PRIO                     ((tsp00_Int4)1)
#endif

#define NUM_CONSOLE_WORKER_THREADS  2


#define CONSOLE_WORKER_STATE_BASE_MASK          0x0000FFFF

#define CONSOLE_WORKER_STATE_UNKNOWN            0x00000000
#define CONSOLE_WORKER_STATE_START_FAILED       0x00000001
#define CONSOLE_WORKER_STATE_STARTED            0x00000002

#define CONSOLE_WORKER_STATE_MASK               0xFFFF0000

#define CONSOLE_WORKER_STATE_ACTIVE             0x00010000
#define CONSOLE_WORKER_STATE_READY              0x00020000
#define CONSOLE_WORKER_STATE_WAITING            0x00040000 


#define CONSOLE_WORKER_INDEX_UNKNOWN            0xFFFFFFFF
/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/

/*===========================================================================*
 *  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
 *===========================================================================*/
typedef struct 
{
    teo07_Thread            thread;
    SAPDB_UInt4             state;
    SAPDB_UInt4             index;
} ConsoleWorkerInfo;


/*===========================================================================*
 *  PROTOTYPES                                                               *
 *===========================================================================*/

/*!
   @description    Starts a worker thread


                  The worker threads listen to the command queue and process
                  the requests from XCons
   @param          threadInfo [in] - Reference to the info structure of a worker thread
   @param          threadIndex [in] - Index of the thread to be started
   @return value   true:   Thread could be started
                false:  Start failed

 */

SAPDB_Bool StartConsoleWorkerThread (ConsoleWorkerInfo &            threadInfo,
                                     SAPDB_UInt4                    threadIndex);

#endif  /* RTETHREAD_CONSOLECOMMANDWORKER_H */
