/*

    ========== licence begin  GPL
    Copyright (c) 2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

*/
#ifndef RTE_TASK_I_SCHEDULING_HPP
#define RTE_TASK_I_SCHEDULING_HPP

#include "RunTime/Tasking/RTETask_TCB.hpp"
/*---------------------------------------------------------------------------*/

class RTETask_IScheduling
{
public:
    virtual void PutTaskToRavQueue(RTE_TCB TCB,RTE_UKT UKTCB,SAPDB_ULong reqType)=0;
    virtual void PutTaskToRexQueue(RTE_TCB TCB,RTE_UKT UKTCB,SAPDB_ULong reqType,SAPDB_Bool condition)=0;
    virtual void ActivateTaskInOtherUKT(RTE_TCB TCB,RTE_UKT UKTCB,RTE_TCB nextTCB)=0;
    virtual void Reschedule(RTE_UKT &UKTCB)=0;
    static RTETask_IScheduling& Instance();
protected:
    RTETask_IScheduling(){};
};

#endif // RTE_TASK_I_SCHEDULING_HPP
