/*!
  @file           PIn_SpecialParts.h
  @author         Bernd Vorsprach - bernd.vorsprach@sap.com
  @brief          Sub classes to represent common part types

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2003-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



\endif
*/

#ifndef PIn_SpecialParts_h
#define PIn_SpecialParts_h

/*
  -----------------------------------------------------------------------------
  includes
  -----------------------------------------------------------------------------
 */
#include "SAPDB/PacketInterface/PIn_Part.h"

/*!  @brief Base class for special parts */
class PIn_SpecialPart : public PIn_Part
{
  public:
     /*!  @brief constructor */
    PIn_SpecialPart (PIn_Part & oPart, tsp1_part_kind_Param partKind );
  private:
    /*! brief forbidden copy constructor */
    PIn_SpecialPart(PIn_SpecialPart & oPart){};

}; // end PIn_SpecialPart

/* ======================================================== */

/*!  @brief Error Part Class */
class PIn_ErrorTextPart : public PIn_SpecialPart
{
  public:
     /*!  @brief constructor */
    PIn_ErrorTextPart (PIn_Part  & oPart );

    /*! @brief destructor */
    ~PIn_ErrorTextPart ();

    /*! @brief retrieve errortext */
    const tsp00_Byte * ErrorText() {return this->GetReadData();}
    SAPDB_Int          ErrorLen () {return this->Length();     }

}; // end PIn_ErrorTextPart

/* ======================================================== */

/*!  @brief Message List Part Class */
class PIn_MessageListPart : public PIn_SpecialPart
{
  public:
     /*!  @brief constructor */
    PIn_MessageListPart (PIn_Part  & oPart );

    /*! @brief destructor */
    ~PIn_MessageListPart ();

    /*! @brief retrieve errortext */
    SAPDBErr_MessageList const & MessageList();

  private:
    SAPDBErr_MessageList oMessageList;

}; // end PIn_MessageListPart

/* ======================================================== */

/*!  @brief Session Info Part Class */
class PIn_SessionInfoPart : public PIn_SpecialPart
{
  public:
    /*!  @brief constructor */
    PIn_SessionInfoPart (PIn_Part  & oPart );

    /*! @brief destructor */
    ~PIn_SessionInfoPart ();

    /*! @brief read unicode flag */
    int IsUnicode();

}; // end PIn_SessionInfoPart

/* ======================================================== */

/*!  @brief Data Part Class */
class PIn_DataPart : public PIn_SpecialPart
{
  public:
    /*!  @brief unicode flag */
    typedef enum {
      ConvertUnknown,
      ConvertAlways,
      ConvertNever,
      ConvertSometimes
    } ConversionNeeded;

    /*!  @brief constructor */
    PIn_DataPart (PIn_Part  & oPart );

    /*! @brief destructor */
    ~PIn_DataPart ();

    /*! @brief retrieve value adress */
    const tsp00_Byte * GetValueAdress
      ( tsp1_param_info * pInfo );

    /*! @brief check for null */
    bool IsNull
      ( tsp1_param_info * pInfo );

    /*! @brief retrieve value as int */
    bool GetValueAsInt
      ( tsp1_param_info * pInfo,
        SAPDB_Int4      & nValue );

    /*! @brief retrieve value as char */
    bool GetValueAsChar
      ( tsp1_param_info *  pInfo,
        const char      *& pValue,
        tsp00_Int4       & nLength,
        ConversionNeeded & oConversion);
}; // end PIn_DataPart

#endif // PIn_SpecialParts_h
