/*

    ========== licence begin  GPL
    Copyright (c) 2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

*/
#ifndef __OMS_GUID_HPP
#define __OMS_GUID_HPP

/* define, if we implement integer GUIDs */
#ifndef LIVECACHE_LONGGUIDS
#define	LIVECACHE_INTGUIDS
#endif

#ifdef	LIVECACHE_INTGUIDS

typedef int			ClassID;
#define	ClassIDPtr	ClassID
#define	ClassIDRef	ClassID
#define	GUID_TEMP(lguid, guid)					\
  GUID lguid;									\
  if (guid == OMS_VAR_OBJ_GUID) {			\
  memcpy(&lguid, &OMS_VAR_OBJ_GUID_DEF,	\
  sizeof(lguid));						\
  } else {									\
  memset(&lguid, 0, sizeof(lguid));		\
  lguid.Data1 = guid;						\
  }
#define CLASSID_TEMP(classid, guid) ClassIDRef classid = guid.Data1; 

#define GUID_MASK_ARRAY ((1<<21) - 1)

#define omsMakeArrayGuid(guid, array) guid = (guid & GUID_MASK_ARRAY) | \
  (((array + 7) >> 3) << 21)
#define omsMaskGuid(guid) ((guid) & GUID_MASK_ARRAY)
#define omsIsCompatibleGuid(guid1, guid2) ((((guid1) ^ (guid2)) & GUID_MASK_ARRAY) == 0)

#else   // LIVECACHE_INTGUIDS

#define ClassID		GUID
#define	ClassIDPtr	GUID*
#define	ClassIDRef	GUID&
#define	GUID_TEMP(lguid, guid)	const GUID &lguid = guid
#define CLASSID_TEMP(classid, guid) const ClassIDRef classid = guid

#define omsIsCompatibleGuid(guid1, guid2) ((guid1) == (guid2))
#define omsMakeArrayGuid(guid, array)
#define omsMaskGuid(guid) (guid)

#endif  // !LIVECACHE_INTGUIDS

#endif  // __OMS_GUID_HPP