/*
    ========== licence begin  GPL
    Copyright (c) 2004-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

 */
#ifndef LOG_MESSAGES_HPP
#define LOG_MESSAGES_HPP

// Generated Header file Log_Messages.hpp.
// Generated by genmsg V2.2 DO NOT EDIT

#include "SAPDBCommon/ErrorsAndMessages/SAPDBErr_MessageList.hpp"

#define LOG_NO_INFOPAGE_UPD                               SAPDBErr_MessageList::Info,0,"no update of LogInfoPage: DeviceState = %s, LogIsEmpty = %s",2
#define LOG_NO_INFOPAGE_UPD_ID 0
#define LOG_IS_FULL                                       SAPDBErr_MessageList::Info,1,"Log is full.",0
#define LOG_IS_FULL_ID 1
#define LOG_SEQUENCE_NOT_FOUND                            SAPDBErr_MessageList::Info,2,"Expected ioseq %s, found %s-%s on off %s",4
#define LOG_SEQUENCE_NOT_FOUND_ID 2
#define LOG_SEQUENCE_NOT_IN_RANGE                         SAPDBErr_MessageList::Info,3,"Ioseq %s not on device. Greatest IOSeq is %s",2
#define LOG_SEQUENCE_NOT_IN_RANGE_ID 3
#define LOG_FORMATTING                                    SAPDBErr_MessageList::Info,4,"Formatting from offset %s to %s.",2
#define LOG_FORMATTING_ID 4
#define LOG_RESTART_INFO                                  SAPDBErr_MessageList::Info,5,"Restart from ioseq %s @ off %s to ioseq %s @ off %s",4
#define LOG_RESTART_INFO_ID 5
#define LOG_DEVICE_INFO_BASIC                             SAPDBErr_MessageList::Info,6,"%s queues, flushmode is '%s', devstate is '%s'",3
#define LOG_DEVICE_INFO_BASIC_ID 6
#define LOG_DEVICE_INFO_OLDEST_NOT_SAVED                  SAPDBErr_MessageList::Info,7,"Oldest not saved is ioseq %s @ off %s",2
#define LOG_DEVICE_INFO_OLDEST_NOT_SAVED_ID 7
#define LOG_DEVICE_INFO_FIRST_KNOWN                       SAPDBErr_MessageList::Info,8,"First known on LogVolume is ioseq %s @ off %s",2
#define LOG_DEVICE_INFO_FIRST_KNOWN_ID 8
#define LOG_DEVICE_INFO_UNCOMPLETE_CYCLE                  SAPDBErr_MessageList::Info,9,"LogVolume not completely written until now",0
#define LOG_DEVICE_INFO_UNCOMPLETE_CYCLE_ID 9
#define LOG_CHECK_RESULT                                  SAPDBErr_MessageList::Info,10,"Result after checking the log device: '%s'",1
#define LOG_CHECK_RESULT_ID 10
#define LOG_ADD_DEVSPACE_PENDING                          SAPDBErr_MessageList::Info,11,"LogVolume was added: adjust size from %s to %s",2
#define LOG_ADD_DEVSPACE_PENDING_ID 11
#define LOG_ENTRY_INFO                                    SAPDBErr_MessageList::Info,12,"%s#%s:TR%s(%s)[%s]@%s.%s'%s':%s:%s",10
#define LOG_ENTRY_INFO_ID 12
#define LOG_PAGE_REPAIRED                                 SAPDBErr_MessageList::Info,13,"partly written LogPage repaired off=%s, ioseq=%s",2
#define LOG_PAGE_REPAIRED_ID 13
#define LOG_SAVEPOINT_FOUND                               SAPDBErr_MessageList::Info,14,"savepoint-iosequence %s searched and found on log at offset %s",2
#define LOG_SAVEPOINT_FOUND_ID 14
#define LOG_ABORTED_CLEAR_LOG                             SAPDBErr_MessageList::Warning,15,"Log is cleared again (was aborted).",0
#define LOG_ABORTED_CLEAR_LOG_ID 15
#define LOG_SAVE_FOR_ABORTED_CLEAR_LOG                    SAPDBErr_MessageList::Warning,16,"Log is tried to be saved although clear has been aborted.",0
#define LOG_SAVE_FOR_ABORTED_CLEAR_LOG_ID 16
#define LOG_AUTOSAVE_ABORTED_HIST_LOST                    SAPDBErr_MessageList::Warning,17,"(AUTO)SAVE LOG has been aborted due to missing backup history",0
#define LOG_AUTOSAVE_ABORTED_HIST_LOST_ID 17
#define LOG_SAVE_DENIED_AUTOOVERWRITE                     SAPDBErr_MessageList::Warning,18,"(AUTO)SAVE LOG has been aborted due to log-auto-overwrite",0
#define LOG_SAVE_DENIED_AUTOOVERWRITE_ID 18
#define LOG_SAVE_DENIED_WRITING_OFF                       SAPDBErr_MessageList::Warning,19,"(AUTO)SAVE LOG has been aborted due to switched off logwriting",0
#define LOG_SAVE_DENIED_WRITING_OFF_ID 19
#define LOG_BACKUP_DISABLED                               SAPDBErr_MessageList::Warning,20,"Log backups are disabled",0
#define LOG_BACKUP_DISABLED_ID 20
#define LOG_PAGECHECK_FAILED                              SAPDBErr_MessageList::Warning,21,"LogPage at offset %s ioseq %s-%s should be repaired later on",3
#define LOG_PAGECHECK_FAILED_ID 21
#define LOG_LASTKNOWN_NOT_FOUND                           SAPDBErr_MessageList::Error,22,"LastKnown not found on log",0
#define LOG_LASTKNOWN_NOT_FOUND_ID 22
#define LOG_OLDEST_NOT_SAVED_NOT_FOUND                    SAPDBErr_MessageList::Error,23,"OldestNotSaved not found on log",0
#define LOG_OLDEST_NOT_SAVED_NOT_FOUND_ID 23
#define LOG_SAVEPOINT_NOT_FOUND                           SAPDBErr_MessageList::Error,24,"Savepoint not found on log",0
#define LOG_SAVEPOINT_NOT_FOUND_ID 24
#define LOG_SAVEPOINT_IOSEQ_NOT_FOUND                     SAPDBErr_MessageList::Error,25,"Savepoint-iosequence %s searched but not found on log",1
#define LOG_SAVEPOINT_IOSEQ_NOT_FOUND_ID 25
#define LOG_INCONSISTENT_SEQUENCE                         SAPDBErr_MessageList::Error,26,"iosequences on log volume are inconsistent.",0
#define LOG_INCONSISTENT_SEQUENCE_ID 26
#define LOG_CYCLE_NOT_FOUND                               SAPDBErr_MessageList::Error,27,"no cycle found on log",0
#define LOG_CYCLE_NOT_FOUND_ID 27
#define LOG_SAVEPOINT_SEQ_NOT_FOUND                       SAPDBErr_MessageList::Error,28,"Savepoint iosequence not found on log",0
#define LOG_SAVEPOINT_SEQ_NOT_FOUND_ID 28
#define LOG_DBIDENT_MISMATCH                              SAPDBErr_MessageList::Error,29,"DBIdentifier of DataVolume (%s) and LogVolume (%s) does not match",2
#define LOG_DBIDENT_MISMATCH_ID 29
#define LOG_HISTORY_LOST_NO_LOGSAVE_ALLOWED               SAPDBErr_MessageList::Error,30,"Backup of Log not allowed. Devicestate is %s.",1
#define LOG_HISTORY_LOST_NO_LOGSAVE_ALLOWED_ID 30
#define LOG_FREE_FAILED_PROT                              SAPDBErr_MessageList::Error,31,"Free LogPages failed: No save to pipe happened before",0
#define LOG_FREE_FAILED_PROT_ID 31
#define LOG_FREE_FAILED_IOSEQ                             SAPDBErr_MessageList::Error,32,"Free LogPages failed: Free IOSeqRange %s...%s but OldstNotSaved=%s",3
#define LOG_FREE_FAILED_IOSEQ_ID 32
#define LOG_FREEPIPE_FAILED_IOSEQ                         SAPDBErr_MessageList::Error,33,"Free LogPages after save to pipe failed: Wrong IOSeq (%s!=%s or %s!=%s)",4
#define LOG_FREEPIPE_FAILED_IOSEQ_ID 33
#define LOG_INVALID_LASTWRITABLE                          SAPDBErr_MessageList::Error,34,"HotStandby: SetLastWritable: Offset not on LogVolume %s",1
#define LOG_INVALID_LASTWRITABLE_ID 34
#define LOG_NOT_ENOUGH_PAGEFRAMES                         SAPDBErr_MessageList::Error,35,"Allocation of pageframe failed",0
#define LOG_NOT_ENOUGH_PAGEFRAMES_ID 35
#define LOG_REPAIR_PAGE_FAILED                            SAPDBErr_MessageList::Error,36,"repair logpage failed at %s (prevIOSeq %s, nextIOSeq %s)",3
#define LOG_REPAIR_PAGE_FAILED_ID 36
#define LOG_END_OF_LOG_EXPECTED                           SAPDBErr_MessageList::Error,37,"repair logpage failed: END_OF_LOG expected from pageCheck",0
#define LOG_END_OF_LOG_EXPECTED_ID 37
#define LOG_CONSISTENT_EXPECTED                           SAPDBErr_MessageList::Error,38,"repair logpage failed: CONSISTENT expected from pageCheck",0
#define LOG_CONSISTENT_EXPECTED_ID 38
#define LOG_RESTORE_NEEDS_CLEARED_LOG                     SAPDBErr_MessageList::Error,39,"Logrecovery is not allowed, because state of log volume is 'HistoryLost' (log must be cleared)",0
#define LOG_RESTORE_NEEDS_CLEARED_LOG_ID 39
#define LOG_SAVE_DISTANCE_TOO_SMALL                       SAPDBErr_MessageList::Error,40,"Parameter LOG_SEGMENT_SIZE is greater then size of log area. %s < %s + %s(seg size)",3
#define LOG_SAVE_DISTANCE_TOO_SMALL_ID 40
#define LOG_VOLUME_TOO_SMALL                              SAPDBErr_MessageList::Error,41,"Parameter LOG_IO_QUEUE may be too large or size of log area too small. %s < %s + %s(reserved), reserved = #queues=%s * qsize=%s",5
#define LOG_VOLUME_TOO_SMALL_ID 41
#define LOG_NORMAL_END_FOUND                              SAPDBErr_MessageList::Info,42,"normal end of log found at off %s lastseq %s.",2
#define LOG_NORMAL_END_FOUND_ID 42
#define LOG_UNTIL_DATE_REACHED                            SAPDBErr_MessageList::Info,43,"until date reached at %s,%s (off = %s, lastseq = %s)",4
#define LOG_UNTIL_DATE_REACHED_ID 43
#define LOG_UNTIL_IOSEQ_REACHED                           SAPDBErr_MessageList::Info,44,"until IOSeq %s reached (Offset %s, date %s/%s)",4
#define LOG_UNTIL_IOSEQ_REACHED_ID 44
#define LOG_READ_QSEQ_INCONSISTENT                        SAPDBErr_MessageList::Error,45,"read: offset %s expected queue sequence %s found %s",3
#define LOG_READ_QSEQ_INCONSISTENT_ID 45
#define LOG_READ_IOSEQ_INCONSISTENT                       SAPDBErr_MessageList::Error,46,"read: offset %s expected iosequence %s found %s",3
#define LOG_READ_IOSEQ_INCONSISTENT_ID 46
#define LOG_READ_LAST_KNOWN_NOT_FOUND                     SAPDBErr_MessageList::Error,47,"read: offset %s expected last known iosequence %s found %s",3
#define LOG_READ_LAST_KNOWN_NOT_FOUND_ID 47
#define LOG_READ_UNEXPECTED_ERROR                         SAPDBErr_MessageList::Error,48,"LogIterator ISeqReader: expected last known iosequence %s found %s",2
#define LOG_READ_UNEXPECTED_ERROR_ID 48
#define LOG_STANDBY_TOO_SLOW                              SAPDBErr_MessageList::Error,49,"Standby reads log slower than master instance writes log or log is corrupted",0
#define LOG_STANDBY_TOO_SLOW_ID 49
#define LOG_SAVEITER_INV_SEG_SIZE                         SAPDBErr_MessageList::Error,50,"Log Segment Size is invalid (0)",0
#define LOG_SAVEITER_INV_SEG_SIZE_ID 50
#define LOG_WRITER_USER_SUSPENDED                         SAPDBErr_MessageList::Info,51,"LogWriter should be supended by user",0
#define LOG_WRITER_USER_SUSPENDED_ID 51
#define LOG_WRITER_USER_RESUMED                           SAPDBErr_MessageList::Info,52,"LogWriter resumed by user",0
#define LOG_WRITER_USER_RESUMED_ID 52
#define LOG_WRITER_SUSPENDED_BY_USER                      SAPDBErr_MessageList::Info,53,"LogWriter suspended by user with ioseq: %s",1
#define LOG_WRITER_SUSPENDED_BY_USER_ID 53
#define LOG_DEVICE_FULL                                   SAPDBErr_MessageList::Warning,54,"LOG FULL: task %s suspended",1
#define LOG_DEVICE_FULL_ID 54
#define LOG_QUEUE_SPACE_AVAILABLE                         SAPDBErr_MessageList::Error,55,"Can not reserve %s (%s) bytes. Maximum is %s bytes.",3
#define LOG_QUEUE_SPACE_AVAILABLE_ID 55
#define LOG_SAVEPOINT_REASON                              SAPDBErr_MessageList::Info,56,"Savepoint requested by T%s reason '%s' (%s).",3
#define LOG_SAVEPOINT_REASON_ID 56
#define LOG_OPENTRANS_FILE_INFO                           SAPDBErr_MessageList::Info,57,"%s svpid=%s",2
#define LOG_OPENTRANS_FILE_INFO_ID 57
#define LOG_BACKUP_AFTER_DATA_BACKUP_NEEDED_IN_ADMIN_MODE SAPDBErr_MessageList::Info,58,"TO DO IN ADMIN MODE: 1. BACKUP DATA 2. BACKUP LOG",0
#define LOG_BACKUP_AFTER_DATA_BACKUP_NEEDED_IN_ADMIN_MODE_ID 58
#define LOG_SAVEPOINT_NOT_ALLOWED                         SAPDBErr_MessageList::Warning,59,"Savepoint requested but not allowed by user.",0
#define LOG_SAVEPOINT_NOT_ALLOWED_ID 59
#define LOG_START_SAVEPOINT_FAILED                        SAPDBErr_MessageList::Error,60,"Savepoint: Could not be started. Servertaskhandling returned with BasisError %s.",1
#define LOG_START_SAVEPOINT_FAILED_ID 60
#define LOG_SAVEPOINT_WANTED_BUT_DENIED                   SAPDBErr_MessageList::Error,61,"Savepoint (%s) requested but denied because of '%s'.",2
#define LOG_SAVEPOINT_WANTED_BUT_DENIED_ID 61
#define LOG_DEL_UNDO_FILE                                 SAPDBErr_MessageList::Info,62,"%s: histfileroot=%s, trans=%s root=%s, last=%s",5
#define LOG_DEL_UNDO_FILE_ID 62
#define LOG_EXISTING_HISTORY_FILES                        SAPDBErr_MessageList::Info,63,"History: %s (%s) files existing",2
#define LOG_EXISTING_HISTORY_FILES_ID 63
#define LOG_BEGIN_REMOVE_COMPLETE_HISTORY                 SAPDBErr_MessageList::Info,64,"History: begin removing complete history",0
#define LOG_BEGIN_REMOVE_COMPLETE_HISTORY_ID 64
#define LOG_END_REMOVE_COMPLETE_HISTORY                   SAPDBErr_MessageList::Info,65,"History: end removing complete history",0
#define LOG_END_REMOVE_COMPLETE_HISTORY_ID 65
#define LOG_HISTORY_FILE_REGISTERED                       SAPDBErr_MessageList::Info,66,"History: all history files registered, GC is ready",0
#define LOG_HISTORY_FILE_REGISTERED_ID 66
#define LOG_WAIT_FOR_REMOVE_HISTORY                       SAPDBErr_MessageList::Info,67,"History: waiting for removal of complete history",0
#define LOG_WAIT_FOR_REMOVE_HISTORY_ID 67
#define LOG_WAIT_FOR_REMOVE_HISTORY_CANCELLED             SAPDBErr_MessageList::Warning,68,"History: removal of complete history is cancelled",0
#define LOG_WAIT_FOR_REMOVE_HISTORY_CANCELLED_ID 68
#define LOG_INFO_VERIFY                                   SAPDBErr_MessageList::Info,69,"Verify of %s with root %s was successfull",2
#define LOG_INFO_VERIFY_ID 69
#define LOG_INFO_VERIFY_OPENTRANS                         SAPDBErr_MessageList::Info,70,"Verify: transaction %s found as open",1
#define LOG_INFO_VERIFY_OPENTRANS_ID 70
#define LOG_LOCAL_REDO_BUFFER_SIZE_SET                    SAPDBErr_MessageList::Info,71,"Size of LocalRedoEntryBuffer/transactions: %s",1
#define LOG_LOCAL_REDO_BUFFER_SIZE_SET_ID 71
#define LOG_ERROR_VERIFY                                  SAPDBErr_MessageList::Error,72,"Verify of %s with root %s gots error %s",3
#define LOG_ERROR_VERIFY_ID 72
#define LOG_TRANS_ERROR_OCCURRED                          SAPDBErr_MessageList::Error,73,"Trans %s: TrError = %s",2
#define LOG_TRANS_ERROR_OCCURRED_ID 73
#define LOG_UNDOPAGE_VERIFY                               SAPDBErr_MessageList::Error,74,"PageNo: %s bottom: %s.",2
#define LOG_UNDOPAGE_VERIFY_ID 74
#define LOG_PAGE_VERIFY                                   SAPDBErr_MessageList::Error,75,"Verify of logpage failed: ioseq: %s",1
#define LOG_PAGE_VERIFY_ID 75
#define LOG_NEW_DBIDENT                                   SAPDBErr_MessageList::Info,76,"New DBIdentifier set (%s)",1
#define LOG_NEW_DBIDENT_ID 76
#define LOG_FREE                                          SAPDBErr_MessageList::Error,77,"FreeLog after backup of log failed: ioseq: %s->%s, off: %s->%s",4
#define LOG_FREE_ID 77
#define LOG_NON_CONTINUOUS_IOSEQ                          SAPDBErr_MessageList::Error,78,"IOSequences are not continuous: %s is not predecessor of %s",2
#define LOG_NON_CONTINUOUS_IOSEQ_ID 78

#endif /* LOG_MESSAGES_HPP */
