/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.rte.comm;

import com.sap.dbtech.rte.comm.PacketLayout;
import com.sap.dbtech.util.StructuredBytes;

class ConnectPacket
extends StructuredBytes {
    private int writePos = 40;

    public ConnectPacket(byte[] byArray, String string, PacketLayout packetLayout, int n, int n2) {
        super(byArray, 24);
        this.putInt1(0, 0);
        this.putInt1(1, 1);
        this.putInt2(296, 2);
        this.putInt1(n2, 4);
        this.putInt1(13, 5);
        this.putInt1(0, 6);
        this.putInt1(0, 7);
        this.putInt4(packetLayout.maxSegmentSize(), 8);
        this.putInt4(packetLayout.maxDataLength(), 12);
        this.putInt4(packetLayout.packetSize(), 16);
        this.putInt4(packetLayout.minReplySize(), 20);
        this.putString(string, 24, 8);
        this.putString("        ", 32, 8);
        this.addConnectInt(0, 73);
        this.addPort(n, 80);
        this.addConnectBool(false, 82);
        this.addFlagOmitReplyPart(114);
    }

    public void addConnectBool(boolean bl, int n) {
        int n2 = bl ? 1 : 0;
        this.putInt1(3, this.writePos);
        this.putInt1(n, this.writePos + 1);
        this.putInt1(n2, this.writePos + 2);
        this.writePos += 3;
    }

    public void addConnectInt(int n, int n2) {
        this.addConnectString(String.valueOf(n), n2);
    }

    public void addConnectString(String string, int n) {
        int n2 = string.length() + 3;
        this.putInt1(n2, this.writePos);
        this.putInt1(n, this.writePos + 1);
        this.putString(string, this.writePos + 2);
        this.putInt1(0, this.writePos + n2 - 1);
        this.writePos += n2;
    }

    public void addPort(int n, int n2) {
        this.putInt1(4, this.writePos);
        this.putInt1(n2, this.writePos + 1);
        this.putInt1(n / 256, this.writePos + 2);
        this.putInt1(n % 256, this.writePos + 3);
        this.writePos += 4;
    }

    public void addFlagOmitReplyPart(int n) {
        this.putInt1(3, this.writePos);
        this.putInt1(n, this.writePos + 1);
        this.putInt1(1, this.writePos + 2);
        this.writePos += 3;
    }

    public int length() {
        return this.writePos;
    }

    void close() {
        int n = this.length();
        if (n < 40) {
            this.writePos += 40 - n;
        }
        this.putInt2(this.writePos, 2);
    }
}

