/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.DBProcParameterInfo;
import com.sap.dbtech.jdbc.exceptions.InternalJDBCError;
import com.sap.dbtech.jdbc.packet.PartEnumeration;
import com.sap.dbtech.jdbc.packet.ReplyPacket;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.vsp001.FunctionCode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Vector;

public class Parseinfo {
    ConnectionSapDB connection;
    String sqlCmd;
    private byte[] parseid;
    private byte[] massParseid;
    DBTechTranslator[] paramInfos;
    DBProcParameterInfo[] procParamInfos;
    int inputCount;
    private boolean isMassCmd;
    boolean isSelect;
    boolean isDBProc;
    boolean hasLongs;
    boolean hasStreams;
    boolean cached;
    int functionCode;
    int sessionID;
    String[] columnNames;
    AbstractMap columnMap;
    DBTechTranslator[] columnInfos;
    boolean isClosed = false;
    boolean varDataInput = false;
    private static final int applicationCodeByte = 10;
    String updTableName;

    public Parseinfo(ConnectionSapDB connectionSapDB, String string, int n) throws SQLException {
        this.connection = connectionSapDB;
        this.sqlCmd = string;
        this.massParseid = null;
        this.paramInfos = null;
        this.inputCount = 0;
        this.isSelect = false;
        this.isDBProc = false;
        this.hasLongs = false;
        this.hasStreams = false;
        this.isMassCmd = false;
        this.functionCode = n;
        this.sessionID = -1;
        this.updTableName = null;
        this.cached = false;
        this.varDataInput = false;
        if (n == 4 || n == 216 || n == 248 || n == 27) {
            this.isSelect = true;
        }
        if (n == 248 || n == 34) {
            this.isDBProc = true;
        }
        this.columnNames = null;
        this.columnMap = null;
        if (n == 34) {
            this.describeProcedureCall();
        }
    }

    void describeProcedureCall() throws SQLException {
        if (this.connection.getKernelVersion() <= 70402) {
            this.procParamInfos = new DBProcParameterInfo[0];
            return;
        }
        char[] cArray = this.sqlCmd.trim().toCharArray();
        int n = 0;
        int n2 = cArray.length;
        if (cArray[n] == '{') {
            ++n;
        }
        if (n == n2) {
            return;
        }
        while (Character.isSpace(cArray[n])) {
            if (++n != n2) continue;
            return;
        }
        if (cArray[n] == 'C' || cArray[n] == 'c') {
            if (++n == n2) {
                return;
            }
        } else {
            return;
        }
        if (cArray[n] == 'A' || cArray[n] == 'a') {
            if (++n == n2) {
                return;
            }
        } else {
            return;
        }
        if (cArray[n] == 'L' || cArray[n] == 'l') {
            if (++n == n2) {
                return;
            }
        } else {
            return;
        }
        if (cArray[n] == 'L' || cArray[n] == 'l') {
            if (++n == n2) {
                return;
            }
        } else {
            return;
        }
        while (Character.isSpace(cArray[n])) {
            if (++n != n2) continue;
            return;
        }
        int n3 = n;
        int n4 = n;
        boolean bl = false;
        if (cArray[n] == '\"') {
            ++n3;
            ++n4;
            bl = true;
            if (++n == n2) {
                return;
            }
        }
        while (!(cArray[n] == '.' && !bl || cArray[n] == '(' && !bl || Character.isSpace(cArray[n]) && !bl || bl && cArray[n] == '\"')) {
            ++n4;
            if (++n != n2) continue;
            return;
        }
        String string = new String(cArray, n3, n4 - n3);
        String string2 = null;
        if (!bl) {
            string = string.toUpperCase();
        }
        if (cArray[n] == '\"') {
            ++n;
        }
        while (n < n2 && Character.isSpace(cArray[n]) && ++n != n2) {
        }
        if (n < n2 && cArray[n] == '.') {
            if (++n == n2) {
                return;
            }
            while (Character.isSpace(cArray[n])) {
                if (++n != n2) continue;
                return;
            }
            n3 = n;
            n4 = n;
            bl = false;
            if (cArray[n] == '\"') {
                ++n3;
                ++n4;
                bl = true;
                if (++n == n2) {
                    return;
                }
            }
            while (!(cArray[n] == '.' && !bl || cArray[n] == '(' && !bl || Character.isSpace(cArray[n]) && !bl || bl && cArray[n] == '\"')) {
                ++n4;
                if (++n != n2) continue;
                return;
            }
            string = new String(cArray, n3, n4 - n3);
            if (!bl) {
                string = string.toUpperCase();
            }
        }
        PreparedStatement preparedStatement = null;
        String string3 = "SELECT 1 FROM DUAL WHERE FALSE";
        if (string2 == null) {
            string3 = this.connection.getKernelVersion() > 70402 ? "SELECT PARAM_NO, DATATYPE, CODE, LEN, DEC, \"IN/OUT-TYPE\", OFFSET, ASCII_OFFSET, UNICODE_OFFSET FROM DBPROCPARAMINFO WHERE OWNER=USER AND DBPROCEDURE=? ORDER BY PARAM_NO,ASCII_OFFSET" : "SELECT PARAM_NO, DATATYPE, CODE, LEN, DEC, \"IN/OUT-TYPE\", OFFSET, OFFSET AS ASCII_OFFSET, OFFSET AS UNICODE_OFFSET FROM DBPROCPARAMINFO WHERE OWNER=USER AND DBPROCEDURE=? ORDER BY PARAM_NO,OFFSET";
            preparedStatement = this.connection.prepareStatement(string3);
            preparedStatement.setString(1, string);
        } else {
            string3 = this.connection.getKernelVersion() > 70402 ? "SELECT PARAM_NO, DATATYPE, CODE, LEN, DEC, \"IN/OUT-TYPE\", OFFSET, ASCII_OFFSET, UNICODE_OFFSET FROM DBPROCPARAMINFO WHERE OWNER=? AND DBPROCEDURE=? ORDER BY PARAM_NO,ASCII_OFFSET" : "SELECT PARAM_NO, DATATYPE, CODE, LEN, DEC, \"IN/OUT-TYPE\", OFFSET, OFFSET AS ASCII_OFFSET, OFFSET AS UNICODE_OFFSET FROM DBPROCPARAMINFO WHERE OWNER=? AND DBPROCEDURE=? ORDER BY PARAM_NO,OFFSET";
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string);
        }
        ResultSet resultSet = preparedStatement.executeQuery();
        if (!resultSet.next()) {
            this.procParamInfos = new DBProcParameterInfo[0];
            resultSet.close();
            resultSet = null;
            preparedStatement.close();
            preparedStatement = null;
            return;
        }
        Vector<DBProcParameterInfo> vector = new Vector<DBProcParameterInfo>();
        DBProcParameterInfo dBProcParameterInfo = null;
        int n5 = 0;
        do {
            int n6;
            String string4;
            int n7;
            if ((n7 = resultSet.getInt(1)) != n5) {
                string4 = resultSet.getString(2);
                if (string4.equals("ABAPTABLE") || string4.equals("STRUCTURE")) {
                    int n8 = resultSet.getInt(4);
                    n6 = resultSet.getInt(5);
                    dBProcParameterInfo = new DBProcParameterInfo(string4, n8, n6);
                    vector.addElement(dBProcParameterInfo);
                } else {
                    dBProcParameterInfo = null;
                    vector.addElement(dBProcParameterInfo);
                }
                n5 = n7;
                continue;
            }
            string4 = resultSet.getString(2);
            String string5 = resultSet.getString(3);
            n6 = resultSet.getInt(4);
            int n9 = resultSet.getInt(5);
            int n10 = resultSet.getInt(7);
            int n11 = resultSet.getInt(8);
            int n12 = resultSet.getInt(9);
            dBProcParameterInfo.addStructureElement(string4, string5, n6, n9, n10, n11, n12);
        } while (resultSet.next());
        resultSet.close();
        resultSet = null;
        preparedStatement.close();
        preparedStatement = null;
        this.procParamInfos = vector.toArray(new DBProcParameterInfo[0]);
    }

    public byte[] getMassParseid() {
        return this.massParseid;
    }

    public boolean setMassParseid(byte[] byArray) {
        this.massParseid = byArray;
        if (byArray == null) {
            return false;
        }
        for (int i = 0; i < FunctionCode.massCmdAppCodes.length; ++i) {
            if (byArray[10] != FunctionCode.massCmdAppCodes[i]) continue;
            this.isMassCmd = true;
            return true;
        }
        return false;
    }

    public boolean isMassCmd() {
        return this.isMassCmd;
    }

    public void setUpdateTableName(String string) {
        this.updTableName = string;
    }

    public boolean isValid() {
        return this.sessionID == this.connection.sessionID;
    }

    public DBTechTranslator[] getColumnInfos() {
        return this.columnInfos;
    }

    public void setParseIdAndSession(byte[] byArray, int n) {
        this.sessionID = n;
        this.parseid = byArray;
    }

    public synchronized void dropParseIDs() {
        if (this.parseid != null && this.connection != null) {
            this.connection.dropParseid(this.parseid);
            this.parseid = null;
        }
        if (this.massParseid != null && this.connection != null) {
            this.connection.dropParseid(this.massParseid);
            this.massParseid = null;
        }
    }

    protected void finalize() {
        this.cached = false;
        this.dropParseIDs();
    }

    public DBTechTranslator[] getParamInfo() {
        return this.paramInfos;
    }

    public void setSelect(boolean bl) {
        this.isSelect = bl;
    }

    public byte[] getParseId() {
        return this.parseid;
    }

    public boolean isAlreadyExecuted() {
        return this.parseid != null && this.parseid[10] == 1;
    }

    public void setShortInfosAndColumnNames(DBTechTranslator[] dBTechTranslatorArray, String[] stringArray) throws SQLException {
        this.inputCount = 0;
        this.hasLongs = false;
        this.hasStreams = false;
        this.columnNames = null;
        this.paramInfos = null;
        this.columnMap = null;
        this.columnInfos = null;
        this.columnNames = stringArray;
        if (dBTechTranslatorArray == null && stringArray == null) {
            this.columnInfos = new DBTechTranslator[0];
            this.paramInfos = this.columnInfos;
            return;
        }
        if (this.functionCode == 4) {
            if (stringArray == null || stringArray.length == 0) {
                this.paramInfos = dBTechTranslatorArray;
                for (int i = 0; i < this.paramInfos.length; ++i) {
                    DBTechTranslator dBTechTranslator = dBTechTranslatorArray[i];
                    if (dBTechTranslator.isInput()) {
                        dBTechTranslator.setColIndex(i);
                        ++this.inputCount;
                    }
                    this.hasLongs |= dBTechTranslator.isLongKind();
                    this.hasStreams |= dBTechTranslator.isStreamKind();
                }
            } else {
                int n = stringArray.length;
                this.columnInfos = new DBTechTranslator[n];
                this.paramInfos = new DBTechTranslator[dBTechTranslatorArray.length - n];
                int n2 = 0;
                int n3 = 0;
                for (int i = 0; i < dBTechTranslatorArray.length; ++i) {
                    DBTechTranslator dBTechTranslator = dBTechTranslatorArray[i];
                    if (dBTechTranslator.isInput()) {
                        if (n3 == this.paramInfos.length) {
                            throw new InternalJDBCError(MessageTranslator.translate("error.internal.unexpectedinput", Integer.toString(n3)));
                        }
                        dBTechTranslator.setColIndex(n3);
                        this.paramInfos[n3] = dBTechTranslator;
                        ++n3;
                        ++this.inputCount;
                    } else {
                        if (n2 == this.columnInfos.length) {
                            throw new InternalJDBCError(MessageTranslator.translate("error.internal.unexpectedoutput", Integer.toString(n2)));
                        }
                        this.columnInfos[n2] = dBTechTranslator;
                        dBTechTranslator.setColIndex(n2);
                        dBTechTranslator.setColName(stringArray[n2]);
                        ++n2;
                    }
                    this.hasLongs |= dBTechTranslatorArray[i].isLongKind();
                    this.hasStreams |= dBTechTranslatorArray[i].isStreamKind();
                }
            }
        } else {
            this.paramInfos = dBTechTranslatorArray;
            if (stringArray != null) {
                if (stringArray.length == this.paramInfos.length) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        DBTechTranslator dBTechTranslator = this.paramInfos[i];
                        dBTechTranslator.setColIndex(i);
                        dBTechTranslator.setColName(stringArray[i]);
                        if (this.procParamInfos != null && i < this.procParamInfos.length) {
                            dBTechTranslator.setProcParamInfo(this.procParamInfos[i]);
                        }
                        this.inputCount += dBTechTranslator.isInput() ? 1 : 0;
                        this.hasLongs |= dBTechTranslator.isLongKind();
                        this.hasStreams |= dBTechTranslator.isStreamKind();
                    }
                } else {
                    int n = 0;
                    for (int i = 0; i < this.paramInfos.length; ++i) {
                        DBTechTranslator dBTechTranslator = this.paramInfos[i];
                        dBTechTranslator.setColIndex(i);
                        if (this.procParamInfos != null && i < this.procParamInfos.length) {
                            dBTechTranslator.setProcParamInfo(this.procParamInfos[i]);
                        }
                        if (dBTechTranslator.isOutput()) {
                            dBTechTranslator.setColName(stringArray[n++]);
                        } else {
                            ++this.inputCount;
                        }
                        this.hasLongs |= dBTechTranslator.isLongKind();
                        this.hasStreams |= dBTechTranslator.isStreamKind();
                    }
                }
            } else {
                for (int i = 0; i < this.paramInfos.length; ++i) {
                    DBTechTranslator dBTechTranslator = this.paramInfos[i];
                    dBTechTranslator.setColIndex(i);
                    if (this.procParamInfos != null && i < this.procParamInfos.length) {
                        dBTechTranslator.setProcParamInfo(this.procParamInfos[i]);
                    }
                    this.inputCount += dBTechTranslator.isInput() ? 1 : 0;
                    this.hasLongs |= dBTechTranslator.isLongKind();
                    this.hasStreams |= dBTechTranslator.isStreamKind();
                }
            }
        }
    }

    public AbstractMap getColumnMap() throws SQLException {
        if (this.columnMap != null) {
            return this.columnMap;
        }
        if (this.columnNames == null) {
            throw new InternalJDBCError(MessageTranslator.translate("error.no.columnnames"));
        }
        this.columnMap = new HashMap(this.columnNames.length);
        for (int i = 0; i < this.paramInfos.length; ++i) {
            DBTechTranslator dBTechTranslator = this.paramInfos[i];
            String string = dBTechTranslator.getColumnName();
            if (string == null) continue;
            this.columnMap.put(string, dBTechTranslator);
        }
        return this.columnMap;
    }

    void doDescribeParseId() throws SQLException {
        String[] stringArray = null;
        DBTechTranslator[] dBTechTranslatorArray = null;
        RequestPacket requestPacket = this.connection.getRequestPacket(false);
        requestPacket.initDbsCommand(false, "Describe ", 1003);
        requestPacket.addParseidPart(this.parseid);
        ReplyPacket replyPacket = this.connection.execute(requestPacket, this, 1);
        PartEnumeration partEnumeration = replyPacket.partEnumeration();
        block5: while (partEnumeration.hasMoreElements()) {
            partEnumeration.nextElement();
            switch (partEnumeration.partKind()) {
                case 2: {
                    stringArray = replyPacket.parseColumnNames();
                    continue block5;
                }
                case 14: {
                    dBTechTranslatorArray = replyPacket.parseShortFields(this.connection.isSpaceoptionSet, false, null, false);
                    continue block5;
                }
                case 32: {
                    this.varDataInput = true;
                    dBTechTranslatorArray = replyPacket.parseShortFields(this.connection.isSpaceoptionSet, false, null, true);
                    continue block5;
                }
            }
        }
        this.setMetaData(dBTechTranslatorArray, stringArray);
    }

    void setMetaData(DBTechTranslator[] dBTechTranslatorArray, String[] stringArray) throws SQLException {
        int n = dBTechTranslatorArray.length;
        this.columnNames = stringArray;
        if (n == stringArray.length) {
            this.columnInfos = dBTechTranslatorArray;
            for (int i = 0; i < n; ++i) {
                DBTechTranslator dBTechTranslator = dBTechTranslatorArray[i];
                String string = stringArray[i];
                dBTechTranslator.setColName(string);
                dBTechTranslator.setColIndex(i);
            }
        } else {
            int n2 = 0;
            this.columnInfos = new DBTechTranslator[stringArray.length];
            for (int i = 0; i < n; ++i) {
                if (!dBTechTranslatorArray[i].isOutput()) continue;
                DBTechTranslator dBTechTranslator = this.columnInfos[n2] = dBTechTranslatorArray[i];
                String string = stringArray[n2];
                dBTechTranslator.setColName(string);
                dBTechTranslator.setColIndex(n2++);
            }
        }
    }
}

