/*



    ========== licence begin  GPL
    Copyright (c) 1998-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




*/

/*! 
  -----------------------------------------------------------------------------
 
  module: vin110.cpp
 
  -----------------------------------------------------------------------------
 
  responsible:  BerndV
 
  special area: SQL interface
 
  description:  implementation of SQL class

  version:      min 7.2.

  -----------------------------------------------------------------------------
 
                          Copyright (c) 1998-2004 SAP AG
 
  -----------------------------------------------------------------------------
*/
 

/* 
  -----------------------------------------------------------------------------
  includes
  -----------------------------------------------------------------------------
*/
#include "gin100.h"
#include "hin110.h"

/* 
  -----------------------------------------------------------------------------
  private definition, declarations and macros
  -----------------------------------------------------------------------------
*/

/* 
  -----------------------------------------------------------------------------
  implementation of class tin110_SQLRecord
  -----------------------------------------------------------------------------
*/

/* 
  -----------------------------------------------------------------------------
  public CONSTRUCTOR tin110_SQLRecord :: tin110_SQLRecord
  -----------------------------------------------------------------------------
*/
tin110_SQLRecord :: tin110_SQLRecord
    ( tin01_sql_session * pSQLSession )
{

  m_pField   = NULL;
  m_pString  = NULL;
  m_pSession = pSQLSession;

} // end tin110_SQLRecord :: tin110_SQLRecord
/* 
  -----------------------------------------------------------------------------
*/
tin110_SQLRecord :: tin110_SQLRecord
    ( const tin110_SQLRecord  & aRecord )
{

  m_pField   = NULL;
  m_pString  = NULL;
  m_pSession = aRecord.m_pSession;

} // end tin110_SQLRecord :: tin110_SQLRecord
/* 
  -----------------------------------------------------------------------------
*/
tin110_SQLRecord :: tin110_SQLRecord
    ( )
{

  m_pField   = NULL;
  m_pString  = NULL;
  m_pSession = NULL;

} // end tin110_SQLRecord :: tin110_SQLRecord

/* 
  -----------------------------------------------------------------------------
  public DESTRUCTOR tin110_SQLRecord :: ~tin110_SQLRecord
  -----------------------------------------------------------------------------
*/
tin110_SQLRecord :: ~tin110_SQLRecord
    (  )
{

  deleteField();
  deleteString();

} // end tin110_SQLRecord :: ~tin110_SQLRecord

/* 
  -----------------------------------------------------------------------------
  public OPERATOR tin110_SQLRecord :: operator =
  -----------------------------------------------------------------------------
*/
tin110_SQLRecord & tin110_SQLRecord :: operator = 
      ( const tin110_SQLRecord & aRecord )
{

  m_pSession = aRecord.m_pSession;

  return *this;
} // end tin110_SQLRecord :: operator =

/* 
  -----------------------------------------------------------------------------
  public FUNCTION tin110_SQLRecord :: fieldAsInt
  -----------------------------------------------------------------------------
*/
tsp00_Int4 tin110_SQLRecord :: fieldAsInt ( const tsp00_Int4 nField  ) 
{
  long              nValue = 0;
  tin01_c_hostvar   aValue;

  if (nField <= i29paramcount ( m_pSession ) && nField > 0) {

    aValue.len    = sizeof(nValue);
    aValue.c_type.becomes(cin01_c_long);
    aValue.addr   = &nValue;

    if (i29fieldvalue(m_pSession, nField, &aValue) != cin01_db_ok) {
      nValue = 0;
    } // end if
  } // end if

  return nValue;
} // end tin110_SQLRecord :: fieldAsInt

/* 
  -----------------------------------------------------------------------------
  public FUNCTION tin110_SQLRecord :: fieldAsInt
  -----------------------------------------------------------------------------
*/
tsp00_Int4 tin110_SQLRecord :: fieldAsInt ( const _TCHAR * szField  ) 
{

  return fieldAsInt(fieldNumber(szField));

} // end tin110_SQLRecord :: fieldAsInt

/* 
  -----------------------------------------------------------------------------
  public FUNCTION tin110_SQLRecord :: fieldAsUint
  -----------------------------------------------------------------------------
*/
tsp00_Uint4 tin110_SQLRecord :: fieldAsUint ( const tsp00_Int4 nField  ) 
{
  unsigned long     nValue = 0;
  tin01_c_hostvar   aValue;

  if (nField <= i29paramcount ( m_pSession ) && nField > 0) {

    aValue.len    = sizeof(nValue);
    aValue.c_type.becomes(cin01_c_ulong);
    aValue.addr   = &nValue;

    if (i29fieldvalue(m_pSession, nField, &aValue) != cin01_db_ok) {
      nValue = 0;
    } // end if
  } // end if

  return nValue;
} // end tin110_SQLRecord :: fieldAsUint

/* 
  -----------------------------------------------------------------------------
  public FUNCTION tin110_SQLRecord :: fieldAsUint
  -----------------------------------------------------------------------------
*/
tsp00_Uint4 tin110_SQLRecord :: fieldAsUint ( const _TCHAR * szField  ) 
{

  return fieldAsUint(fieldNumber(szField));

} // end tin110_SQLRecord :: fieldAsUint

/* 
  -----------------------------------------------------------------------------
  public FUNCTION tin110_SQLRecord :: fieldAsChar
  -----------------------------------------------------------------------------
*/
const _TCHAR * tin110_SQLRecord :: fieldAsChar 
      ( const tsp00_Int4 nField,
        const _TCHAR     cStringQuote)
{
  tin01_c_hostvar   aValue;
  tsp1_param_info * pParamInfo  = NULL;

  deleteString();
  
  if (nField <= i29paramcount ( m_pSession ) && nField > 0) {

    pParamInfo  = i29gparaminfo(m_pSession, nField - 1);

    newString(pParamInfo->sp1i_in_out_len + ((cStringQuote != 0) ? 2 : 0));
    
    if (m_pString != NULL) {

      aValue.len    = -1;
      aValue.c_type.becomes(cin01_c_charp);
      aValue.addr   = m_pString;

      if (i29fieldvalue(m_pSession, nField, &aValue, cStringQuote) != cin01_db_ok) {
        m_pString[0] = '\0';
      } // end if

    } // end if

  } // end if

  return m_pString;
} // end tin110_SQLRecord :: fieldAsChar

/* 
  -----------------------------------------------------------------------------
  public FUNCTION tin110_SQLRecord :: fieldAsChar
  -----------------------------------------------------------------------------
*/
const _TCHAR * tin110_SQLRecord :: fieldAsChar 
      ( const _TCHAR * szField,
        const _TCHAR   cStringQuote)
{

  return fieldAsChar(fieldNumber(szField));

} // end tin110_SQLRecord :: fieldAsChar

/* 
  -----------------------------------------------------------------------------
  public FUNCTION tin110_SQLRecord :: fieldType
  -----------------------------------------------------------------------------
*/
tsp00_DataType tin110_SQLRecord :: fieldType ( const tsp00_Int4 nField  ) 
{
  tsp1_param_info * pParamInfo  = NULL;
  tsp00_DataType    aType;

  if (nField <= i29paramcount ( m_pSession ) && nField > 0) {

    pParamInfo  = i29gparaminfo(m_pSession, nField - 1);

  } // end if

  if (pParamInfo == NULL) {
    aType.becomes(dunknown);
  } else {
    aType.becomes(pParamInfo->sp1i_data_type);
  } // end if

  return aType;

} // end tin110_SQLRecord :: fieldType

/* 
  -----------------------------------------------------------------------------
  public FUNCTION tin110_SQLRecord :: fieldType
  -----------------------------------------------------------------------------
*/
tsp00_DataType tin110_SQLRecord :: fieldType ( const _TCHAR * szField  ) 
{

  return fieldType(fieldNumber(szField));

} // end tin110_SQLRecord :: fieldType

/* 
  -----------------------------------------------------------------------------
  public FUNCTION tin110_SQLRecord :: isNull
  -----------------------------------------------------------------------------
*/
bool tin110_SQLRecord :: isNull ( const tsp00_Int4 nField  ) 
{
  tin01_c_hostvar   aValue;
  tsp1_param_info * pParamInfo  = NULL;
  _TCHAR          * pTemp       = NULL;
  
  if (nField <= i29paramcount ( m_pSession ) && nField > 0) {

    pParamInfo  = i29gparaminfo(m_pSession, nField - 1);

    pTemp = new _TCHAR[pParamInfo->sp1i_in_out_len];

    if (pTemp != NULL) {

      aValue.len    = -1;
      aValue.c_type.becomes(cin01_c_charp);
      aValue.addr   = pTemp;

      if (i29fieldvalue(m_pSession, nField, &aValue, 0) != cin01_db_ok) {
        aValue.is_null = false;
      } // end if

      delete pTemp;
    } // end if

  } // end if

  return (aValue.is_null != false);
} // end tin110_SQLRecord :: isNull

/* 
  -----------------------------------------------------------------------------
  public FUNCTION tin110_SQLRecord :: isNull
  -----------------------------------------------------------------------------
*/
bool tin110_SQLRecord :: isNull ( const _TCHAR * szField  ) 
{

  return isNull(fieldNumber(szField));

} // end tin110_SQLRecord :: isNull

/* 
  -----------------------------------------------------------------------------
  public FUNCTION tin110_SQLRecord :: exists
  -----------------------------------------------------------------------------
*/
bool tin110_SQLRecord :: exists ( const tsp00_Int4 nField  ) 
{

  return (nField <= i29paramcount ( m_pSession ) && nField > 0);

} // end tin110_SQLRecord :: exists

/* 
  -----------------------------------------------------------------------------
  public FUNCTION tin110_SQLRecord :: exists
  -----------------------------------------------------------------------------
*/
bool tin110_SQLRecord :: exists ( const _TCHAR * szField  ) 
{

  return exists(fieldNumber(szField));

} // end tin110_SQLRecord :: exists

/* 
  -----------------------------------------------------------------------------
  public FUNCTION tin110_SQLRecord :: fieldName
  -----------------------------------------------------------------------------
*/
const _TCHAR * tin110_SQLRecord :: fieldName ( const tsp00_Int4 nField  ) 
{

  
  deleteField();

  if (newField(50) != NULL) {
    i29fieldname(m_pSession, nField, m_pField);
  } // end if

  return m_pField;

/*  
  
  tin01_cstr  pCols;
  int         nParamCount;
  int         i = 1;
  int         j = 0;
  
  pCols       = i29colnames   ( m_pSession );
  nParamCount = i29paramcount ( m_pSession );

  deleteField();
  
  if (nParamCount >= nField) {
    while (i < nField) {
      j = j + pCols[j] + 1;
      ++i;
    } // end if
    if (newField(pCols[j] + 1) != NULL) {
      _tcsncpy(m_pField, &pCols[j+1], pCols[j]);
    } // end if
  } // end if

  return m_pField;
*/
} // end tin110_SQLRecord :: fieldName

/* 
  -----------------------------------------------------------------------------
  public FUNCTION tin110_SQLRecord :: fieldNumber
  -----------------------------------------------------------------------------
*/
tsp00_Int4 tin110_SQLRecord :: fieldNumber ( const _TCHAR * szField  ) 
{
  int         nParamCount;
  tsp00_Int4  nField = 0;
  int         i = 1;
  
  nParamCount = i29paramcount ( m_pSession );

  while (nField == 0 && i <= nParamCount) {
    nField = (strcmp(szField, fieldName(i)) == 0) ? i : 0;
    ++i;
  } // end if

  return nField;
} // end tin110_SQLRecord :: fieldNumber

/* 
  -----------------------------------------------------------------------------
  public FUNCTION tin110_SQLRecord :: fields
  -----------------------------------------------------------------------------
*/
tsp00_Int4 tin110_SQLRecord :: fields ( ) 
{
  
  return i29paramcount ( m_pSession );

} // end tin110_SQLRecord :: fields

/* 
  -----------------------------------------------------------------------------
  protected FUNCTION tin110_SQLRecord :: newField
  -----------------------------------------------------------------------------
*/
_TCHAR * tin110_SQLRecord :: newField ( const tsp00_Int4 nSize )
{

  deleteField();
  m_pField = new _TCHAR[nSize];
  if (m_pField != NULL) {
    memset(m_pField, 0, nSize);
  } // end if

  return m_pField;
} // end tin110_SQLRecord :: newField

/* 
  -----------------------------------------------------------------------------
  protected  FUNCTION tin110_SQLRecord :: deleteField
  -----------------------------------------------------------------------------
*/
_TCHAR * tin110_SQLRecord :: deleteField ( )
{

  if (m_pField != NULL) {
    delete m_pField;
    m_pField = NULL;
  } // end if

  return NULL;
} // end tin110_SQLRecord :: deleteField

/* 
  -----------------------------------------------------------------------------
  protected FUNCTION tin110_SQLRecord :: newString
  -----------------------------------------------------------------------------
*/
_TCHAR * tin110_SQLRecord :: newString ( const tsp00_Int4 nSize )
{

  deleteString();
  m_pString = new _TCHAR[nSize];
  if (m_pString != NULL) {
    memset(m_pString, 0, nSize);
  } // end if

  return m_pString;
} // end tin110_SQLRecord :: newString

/* 
  -----------------------------------------------------------------------------
  protected  FUNCTION tin110_SQLRecord :: deleteString
  -----------------------------------------------------------------------------
*/
_TCHAR * tin110_SQLRecord :: deleteString ( )
{

  if (m_pString != NULL) {
    delete m_pString;
    m_pString = NULL;
  } // end if

  return NULL;
} // end tin110_SQLRecord :: deleteString

/* 
  -----------------------------------------------------------------------------
  implementation of class tin110_SQLResultTable
  -----------------------------------------------------------------------------
*/

/* 
  -----------------------------------------------------------------------------
  public CONSTRUCTOR tin110_SQLResultTable :: tin110_SQLResultTable
  -----------------------------------------------------------------------------
*/
tin110_SQLResultTable :: tin110_SQLResultTable
    ( tin01_sql_session * pSQLSession,
      const _TCHAR      * szSelectStmt )
{
  FUNCTION_DBG_MIN100(_T("tin110_SQLResultTable :: tin110_SQLResultTable"));

  // init members
  m_EvtLast.eo200_ClearEventList();
  m_pSession = pSQLSession;
  m_nSqlRc   = cin01_db_ok;

  execute(szSelectStmt);

} // tin110_SQLResultTable :: tin110_SQLResultTable
/* 
  -----------------------------------------------------------------------------
*/
tin110_SQLResultTable :: tin110_SQLResultTable
    ( tin01_sql_session * pSQLSession)
{
  FUNCTION_DBG_MIN100(_T("tin110_SQLResultTable :: tin110_SQLResultTable"));

  // init members
  m_EvtLast.eo200_ClearEventList();
  m_pSession = pSQLSession;
  m_nSqlRc   = cin01_db_ok;

} // tin110_SQLResultTable :: tin110_SQLResultTable

/* 
  -----------------------------------------------------------------------------
  public function tin110_SQLResultTable :: lastEvent
  -----------------------------------------------------------------------------
*/
teo200_EventList & tin110_SQLResultTable :: lastEvent
    ( ) 
{
  return m_EvtLast;
} // end tin110_SQLResultTable :: lastEvent

/* 
  -----------------------------------------------------------------------------
  public function tin110_SQLResultTable :: sqlRc
  -----------------------------------------------------------------------------
*/
int tin110_SQLResultTable :: sqlRc
    ( ) 
{
  return m_nSqlRc;
} // end tin110_SQLResultTable :: sqlRc

/* 
  -----------------------------------------------------------------------------
  public function tin110_SQLResultTable :: execute
  -----------------------------------------------------------------------------
*/
void tin110_SQLResultTable :: execute
    ( const _TCHAR      * szSelectStmt ) 
{
  FUNCTION_DBG_MIN100(_T("tin110_SQLResultTable :: execute"));

  // init members
  m_EvtLast.eo200_ClearEventList();
  m_nSqlRc   = cin01_db_ok;

  if (!m_pSession->is_connected) {
    teo200_EventList lEvtList(FUNCTION_NAME_MIN100, ERR_SQLNOSESS_IN100);
    m_EvtLast = lEvtList;
  } else {

    if (_tcsnicmp(szSelectStmt, "SELECT", _tcslen("SELECT")) != 0) {
      teo200_EventList lEvtList(FUNCTION_NAME_MIN100, ERR_SQLNOSEL_IN100);
      m_EvtLast = lEvtList;
      m_nSqlRc  = cin01_db_invalid_keyword;
    } else {

      // execute select
      m_nSqlRc = i29record(m_pSession, szSelectStmt);

      // error handling
      if (m_nSqlRc != cin01_db_ok) {
        tsp00_C256c    szError;
        i29errmsg(m_pSession, szError);
        teo200_EventList lEvtList(FUNCTION_NAME_MIN100, ERR_SQLSQL_IN100, m_nSqlRc, szError.asCharp());
        m_EvtLast = lEvtList;
      } // end if

    } // end if
  } // end if

} // end tin110_SQLResultTable :: execute

/* 
  -----------------------------------------------------------------------------
  public function tin110_SQLResultTable :: record
  -----------------------------------------------------------------------------
*/
tin110_SQLRecord tin110_SQLResultTable :: record
    ( ) 
{
  tin110_SQLRecord aRecord (m_pSession);

  return aRecord;
} // end tin110_SQLResultTable :: record

/* 
  -----------------------------------------------------------------------------
  public function tin110_SQLResultTable :: nextRecord
  -----------------------------------------------------------------------------
*/
tin110_SQLRecord tin110_SQLResultTable :: nextRecord
    ( ) 
{
  FUNCTION_DBG_MIN100(_T("tin110_SQLResultTable :: nextRecord"));

  m_EvtLast.eo200_ClearEventList();
  m_nSqlRc   = cin01_db_ok;

  // execute select
  m_nSqlRc = i29nextrecord(m_pSession);

  // error handling
  if (m_nSqlRc != cin01_db_ok) {
    tsp00_C256c    szError;
    i29errmsg(m_pSession, szError);
    teo200_EventList lEvtList(FUNCTION_NAME_MIN100, ERR_SQLSQL_IN100, m_nSqlRc, szError.asCharp());
    m_EvtLast = lEvtList;
  } // end if

  tin110_SQLRecord aRecord (m_pSession);

  return aRecord;
} // end tin110_SQLResultTable :: record
