#include "creature.h"

creature **r[MAPWIDTH];
creature *firstcreature[N_OF_SPECIES];

void creature::preparecreature(creature* parent)
{
  weight=hitpoints+power+health+speed+
    200*countones(diet)+200*countones(terrain);
  life=hitpoints;
  load=VOID;
  creatureload=NULL;
  status=ALIVE;
  dir=NORTH;
  job=SLEEP;
  food=random(weight*5)+100;
  xcoor=-1;ycoor=-1;
  if (parent)
   if (parent->previous())
   {
    xcoor=parent->xcoor+dx[parent->dir];
    ycoor=parent->ycoor+dy[parent->dir];
    dir=parent->dir;
    food=(parent->food-weight)/2;
    parent->food=food;
   }
}

char* creature::name()
{
 return "Unknown";
}

int creature::lookslike()
	{
		return 1*(status==DEAD)+
					 2*(status==ALIVE&&load!=VOID&&job!=ATTACK)+
					 3*(job==ATTACK&&status==ALIVE)+
					 4*(dir==SOUTH||dir==WEST);
	}

void creature::drawinfo(BITMAP *cr_info, bool firsttime)
{
 if (firsttime) {
  textout(cr_info,font,"Food:",10,5,5);
  textout(cr_info,font,"Life:",10,35,5);
  textout(cr_info,font,"Weight:",10,65,5);
 }
 rectfill(cr_info,5,15,cr_info->w-1,23,0);
 textprintf(cr_info,font,5,15,5,"%i",(int) food);
 rectfill(cr_info,5,45,cr_info->w-1,53,0);
 textprintf(cr_info,font,5,45,5,"%i",life);
 rectfill(cr_info,5,75,cr_info->w-1,83,0);
 textprintf(cr_info,font,5,75,5,"%i",weight);

}

void creature::choosejob()
{
  job=SLEEP;
}

