(*
    ||M||  This file is part of HELM, an Hypertextual, Electronic        
    ||A||  Library of Mathematics, developed at the Computer Science     
    ||T||  Department, University of Bologna, Italy.                     
    ||I||                                                                
    ||T||  HELM is free software; you can redistribute it and/or         
    ||A||  modify it under the terms of the GNU General Public License   
    \   /  version 2 or (at your option) any later version.      
     \ /   This software is distributed as is, NO WARRANTY.     
      V_______________________________________________________________ *)

(* $Id: terms.mli 9822 2009-06-03 15:37:06Z tassi $ *)

let reference_of_oxuri = ref (fun _ -> assert false);;
let set_reference_of_oxuri f = reference_of_oxuri := f;;

module type NCicContext =
  sig
    val metasenv : NCic.metasenv
    val subst : NCic.substitution
    val context : NCic.context
  end

module NCicBlob(C : NCicContext) : Terms.Blob 
with type t = NCic.term and type input = NCic.term = struct

  type t = NCic.term

  let eq x y = NCicReduction.alpha_eq C.metasenv C.subst C.context x y;;

  let rec compare x y = 
    match x,y with
    | NCic.Rel i, NCic.Rel j -> j-i
    | NCic.Meta (i,_), NCic.Meta (j,_) -> i-j
    | NCic.Const r1, NCic.Const r2 -> NReference.compare r1 r2
    | NCic.Appl l1, NCic.Appl l2 -> FoUtils.lexicograph compare l1 l2
    | NCic.Rel _, ( NCic.Meta _ | NCic.Const _ | NCic.Appl _ ) -> ~-1
    | ( NCic.Meta _ | NCic.Const _ | NCic.Appl _ ), NCic.Rel _ -> 1
    | NCic.Const _, ( NCic.Meta _ | NCic.Appl _ ) -> ~-1
    | ( NCic.Meta _ | NCic.Appl _ ), NCic.Const _ -> 1
    | NCic.Appl _, NCic.Meta _ -> ~-1
    | NCic.Meta _, NCic.Appl _ -> 1
    | _ -> assert false
  ;;
  
  let compare x y = 
    if NCicReduction.alpha_eq C.metasenv C.subst C.context x y then 0 
    else compare x y
  ;;

  let pp t = 
    NCicPp.ppterm ~context:C.context ~metasenv:C.metasenv ~subst:C.subst t;;

  type input = NCic.term

  let rec embed = function
    | NCic.Meta (i,_) -> Terms.Var i, [i]
    | NCic.Appl l ->
	let rec aux acc l = function
	  |[] -> acc@l
	  |hd::tl -> if List.mem hd l then aux acc l tl else aux (hd::acc) l tl
	in
	let res,vars = List.fold_left
	  (fun (r,v) t -> let r1,v1 = embed t in (r1::r),aux [] v v1) ([],[]) l
	in (Terms.Node (List.rev res)), vars
    | t -> Terms.Leaf t, []
  ;;

  let embed t = fst (embed t) ;;

  let saturate t ty = 
    let sty, _, args = 
      NCicMetaSubst.saturate ~delta:max_int C.metasenv C.subst C.context
        ty 0
    in
    let proof = 
      if args = [] then Terms.Leaf t 
      else Terms.Node (Terms.Leaf t :: List.map embed args)
    in
    let sty = embed sty in
    proof, sty
  ;;

  let eqP = 
    let r = 
      !reference_of_oxuri 
       (UriManager.uri_of_string 
         "cic:/matita/logic/equality/eq.ind#xpointer(1/1)")
    in
    NCic.Const r
  ;;

 end
