/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */
/*
 * $Id: mixer.c,v 1.1.1.1 2003/01/22 13:26:24 rocko Exp $
 *
 * Copyright (c) 2000, 2001 by Shiman Associates Inc. and Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions: The above
 * copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the names of the authors or
 * copyright holders shall not be used in advertising or otherwise to
 * promote the sale, use or other dealings in this Software without
 * prior written authorization from the authors or copyright holders,
 * as applicable.
 *
 * All trademarks and registered trademarks mentioned herein are the
 * property of their respective owners. No right, title or interest in
 * or to any trademark, service mark, logo or trade name of the
 * authors or copyright holders or their licensors is granted.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mas/mas_dpi.h"
#include "buffer.h"
#include "mixer.h"

#define LIN_DB_SCALE_RATIO 6.363636363

/* 
 * LINEAR/DB VOLUME CONTROL CONVERSION 
 *
 * Input is an integer 0-100.  Output is an integer -600 to 0.  100
 * corresponds to 0.0dB attenuation, 0 corresponds to 60.0dB
 * attenuation (-60.0dB).
 *
 * The trick here is that you want any volume control to have log
 * taper, even if the control is drawn with a scale of 0-100 (or
 * 1-10). 
 * 
 * */

int16
linear_to_dbvol( int16 lvol )
{
    int16 dbvol = ( (lvol - 100)*LIN_DB_SCALE_RATIO );

    if (dbvol > 60) dbvol = 60; /* clamp it at +6dB */
    /* but don't clamp the attenuation */
    
    return dbvol;
}

int16
dbvol_to_linear( int16 dbvol )
{
    int16 lvol = ( (dbvol/LIN_DB_SCALE_RATIO) + 100 );

    if ( lvol > 110 ) lvol = 110; /* clamp at 110.  It's one louder */
    if ( lvol < 0 ) lvol = 0;

    return lvol;
}


/* sets up a new mixer channel.  returns -1 on error, or the ID of the
   new channel if successful. */
int32
add_mix_channel(struct mixer_channel* mch, char* name, int32 portnum, int mixer_channels )
{
    int i = 0;

    /* find the next empty channel */
    while ( i < mixer_channels )
    {
        if (*(mch[i].name) == 0)
            break;
        else i++;
    }
    
    if ( i == mixer_channels )
        return -1;
    
    mch[i].portnum = portnum;
    mch[i].recsrc = FALSE;
    strncpy(mch[i].name, name, min(strlen(name)+1, MAX_NAME_LEN+1));
    
    return i;
}
