/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

#ifndef _MAS_SOURCE_RIFF_H
#define _MAS_SOURCE_RIFF_H

#include "playlist.h"

#define RIFF_MAX_CHUNKSIZE 65536

#define RIFF_ID      "RIFF"

/*** Microsoft WAVE format, used in the RIFF chunk ***/
#define RIFF_WAVE_ID "WAVE"

typedef uint32 FourCC;  /* From the RIFF specs.  Four 8-bit characters
			    forming a four character tag string. */ 

/* Common to all RIFF chunks.  A four-character ID and a 32-bit length. */
struct riff_chunk_header
{
    FourCC  id;
    uint32  length;
};

extern int32  riff_cmp_fourcc(FourCC id, char* test_string);
extern int32  riff_read_chunk_header( FILE *fp, struct riff_chunk_header* header );
extern int32  riff_read_chunk(FILE *fp, struct riff_chunk_header* header, void** chunk);
extern int32  riff_start_decode( FILE* fp, struct riff_chunk_header** header_ptr );

#endif /* _MAS_SOURCE_RIFF_H */
