#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <gtk/gtk.h>

#include "../include/string.h"
#include "../include/disk.h"

#include "guiutils.h"
#include "cdialog.h"

#include "editor.h"
#include "viewer.h"
#include "viewerfio.h"

#include "manedit.h"
#include "maneditcb.h"
#include "maneditop.h"
#include "aboutdialog.h"
#include "config.h"


void MEditHelpManPageProceduresCB(GtkWidget *widget, gpointer data);
void MEditHelpManPageXMLRefCB(GtkWidget *widget, gpointer data);
void MEditHelpManualCB(GtkWidget *widget, gpointer data);

void MEditAboutDialogMapCB(GtkWidget *widget, gpointer data);
void MEditEditorNewCB(GtkWidget *widget, gpointer data);
void MEditViewerNewCB(GtkWidget *widget, gpointer data);



/* Creates a new viewer window or maps an existing initialized but
 * unmapped viewer on the core structure, uses variables core_ptr,
 * last_null_num, viewer_num, and viewer.
 */
#define DO_NEW_VIEWER	\
{ \
 last_null_num = -1; \
 for(viewer_num = 0; viewer_num < core_ptr->total_viewers; viewer_num++) \
 { \
  viewer = core_ptr->viewer[viewer_num]; \
  if(viewer == NULL) \
  { \
   last_null_num = viewer_num; \
   continue; \
  } \
  if(viewer->initialized && !viewer->map_state) \
   break; \
 } \
 if(viewer_num < core_ptr->total_viewers) \
 { \
  /* Found one that was initialized and unmapped. */ \
  viewer = core_ptr->viewer[viewer_num]; \
  ViewerMap(viewer); \
 } \
 else \
 { \
  /* Need to create a new viewer. */ \
  if(last_null_num > -1) \
  { \
   viewer_num = last_null_num; \
  } \
  else \
  { \
   viewer_num = core_ptr->total_viewers; \
   core_ptr->total_viewers = viewer_num + 1; \
   core_ptr->viewer = (viewer_struct **)realloc( \
    core_ptr->viewer, \
    core_ptr->total_viewers * sizeof(viewer_struct *) \
   ); \
   if(core_ptr->viewer == NULL) \
   { \
    core_ptr->total_viewers = 0; \
    return; \
   } \
   core_ptr->viewer[viewer_num] = NULL; \
  } \
  /* Allocate and create a new viewer. */ \
  viewer = ViewerNew((void *)core_ptr, -1); \
  core_ptr->viewer[viewer_num] = viewer; \
  if(viewer != NULL) \
   ViewerMap(viewer); \
  else \
   viewer_num = -1; \
 } \
}


/*
 *	Help man page creation procedures.
 */
void MEditHelpManPageProceduresCB(GtkWidget *widget, gpointer data)
{
        const char *cstrptr;
        int last_null_num, viewer_num;
        viewer_struct *viewer;
        char help_path[PATH_MAX + NAME_MAX];
        char help_file[PATH_MAX + NAME_MAX];
        struct stat stat_buf;
        medit_core_struct *core_ptr = (medit_core_struct *)data;
        if(core_ptr == NULL)
            return;
                
        /* Get template path. */
        cstrptr = (const char *)PrefParmGetValueP(
            core_ptr->pref, MEDIT_PREF_PARM_LOCATIONS_GLOBAL_DIR
        );
        if(cstrptr == NULL)
            cstrptr = MEDIT_GLOBAL_DIR;
        if(cstrptr == NULL)
        { 
            strncpy(help_path, "/", PATH_MAX + NAME_MAX);
            help_path[PATH_MAX + NAME_MAX - 1] = '\0'; 
        }
        else
        {
            cstrptr = (const char *)PrefixPaths(
                cstrptr, MEDIT_HELP_DIR
            );
            if(cstrptr == NULL)
                cstrptr = "/";
            strncpy(help_path, cstrptr, PATH_MAX + NAME_MAX);
            help_path[PATH_MAX + NAME_MAX - 1] = '\0';
        }

        /* Get help file path. */
        cstrptr = PrefixPaths(  
            help_path, MEDIT_MANPAGE_WRITING_FILE
        );
        if(cstrptr == NULL)
            cstrptr = MEDIT_MANPAGE_WRITING_FILE;
        strncpy(help_file, cstrptr, PATH_MAX + NAME_MAX);
        help_file[PATH_MAX + NAME_MAX - 1] = '\0';

        /* Check if help file exists. */
        if(stat(help_file, &stat_buf))
        {
            char *tmp_buf;
            int tmp_buf_len;

            /* Allocate message buffer. */
            tmp_buf_len = 256 + strlen(help_file);
            tmp_buf = (char *)malloc((tmp_buf_len + 1) * sizeof(char));
            if(tmp_buf != NULL)
                sprintf(tmp_buf,
"Cannot find Manual Page file\n`%s'",
                    help_file
                );
            CDialogGetResponse(
"Cannot find file!",
                tmp_buf,
"The specified Manual Page file could not be found\n\
please check the specified paths in the preferences\n\
(go to edit->preferences). Also make sure that the\n\
program is installed properly.",
                CDIALOG_ICON_ERROR,
                CDIALOG_BTNFLAG_OK | CDIALOG_BTNFLAG_HELP,
                CDIALOG_BTNFLAG_OK
            );

            /* Free message buffer. */
            free(tmp_buf);

            return;
        }


        /* Create a new viewer. */
        DO_NEW_VIEWER

        ViewerSetBusy(viewer);
        ViewerViewTextRecordScrollPositions(viewer);
        ViewerTextDelete(viewer, 0, -1);
        ViewerTextInsertPosition(viewer, 0);
        ViewerLoadFile(
            viewer, help_file, MEDIT_MANPAGE_WRITING_FILE
        );
        ViewerSetReady(viewer);

	return;
}

/*
 *	Help man page XML referances.
 */
void MEditHelpManPageXMLRefCB(GtkWidget *widget, gpointer data)
{
	const char *cstrptr;
        int last_null_num, viewer_num;
        viewer_struct *viewer;
	char help_path[PATH_MAX + NAME_MAX];
	char help_file[PATH_MAX + NAME_MAX];
	struct stat stat_buf;
        medit_core_struct *core_ptr = (medit_core_struct *)data;
        if(core_ptr == NULL)
            return;

	/* Get template path. */
	cstrptr = (const char *)PrefParmGetValueP(
	    core_ptr->pref, MEDIT_PREF_PARM_LOCATIONS_GLOBAL_DIR
	);
	if(cstrptr == NULL)
	    cstrptr = MEDIT_GLOBAL_DIR;
	if(cstrptr == NULL)
	{
	    strncpy(help_path, "/", PATH_MAX + NAME_MAX);
            help_path[PATH_MAX + NAME_MAX - 1] = '\0';
        }
	else
	{
	    cstrptr = (const char *)PrefixPaths(
		cstrptr, MEDIT_HELP_DIR
	    );
	    if(cstrptr == NULL)
		cstrptr = "/";
	    strncpy(help_path, cstrptr, PATH_MAX + NAME_MAX);
	    help_path[PATH_MAX + NAME_MAX - 1] = '\0';
	}

	/* Get help file path. */
	cstrptr = PrefixPaths(
	    help_path, MEDIT_MANPAGE_XML_REFERANCE_FILE
	);
	if(cstrptr == NULL)
	    cstrptr = MEDIT_MANPAGE_XML_REFERANCE_FILE;
	strncpy(help_file, cstrptr, PATH_MAX + NAME_MAX);
	help_file[PATH_MAX + NAME_MAX - 1] = '\0';

	/* Check if help file exists. */
        if(stat(help_file, &stat_buf))
	{
	    char *tmp_buf;
	    int tmp_buf_len;

	    /* Allocate message buffer. */
	    tmp_buf_len = 256 + strlen(help_file);
	    tmp_buf = (char *)malloc((tmp_buf_len + 1) * sizeof(char));
	    if(tmp_buf != NULL)
		sprintf(tmp_buf,
"Cannot find Manual Page file\n`%s'",
		    help_file
		);
	    CDialogGetResponse(
"Cannot find file!",
		tmp_buf,
"The specified Manual Page file could not be found\n\
please check the specified paths in the preferences\n\
(go to edit->preferences). Also make sure that the\n\
program is installed properly.",
		CDIALOG_ICON_ERROR,
		CDIALOG_BTNFLAG_OK | CDIALOG_BTNFLAG_HELP,
		CDIALOG_BTNFLAG_OK
	    );

	    /* Free message buffer. */
	    free(tmp_buf);

	    return;
	}


        /* Create a new viewer. */
        DO_NEW_VIEWER

	ViewerSetBusy(viewer);
	ViewerViewTextRecordScrollPositions(viewer);
	ViewerTextDelete(viewer, 0, -1);
	ViewerTextInsertPosition(viewer, 0);
	ViewerLoadFile(
	    viewer, help_file, MEDIT_MANPAGE_XML_REFERANCE_FILE
	);
	ViewerSetReady(viewer);

        return;
}

/*
 *	Help manual callback.
 */
void MEditHelpManualCB(GtkWidget *widget, gpointer data)
{
	int last_null_num, viewer_num;
	viewer_struct *viewer;
        medit_core_struct *core_ptr = (medit_core_struct *)data;
        if(core_ptr == NULL)
            return;

	/* Create a new viewer. */
	DO_NEW_VIEWER

        ViewerSetBusy(viewer);
	ViewerViewTextRecordScrollPositions(viewer);
        ViewerTextDelete(viewer, 0, -1);
        ViewerTextInsertPosition(viewer, 0);
	ViewerLoadFile(viewer, "manedit", "manedit");
	ViewerSetReady(viewer);

	return;
}




#undef DO_NEW_VIEWER

/*
 *	Maps the program's about dialog.
 */
void MEditAboutDialogMapCB(GtkWidget *widget, gpointer data)
{
	about_dialog_struct *about;
        medit_core_struct *core_ptr = (medit_core_struct *)data;
        if(core_ptr == NULL)
            return;

	/* Get pointer to about window structure and initialize as
	 * needed.
	 */
	about = core_ptr->about;
	if(about == NULL)
	{
	    about = AboutDialogNew(core_ptr);
	    core_ptr->about = about;
	}
	if(about == NULL)
	    return;

	AboutDialogMap(about);

	return;
}

/*
 *	Creates a new editor or maps an existing initialized and
 *	unmapped editor if possible.
 */
void MEditEditorNewCB(GtkWidget *widget, gpointer data)
{
	int i, last_null_num = -1;
	editor_struct *editor;
	medit_core_struct *core_ptr = (medit_core_struct *)data;
	if(core_ptr == NULL)
	    return;

	/* Search for existing initialized but unmapped editor on
	 * the core structure.
	 */
	for(i = 0; i < core_ptr->total_editors; i++)
	{
	    editor = core_ptr->editor[i];
	    if(editor == NULL)
	    {
		last_null_num = i;
		continue;
	    }

	    if(editor->initialized && !editor->map_state)
		break;
	}
	if(i < core_ptr->total_editors)
	{
	    /* Found one that was initialized and unmapped. */
	    EditorMap(core_ptr->editor[i]);
	}
	else
	{
	    /* Need to create a new editor. */
	    if(last_null_num > -1)
	    {
		i = last_null_num;
	    }
	    else
	    {
		i = core_ptr->total_editors;
		core_ptr->total_editors = i + 1;
		core_ptr->editor = (editor_struct **)realloc(
		    core_ptr->editor,
		    core_ptr->total_editors * sizeof(editor_struct *)
		);
		if(core_ptr->editor == NULL)
		{
		    core_ptr->total_editors = 0;
		    return;
		}
		core_ptr->editor[i] = NULL;
	    }

	    /* Allocate and create a new editor. */
	    editor = EditorNew((void *)core_ptr);
	    core_ptr->editor[i] = editor;

	    if(editor != NULL)
	    {
		EditorMap(editor);
	    }
	}

	return;
}


/*
 *	Creates a new viewer or maps an existing initialized and
 *	unmapped viewer if possible.
 */
void MEditViewerNewCB(GtkWidget *widget, gpointer data)
{
        int i, last_null_num = -1;
        viewer_struct *viewer;
        medit_core_struct *core_ptr = (medit_core_struct *)data;
        if(core_ptr == NULL)
            return;

        /* Search for existing initialized but unmapped viewer on
         * the core structure.
         */
        for(i = 0; i < core_ptr->total_viewers; i++)
        {
            viewer = core_ptr->viewer[i];
            if(viewer == NULL)
            {
                last_null_num = i;
                continue;
            }
                
            if(viewer->initialized && !viewer->map_state)
                break;
        }
        if(i < core_ptr->total_viewers)
        {
            /* Found one that was initialized and unmapped. */
            ViewerMap(core_ptr->viewer[i]);
        }
        else
	{
            /* Need to create a new viewer. */
            if(last_null_num > -1)
            {
                i = last_null_num;
            }
            else
            {
                i = core_ptr->total_viewers;
                core_ptr->total_viewers = i + 1;
                core_ptr->viewer = (viewer_struct **)realloc(
                    core_ptr->viewer,
                    core_ptr->total_viewers * sizeof(viewer_struct *)
                );
                if(core_ptr->viewer == NULL)
                {
                    core_ptr->total_viewers = 0;
                    return;
                }
                core_ptr->viewer[i] = NULL;
            }

            /* Allocate and create a new viewer. */
            viewer = ViewerNew((void *)core_ptr, -1);
            core_ptr->viewer[i] = viewer;

            if(viewer != NULL)
            {
                ViewerMap(viewer);
            }
        }

        return;
}
