/* *********************************************************************** */
/* A scanner definition for Mailfilter's config files                      */
/* Copyright (c) 2000 - 2002  Andreas Bauer <baueran@in.tum.de>            */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; either version 2 of the License, or       */
/* (at your option) any later version.                                     */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software             */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,   */
/* USA.                                                                    */
/* *********************************************************************** */

%s GET_PARM
%s GET_OP
%x INCL

%{
#include <fstream>
#include <iostream>
#include <string>
extern "C" {
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
}
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "rcparser.h"
#include "i18n.hh"

#define MAX_INCLUDE_DEPTH 1
YY_BUFFER_STATE include_stack[MAX_INCLUDE_DEPTH];
int include_stack_ptr = 0;

using namespace std;
%}

ALLOW           allow
DEL_DUPLICATES  del_duplicates
DENY_NOCASE     deny_nocase
DENY_CASE       deny_case
DENY            deny
DENIES          {DENY_NOCASE}|{DENY_CASE}|{DENY}
INCLUDE         include[ \t]*=
LOGFILE         logfile
MAXLENGTH       maxlength
MAXSIZE_ALLOW   maxsize_allow
MAXSIZE_DENY    maxsize_deny
NORMAL          normal
REG_CASE        reg_case
REG_NEWL        reg_newline
REG_TYPE        reg_type
REGS            {REG_CASE}|{REG_NEWL}|{REG_TYPE}
SERVER          server
USER            user
PASS            pass
PROTOCOL        protocol
PORT            port
HOSTS           {SERVER}|{USER}|{PASS}|{PROTOCOL}
SHOW_HEADERS    show_headers
TEST            test
TIMEOUT         timeout
VERBOSE         verbose
NKEYWD          {MAXLENGTH}|{MAXSIZE_ALLOW}|{MAXSIZE_DENY}|{TIMEOUT}|{VERBOSE}|{PORT}
CKEYWD          {ALLOW}|{DEL_DUPLICATES}|{DENIES}|{LOGFILE}|{NORMAL}|{REGS}|{HOSTS}|{SHOW_HEADERS}|{TEST}
REM		^[[:blank:]]*#.*
OP		(=|<>)
ID		([[:graph:]]+)|([[:graph:]]+.*[[:graph:]]+)
		int numLines = 0;
                int tempNumLines = 0;
		string subfile;

%%
{INCLUDE} {
     BEGIN(INCL);
     tempNumLines = numLines;
     numLines = 0;
}

<INCL>[ \t]*  /* eat the whitespace */
<INCL>[^ \t\n]+ {
     if (include_stack_ptr >= MAX_INCLUDE_DEPTH) {
        cerr << PACKAGE << _(": Error: Rcfiles nested too deeply.") << endl;
	exit(-1);
     }
     include_stack[include_stack_ptr++] = YY_CURRENT_BUFFER;
     
     try {
	subfile = yytext;
        yyin = new ifstream(yytext);
        if (!((ifstream*)yyin)->is_open()) {
           cerr << PACKAGE << _(": Error: Nested rcfile '") << yytext << _("' could not be opened.") << endl;
	   exit(-1);
        }
        yy_switch_to_buffer(yy_create_buffer(yyin, YY_BUF_SIZE));
     }
     catch (...) {
	throw;
     }

     BEGIN(INITIAL);
}

<<EOF>> {
     if ( --include_stack_ptr < 0 ) {
        yyterminate();
     }
     else {
        yy_delete_buffer( YY_CURRENT_BUFFER );
        yy_switch_to_buffer(include_stack[include_stack_ptr]);
     }

     numLines = tempNumLines;
     subfile = "";
}

{REM} // Do nothing with remarks

{CKEYWD} {
     BEGIN(GET_OP);
     yylval.sval = strdup(yytext);
     return CKEYWD;
}

{NKEYWD} {
     BEGIN(GET_OP);
     yylval.sval = strdup(yytext);
     return NKEYWD;
}

<GET_OP>{OP} {
     BEGIN(GET_PARM);
     yylval.sval = strdup(yytext);
     return OP;
}

<GET_PARM>{ID} {
     yylval.sval = strdup(yytext);
     return ID;
}

"\n" {
     ++numLines;
     BEGIN(0);
}

[ \t] // Do nothing with tabs and spaces

. {
     if (subfile != "")
     	cerr << PACKAGE << _(": Error: Syntax error in line ") << (numLines + 1) << _(" of your rcfile '") << subfile << "'."  << endl;
     else
        cerr << PACKAGE << _(": Error: Syntax error in line ") << (numLines + 1) << _(" of your rcfile.")  << endl;

     cerr << PACKAGE << _(": The term '") << yytext << _("' could not be interpreted.") << endl;
     exit(-1);
}

%%
