// Connection.hh - source file for the mailfilter program
// Copyright (c) 2000 - 2002  Andreas Bauer <baueran@in.tum.de>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

#ifndef CONNECTION_HH
#define CONNECTION_HH

#ifndef MAX_BYTES
#define MAX_BYTES 512
#endif

#include <string>

using namespace std;

namespace conn {

  class Connection {
  protected:
    bool isHeaderEnd(const string&);
    virtual int connectHost(const string&, int, int) = 0; // Establish network connection to the e-mail server on certain port number
    virtual int disconnectHost(void) = 0;                 // Close network connection to the e-mail server
    virtual int sendHost(const string&) = 0;              // Send command to the e-mail server
    virtual string receiveHost(const bool) = 0;           // Receive (string) results from the e-mail server (after a command was issued)
                                                          // If argument is 'true', we expect a single-line response from the server, otherwise multi-line response is expected

  public:
    virtual ~Connection() = 0;
  };
  
  // Exceptions
  class IOException { };
  class ConnectionTimeOut { };

}

#endif
