/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file MonthDateAxisAttributes.cc
    \brief Implemtation of MonthDateAxis Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Mon Mar  5 17:12:46 2012
*/    

#include "MonthDateAxisAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


MonthDateAxisAttributes::MonthDateAxisAttributes():
	colour_(MagTranslator<string, Colour>().magics("axis_months_label_colour")),
	quality_(ParameterManager::getString("axis_months_label_quality")),
	height_(ParameterManager::getDouble("axis_months_label_height")),
	composition_(ParameterManager::getString("axis_months_label_composition")),
	format_(ParameterManager::getString("axis_months_label_format"))
{
} 



MonthDateAxisAttributes::~MonthDateAxisAttributes()
{
}

    
void MonthDateAxisAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	prefix[0] = "axis_months";
	prefix[1] = "axis";

	setAttribute(prefix, "axis_months_label_colour", colour_, params);
	setAttribute(prefix, "axis_months_label_quality", quality_, params);
	setAttribute(prefix, "axis_months_label_height", height_, params);
	setAttribute(prefix, "axis_months_label_composition", composition_, params);
	setAttribute(prefix, "axis_months_label_format", format_, params);
}

void MonthDateAxisAttributes::copy(const MonthDateAxisAttributes& other)
{
	setColour(other.colour_->clone());
	quality_ = other.quality_;
	height_ = other.height_;
	composition_ = other.composition_;
	format_ = other.format_;
} 


bool MonthDateAxisAttributes::accept(const string& node)
{	
	if ( magCompare(node, "month")  )
		return true;
	return false;
}

void MonthDateAxisAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "month") )
		set(node.attributes());
	else {
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void MonthDateAxisAttributes::print(ostream& out)  const
{
	out << "MonthDateAxisAttributes[";
	out << "colour = " << *colour_;
	out << ", quality = " << quality_;
	out << ", height = " << height_;
	out << ", composition = " << composition_;
	out << ", format = " << format_;
	out << "]" << "\n";
}


void MonthDateAxisAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
     out <<  "\"month\"";
	 out << ", \"axis_months_label_colour\":";
	 niceprint(out, *colour_);
	 out << ", \"axis_months_label_quality\":";
	 niceprint(out,quality_);
	 out << ", \"axis_months_label_height\":";
	 niceprint(out,height_);
	 out << ", \"axis_months_label_composition\":";
	 niceprint(out,composition_);
	 out << ", \"axis_months_label_format\":";
	 niceprint(out,format_);
}
static MagicsParameter<string> axis_months_label_colour("axis_months_label_colour", "automatic", "");
static MagicsParameter<string> axis_months_label_quality("axis_months_label_quality", "medium", "");
static MagicsParameter<double> axis_months_label_height("axis_months_label_height", 0.2, "");
static MagicsParameter<string> axis_months_label_composition("axis_months_label_composition", "three", "");
static MagicsParameter<string> axis_months_label_format("axis_months_label_format", "MM", "");
