/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file HiLoSave.h
    \brief Definition of the Template class HiLoSave.
    
    Magics Team - ECMWF 2004
    
    Started: Tue 22-Jun-2004
    
    Changes:
    
*/

#ifndef HiLoSave_H
#define HiLoSave_H

#include "HiLoSaveBase.h"
#include "HiLoSaveAttributes.h"
#include "MagException.h"

namespace magics {

template <class P>
class HiLoSave:  public HiLoSaveBase<P>, public HiLoSaveAttributes {

public:
	HiLoSave() : out_(*file_name_)
	{
	       if ( !out_) throw magics::NoWritePermissionException(*file_name_);
	       out_ << "#GEO" << "\n";
	       out_ << "#DATA" << "\n";
	       out_ << flush;
	}

	~HiLoSave() {}
    
	void operator()(const P& point)
	{
	   out_ << point.y() << " " << point.x() << " 0 0 0 " << point.value() << "\n";
	   out_ << flush; 
	}

	void set(const map<string, string>& map) { HiLoSaveAttributes::set(map); }
	void set(const XmlNode& node) { HiLoSaveAttributes::set(node); }
	bool accept(const string& node) { return HiLoSaveAttributes::accept(node); }

	HiLoSaveBase<P>* clone() const
	{
	   HiLoSave<P>* object = new HiLoSave<P>();
	   object->copy(*this);
	   return object;
	}

protected:
	//! Method to print string about this class on to a stream of type ostream
	void print(ostream&) const {}
	ofstream out_;

private:
	//! Copy constructor - No copy allowed
	HiLoSave(const HiLoSave<P>&);
	//! Overloaded << operator to copy - No copy allowed
	HiLoSave<P>& operator=(const HiLoSave<P>&);

// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const HiLoSave<P>& p)
		{ p.print(s); return s; }

};

template <class P>
class NoHiLoSave: public HiLoSaveBase<P> {

public:
	NoHiLoSave() {}
	~NoHiLoSave() {}
	void open(){}
	void operator()(const P&) {}
	HiLoSaveBase<P>* clone() const {
		HiLoSaveBase<P>* object = new NoHiLoSave<P>();
		return object;
	}

protected:
	//! Method to print string about this class on to a stream of type ostream
	void print(ostream&) const {} 
};

template <class P>
class MagTranslator<string, HiLoSave<P> > { 
public:
	HiLoSave<P>* operator()(const string& val )
	{
		return SimpleObjectMaker<HiLoSave<P> >::create(val);
	}     

	HiLoSave<P>* magics(const string& param)
	{
		HiLoSave<P>* object;
		ParameterManager::update(param, object);
		return object;
	}
};


} // namespace magics
#endif
