/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file FortranSceneNodeAttributes.h
    \brief Definition of FortranSceneNode Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Mon Mar  5 17:12:44 2012
*/
   

#ifndef FortranSceneNodeAttributes_H
#define FortranSceneNodeAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "PageID.h"
#include "Colour.h"

namespace magics {

class XmlNode;



class FortranSceneNodeAttributes 
{
public:
//  --  constructor
    FortranSceneNodeAttributes();
    
//  --  destructor
    virtual ~FortranSceneNodeAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const FortranSceneNodeAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  X-Coordinate of lower left hand corner of page.Default 
    \param x Setting page_x_position - default=0
*/
	void setX(double x) 
		{ x_ =  x; } 
	double getX() const 
		{ return x_; } 
        
/*!
    Magics Information:
    \brief  Y-Coordinate of lower left hand corner of page.Default 
    \param y Setting page_y_position - default=0
*/
	void setY(double y) 
		{ y_ =  y; } 
	double getY() const 
		{ return y_; } 
        
/*!
    Magics Information:
    \brief  Length of page in horizontal direction 
    \param width Setting page_x_length - default=29.7
*/
	void setWidth(double width) 
		{ width_ =  width; } 
	double getWidth() const 
		{ return width_; } 
        
/*!
    Magics Information:
    \brief  Length of page in vertical direction 
    \param height Setting page_y_length - default=21
*/
	void setHeight(double height) 
		{ height_ =  height; } 
	double getHeight() const 
		{ return height_; } 
        
/*!
    Magics Information:
    \brief  Plot frame around page (ON/OFF) 
    \param frame Setting page_frame - default=off
*/
	void setFrame(bool frame) 
		{ frame_ =  frame; } 
	bool getFrame() const 
		{ return frame_; } 
        
/*!
    Magics Information:
    \brief  Colour of page frame (Full choice of colours) 
    \param frame_colour Setting page_frame_colour - default=blue
*/
	void setFrame_colour(Colour* frame_colour) 
		{ auto_ptr<Colour> tmp(frame_colour); frame_colour_ = tmp; } 
	const Colour&  getFrame_colour() const 
		{ return *frame_colour_; }
/*!
    Magics Information:
    \brief  Style of page frame(SOLID/DASH/DOT/CHAIN_DASH/CHAIN_DOT) 
    \param frame_line_style Setting page_frame_line_style - default=solid
*/
	void setFrame_line_style(LineStyle frame_line_style) 
		{ frame_line_style_ =  frame_line_style; } 
	LineStyle getFrame_line_style() const 
		{ return frame_line_style_; } 
        
/*!
    Magics Information:
    \brief  Thickness of page frame 
    \param frame_thickness Setting page_frame_thickness - default=1
*/
	void setFrame_thickness(int frame_thickness) 
		{ frame_thickness_ =  frame_thickness; } 
	int getFrame_thickness() const 
		{ return frame_thickness_; } 
        
/*!
    Magics Information:
    \brief  Plot identification line and ECMWF logo (ON/OFF) 
    \param page_id Setting page_id_line - default=on
*/
	void setPage_id(NoPageID* page_id) 
		{ auto_ptr<NoPageID> tmp(page_id); page_id_ = tmp; } 
	const NoPageID&  getPage_id() const 
		{ return *page_id_; }
/*!
    Magics Information:
    \brief  Type of page layout (POSITIONAL/AUTOMATIC) 
    \param plot_layout Setting layout - default=automatic
*/
	void setPlot_layout(const string& plot_layout) 
		{ plot_layout_ =  plot_layout; } 
	const string& getPlot_layout() const 
		{ return plot_layout_; } 
        
/*!
    Magics Information:
    \brief  Position of first page plotted (BOTTOM/TOP) 
    \param plot_start Setting plot_start - default=bottom
*/
	void setPlot_start(const string& plot_start) 
		{ plot_start_ =  plot_start; } 
	const string& getPlot_start() const 
		{ return plot_start_; } 
        
/*!
    Magics Information:
    \brief  Direction of plotting (HORIZONTAL/VERTICAL) 
    \param plot_direction Setting plot_direction - default=vertical
*/
	void setPlot_direction(const string& plot_direction) 
		{ plot_direction_ =  plot_direction; } 
	const string& getPlot_direction() const 
		{ return plot_direction_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	double x_;
	double y_;
	double width_;
	double height_;
	bool frame_;
	auto_ptr<Colour> frame_colour_;
	LineStyle frame_line_style_;
	int frame_thickness_;
	auto_ptr<NoPageID> page_id_;
	string plot_layout_;
	string plot_start_;
	string plot_direction_;

private:
  
	friend ostream& operator<<(ostream& s,const FortranSceneNodeAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
