"""
Fires or anything the player can destroy to complete the level.

Copyright 2006  Peter Gebauer. Licensed as Public Domain.
(see LICENSE for more info)
"""

import math, random
from magicor.sprites import *
from magicor.sprites.lights import YellowLight, YellowSpark
from magicor.sprites.blocks import Ice

class Fire(PhysicsSprite):

    def __init__(self, x, y, level, blocksGroup, lightsGroup, players,
                 canFall = True):
        PhysicsSprite.__init__(
            self, level, x, y, 32, 32,
            {"default": (ImageFrame("sprites/fire-normal", 32, 32),
                         AnimationFrame(0, 1),
                         AnimationFrame(1, 1),
                         AnimationFrame(2, 1),
                         AnimationFrame(3, 1),
                         AnimationFrame(4, 1),
                         AnimationFrame(5, 1),
                         JumpFrame(1))},
            blocksGroup
            )
        self.players = players
        self.light = YellowLight(x - 32, y - 32)
        self.canFall = canFall
        lightsGroup.add(self.light)
        self.lightsGroup = lightsGroup

    def kill(self):
        PhysicsSprite.kill(self)
        self.light.kill()
        for i in xrange(16):
            angle = i * (360 / 16.0)
            dx = 8.0 * math.cos(math.radians(angle))
            dy = 8.0 * math.sin(math.radians(angle))
            self.lightsGroup.add(YellowSpark(self.x - 32, self.y - 32, dx, dy))

    def physics(self):
        for s in self.blocksGroup.sprites():
            if isinstance(s, Ice) and s.x == self.x and s.y == self.y:
                s.kill()
                self.resources.playSound("samples/bonus")
                self.kill()
                break
        for player in self.players.sprites():
            if player.x == self.x and player.y == self.y and not player.dead:
                player.die()
        if self.canFall and not self.blockedBelow():
            self.y += 4
        self.light.x = self.x - 32 + random.randint(-4, 4)
        self.light.y = self.y - 32 + random.randint(-4, 4)
