/*
 * JToolbarTester.java - Test application for JToolBar that simulates outlook
 *                       toolbar behavior.
 *
 * Copyright (c) 2004-2011 Gregory Kotsaftis
 * gregkotsaftis@yahoo.com
 * http://zeus-jscl.sourceforge.net/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package gr.zeus.tests;

import gr.zeus.ui.OutLookToolBar;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.UIManager;

public class JToolBarTester extends JFrame {

    private OutLookToolBar m_outLookToolBar = null;
    private JButton m_dummy = null;


    public JToolBarTester()
    {
        initComponents();

        m_outLookToolBar = new OutLookToolBar( m_toolbar );
    }


    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents()
    {

        m_toolbar = new javax.swing.JToolBar();
        javax.swing.JButton button1 = new javax.swing.JButton();
        javax.swing.JButton button2 = new javax.swing.JButton();
        javax.swing.JButton button3 = new javax.swing.JButton();
        javax.swing.JScrollPane jScrollPane1 = new javax.swing.JScrollPane();
        m_textArea = new javax.swing.JTextArea();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        button1.setText("Button1");
        button1.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                button1ActionPerformed(evt);
            }
        });
        m_toolbar.add(button1);

        button2.setText("Button2");
        button2.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                button2ActionPerformed(evt);
            }
        });
        m_toolbar.add(button2);

        button3.setText("Button3");
        button3.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                button3ActionPerformed(evt);
            }
        });
        m_toolbar.add(button3);

        getContentPane().add(m_toolbar, java.awt.BorderLayout.NORTH);

        jScrollPane1.setViewportView(m_textArea);

        getContentPane().add(jScrollPane1, java.awt.BorderLayout.CENTER);

        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setBounds((screenSize.width-400)/2, (screenSize.height-300)/2, 400, 300);
    }// </editor-fold>//GEN-END:initComponents

    private void button3ActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_button3ActionPerformed
    {//GEN-HEADEREND:event_button3ActionPerformed

        m_textArea.append("Button3 pressed\n");

    }//GEN-LAST:event_button3ActionPerformed

    private void button2ActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_button2ActionPerformed
    {//GEN-HEADEREND:event_button2ActionPerformed

        m_textArea.append("Button2 pressed\n");

        if( m_dummy != null )
        {
            m_textArea.append("removing the dummy button\n");
            m_toolbar.remove( m_dummy );
            m_dummy = null;
        }

    }//GEN-LAST:event_button2ActionPerformed

    private void button1ActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_button1ActionPerformed
    {//GEN-HEADEREND:event_button1ActionPerformed

        m_textArea.append("Button1 pressed\n");

        if( m_dummy == null )
        {
            m_textArea.append("adding new dummy button to demonstrate how " +
                    "this automatically inherits outlook like functionality\n");
            m_dummy = new JButton("dummy");
            m_toolbar.add( m_dummy );
        }

    }//GEN-LAST:event_button1ActionPerformed


    /**
     * @param args the command line arguments
     */
    public static void main(String args[])
    {
        try
        {
            UIManager.setLookAndFeel(
                    UIManager.getSystemLookAndFeelClassName() );
        }
        catch( Exception e )
        {
            e.printStackTrace();
        }

        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new JToolBarTester().setVisible(true);
            }
        });
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextArea m_textArea;
    private javax.swing.JToolBar m_toolbar;
    // End of variables declaration//GEN-END:variables

}
