/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.util;

import com.jclark.xsl.util.Comparator;

public class MergeSort {
    private MergeSort() {
    }

    public static void sort(Comparator cmp, Object[] src) {
        MergeSort.sort(cmp, src, 0, src.length);
    }

    public static void sort(Comparator cmp, Object[] src, int off, int len) {
        MergeSort.sort(cmp, src, off, len, new Object[len], 0);
    }

    public static void sort(Comparator cmp, Object[] src, int off, int len, Object[] temp, int tempOff) {
        if (len <= 1) {
            return;
        }
        int halfLen = len / 2;
        MergeSort.sortCopy(cmp, src, off, halfLen, temp, tempOff);
        MergeSort.sortCopy(cmp, src, off + halfLen, len - halfLen, temp, tempOff + halfLen);
        MergeSort.merge(cmp, temp, tempOff, halfLen, len - halfLen, src, off);
    }

    private static void sortCopy(Comparator cmp, Object[] src, int off, int len, Object[] dest, int destOff) {
        if (len <= 1) {
            if (len != 0) {
                dest[destOff] = src[off];
            }
            return;
        }
        int halfLen = len / 2;
        MergeSort.sort(cmp, src, off, halfLen, dest, destOff);
        MergeSort.sort(cmp, src, off + halfLen, len - halfLen, dest, destOff + halfLen);
        MergeSort.merge(cmp, src, off, halfLen, len - halfLen, dest, destOff);
    }

    private static void merge(Comparator cmp, Object[] src, int off1, int len1, int len2, Object[] dest, int destOff) {
        int off2 = off1 + len1;
        if (len1 != 0 && len2 != 0) {
            while (true) {
                if (cmp.compare(src[off1], src[off2]) <= 0) {
                    dest[destOff++] = src[off1++];
                    if (--len1 != 0) continue;
                    break;
                }
                dest[destOff++] = src[off2++];
                if (--len2 == 0) break;
            }
        }
        while (len1 > 0) {
            dest[destOff++] = src[off1++];
            --len1;
        }
        while (len2 > 0) {
            dest[destOff++] = src[off2++];
            --len2;
        }
    }
}

