#!/usr/bin/perl

# this script is an example on how to make a HTTP request using libwhisker

$|++;
use LW;

# %hin contains the request values passed to libwhisker
# %hout contains the response values received from libwhisker
# %jar contains all our cookies
my (%hin, %hout, %jar); 


# this sets up some standard values in the given hash
LW::http_init_request(\%hin);


# set the target host and URI
$hin{'whisker'}->{'host'}="10.9.200.4";
$hin{'whisker'}->{'uri'}="/";
# $hin{'whisker'}->{'port'}=80;  # port 80 is default


# SSL support seems ok, but still reserves the right to be buggy
#$hin{'whisker'}->{'port'}=443;
#$hin{'whisker'}->{'ssl'}=1;
#$hin{'whisker'}->{'save_ssl_info'}=1;


# proxy support
# $hin{'whisker'}->{'proxy_host'}='localhost';
# $hin{'whisker'}->{'proxy_port'}=8080;


# anti-IDS
# $hin{'whisker'}->{'anti_ids'}='12345'; # values are the modes


# basic auth
# LW::auth_set_header('basic',\%hin,'user','password');


# special function to tweak the request to make sure it's valid HTTP 
# (not required if you set it all manually, but it never hurts)
LW::http_fixup_request(\%hin);


# if there's any cookies in the %jar, then set them as appropriate
# LW::cookie_write(\%jar,\%hin);


# actually make the request (and get response)
if(LW::http_do_request(\%hin,\%hout)){

	print 'ERROR: ', $hout{'whisker'}->{'error'}, "\n";
	print $hout{'whisker'}->{'data'}, "\n";

} else {

	# save any cookies sent to us into our %jar
	# LW::cookie_read(\%jar,\%hout);

	print $hout{'whisker'}->{'code'}, "\n"; # HTTP return code
	print $hout{'Server'}, "\n";		# Server banner

#       Uncomment following line if you want to see resulting HTML data
#	print $hout{'whisker'}->{'data'}, "\n";


	# If we are using the retry feature, we can print previous errors that
	# we didn't see
	if(defined $hout{whisker}->{retry_errors}){
		print "Previous (retry) errors:\n\t";
		print join("\n\t",@{$hout{whisker}->{retry_errors}});
		print "\n";
	}


	# If we wanted to save the SSL info (only works with Net::SSLeay)
	if(defined $hin{whisker}->{save_ssl_info}){
		print 'SSL cipher: ',$hout{whisker}->{ssl_cipher},"\n";
		print "Server cert:\n\t",$hout{whisker}->{ssl_cert_subject},"\n";
		print "Cert issuer:\n\t",$hout{whisker}->{ssl_cert_issuer},"\n";
	}

}




# good practice to clean up our mess
&LW::http_reset;
