/*  tilp - link program for TI calculators
 *  Copyright (C) 1999, 2000  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
  This unit contains functions for managing TIGraphLink variable format
  and some other stuffs (loading).
  This unit is built as an overlayer of the ti_files.c unit.
*/

#include "hfiles.h"
#include "tiffep.h"

/* !!!General comment!!! */
/*
  Load the content of the specified variable in the type 'TYPE' 
  as specified by 'tiffep_load_var_content_as_TYPE'.
  - fi [in]: the TiffepFileInfo structure of a previously loaded file
  (by a call to tiffep_load_file_content).
  - v [out]: an internally allocated structure which contain an image
  of the variable to handle. Can be modified in order to be saved later.
  - int [out]: 0 if success, an error code otherwise.
*/

TIEXPORT
int tiffep_load_var_content_as_number(TiffepVarInfo *vi, VarNum *v)
{
  return 0;
}

TIEXPORT
int tiffep_load_var_content_as_expression(TiffepVarInfo *vi, VarExpr *v)
{
  return 0;
}

TIEXPORT
int tiffep_load_var_content_as_list(TiffepVarInfo *vi, VarList *v)
{
  return 0;
}

TIEXPORT
int tiffep_load_var_content_as_matrix(TiffepVarInfo *vi, VarMatrix *v)
{
  return 0;
}

TIEXPORT
int tiffep_load_var_content_as_data(TiffepVarInfo *vi, VarData *v)
{
  return 0;
}

/*
TIEXPORT
int tiffep_load_var_content_as_text(TiffepVarInfo *vi, VarText *v)
{
  return 0;
}
*/

TIEXPORT
int tiffep_load_var_content_as_string(TiffepVarInfo *vi, VarString *vs)
{
  byte *var_data = NULL;
  gint var_size = 0;
  gint j;
  /* vi = FI_VARINFO(fi) */

  vs->type = VI_TYPE(vi);
  switch(vs->type)
    {
    case TYPE_STRING:
      var_data = (byte *)VI_CONTENT(vi);
      var_size = VI_SIZE(vi);
      /*
      fprintf(stdout, "Size of var: %i\n", var_size);
      for(j=0; j<var_size; j++)
	{
	  fprintf(stdout, "0x%02x ", var_data[j]);
	}
      fprintf(stdout, "\n");
      */
      switch(VI_CALCTYPE(vi))
	{ // HH LL 00 <..string..> (00) 2D
	case TYPE_TI92P:
	case TYPE_TI92:
	case TYPE_TI89:
	  vs->curs_pos = 0;
	  vs->str = g_strdup(var_data + 0x03);
	  break;
	  // HH LL <..string..>
	case TYPE_TI86:
	case TYPE_TI85:
	case TYPE_TI83P:
	case TYPE_TI83:
	case TYPE_TI82:
	  vs->str = g_strdup(var_data + 0x02); // ??
	  break;
	}
      break;
    case TYPE_TEXT:
      var_data = (byte *)VI_CONTENT(vi);
      var_size = VI_SIZE(vi);
      fprintf(stdout, "Size of var: %i\n", var_size);
      for(j=0; j<var_size; j++)
	{
	  fprintf(stdout, "0x%02x ", var_data[j]);
	}
      fprintf(stdout, "\n");
      
      switch(VI_CALCTYPE(vi))
	{ // HH LL CH CL <..text..> (00) 2D
	case TYPE_TI92P:
	case TYPE_TI92:
	case TYPE_TI89:
	  vs->curs_pos = B_BYTE2WORD(var_data[2], var_data[3]);
	  //var_data[4] always equals to 0x20
	  vs->str = g_strdup(var_data + 0x05);
	  break;
	  // HH LL <..text..> ??
	case TYPE_TI86:
	case TYPE_TI85:
	case TYPE_TI83P:
	case TYPE_TI83:
	case TYPE_TI82:
	  vs->str = g_strdup(var_data + 0x02); // ??
	  break;
	}
      break;
    default:
       return ERR_INVALID_TYPE;
       break;
    }

  return 0;
}

TIEXPORT
int tiffep_load_var_content_as_gdb(TiffepVarInfo *vi, VarGdb *v)
{
  return 0;
}

TIEXPORT
int tiffep_load_var_content_as_figure(TiffepVarInfo *vi, VarFigure *v)
{
  return 0;
}

TIEXPORT
int tiffep_load_var_content_as_picture(TiffepVarInfo *vi, VarPict *v)
{
  return 0;
}

TIEXPORT
int tiffep_load_var_content_as_program(TiffepVarInfo *vi, VarPrgm *v)
{
  return 0;
}

TIEXPORT
int tiffep_load_var_content_as_function(TiffepVarInfo *vi, VarFnct *v)
{
  return 0;
}

TIEXPORT
int tiffep_load_var_content_as_macro(TiffepVarInfo *vi, VarMacro *v)
{
  return 0;
}

TIEXPORT
int tiffep_load_var_content_as_backup(TiffepVarInfo *vi, VarBackup *v)
{
  return 0;
}
