/*  tilp - link program for TI calculators
 *  Copyright (C) 1999, 2000  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __TIFFEP_TIVARS_86__
#define __TIFFEP_TIVARS_86__

#include "tiffep.h"

/*************************/
/* Structure definitions */
/*************************/

/* TI86 calculators */

/*
  This structure is used for storing a real
*/
struct real_number_86_
{
  // TI encoding
  byte flags;
  byte exponent[2];
  byte mantissa[7];
};
typedef struct real_number_86_ RealNumber_86;

/*
  This structure is used for storing a complex number
*/
struct complex_number_86_
{
  RealNumber_86 real_part;
  RealNumber_86 imag_part;
};
typedef struct complex_number_86_ CplxNumber_86;

/*
  This structure is used for storing a real vector
*/
struct var_real_vector_86_
{
  // TI encoding
  byte nothing;     // always set to 1
  byte nelts;       // number of elements in the vector
  RealNumber_86 *elts;       // array of elements (Real)
};
typedef struct var_real_vector_86_ RealVector_86;

/*
  This structure is used for storing a complex vector
*/
struct var_cplx_vector_86_
{
  // TI encoding
  byte nothing;     // always set to 1
  byte nelts;       // number of elements in the vector
  CplxNumber_86 *elts; // array of elements (Complex)
};
typedef struct var_cplx_vector_86_ CplxVector_86;

/*
  This structure is used for storing a real list
*/
struct var_real_list_86_
{
  // TI encoding
  word nelts;       // number of elements in the list
  RealNumber_86 *elts; // array of elements (Real)
};
typedef struct var_real_vector_86_ RealList_86;

/*
  This structure is used for storing a complex list
*/
struct var_cplx_list_86_
{
  // TI encodind
  word nelts;       // number of elements in the list
  CplxNumber_86 *elts; // array of elements (Complex)
};
typedef struct var_cplx_vector_86_ CplxList_86;

/*
  This structure is used for storing a real matrix
*/
struct var_real_matrix_86_
{
  // TI encoding
  byte ncols;
  byte nrows;
  RealNumber_86 *elts; // array of elements (Real)
};
typedef struct var_real_matrix_86_ RealMatrix_86;

/*
  This structure is used for storing a complex list
*/
struct var_cplx_matrix_86_
{
  // TI encoding
  byte ncols;
  byte nrows;
  RealNumber_86 *elts; // array of elements (Real)
};
typedef struct var_cplx_matrix_86_ CplxMatrix_86;

/*
  This structure is used for storing a real constant
*/
typedef RealNumber_86 RealConstant_86;

/*
  This structure is used for storing a real constant
*/
typedef CplxNumber_86 CplxConstant_86;

/*
  This structure is used for storing a string
*/
struct var_string_86_
{
  // TI encoding
  word length;
  byte *string; //not zero terminated
};
typedef struct var_string_86_ String_86;

/*
  This structure is used for storing an equation
*/
typedef String_86 Equation_86;

/*
  This structure is used for storing a Graphic Data Base object
*/
struct var_gdb_function_86_
{
  // TI encoding
  word length;
  byte mode_settings;
  RealNumber_86 x_min;
  RealNumber_86 x_max;
  RealNumber_86 x_scl;
  RealNumber_86 y_min;
  RealNumber_86 y_max;
  RealNumber_86 y_scl;
  RealNumber_86 x_res;

  byte n_fncts;
  byte *fnct_table;
  byte style[50];
};

struct var_gdb_polar_86_
{
  // TI encoding
  word length;
  byte mode_settings;
  RealNumber_86 theta_min;
  RealNumber_86 theta_max;
  RealNumber_86 theta_step;
  RealNumber_86 x_min;
  RealNumber_86 x_max;
  RealNumber_86 x_scl;
  RealNumber_86 y_min;
  RealNumber_86 y_max;
  RealNumber_86 y_scl;

  byte n_fncts;
  byte *fnct_table;
  byte style[50];
};

struct var_gdb_param_86_
{
  // TI encoding
  word length;
  byte mode_settings;
  RealNumber_86 t_min;
  RealNumber_86 t_max;
  RealNumber_86 t_step;
  RealNumber_86 x_min;
  RealNumber_86 x_max;
  RealNumber_86 x_scl;
  RealNumber_86 y_min;
  RealNumber_86 y_max;
  RealNumber_86 y_scl;

  byte n_fncts;
  byte *fnct_table;
  byte style[50];
};

struct var_gdb_diffeq_86_
{
  // TI encoding
  word length;
  byte mode_settings;
  RealNumber_86 dif_tol;
  RealNumber_86 t_plot;
  RealNumber_86 t_min;
  RealNumber_86 t_max;
  RealNumber_86 t_step;
  RealNumber_86 x_min;
  RealNumber_86 x_max;
  RealNumber_86 x_scl;
  RealNumber_86 y_min;
  RealNumber_86 y_max;
  RealNumber_86 y_scl;
  byte fld_off_x;
  byte fld_off_y;
  byte slp_fld_y;
  byte dir_fld_x;
  byte dir_fld_y;
  RealNumber_86 d_time;
  RealNumber_86 fld_res;
  RealNumber_86 e_step;

  byte n_fncts;
  byte *fnct_table;
  byte style[50];
};

union var_gdb_86_
{
  struct var_gdb_function_86_ fnct;
  struct var_gdb_polar_86_    polar;
  struct var_gdb_param_86_    param;
  struct var_gdb_diffeq_86_   diffeq;
};
typedef union var_gdb_86_ Gdb_86;

/*
  This structure is used for storing a picture object
*/
struct var_picture_86_
{
  // TI encoding
  word size;
  byte bitmap[1008];
};
typedef struct var_picture_86_ Picture_86;

/*
  This structure is used for storing a program object
*/
typedef String_86 Program_86;

/*
  This structure is used for storing a Window Settings object
*/
struct var_wndsettings_function_86_
{
  // TI encoding
  word unused;
  byte unknwown;
  RealNumber_86 x_min;
  RealNumber_86 x_max;
  RealNumber_86 x_scl;
  RealNumber_86 y_min;
  RealNumber_86 y_max;
  RealNumber_86 y_scl;
  byte unknown2[20]; // 2 reals, 1 complex ??
  RealNumber_86 x_res;
};

struct var_wndsettings_polar_86_
{
  // TI encoding
  word unused;
  byte unknwown;
  RealNumber_86 theta_min;
  RealNumber_86 thetha_max;
  RealNumber_86 theta_step;
  RealNumber_86 x_min;
  RealNumber_86 x_max;
  RealNumber_86 x_scl;
  RealNumber_86 y_min;
  RealNumber_86 y_max;
  RealNumber_86 y_scl;
};

struct var_wndsettings_param_86_
{
  // TI encoding
  word unused;
  byte unknwown;
  RealNumber_86 t_min;
  RealNumber_86 t_max;
  RealNumber_86 t_step;
  RealNumber_86 x_min;
  RealNumber_86 x_max;
  RealNumber_86 x_scl;
  RealNumber_86 y_min;
  RealNumber_86 y_max;
  RealNumber_86 y_scl;
};

struct var_wndsettings_diffeq_86_
{
  // TI encoding
  word unused;
  byte unknwown;
  RealNumber_86 diff_tol;
  RealNumber_86 t_plot;
  RealNumber_86 t_min;
  RealNumber_86 t_max;
  RealNumber_86 t_step;
  RealNumber_86 x_min;
  RealNumber_86 x_max;
  RealNumber_86 x_scl;
  RealNumber_86 y_min;
  RealNumber_86 y_max;
  RealNumber_86 y_scl;
  
  byte fld_off_x;
  byte fld_off_y;
  byte slp_fld_y;
  byte dir_fld_x;
  byte dir_fld_y;
  RealNumber_86 d_time;
  RealNumber_86 fld_res;
  RealNumber_86 e_step;
};

struct var_wndsettings_saved_86_
{
  // TI encoding
  word unused;
  RealNumber_86 z_theta_min;
  RealNumber_86 z_theta_max;
  RealNumber_86 z_theta_step;
  RealNumber_86 z_t_plot;
  RealNumber_86 z_t_min;
  RealNumber_86 z_t_max;
  RealNumber_86 z_t_step;
  RealNumber_86 z_x_min;
  RealNumber_86 z_x_max;
  RealNumber_86 z_x_scl;
  RealNumber_86 z_y_min;
  RealNumber_86 z_y_max;
  RealNumber_86 z_y_scl;
  RealNumber_86 z_x_res;
};

union var_wndsettings_86_
{
  struct var_wndsettings_function_86_ fnct;
  struct var_wndsettings_polar_86_    polar;
  struct var_wndsettings_param_86_    param;
  struct var_wndsettings_diffeq_86_   diffeq;
  struct var_wndsettings_saved_86_    zsto;
};
typedef union var_wndsettings_86_ WndSettings_86;


#endif

