/*  tilp - link program for TI calculators
 *  Copyright (C) 1999, 2000  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __TIFFEP_TIVARS_82__
#define __TIFFEP_TIVARS_82__

#include "tiffep.h"

/*************************/
/* Structure definitions */
/*************************/

/* TI82 calculators */

/*
  This structure is used for storing a real
*/
struct real_number_82_
{
  // TI encoding
  byte flags;
  byte exponent[1];
  byte mantissa[7];
};
typedef struct real_number_82_ RealNumber_82;


/*
  This structure is used for storing a real list
*/
struct var_real_list_82_
{
  // TI encoding
  word nelts;       // number of elements in the list
  RealNumber_82 *elts; // array of elements (Real)
};
typedef struct var_real_vector_82_ RealList_82;


/*
  This structure is used for storing a real matrix
*/
struct var_real_matrix_82_
{
  // TI encoding
  byte ncols;
  byte nrows;
  RealNumber_82 *elts; // array of elements (Real)
};
typedef struct var_real_matrix_82_ RealMatrix_82;


/*
  This structure is used to store an Y-equation object
*/
struct var_y_equation_82_
{
  word n_tokens;
  byte *tokens;
};
typedef struct var_y_equation_82_ YVariable_82;


/*
  This structure is used for storing a Graphic Data Base object
*/
struct functions_82_
{
  byte flags;
  YVariable_82 fnct;
};

struct var_gdb_function_82_
{
  // TI encoding
  word length;
  byte mode_id;
  byte mode_settings;
  byte unused;

  RealNumber_82 x_min;
  RealNumber_82 x_max;
  RealNumber_82 x_scl;
  RealNumber_82 y_min;
  RealNumber_82 y_max;
  RealNumber_82 y_scl;
  RealNumber_82 x_res;

  struct functions_82_ fnct_table[10];
};

struct var_gdb_polar_82_
{
  // TI encoding
  word length;
  byte mode_id;
  byte mode_settings;
  byte unused;

  RealNumber_82 x_min;
  RealNumber_82 x_max;
  RealNumber_82 x_scl;
  RealNumber_82 y_min;
  RealNumber_82 y_max;
  RealNumber_82 y_scl;
  RealNumber_82 theta_min;
  RealNumber_82 theta_max;
  RealNumber_82 theta_step;
  
  struct functions_82_ fnct_table[10];
};

struct var_gdb_param_82_
{
  // TI encoding
  word length;
  byte mode_id;
  byte mode_settings;
  byte unused;

  RealNumber_82 x_min;
  RealNumber_82 x_max;
  RealNumber_82 x_scl;
  RealNumber_82 y_min;
  RealNumber_82 y_max;
  RealNumber_82 y_scl;
  RealNumber_82 t_min;
  RealNumber_82 t_max;
  RealNumber_82 t_step;
  
  struct functions_82_ fnct_table[12];
};

struct var_gdb_seq_82_
{
  // TI encoding
  word length;
  byte mode_id;
  byte mode_settings;
  byte unused;

  RealNumber_82 x_min;
  RealNumber_82 x_max;
  RealNumber_82 x_scl;
  RealNumber_82 y_min;
  RealNumber_82 y_max;
  RealNumber_82 y_scl;
  RealNumber_82 n_min;
  RealNumber_82 n_max;
  RealNumber_82 un_start;
  RealNumber_82 vn_start;
  RealNumber_82 n_start;
  
  struct functions_82_ fnct_table[2];
};

union var_gdb_82_
{
  struct var_gdb_function_82_ fnct;
  struct var_gdb_polar_82_    polar;
  struct var_gdb_param_82_    param;
  struct var_gdb_seq_82_      seq;
};
typedef union var_gdb_82_ Gdb_82;

/*
  This structure is used for storing a picture object
*/
struct var_picture_82_
{
  // TI encoding
  word size;
  byte bitmap[1008];
};
typedef struct var_picture_82_ Picture_82;

/*
  This structure is used for storing a program object
*/
typedef YVariable_82 Program_82;

/*
  This structure is used for storing a Window Settings object
*/
struct var_wndsettings_normal_82_
{
  // TI encoding
  word unused;
  byte unknwown;
  RealNumber_82 x_min;
  RealNumber_82 x_max;
  RealNumber_82 x_scl;
  RealNumber_82 y_min;
  RealNumber_82 y_max;
  RealNumber_82 y_scl;
  RealNumber_82 theta_min;
  RealNumber_82 theta_max;
  RealNumber_82 theta_step;
  RealNumber_82 t_min;
  RealNumber_82 t_max;
  RealNumber_82 t_step;
  RealNumber_82 n_min;
  RealNumber_82 n_max;
  RealNumber_82 un_start;
  RealNumber_82 vn_start;
  RealNumber_82 n_start;
};

struct var_wndsettings_saved_82_
{
  // TI encoding
  word unused;
  RealNumber_82 x_min;
  RealNumber_82 x_max;
  RealNumber_82 x_scl;
  RealNumber_82 y_min;
  RealNumber_82 y_max;
  RealNumber_82 y_scl;
  RealNumber_82 theta_min;
  RealNumber_82 theta_max;
  RealNumber_82 theta_step;
  RealNumber_82 t_min;
  RealNumber_82 t_max;
  RealNumber_82 t_step;
  RealNumber_82 n_min;
  RealNumber_82 n_max;
  RealNumber_82 un_start;
  RealNumber_82 vn_start;
  RealNumber_82 n_start;
};

union var_wndsettings_82_
{
  struct var_wndsettings_normal_82_ fnct;
  struct var_wndsettings_saved_82_    zsto;
};
typedef union var_wndsettings_82_ WndSettings_82;

/*
  This structure is used for storing a Table Settings object
*/
struct var_tblsettings_82_
{
  // TI encoding
  word unused;
  RealNumber_82 tbl_min;
  RealNumber_82 delta_tbl;
};

typedef struct var_tblsettings_82_ TblSettings_82;

#endif




