/*  tilp - link program for TI calculators
 *  Copyright (C) 1999, 2000  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
  Win32 only
  This unit contains a useful function for handling Win32 errors.
  Linux rocks and Win$ sucks !
*/

#if defined(__WIN32__)

#include <windows.h>
#include <stdio.h>
#include <string.h>

#include "export.h"

/*
  Print the error message corresponding to the value 
  returned by the GetLastError function.
*/
void print_last_error(char *s)
{
  LPVOID lpMsgBuf;
  DWORD err;
  
  FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER |
		FORMAT_MESSAGE_FROM_SYSTEM |
		FORMAT_MESSAGE_IGNORE_INSERTS,
		NULL, err = GetLastError(),
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
		(LPTSTR) &lpMsgBuf,    0,    NULL );
  fprintf(stderr, "Error in %s -> code = %i, msg = %s\n", s, err,
	  lpMsgBuf);
}

void print_last_socket_error(char *s)
{
  LPVOID lpMsgBuf;
  
  FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER |
		FORMAT_MESSAGE_FROM_SYSTEM |
		FORMAT_MESSAGE_IGNORE_INSERTS,
		NULL, WSAGetLastError(),
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
		(LPTSTR) &lpMsgBuf,    0,    NULL );
  fprintf(stderr, "Error in (socket) %s -> msg = %s\n", s, lpMsgBuf);
}

#elif defined(__LINUX__)

#include <stdio.h>
#include <string.h>

//TIEXPORT
void print_last_error(char *s)
{
  fprintf(stderr, "Error in %s -> msg = ", s);
  perror("");
}

//TIEXPORT
void print_last_socket_error(char *s)
{
  print_last_error(s);
}

#endif
