#ifndef INTL_H
#define INTL_H

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <locale.h>
//#include <glib.h>

/*
 * Standard gettext macros.
 */
#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (PACKAGE, String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define N_(String) (String)
#endif

/* Taken from Gimp Win32 */
/*
#define INIT_LOCALE( domain )	G_STMT_START{	\
	gtk_set_locale ();			\
	setlocale (LC_NUMERIC, "C");		\
	bindtextdomain (domain, LOCALEDIR);	\
	textdomain (domain);			\
				}G_STMT_END
*/

#ifdef __WIN32__
//#  define PACKAGE "libtiffep"    	// name of package
//#  define PACKAGE_LOCALE_DIR ""		// place of the translated file
#endif

#endif

