/*  tilp - link program for TI calculators
 *  Copyright (C) 1999, 2000  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
  This unit contains the interface of the libTiFFEP library.
*/

#include <stdio.h>
#ifndef __WIN32__
# include <unistd.h>
#endif
#ifdef __WIN32__
#include <windows.h>
#endif

#include "hfiles.h"
#include "tiffep.h"

/*****************/
/* Internal data */
/*****************/

gchar *reg_path = REG_FILE;
gchar *conf_path = NULL;

/***********/
/* Methods */
/***********/

/*
  Returns the library version number
  - const char* [out]: the version number such as "X.X.X"
*/
TIEXPORT
const char *tiffep_get_version()
{
  return LIBTIFFEP_VERSION;
}

/*
 * Load a plugin for the specified file
 * - filename [in]: the filename (with full path) of the file to use
 * - app_path [out]: location of the plugin to execute (must be freed when no longer used !)
 * - int [out]: the result of the operation
 */
TIEXPORT
int tiffep_load_plugin(gchar *filename, gchar **app_path)
{
  TiffepRegistryEntry *entry         = NULL;
  TiffepRegistry      *main_registry = NULL;
  TiffepRegistry      *sub_registry  = NULL;
  TiffepRegistry      *sub_registry2 = NULL;
  TiffepRegistry      *sub_registry3 = NULL;
  const gchar *calc, *var;
  TiffepShm s;

  /* Search a plugin */
  
  fprintf(stdout, "-> tiffep, file to edit: <%s>\n", filename);
  fprintf(stdout, "-> var type:  %s\n", 
	  var = tiffep_var_type_to_string(tiffep_which_var_type_from_file(filename)));
  fprintf(stdout, "-> calc type: %s\n", 
	  calc = tiffep_calc_type_to_string(tiffep_which_calc_type_from_file(filename)));

  TRY(registry_get_pointer(&main_registry));

  /* Sort registry entries by calc */
  fprintf(stdout, "-> searching calc...\n");
  TRY(registry_search_entry_by_calc((gchar *)calc, main_registry, 
				    &sub_registry));
  
  /* Sort registry entries by var */
  fprintf(stdout, "-> searching var...\n");
  TRY(registry_search_entry_by_var((gchar *)var, sub_registry, 
				   &sub_registry2));

  /* Now, sort registry entries by plugin (no linking program) */
  fprintf(stdout, "-> searching type...\n");
  TRY(registry_search_entry_by_type("plugin", sub_registry2, 
				    &sub_registry3));
  
  entry = (TiffepRegistryEntry *)g_list_first(sub_registry3)->data;
  fprintf(stdout, "-> entry found, name: <%s>\n", entry->name->str);
  fprintf(stdout, "-> entry found, path: <%s>\n", entry->path->str);
  *app_path = g_strdup(entry->path->str);
  fprintf(stdout, "-> Launching it now\n");
  
  /* We have found a plugin then we can launch it */
  if(shm_create(&s, SHM_NAME, TiffepMsgSize, 0))  
    {
      exit(1);
    }
  
  if(shm_attach(&s, 0))  
    {
      exit(1);
    }
  
  TRY(cmd_send_exec_plugin(s, entry->path->str, filename));
  TRY(cmd_send_ok(s));

  shm_detach(&s);
  shm_destroy(&s);

  /* End */
  return 0;
}

/*
 * Load a linking program for the specified file
 * - filename [in]: the filename (with full path) of the file to use
 * - int [out]: the result of the operation
 */
TIEXPORT
int tiffep_load_linking_program(gchar *filename)
{

  return 0;
}


/*
  Check whether the TiFFEP server is running
  Returns TRUE if yes, FALSE otherwise
*/
TIEXPORT
int tiffep_server_is_running()
{
  return shm_is_exist();
}


/*
  Try to connect a plug-in on the TiFFEP server
  - s [out]: a TiffepShm structure for future communications
  Returns 0 if success, an error code otherwise
*/
TIEXPORT
int tiffep_connect(TiffepShm *s)
{
  TRY(shm_create(s, SHM_NAME, TiffepMsgSize, 0));
  TRY(shm_attach(s, 0));

  return 0;
}

/* Initialize i18n support under Win32 platforms */
#if defined(__WIN32__)

BOOL WINAPI DllMain(  HINSTANCE hinstDLL,  // handle to DLL module
		      DWORD fdwReason,     // reason for calling function
		      LPVOID lpvReserved)   // reserved);
{
	/* Segfaults under Win2k */
	char buffer[65536];
	HINSTANCE hDLL = hinstDLL;
	int i=0;

	GetModuleFileName(hinstDLL, buffer, 4*MAXCHARS);
    fprintf(stderr, "libtiffep, filename: <%s>\n", buffer);
	for(i=strlen(buffer); i>=0; i--) { if(buffer[i]=='\\') break; }
	buffer[i]='\0';

	reg_path = (gchar *)g_malloc(1+(strlen(buffer)+strlen(SHARE_DIR)+
			strlen(G_DIR_SEPARATOR_S)+strlen(REG_FILE))*sizeof(gchar));
	strcpy(reg_path, buffer);
	strcat(reg_path, SHARE_DIR);
	strcat(reg_path, G_DIR_SEPARATOR_S);
	strcat(reg_path, REG_FILE);

	strcat(buffer, "\\locale\\");
	fprintf(stderr, "libtiffep, locale_dir: <%s>\n", buffer);
	/*
#ifdef ENABLE_NLS
	bindtextdomain (PACKAGE, buffer);	
	textdomain (PACKAGE);
#endif
	*/
}
#endif
